/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import org.netbeans.core.NbMainExplorer;
import org.netbeans.core.modules.ManifestSection;
import org.netbeans.core.projects.FixedFileSystem;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.actions.Presenter;

final class NodeSectionTranslator {
    private static final String INSTANCE_EXT = "instance";

    private NodeSectionTranslator() {
    }

    public static void loadNode(ManifestSection.NodeSection nodeSection) throws Exception {
        String nodeType = nodeSection.getType();
        if ("environment".equals(nodeType)) {
            NodeSectionTranslator.createInstanceFile("UI/Runtime/", nodeSection);
        } else if ("session".equals(nodeType)) {
            NodeSectionTranslator.createInstanceFile("UI/Services/", nodeSection);
        } else if ("roots".equals(nodeType)) {
            NodeSectionTranslator.createRoot(nodeSection);
        }
    }

    public static void unloadNode(ManifestSection.NodeSection nodeSection) throws Exception {
        String nodeType = nodeSection.getType();
        if ("environment".equals(nodeType)) {
            NodeSectionTranslator.deleteInstanceFile("UI/Runtime/", nodeSection);
        } else if ("session".equals(nodeType)) {
            NodeSectionTranslator.deleteInstanceFile("UI/Services/", nodeSection);
        } else if ("roots".equals(nodeType)) {
            NodeSectionTranslator.deleteRoot(nodeSection);
        }
    }

    private static String createInstanceFile(String folder, ManifestSection.NodeSection nodeSection) throws Exception {
        String filePath = NodeSectionTranslator.getInstancePath(folder, nodeSection);
        FixedFileSystem.Instance inst = new FixedFileSystem.Instance(false, null, null, null, (String)null);
        FixedFileSystem.getDefault().add(filePath, inst);
        return filePath;
    }

    private static String deleteInstanceFile(String folder, ManifestSection.NodeSection nodeSection) throws Exception {
        String filePath = NodeSectionTranslator.getInstancePath(folder, nodeSection);
        FixedFileSystem.getDefault().remove(filePath);
        return filePath;
    }

    private static String getInstancePath(String folder, ManifestSection.NodeSection nodeSection) throws Exception {
        String originName = nodeSection.getSectionClass().getName();
        String fileName = originName.replace('.', '-');
        StringBuffer filePathBuf = new StringBuffer(folder.length() + fileName.length() + INSTANCE_EXT.length() + 1);
        filePathBuf.append(folder).append(fileName).append('.').append(INSTANCE_EXT);
        return filePathBuf.toString();
    }

    private static void createRoot(ManifestSection.NodeSection nodeSection) throws Exception {
        String filePath = NodeSectionTranslator.createInstanceFile("UI/Roots/", nodeSection);
        NodeSectionTranslator.createMenuInstance(filePath, nodeSection);
    }

    private static void deleteRoot(ManifestSection.NodeSection nodeSection) throws Exception {
        NodeSectionTranslator.deleteInstanceFile("UI/Roots/", nodeSection);
        NodeSectionTranslator.deleteMenuInstance(nodeSection);
    }

    private static void createMenuInstance(String filePath, ManifestSection.NodeSection nodeSection) throws Exception {
        FixedFileSystem.Instance inst = new FixedFileSystem.Instance(false, null, null, null, (String)null);
        inst.writeAttribute("instanceClass", "org.netbeans.core.modules.NodeSectionTranslator$RootMenuItem");
        Creator creator = new Creator(filePath);
        inst.writeAttribute("instanceCreate", creator);
        String name = nodeSection.getSectionClassName() + ".instance";
        FileObject folder = Repository.getDefault().getDefaultFileSystem().findResource("Menu/View");
        if (folder != null) {
            folder.setAttribute("oldRootsStart.txt/" + name, (Object)Boolean.TRUE);
            folder.setAttribute(name + "/oldRootsEnd.txt", (Object)Boolean.TRUE);
        }
        String path = "Menu/View/" + name;
        FixedFileSystem.getDefault().add(path, inst);
    }

    private static void deleteMenuInstance(ManifestSection.NodeSection nodeSection) throws Exception {
        String path = "Menu/View/" + nodeSection.getSectionClassName() + ".instance";
        FixedFileSystem.getDefault().remove(path);
    }

    public static class Creator
    implements FixedFileSystem.AttributeCreator {
        private String filePath;
        static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

        public Creator(String filePath) {
            this.filePath = filePath;
        }

        public Object createValue(FixedFileSystem ffs, String path, String attrName) {
            Node node = Creator.getNodeInstance(this.filePath);
            if (node == null) {
                ErrorManager.getDefault().notify((Throwable)new NullPointerException("Can not create node instance for path " + this.filePath));
                return null;
            }
            return new RootMenuItem(node);
        }

        private static Node getNodeInstance(String filePath) {
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(filePath);
            if (fo == null) {
                return null;
            }
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                InstanceCookie ic = (InstanceCookie)dobj.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = Creator.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                if (ic == null) {
                    return null;
                }
                return (Node)ic.instanceCreate();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class RootMenuItem
    implements Presenter.Menu {
        private final Node node;

        public RootMenuItem(Node node) {
            this.node = node;
        }

        public JMenuItem getMenuPresenter() {
            return new JMenuItem(new Action(this.node));
        }

        private static class Action
        extends AbstractAction {
            private final Node node;

            public Action(Node node) {
                super(node.getDisplayName(), new ImageIcon(node.getIcon(1)));
                this.node = node;
            }

            public void actionPerformed(ActionEvent evt) {
                NbMainExplorer.ExplorerTab panel = NbMainExplorer.getExplorer().getRootPanel((Node)new FilterNode(this.node));
                if (panel == null) {
                    ErrorManager.getDefault().notify((Throwable)new NullPointerException("Missing ModuleTab in NbMainExplorer for node " + this.node));
                } else {
                    panel.open();
                    panel.requestFocus();
                }
            }
        }
    }
}

