/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.perftool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.regexp.CharacterIterator;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.apache.regexp.ReaderCharacterIterator;
import org.netbeans.core.perftool.Util;

final class Parser {
    private static final String nline = System.getProperty("line.separator");
    private static final String SESSION_START_PATTERN = "^([\\-]+)" + nline + "^(>Log Session: .*)";
    private static final String SESSION_END_PATTERN = "^([\\-]+)".concat(nline);
    private static final String ENTRY_PATTERN = "^[IDE-Perf] ([^0-9]+)([0-9]+)\\.([0-9]+) s";
    private static RE logstart;
    private static RE logend;
    private static RE entries;

    static RE getLogStart() throws RESyntaxException {
        if (logstart == null) {
            RECompiler rec = new RECompiler();
            REProgram rep = rec.compile(SESSION_START_PATTERN);
            logstart = new RE(rep, 2);
        }
        return logstart;
    }

    static RE getLogEnd() throws RESyntaxException {
        if (logend == null) {
            RECompiler rec = new RECompiler();
            REProgram rep = rec.compile(SESSION_END_PATTERN);
            logend = new RE(rep, 2);
        }
        return logend;
    }

    static RE getEntries() throws RESyntaxException {
        if (entries == null) {
            RECompiler rec = new RECompiler();
            REProgram rep = rec.compile(ENTRY_PATTERN);
            entries = new RE(rep, 2);
        }
        return entries;
    }

    private Parser() {
    }

    public static SessionInfo[] getData(File f) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            ReaderCharacterIterator iter = new ReaderCharacterIterator(reader);
            RE logstart = Parser.getLogStart();
            RE logend = Parser.getLogEnd();
            ArrayList<SessionInfo> sessions = new ArrayList<SessionInfo>(20);
            int idx = 0;
            while (logstart.match(iter, idx)) {
                int start = logstart.getParenStart(0);
                Parser.parseEntries(iter, idx, start, sessions);
                if (!logend.match(iter, logstart.getParenEnd(0))) break;
                int end = logend.getParenEnd(0);
                SessionInfo info = new SessionInfo(Parser.trimString(iter.substring(start, end)));
                sessions.add(info);
                idx = end;
            }
            ((Reader)reader).close();
            return sessions.toArray(new SessionInfo[sessions.size()]);
        }
        catch (RESyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void parseEntries(CharacterIterator iter, int startpos, int endpos, List sessions) throws IOException, RESyntaxException {
        int size = sessions.size();
        if (size == 0) {
            return;
        }
        SessionInfo session = (SessionInfo)sessions.get(size - 1);
        RE entries = Parser.getEntries();
        while (endpos > startpos && entries.match(iter, startpos)) {
            if (entries.getParenStart(0) > endpos) {
                startpos = entries.getParenStart(0);
                continue;
            }
            String entry = entries.getParen(0);
            double timeVal = Parser.strings2Double(entries.getParen(2), entries.getParen(3));
            Field f = new Field(session, entries.getParen(1), timeVal);
            session.addField(f);
            startpos = entries.getParenEnd(0);
        }
        if (session.size() == 0) {
            sessions.remove(size - 1);
        }
    }

    private static double strings2Double(String sx, String sy) {
        try {
            double ret = Double.parseDouble(sx);
            return ret += Double.parseDouble(sy) / Util.tenpower(sy.length());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    private static String trimString(String s) {
        char c;
        int idx = 0;
        int slen = s.length();
        if (slen == 0) {
            return s;
        }
        while (((c = s.charAt(idx++)) == '\n' || c == '\r') && idx < slen) {
        }
        --idx;
        if ((idx = (s = s.substring(idx)).length() - 1) < 0) {
            return s;
        }
        while (((c = s.charAt(idx--)) == '\n' || c == '\r') && idx >= 0) {
        }
        return s.substring(0, idx + 2);
    }

    public static class Field {
        private String name;
        private double time;
        private SessionInfo session;

        Field(SessionInfo session, String name, double time) {
            this.name = name;
            this.time = time;
            this.session = session;
        }

        public String getName() {
            return this.name;
        }

        public double getTime() {
            return this.time;
        }

        public SessionInfo getSessionInfo() {
            return this.session;
        }
    }

    public static class SessionInfo {
        private String desc;
        private Map fields;
        private int build;
        private Date date;

        SessionInfo(String desc) {
            this.desc = desc;
            this.fields = new HashMap(80);
            this.build = SessionInfo.getBuildNumber(desc);
            Locale loc = SessionInfo.getLocale(desc);
            this.date = SessionInfo.getDate(desc, loc);
        }

        public String getDescription() {
            return this.desc;
        }

        void addField(Field f) {
            this.fields.put(f.getName(), f);
        }

        public Field getField(String name) {
            return (Field)this.fields.get(name);
        }

        public int getBuildNumber() {
            return this.build;
        }

        public Date getDate() {
            return this.date;
        }

        int size() {
            return this.fields.size();
        }

        private static int getBuildNumber(String desc) {
            try {
                int idx = desc.indexOf("(Build ");
                int paren = desc.indexOf(41, idx);
                String build = desc.substring(idx + 7, paren);
                if (build.equals("@BUILD_NUMBER_SUBST@")) {
                    return -1;
                }
                return Integer.parseInt(build);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return -1;
            }
        }

        private static Locale getLocale(String desc) {
            int idx = desc.indexOf("System Locale");
            idx = desc.indexOf("= ", idx);
            String[] locale = new String[]{null, "", ""};
            int ptr = 0;
            StringBuffer sb = new StringBuffer(3);
            char c = desc.charAt(idx += 2);
            while (Character.isLetter(c)) {
                if (c == ':') {
                    locale[ptr++] = sb.toString();
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
                c = desc.charAt(++idx);
            }
            locale[ptr] = sb.toString();
            return new Locale(locale[0], locale[1], locale[2]);
        }

        private static Date getDate(String desc, Locale locale) {
            int idx = desc.indexOf(">Log Session: ");
            int end = desc.indexOf(62, idx + 14);
            String date = Parser.trimString(desc.substring(idx + 14, end));
            DateFormat df = DateFormat.getDateTimeInstance(0, 0, locale);
            Date dt = df.parse(date, new ParsePosition(0));
            return dt;
        }
    }
}

