/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;

final class LocalFileSystemEx
extends LocalFileSystem {
    private static HashMap allLocks = new HashMap(7);
    private static HashSet pLocks = new HashSet(7);

    public static String[] getLocks() {
        HashMap hashMap = allLocks;
        synchronized (hashMap) {
            LocalFileSystemEx.removeInvalid(pLocks);
            LinkedList l = new LinkedList();
            l.addAll(allLocks.keySet());
            l.addAll(pLocks);
            String[] stringArray = l.toArray(new String[l.size()]);
            return stringArray;
        }
    }

    public static boolean hasLocks() {
        HashMap hashMap = allLocks;
        synchronized (hashMap) {
            LocalFileSystemEx.removeInvalid(pLocks);
            boolean bl = !allLocks.isEmpty() || !pLocks.isEmpty();
            return bl;
        }
    }

    public static void potentialLock(String name) {
        HashMap hashMap = allLocks;
        synchronized (hashMap) {
            pLocks.add(name);
        }
    }

    public static void potentialLock(String o, String n) {
        HashMap hashMap = allLocks;
        synchronized (hashMap) {
            if (pLocks.remove(o)) {
                pLocks.add(n);
            }
        }
    }

    private static void removeInvalid(Set names) {
        FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (null != sfs.findResource(name)) continue;
            i.remove();
        }
    }

    public LocalFileSystemEx() {
    }

    public LocalFileSystemEx(FileSystemCapability cap) {
        super(cap);
    }

    protected void lock(String name) throws IOException {
        super.lock(name);
        HashMap hashMap = allLocks;
        synchronized (hashMap) {
            FileObject fo = this.findResource(name);
            allLocks.put(name, fo);
            pLocks.remove(name);
        }
    }

    protected void unlock(String name) {
        HashMap hashMap = allLocks;
        synchronized (hashMap) {
            if (allLocks.containsKey(name)) {
                allLocks.remove(name);
            } else {
                FileObject fo = this.findResource(name);
                if (fo != null) {
                    Iterator i = allLocks.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        if (!fo.equals(entry.getValue())) continue;
                        allLocks.remove(entry.getKey());
                        break;
                    }
                } else {
                    ErrorManager.getDefault().notify(1, new Throwable("Can't unlock file " + name + ", it's lock was not found or it wasn't locked."));
                }
            }
        }
        super.unlock(name);
    }
}

