/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.core.AutomountSupport;
import org.netbeans.core.projects.FilterFileSystem;
import org.netbeans.core.projects.LocalFileSystemEx;
import org.netbeans.core.projects.SystemFileSystem;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public final class SessionManager {
    public static final String PROP_OPEN = "session_open";
    public static final String PROP_CLOSE = "session_close";
    public static final String LAYER_SESSION = "session";
    public static final String LAYER_INSTALL = "install";
    public static final String LAYER_PROJECT = "project";
    private static SessionManager sm = null;
    private SystemFileSystem systemFS;
    private HashMap layers = new HashMap();
    private boolean isOpen = false;
    private transient ArrayList propertyChangeListeners;

    private SessionManager() {
    }

    public static SessionManager getDefault() {
        if (sm == null) {
            sm = new SessionManager();
        }
        return sm;
    }

    public FileSystem create(File userDir, File homeDir, File[] extradirs) throws PropertyVetoException, IOException {
        this.systemFS = SystemFileSystem.create(userDir, homeDir, extradirs);
        this.layers.put(LAYER_INSTALL, this.systemFS.getInstallationLayer());
        this.layers.put(LAYER_SESSION, this.systemFS.getUserLayer());
        return this.systemFS;
    }

    public void setProjectLayer(FileObject project) throws IOException {
        int i;
        FileSystem[] setfss;
        FileObject current;
        FilterFileSystem currentPL = (FilterFileSystem)((Object)this.layers.get(LAYER_PROJECT));
        FileSystem newPL = null;
        FileObject fileObject = current = currentPL == null ? null : currentPL.getRootFileObject();
        if (project == null && current == null) {
            return;
        }
        if (project != null) {
            newPL = this.createProjectLayer(project);
        }
        if (this.isOpen) {
            this.firePropertyChange(PROP_CLOSE);
        }
        this.waitForLocks();
        FileSystem[] fss = this.systemFS.getLayers();
        if (this.layers.get(LAYER_PROJECT) == null) {
            setfss = new FileSystem[fss.length + 1];
            i = 0;
            while (i < fss.length) {
                setfss[i + 1] = fss[i];
                ++i;
            }
            fss = setfss;
        }
        if (project == null) {
            setfss = new FileSystem[fss.length - 1];
            i = 0;
            while (i < setfss.length) {
                setfss[i] = fss[i + 1];
                ++i;
            }
            fss = setfss;
        } else {
            fss[0] = newPL;
        }
        final FileSystem[] fss_1 = fss;
        final FileSystem fs_1 = newPL;
        try {
            this.systemFS.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    SessionManager.this.systemFS.setLayers(fss_1);
                    SessionManager.this.layers.put(SessionManager.LAYER_PROJECT, fs_1);
                }
            });
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        AutomountSupport.initialize().waitFinished();
        this.isOpen = true;
        this.firePropertyChange(PROP_OPEN);
    }

    private FileSystem createProjectLayer(FileObject project) throws IOException {
        FileObject fo = null;
        if (project.getFileSystem() != this.systemFS) {
            fo = project;
        } else {
            String name = project.getPath();
            fo = FileUtil.createFolder((FileObject)this.systemFS.getUserLayer().getLayers()[0].getRoot(), (String)name);
        }
        if (fo == null) {
            throw new IOException("FileObject " + project + " can't be used as a root of project layer.");
        }
        return new FilterFileSystem(fo);
    }

    public void close() {
        this.firePropertyChange(PROP_CLOSE);
        this.waitForLocks();
    }

    public FileSystem getLayer(String name) {
        return (FileSystem)this.layers.get(name);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListeners == null) {
            this.propertyChangeListeners = new ArrayList();
        }
        this.propertyChangeListeners.add(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListeners != null) {
            ((AbstractCollection)this.propertyChangeListeners).remove(listener);
        }
    }

    private void firePropertyChange(String name) {
        ArrayList list;
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if (this.propertyChangeListeners == null || this.propertyChangeListeners.size() == 0) {
                return;
            }
            list = (ArrayList)this.propertyChangeListeners.clone();
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, name, null, null);
        int i = 0;
        while (i < list.size()) {
            try {
                ((PropertyChangeListener)list.get(i)).propertyChange(event);
            }
            catch (RuntimeException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            ++i;
        }
    }

    private void waitForLocks() {
        int count = 50;
        try {
            while (LocalFileSystemEx.hasLocks() && 0 < count) {
                Thread.currentThread();
                Thread.sleep(100L);
                --count;
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (LocalFileSystemEx.hasLocks()) {
            String[] locks = LocalFileSystemEx.getLocks();
            StringBuffer msg = new StringBuffer(256);
            msg.append("Settings saving ");
            msg.append(count == 0 ? "timeout!" : "interrupted!");
            msg.append("\nList of pending locks:\n");
            int i = 0;
            while (i < locks.length) {
                msg.append(locks[i]);
                msg.append("\n");
                ++i;
            }
            System.err.println(msg.toString());
        }
    }
}

