/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.core.projects.FixedFileSystem;
import org.netbeans.core.projects.LocalFileSystemEx;
import org.netbeans.core.projects.MemoryFileSystem;
import org.netbeans.core.projects.ModuleLayeredFileSystem;
import org.netbeans.core.projects.SessionManager;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;

public final class SystemFileSystem
extends MultiFileSystem
implements FileSystem.Status {
    static final long serialVersionUID = -7761052280240991668L;
    private static final String SYSTEM_NAME = "SystemFileSystem";
    private static final String ATTR_BUNDLE = "SystemFileSystem.localizingBundle";
    private static final String ATTR_ICON_16 = "SystemFileSystem.icon";
    private static final String ATTR_ICON_32 = "SystemFileSystem.icon32";
    static final String ATTR_LAYER = "SystemFileSystem.layer";
    private ModuleLayeredFileSystem user;
    private ModuleLayeredFileSystem home;
    private static MessageFormat homeFormat;
    private static MessageFormat userFormat;
    private static final ThreadLocal newFiles;
    static /* synthetic */ Class class$org$netbeans$core$projects$SystemFileSystem;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    private SystemFileSystem(FileSystem[] fss) throws PropertyVetoException {
        super(fss);
        this.user = (ModuleLayeredFileSystem)fss[0];
        this.home = fss.length > 2 ? (ModuleLayeredFileSystem)fss[1] : null;
        this.setSystemName(SYSTEM_NAME);
        this.setHidden(true);
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$core$projects$SystemFileSystem == null ? (class$org$netbeans$core$projects$SystemFileSystem = SystemFileSystem.class$("org.netbeans.core.projects.SystemFileSystem")) : class$org$netbeans$core$projects$SystemFileSystem), (String)"CTL_SystemFileSystem");
    }

    public ModuleLayeredFileSystem getInstallationLayer() {
        return this.home;
    }

    public ModuleLayeredFileSystem getUserLayer() {
        return this.user;
    }

    public final void setLayers(FileSystem[] arr) throws IllegalArgumentException {
        HashSet<FileSystem> s = new HashSet<FileSystem>();
        int i = 0;
        while (i < arr.length) {
            if (s.contains(arr[i])) {
                throw new IllegalArgumentException("Overlap in filesystem layers");
            }
            s.add(arr[i]);
            ++i;
        }
        this.setDelegates((FileSystem[])arr.clone());
        this.firePropertyChange("layers", null, null);
    }

    public FileSystem[] getLayers() {
        return (FileSystem[])this.getDelegates().clone();
    }

    public static void setLayerForNew(String path, String layer) {
        if (layer == null) {
            newFiles.set(null);
        } else {
            newFiles.set(new String[]{path, layer});
        }
    }

    protected FileSystem createWritableOnForRename(String oldName, String newName) throws IOException {
        return this.createWritableOn(oldName);
    }

    protected FileSystem createWritableOn(String name) throws IOException {
        FileObject fo = this.findResource(name);
        int index = 0;
        FileSystem PRJ_FS = SessionManager.getDefault().getLayer("project");
        FileSystem SSN_FS = SessionManager.getDefault().getLayer("session");
        if (PRJ_FS != null) {
            index = 1;
            if (fo != null) {
                Boolean isGlobal;
                FileSystem fofs = this.findSystem(fo);
                if (fofs == PRJ_FS && SystemFileSystem.isWritableOn(name, fofs)) {
                    return PRJ_FS;
                }
                if (fofs == SSN_FS && SystemFileSystem.isWritableOn(name, fofs)) {
                    return SSN_FS;
                }
                String layer = (String)fo.getAttribute(ATTR_LAYER);
                if (layer != null) {
                    if (layer.equals("project")) {
                        return PRJ_FS;
                    }
                    if (layer.equals("session")) {
                        return SSN_FS;
                    }
                }
                if ((isGlobal = (Boolean)fo.getAttribute("global-layer")) != null && isGlobal.equals(Boolean.FALSE)) {
                    return PRJ_FS;
                }
            }
            if (this.isProjectSubFolder(name)) {
                return PRJ_FS;
            }
        }
        FileSystem[] fss = this.getDelegates();
        while (index < fss.length) {
            if (!fss[index].isReadOnly()) {
                return fss[index];
            }
            ++index;
        }
        throw new IOException("No writable filesystems in our delegates");
    }

    protected Set createLocksOn(String name) throws IOException {
        LocalFileSystemEx.potentialLock(name);
        return super.createLocksOn(name);
    }

    private static boolean isWritableOn(String name, FileSystem fs) {
        if (fs.isReadOnly()) {
            return false;
        }
        if (fs instanceof ModuleLayeredFileSystem) {
            FileSystem[] fss = ((ModuleLayeredFileSystem)fs).getLayers();
            int i = 0;
            while (i < fss.length) {
                if (fss[i].findResource(name) != null) {
                    return !fss[i].isReadOnly();
                }
                ++i;
            }
            throw new IllegalArgumentException("did not find " + name + " on " + fs);
        }
        return true;
    }

    private boolean isProjectSubFolder(String name) {
        FileObject parent;
        String foldername;
        int idx = name.lastIndexOf(47);
        boolean isRoot = false;
        if (idx != -1) {
            foldername = name.substring(0, idx);
        } else {
            foldername = name;
            isRoot = true;
        }
        String[] newFile = (String[])newFiles.get();
        if (newFile != null && foldername.equals(newFile[0])) {
            if (newFile[1].equals("project")) {
                return true;
            }
            if (newFile[1].equals("session")) {
                return false;
            }
        }
        if ((parent = this.findResource(foldername)) != null) {
            Boolean isGlobal;
            String layer = (String)parent.getAttribute(ATTR_LAYER);
            if (layer != null) {
                if (layer.equals("project")) {
                    return true;
                }
                if (layer.equals("session")) {
                    return false;
                }
            }
            if ((isGlobal = (Boolean)parent.getAttribute("global-layer")) != null && isGlobal.equals(Boolean.FALSE)) {
                return true;
            }
        }
        return isRoot ? false : this.isProjectSubFolder(foldername);
    }

    public boolean isPersistent() {
        return true;
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    public String annotateName(String s, Set set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String fixedName;
            FileObject fo = (FileObject)it.next();
            String bundleName = (String)fo.getAttribute(ATTR_BUNDLE);
            if (bundleName != null) {
                try {
                    bundleName = Utilities.translate((String)bundleName);
                    ResourceBundle b = NbBundle.getBundle((String)bundleName, (Locale)Locale.getDefault(), (ClassLoader)((ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? SystemFileSystem.class$("java.lang.ClassLoader") : class$java$lang$ClassLoader)));
                    try {
                        return b.getString(fo.getPath());
                    }
                    catch (MissingResourceException ex) {
                    }
                }
                catch (MissingResourceException ex) {
                    ErrorManager.getDefault().annotate((Throwable)ex, 0, "Computing display name for " + fo, null, null, null);
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            if ((fixedName = FixedFileSystem.deflt.annotateName(fo.getPath())) == null) continue;
            return fixedName;
        }
        return this.annotateNameNoLocalization(s, set);
    }

    private String annotateNameNoLocalization(String s, Set set) {
        if (this.home == null || this.user == null) {
            return s;
        }
        Iterator it = set.iterator();
        int cnt = 0;
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            if (!fo.isRoot()) {
                ++cnt;
            }
            if (this.findSystem(fo) != this.home) continue;
            return SystemFileSystem.getHomeFormat().format(new Object[]{s});
        }
        if (cnt == 0) {
            return s;
        }
        return SystemFileSystem.getUserFormat().format(new Object[]{s});
    }

    public Image annotateIcon(Image im, int type, Set s) {
        String attr;
        if (type == 1) {
            attr = ATTR_ICON_16;
        } else if (type == 2) {
            attr = ATTR_ICON_32;
        } else {
            return im;
        }
        Iterator it = s.iterator();
        while (it.hasNext()) {
            Image anntIm;
            FileObject fo = (FileObject)it.next();
            Object value = fo.getAttribute(attr);
            if (value != null) {
                if (value instanceof URL) {
                    return Toolkit.getDefaultToolkit().getImage((URL)value);
                }
                if (value instanceof Image) {
                    return (Image)value;
                }
                ErrorManager.getDefault().log(16, "Attribute " + attr + " on " + fo + " expected to be a URL or Image; was: " + value);
            }
            if ((anntIm = FixedFileSystem.deflt.annotateIcon(fo.getPath())) == null) continue;
            return anntIm;
        }
        return im;
    }

    static SystemFileSystem create(File userDir, File homeDir, File[] extradirs) throws PropertyVetoException, IOException {
        LocalFileSystemEx home;
        Object user;
        if (userDir != null) {
            LocalFileSystemEx l = new LocalFileSystemEx();
            l.setRootDirectory(userDir);
            user = l;
        } else {
            user = new MemoryFileSystem();
        }
        if (homeDir == null) {
            home = null;
        } else {
            home = new LocalFileSystemEx();
            home.setRootDirectory(homeDir);
            home.setReadOnly(true);
        }
        LocalFileSystem[] extras = new LocalFileSystem[extradirs.length];
        int i = 0;
        while (i < extradirs.length) {
            extras[i] = new LocalFileSystemEx();
            extras[i].setRootDirectory(extradirs[i]);
            extras[i].setReadOnly(true);
            ++i;
        }
        FileSystem[] arr = new FileSystem[home == null ? 2 : 3];
        arr[0] = new ModuleLayeredFileSystem((FileSystem)user, new FileSystem[0], null);
        if (home != null) {
            File cachedir = new File(userDir.getParentFile(), "cache");
            arr[1] = new ModuleLayeredFileSystem((FileSystem)home, (FileSystem[])extras, cachedir);
        }
        FixedFileSystem.deflt = new FixedFileSystem("org.netbeans.core.projects.FixedFileSystem", "Automatic Manifest Installation");
        arr[home == null ? 1 : 2] = FixedFileSystem.deflt;
        return new SystemFileSystem(arr);
    }

    private static MessageFormat getUserFormat() {
        if (userFormat == null) {
            userFormat = new MessageFormat(NbBundle.getMessage((Class)(class$org$netbeans$core$projects$SystemFileSystem == null ? (class$org$netbeans$core$projects$SystemFileSystem = SystemFileSystem.class$("org.netbeans.core.projects.SystemFileSystem")) : class$org$netbeans$core$projects$SystemFileSystem), (String)"CTL_UserFile"));
        }
        return userFormat;
    }

    private static MessageFormat getHomeFormat() {
        if (homeFormat == null) {
            homeFormat = new MessageFormat(NbBundle.getMessage((Class)(class$org$netbeans$core$projects$SystemFileSystem == null ? (class$org$netbeans$core$projects$SystemFileSystem = SystemFileSystem.class$("org.netbeans.core.projects.SystemFileSystem")) : class$org$netbeans$core$projects$SystemFileSystem), (String)"CTL_HomeFile"));
        }
        return homeFormat;
    }

    protected void notifyMigration(FileObject fo) {
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, fo, false, true));
    }

    private Object writeReplace() throws ObjectStreamException {
        new NotSerializableException("WARNING - SystemFileSystem is not designed to be serialized").printStackTrace();
        return new SingletonSerializer();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        newFiles = new ThreadLocal();
    }

    public static class StructureNode
    extends AbstractNode {
        public StructureNode() {
            this(Repository.getDefault().getDefaultFileSystem());
        }

        public StructureNode(FileSystem fs) {
            super((Children)new StructureChildren(fs));
            this.setName(fs.getSystemName());
            this.setDisplayName(fs.getDisplayName());
        }

        private static class StructureChildren
        extends Children.Keys
        implements PropertyChangeListener {
            private FileSystem fs;

            public StructureChildren(FileSystem fs) {
                this.fs = fs;
                if (fs instanceof SystemFileSystem || fs instanceof ModuleLayeredFileSystem) {
                    fs.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)fs));
                }
            }

            protected void addNotify() {
                ArrayList<Object> k = new ArrayList<Object>();
                k.add(this.fs.getRoot());
                if (this.fs instanceof SystemFileSystem) {
                    k.addAll(Arrays.asList(((SystemFileSystem)this.fs).getLayers()));
                } else if (this.fs instanceof ModuleLayeredFileSystem) {
                    k.addAll(Arrays.asList(((ModuleLayeredFileSystem)this.fs).getLayers()));
                }
                this.setKeys(k);
            }

            protected void removeNotify() {
                this.setKeys(Collections.EMPTY_SET);
            }

            protected Node[] createNodes(Object k) {
                if (k instanceof FileObject) {
                    try {
                        return new Node[]{new RootNode(this.fs, DataObject.find((FileObject)((FileObject)k)).getNodeDelegate())};
                    }
                    catch (DataObjectNotFoundException donfe) {
                        ErrorManager.getDefault().notify((Throwable)donfe);
                        return new Node[0];
                    }
                }
                return new Node[]{new StructureNode((FileSystem)k)};
            }

            public void propertyChange(PropertyChangeEvent pce) {
                if ("layers".equals(pce.getPropertyName())) {
                    RequestProcessor.getDefault().post(new Runnable(this){
                        private final /* synthetic */ StructureChildren this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void run() {
                            this.this$0.addNotify();
                        }
                    });
                }
            }

            private static class RootNode
            extends FilterNode {
                public RootNode(FileSystem fs, Node orig) {
                    super(orig);
                    this.disableDelegation(15);
                    this.setName(fs.getSystemName());
                    this.setDisplayName("Root of " + fs.getDisplayName());
                }
            }
        }
    }

    private static final class SingletonSerializer
    implements Serializable {
        private static final long serialVersionUID = 6436781994611L;

        SingletonSerializer() {
        }

        private Object readResolve() throws ObjectStreamException {
            return Repository.getDefault().getDefaultFileSystem();
        }
    }
}

