/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.netbeans.core.IDESettings;
import org.netbeans.core.windows.UIModeManager;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.AsyncGUIJob;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;

class IDESettingsPanel
extends JPanel
implements PropertyChangeListener,
AsyncGUIJob {
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$core$ui$IDESettingsPanel == null ? (class$org$netbeans$core$ui$IDESettingsPanel = IDESettingsPanel.class$("org.netbeans.core.ui.IDESettingsPanel")) : class$org$netbeans$core$ui$IDESettingsPanel));
    private InitData initData;
    private JComboBox browserComboBox;
    private JLabel browserLabel;
    private JTextArea helpTextArea;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JLabel mdiIcon;
    private JRadioButton mdiRadioButton;
    private JTextField portField;
    private JLabel portLabel;
    private JCheckBox proxyCheckBox;
    private JLabel proxyLabel;
    private JLabel sdiIcon;
    private JRadioButton sdiRadioButton;
    private JTextField serverField;
    private JLabel serverLabel;
    private JLabel windowLabel;
    private int uiMode;
    private PropertyEditor editor;
    static /* synthetic */ Class class$org$netbeans$core$ui$IDESettingsPanel;
    static /* synthetic */ Class class$org$netbeans$core$IDESettings;
    static /* synthetic */ Class class$org$openide$awt$HtmlBrowser$Factory;

    public IDESettingsPanel() {
        this.initComponents();
        this.serverLabel.setDisplayedMnemonic(this.bundle.getString("LBL_Server_Name_Mnemonic").charAt(0));
        this.portLabel.setDisplayedMnemonic(this.bundle.getString("LBL__Port_Mnemonic").charAt(0));
        String string = this.bundle.getString("LBL_UseProxyServer");
        this.proxyCheckBox.setText(new StringBuffer(string.length() + 1).append(' ').append(string).toString());
        string = this.bundle.getString("LBL_SDI");
        this.sdiRadioButton.setText(new StringBuffer(string.length() + 1).append(' ').append(string).toString());
        string = this.bundle.getString("LBL_MDI");
        this.mdiRadioButton.setText(new StringBuffer(string.length() + 1).append(' ').append(string).toString());
        this.proxyCheckBox.setMnemonic(this.bundle.getString("LBL_UseProxyServer_Mnemonic").charAt(0));
        this.sdiRadioButton.setMnemonic(this.bundle.getString("LBL_SDI_Mnemonic").charAt(0));
        this.mdiRadioButton.setMnemonic(this.bundle.getString("LBL_MDI_Mnemonic").charAt(0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mdiRadioButton);
        bg.add(this.sdiRadioButton);
        this.putClientProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(0));
        this.putClientProperty(PROP_CONTENT_DATA, new String[]{this.getName()});
        this.initAccessibility();
        Utilities.attachInitJob((Component)this, (AsyncGUIJob)this);
    }

    private void initComponents() {
        this.proxyCheckBox = new JCheckBox();
        this.serverField = new JTextField();
        this.portField = new JTextField();
        this.sdiRadioButton = new JRadioButton();
        this.mdiRadioButton = new JRadioButton();
        this.serverLabel = new JLabel();
        this.portLabel = new JLabel();
        this.windowLabel = new JLabel();
        this.browserLabel = new JLabel();
        this.browserComboBox = new JComboBox();
        this.helpTextArea = new JTextArea();
        this.sdiIcon = new JLabel();
        this.mdiIcon = new JLabel();
        this.jTextArea1 = new JTextArea();
        this.proxyLabel = new JLabel();
        this.jTextArea2 = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setName(this.bundle.getString("LBL_IDEPanelName"));
        this.proxyCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IDESettingsPanel.this.changeProxyEnabled(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.proxyCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 60);
        this.add((Component)this.serverField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 160);
        this.add((Component)this.portField, gridBagConstraints);
        this.sdiRadioButton.setMargin(new Insets(0, 2, 0, 2));
        this.sdiRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IDESettingsPanel.this.changeWindowMode(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 72, 6, 0);
        this.add((Component)this.sdiRadioButton, gridBagConstraints);
        this.mdiRadioButton.setMargin(new Insets(0, 2, 0, 2));
        this.mdiRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IDESettingsPanel.this.changeWindowMode(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.add((Component)this.mdiRadioButton, gridBagConstraints);
        this.serverLabel.setLabelFor(this.serverField);
        this.serverLabel.setText(this.bundle.getString("LBL_Server_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 24, 5, 12);
        this.add((Component)this.serverLabel, gridBagConstraints);
        this.portLabel.setLabelFor(this.portField);
        this.portLabel.setText(this.bundle.getString("LBL_Port"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 24, 5, 12);
        this.add((Component)this.portLabel, gridBagConstraints);
        this.windowLabel.setLabelFor(this.sdiRadioButton);
        this.windowLabel.setText(this.bundle.getString("LBL_WindowMode"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.windowLabel, gridBagConstraints);
        this.browserLabel.setLabelFor(this.browserComboBox);
        this.browserLabel.setText(NbBundle.getMessage((Class)(class$org$netbeans$core$ui$IDESettingsPanel == null ? (class$org$netbeans$core$ui$IDESettingsPanel = IDESettingsPanel.class$("org.netbeans.core.ui.IDESettingsPanel")) : class$org$netbeans$core$ui$IDESettingsPanel), (String)"CTL_BrowserLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        this.add((Component)this.browserLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 160);
        this.add((Component)this.browserComboBox, gridBagConstraints);
        this.helpTextArea.setBackground((Color)UIManager.getDefaults().get("Panel.background"));
        this.helpTextArea.setColumns(53);
        this.helpTextArea.setEditable(false);
        this.helpTextArea.setFont(UIManager.getFont("Label.font"));
        this.helpTextArea.setLineWrap(true);
        this.helpTextArea.setRows(4);
        this.helpTextArea.setText(NbBundle.getMessage((Class)(class$org$netbeans$core$ui$IDESettingsPanel == null ? (class$org$netbeans$core$ui$IDESettingsPanel = IDESettingsPanel.class$("org.netbeans.core.ui.IDESettingsPanel")) : class$org$netbeans$core$ui$IDESettingsPanel), (String)"CTL_HelpTextArea"));
        this.helpTextArea.setWrapStyleWord(true);
        this.helpTextArea.setDisabledTextColor((Color)UIManager.getDefaults().get("Label.foreground"));
        this.helpTextArea.setEnabled(false);
        this.helpTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 12, 24, 0);
        this.add((Component)this.helpTextArea, gridBagConstraints);
        this.sdiIcon.setMinimumSize(new Dimension(99, 77));
        this.sdiIcon.setPreferredSize(new Dimension(99, 77));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 96, 24, 0);
        this.add((Component)this.sdiIcon, gridBagConstraints);
        this.mdiIcon.setMinimumSize(new Dimension(99, 77));
        this.mdiIcon.setPreferredSize(new Dimension(99, 77));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 36, 24, 0);
        this.add((Component)this.mdiIcon, gridBagConstraints);
        this.jTextArea1.setBackground((Color)UIManager.getDefaults().get("Panel.background"));
        this.jTextArea1.setColumns(30);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(UIManager.getFont("Label.font"));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(1);
        this.jTextArea1.setText(NbBundle.getMessage((Class)(class$org$netbeans$core$ui$IDESettingsPanel == null ? (class$org$netbeans$core$ui$IDESettingsPanel = IDESettingsPanel.class$("org.netbeans.core.ui.IDESettingsPanel")) : class$org$netbeans$core$ui$IDESettingsPanel), (String)"LBL_Head"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setDisabledTextColor((Color)UIManager.getDefaults().get("Label.foreground"));
        this.jTextArea1.setEnabled(false);
        this.jTextArea1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.proxyLabel.setLabelFor(this.sdiRadioButton);
        this.proxyLabel.setText(this.bundle.getString("LBL_WebProxy"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.proxyLabel, gridBagConstraints);
        this.jTextArea2.setBackground((Color)UIManager.getDefaults().get("Panel.background"));
        this.jTextArea2.setColumns(53);
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setFont(UIManager.getFont("Label.font"));
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setRows(3);
        this.jTextArea2.setText(NbBundle.getMessage((Class)(class$org$netbeans$core$ui$IDESettingsPanel == null ? (class$org$netbeans$core$ui$IDESettingsPanel = IDESettingsPanel.class$("org.netbeans.core.ui.IDESettingsPanel")) : class$org$netbeans$core$ui$IDESettingsPanel), (String)"LBL_ProxyDesc"));
        this.jTextArea2.setWrapStyleWord(true);
        this.jTextArea2.setDisabledTextColor((Color)UIManager.getDefaults().get("Label.foreground"));
        this.jTextArea2.setEnabled(false);
        this.jTextArea2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.jTextArea2, gridBagConstraints);
    }

    private void changeProxyEnabled(ActionEvent evt) {
        this.setProxySettingEnabled(this.proxyCheckBox.isSelected());
    }

    private void setProxySettingEnabled(boolean b) {
        this.serverLabel.setEnabled(b);
        this.portLabel.setEnabled(b);
        this.serverField.setEnabled(b);
        this.portField.setEnabled(b);
        if (b) {
            this.serverField.requestFocus();
        }
    }

    private void changeWindowMode(ActionEvent evt) {
        this.uiMode = evt.getSource() == this.mdiRadioButton ? 2 : 1;
    }

    public void initFromSettings(WizardDescriptor wd) {
        wd.addPropertyChangeListener((PropertyChangeListener)this);
        if (Boolean.TRUE.equals(wd.getProperty("initializePanel"))) {
            this.initializePanel();
        }
    }

    private void initializePanel() {
        this.uiMode = UIModeManager.getDefault().getUIMode();
        this.sdiRadioButton.setSelected(this.uiMode == 1);
        this.mdiRadioButton.setSelected(this.uiMode == 2);
        this.browserLabel.setDisplayedMnemonic(this.bundle.getString("CTL_BrowserLabel_mnemonic").charAt(0));
        try {
            IDESettings settings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = IDESettingsPanel.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
            this.proxyCheckBox.setSelected(settings.getUseProxy());
            this.serverField.setText(settings.getProxyHost());
            this.portField.setText(settings.getProxyPort());
            this.setProxySettingEnabled(settings.getUseProxy());
            this.putClientProperty("PostInit", this);
        }
        catch (RuntimeException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        WizardDescriptor wd;
        if (evt.getSource() instanceof WizardDescriptor && "value".equals(evt.getPropertyName()) && (wd = (WizardDescriptor)evt.getSource()).getValue() == WizardDescriptor.FINISH_OPTION) {
            wd.removePropertyChangeListener((PropertyChangeListener)this);
            IDESettings settings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = IDESettingsPanel.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
            settings.setProxyHost(this.serverField.getText());
            settings.setProxyPort(this.portField.getText());
            settings.setUseProxy(this.proxyCheckBox.isSelected());
            UIModeManager.getDefault().setUIMode(this.uiMode, true);
            if (this.editor != null) {
                try {
                    Object o = this.browserComboBox.getSelectedItem();
                    if (o instanceof String && o != null) {
                        this.editor.setAsText((String)o);
                        settings.setWWWBrowser((HtmlBrowser.Factory)this.editor.getValue());
                    }
                }
                catch (RuntimeException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_IDESettingsPanel"));
        this.browserComboBox.getAccessibleContext().setAccessibleDescription(this.helpTextArea.getText());
        this.proxyCheckBox.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_proxyCheckBox"));
        this.sdiRadioButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_sdiRadioButton"));
        this.mdiRadioButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_mdiRadioButton"));
        this.serverField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_serverField"));
        this.portField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_portField"));
    }

    public void construct() {
        this.initData = new InitData();
        this.initData.editor = PropertyEditorManager.findEditor(class$org$openide$awt$HtmlBrowser$Factory == null ? (class$org$openide$awt$HtmlBrowser$Factory = IDESettingsPanel.class$("org.openide.awt.HtmlBrowser$Factory")) : class$org$openide$awt$HtmlBrowser$Factory);
        IDESettings settings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = IDESettingsPanel.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
        this.initData.editor.setValue(settings.getWWWBrowser());
        this.initData.comboModel = new DefaultComboBoxModel<String>(this.initData.editor.getTags());
        this.initData.sdiIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/core/resources/sdi.gif"));
        this.initData.mdiIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/core/resources/mdi.gif"));
    }

    public void finished() {
        this.browserComboBox.setModel(this.initData.comboModel);
        this.browserComboBox.setSelectedItem(this.initData.editor.getAsText());
        this.editor = this.initData.editor;
        this.sdiIcon.setIcon(this.initData.sdiIcon);
        this.mdiIcon.setIcon(this.initData.mdiIcon);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class InitData {
        PropertyEditor editor;
        ComboBoxModel comboModel;
        Icon sdiIcon;
        Icon mdiIcon;

        private InitData() {
        }
    }
}

