/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.AWTEventListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class MouseCursorUtils
implements AWTEventListener,
Runnable {
    private static MouseCursorUtils instance;
    private static boolean cursorShown;

    private MouseCursorUtils() {
    }

    private static MouseCursorUtils getInstance() {
        if (instance == null) {
            instance = new MouseCursorUtils();
        }
        return instance;
    }

    public static void showWaitCursor() {
        Component mwGlass = ((JFrame)WindowManager.getDefault().getMainWindow()).getGlassPane();
        mwGlass.getToolkit().removeAWTEventListener(MouseCursorUtils.getInstance());
        mwGlass.getToolkit().addAWTEventListener(MouseCursorUtils.getInstance(), 64L);
        cursorShown = true;
        if (SwingUtilities.isEventDispatchThread()) {
            MouseCursorUtils.getInstance().run();
        } else {
            SwingUtilities.invokeLater(MouseCursorUtils.getInstance());
        }
    }

    public static void hideWaitCursor() {
        Component mwGlass = ((JFrame)WindowManager.getDefault().getMainWindow()).getGlassPane();
        mwGlass.getToolkit().removeAWTEventListener(MouseCursorUtils.getInstance());
        if (cursorShown) {
            cursorShown = false;
            if (SwingUtilities.isEventDispatchThread()) {
                MouseCursorUtils.getInstance().run();
            } else {
                SwingUtilities.invokeLater(MouseCursorUtils.getInstance());
            }
        }
    }

    public void run() {
        Component mwGlass = ((JFrame)WindowManager.getDefault().getMainWindow()).getGlassPane();
        if (cursorShown) {
            mwGlass.setCursor(Utilities.createProgressCursor((Component)mwGlass));
            mwGlass.setVisible(true);
        } else {
            mwGlass.setVisible(false);
            mwGlass.setCursor(null);
        }
    }

    public void eventDispatched(AWTEvent event) {
        if (event.getID() == 200) {
            MouseCursorUtils.hideWaitCursor();
        }
    }

    static {
        cursorShown = false;
    }
}

