/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.FocusManager;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class NbTextAreaA11y
extends JTextArea {
    private boolean isFocusable = false;
    private boolean isFocused = false;
    private boolean showFocus = false;
    private boolean tabWasReleased = false;

    public NbTextAreaA11y() {
    }

    public NbTextAreaA11y(String label) {
        this();
        this.setText(label);
    }

    public NbTextAreaA11y(boolean focusable) {
        this();
        this.isFocusable = this.showFocus = focusable;
        this.setA11yFocus(this.isFocusable);
    }

    public NbTextAreaA11y(boolean isFocusable, String a11yName, String a11yDesc) {
        this(isFocusable);
        this.setA11yContext(a11yName, a11yDesc);
    }

    public void setA11yContext(String a11yName, String a11yDesc) {
        if (a11yName == "" && this.getAccessibleContext().getAccessibleName() == null && this.getText() != "") {
            this.getAccessibleContext().setAccessibleName(this.getText());
        }
        if (a11yDesc == "" && this.getAccessibleContext().getAccessibleDescription() == null && this.getToolTipText() != "") {
            this.getAccessibleContext().setAccessibleDescription(this.getToolTipText());
        }
        if (a11yName != "") {
            this.getAccessibleContext().setAccessibleName(a11yName);
        }
        if (a11yDesc != "") {
            this.getAccessibleContext().setAccessibleDescription(a11yDesc);
        }
    }

    public void setA11yFocus(boolean a11yFocus) {
        this.isFocusable = a11yFocus;
        this.setA11yFocusShow(a11yFocus);
        this.setRequestFocusEnabled(a11yFocus);
        if (a11yFocus) {
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent event) {
                    NbTextAreaA11y.this.isFocused = true;
                    NbTextAreaA11y.this.repaint();
                }

                public void focusLost(FocusEvent event) {
                    NbTextAreaA11y.this.isFocused = false;
                    NbTextAreaA11y.this.repaint();
                }
            });
            this.addKeyListener(new KeyListener(){

                public void keyTyped(KeyEvent e) {
                    if (e.getKeyCode() == 9 && NbTextAreaA11y.this.tabWasReleased) {
                        NbTextAreaA11y.this.a11yFocusNext();
                        NbTextAreaA11y.this.tabWasReleased = false;
                    }
                }

                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 9 && NbTextAreaA11y.this.tabWasReleased) {
                        e.consume();
                        NbTextAreaA11y.this.a11yFocusNext();
                        NbTextAreaA11y.this.tabWasReleased = false;
                    }
                }

                public void keyPressed(KeyEvent e) {
                    NbTextAreaA11y.this.tabWasReleased = true;
                    if (e.getKeyCode() == 9) {
                        e.consume();
                    }
                }
            });
            this.repaint();
        }
    }

    public void setA11yFocusShow(boolean showFocusBorder) {
        this.showFocus = showFocusBorder;
    }

    public void setA11yAll(boolean a11yFocus, String a11yName, String a11yDesc) {
        this.setA11yFocus(a11yFocus);
        this.setA11yContext(a11yName, a11yDesc);
        this.repaint();
    }

    public void a11yFocusNext() {
        FocusManager focusManager = FocusManager.getCurrentManager();
        focusManager.focusNextComponent(this);
    }

    public boolean isFocusTraversable() {
        return this.isFocusable;
    }

    public boolean isManagingFocus() {
        return false;
    }

    public void paintComponent(Graphics g) {
        if (this.ui != null) {
            try {
                this.ui.update(g, this);
                Object var3_2 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                g.dispose();
                throw throwable;
            }
        }
        if (this.isFocused && this.showFocus) {
            Dimension size = this.getSize();
            g.setColor(UIManager.getColor("Button.focus"));
            g.drawRect(0, 0, size.width - 1, size.height - 1);
        }
    }
}

