/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.core.actions.SystemExit;
import org.netbeans.core.windows.JdkBug4524015Hack;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.RegistryImpl;
import org.netbeans.core.windows.StatusLine;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.WorkspaceSwitcher;
import org.netbeans.core.windows.frames.DesktopPane;
import org.netbeans.core.windows.frames.FrameType;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.awt.MenuBar;
import org.openide.awt.ToolbarPool;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class MainWindow
extends JFrame {
    static final long serialVersionUID = -1160791973145645501L;
    public static final String ABOUT_TO_SHOW = "aboutToShow";
    private static MainWindow instance;
    private HelpCtx mainWindowHelp;
    private MenuBar menuBar;
    private JPanel toolbars;
    private DesktopPane desktopPane;
    static /* synthetic */ Class class$org$netbeans$core$windows$MainWindow;

    private MainWindow() {
        JdkBug4524015Hack.install();
        this.addWindowListener(new IconifyManager());
    }

    public static synchronized MainWindow getDefault() {
        if (instance == null) {
            instance = new MainWindow();
        }
        return instance;
    }

    public static WorkspaceSwitcher getSwitcher() {
        return WorkspaceSwitcher.getInstance();
    }

    public void initialize() {
        this.menuBar = new MenuBar(null);
        this.menuBar.setBorderPainted(false);
        ImageIcon ideIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(NbBundle.getLocalizedFile((String)("org.netbeans.core.resources.frames.ide" + (Utilities.isLargeFrameIcons() ? "32" : "")), (String)"gif", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$windows$MainWindow == null ? (class$org$netbeans$core$windows$MainWindow = MainWindow.class$("org.netbeans.core.windows.MainWindow")) : class$org$netbeans$core$windows$MainWindow).getClassLoader())));
        ((Frame)this).setIconImage(ideIcon.getImage());
        this.updateTitle();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){
            static /* synthetic */ Class class$org$netbeans$core$actions$SystemExit;
            static /* synthetic */ Class class$org$netbeans$core$windows$MainWindow;

            public void windowClosing(WindowEvent evt) {
                ((SystemExit)SharedClassObject.findObject((Class)(class$org$netbeans$core$actions$SystemExit == null ? (class$org$netbeans$core$actions$SystemExit = 1.class$("org.netbeans.core.actions.SystemExit")) : class$org$netbeans$core$actions$SystemExit), (boolean)true)).performAction();
            }

            public void windowActivated(WindowEvent evt) {
                RegistryImpl.cancelMenu(MainWindow.this);
                if (MainWindow.this.mainWindowHelp == null) {
                    MainWindow.this.mainWindowHelp = new HelpCtx(1.class$org$netbeans$core$windows$MainWindow == null ? (1.class$org$netbeans$core$windows$MainWindow = 1.class$("org.netbeans.core.windows.MainWindow")) : 1.class$org$netbeans$core$windows$MainWindow);
                    HelpCtx.setHelpIDString((JComponent)MainWindow.this.getRootPane(), (String)MainWindow.this.mainWindowHelp.getHelpID());
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$MainWindow == null ? (class$org$netbeans$core$windows$MainWindow = MainWindow.class$("org.netbeans.core.windows.MainWindow")) : class$org$netbeans$core$windows$MainWindow), (String)"ACSD_MainWindow"));
    }

    public void showWindow() {
        if (this.menuBar == null) {
            this.initialize();
        }
        this.menuBar.waitFinished();
        ToolbarPool tp = ToolbarPool.getDefault();
        tp.waitFinished();
        this.toolbars = new JPanel();
        this.toolbars.setLayout(new BorderLayout());
        this.toolbars.add((Component)tp, "Center");
        if (this.enableFixedSwitcher()) {
            JPanel southPanel = new JPanel();
            southPanel.setBorder(new EmptyBorder(2, 0, 0, 0));
            southPanel.setLayout(new BorderLayout());
            WorkspaceSwitcher ws = WorkspaceSwitcher.getInstance();
            southPanel.add(ws.getComponent(), "West");
            JComponent status = StatusLine.createLabel();
            southPanel.add((Component)status, "Center");
            this.toolbars.add((Component)southPanel, "South");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.doShowWindow();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainWindow.this.doShowWindow();
                }
            });
        }
    }

    private void doShowWindow() {
        this.setJMenuBar((JMenuBar)this.menuBar);
        this.getContentPane().add((Component)this.toolbars, "North");
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        wm.getCurrentWorkspace();
        if (!wm.isMainPositioned()) {
            this.pack();
        } else {
            Rectangle origBounds = this.getBounds();
            this.pack();
            ((Component)this).setBounds(origBounds);
            this.validate();
        }
        this.firePropertyChange(ABOUT_TO_SHOW, null, null);
        this.show();
        this.getRootPane().requestDefaultFocus();
        wm.setWasIDEStarted(true);
    }

    private boolean enableFixedSwitcher() {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Toolbars/WorkspaceSwitcher");
        return fo != null ? false : !Boolean.getBoolean("netbeans.windows.no_wswitcher");
    }

    void updateTitle() {
        SwingUtilities.invokeLater(new Runnable(){
            static /* synthetic */ Class class$org$netbeans$core$windows$MainWindow;

            public void run() {
                WorkspaceImpl wi;
                ModeImpl mi;
                String buildNumber = System.getProperty("netbeans.buildnumber");
                String frameTitle = "";
                if (WindowUtils.isMdi() && (mi = (wi = (WorkspaceImpl)WindowManager.getDefault().getCurrentWorkspace()).getTopMaximizedMode()) != null) {
                    frameTitle = " - " + mi.frameTitle();
                }
                String title = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$MainWindow == null ? (class$org$netbeans$core$windows$MainWindow = 3.class$("org.netbeans.core.windows.MainWindow")) : class$org$netbeans$core$windows$MainWindow), (String)"CTL_MainWindow_Title", (Object)buildNumber);
                MainWindow.this.setTitle(title + frameTitle);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
    }

    Point getDesktopScreenLocation() {
        Point loc = new Point(0, 0);
        if (this.toolbars != null) {
            loc.y += this.toolbars.getSize().height;
        }
        SwingUtilities.convertPointToScreen(loc, this.getContentPane());
        return loc;
    }

    Dimension getDesktopSize() {
        Dimension result = this.getContentPane().getSize();
        if (this.toolbars != null) {
            result = new Dimension(result.width, result.height - this.toolbars.getSize().height);
        }
        return result;
    }

    public void validate() {
        super.validate();
        Dimension curSize = this.getSize();
        Dimension minSize = this.getMinimumSize();
        Dimension maxSize = this.getMaximumSize();
        final Dimension newSize = new Dimension(Math.min(maxSize.width, Math.max(curSize.width, minSize.width)), Math.min(maxSize.height, Math.max(curSize.height, minSize.height)));
        if (!newSize.equals(curSize)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((Component)MainWindow.this).setSize(newSize);
                }
            });
        }
    }

    public Dimension getPreferredSize() {
        if (WindowUtils.isMdi()) {
            return Utilities.getUsableScreenBounds().getSize();
        }
        return new Dimension(Utilities.getUsableScreenBounds().getSize().width, super.getPreferredSize().height);
    }

    public Dimension getMinimumSize() {
        if (WindowUtils.isMdi()) {
            return new Dimension(320, 320);
        }
        return new Dimension(320, super.getPreferredSize().height);
    }

    public Dimension getMaximumSize() {
        if (WindowUtils.isMdi()) {
            return super.getMaximumSize();
        }
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    protected void processWindowEvent(WindowEvent evt) {
        TopComponent activatedTc;
        DesktopPane dp = null;
        if (WindowUtils.isMdi() && (activatedTc = TopComponent.getRegistry().getActivated()) != null && !this.equals(SwingUtilities.windowForComponent((Component)activatedTc)) && evt.getID() == 205) {
            dp = ((WorkspaceImpl)WindowManagerImpl.getInstance().getCurrentWorkspace()).desktopPane();
            dp.setAutoFocusEnabled(false);
        }
        super.processWindowEvent(evt);
        if (dp != null) {
            dp.setAutoFocusEnabled(true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class IconifyManager
    extends WindowAdapter
    implements Runnable {
        private WorkspaceImpl workspace;

        IconifyManager() {
        }

        public void windowIconified(WindowEvent evt) {
            if (!WindowUtils.isMdi()) {
                RequestProcessor.postRequest((Runnable)this, (int)200);
            }
        }

        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.iconify();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        public void windowDeiconified(WindowEvent evt) {
            if (this.workspace != null) {
                this.workspace.setVisible(true);
                this.workspace = null;
            }
        }

        private void iconify() {
            this.workspace = (WorkspaceImpl)WindowManager.getDefault().getCurrentWorkspace();
            Iterator it = this.workspace.getModes().iterator();
            while (it.hasNext()) {
                FrameType curFrame = ((ModeImpl)it.next()).getFrameInstance();
                if (curFrame == null || curFrame.getState() != 0) continue;
                this.workspace.setVisible(false);
                return;
            }
        }
    }
}

