/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.core.IDESettings;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakSet;

public class MiniStatusBar
extends JLabel {
    public static final String PROP_NODE_DESCRIPTION = "nodeDescription";
    private static final WeakSet loggedClasses = new WeakSet();
    private static boolean LOG_NODE_DESCRIPTION = Boolean.getBoolean("netbeans.log.node.description");
    private ExplorerManager explorerMgr;
    private PropertyChangeListener selectedNodesListener;
    private static IDESettings ideSettings;
    static /* synthetic */ Class class$org$netbeans$core$IDESettings;

    private MiniStatusBar() {
        this((ExplorerManager)null);
    }

    public MiniStatusBar(ExplorerManager mgr) {
        this.initialize();
        this.setExplorerManager(mgr);
        this.setNodeDescription(null);
    }

    private void initialize() {
        Border bor;
        this.setOpaque(false);
        this.setEnabled(true);
        UIDefaults def = UIManager.getDefaults();
        Color backcolor = def.getColor("nb.MiniStatusBar.foreground");
        Color forecolor = def.getColor("nb.MiniStatusBar.background");
        if (backcolor != null) {
            this.setBackground(backcolor);
        }
        if (forecolor != null) {
            this.setForeground(forecolor);
        }
        if ((bor = def.getBorder("nb.MiniStatusBar.border")) == null) {
            bor = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, def.getColor("control")), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, def.getColor("controlHighlight")), BorderFactory.createLineBorder(def.getColor("controlDkShadow"))));
        }
        this.setBorder(bor);
    }

    private static IDESettings ideSettings() {
        if (ideSettings == null) {
            ideSettings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = MiniStatusBar.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
        }
        return ideSettings;
    }

    public static void setMiniStatusBarEnabled(boolean state) {
        if (MiniStatusBar.isMiniStatusBarEnabled() == state) {
            return;
        }
        MiniStatusBar.ideSettings().setMiniStatusBarState(state);
    }

    public static boolean isMiniStatusBarEnabled() {
        return MiniStatusBar.ideSettings().getMiniStatusBarState();
    }

    private void setNodeDescription(String desc) {
        if (!MiniStatusBar.isMiniStatusBarEnabled()) {
            return;
        }
        if (this.getRootPane() != null) {
            this.getRootPane().revalidate();
        }
        if (desc != null) {
            if (desc.startsWith("<html>")) {
                this.setText("<html>&nbsp;" + desc.substring(6));
            } else {
                this.setText(" " + desc);
            }
        } else {
            this.setText(" ");
        }
    }

    public void setExplorerManager(ExplorerManager mgr) {
        if (this.explorerMgr != null && this.explorerMgr.equals(mgr)) {
            this.selectedNodesListener.propertyChange(new PropertyChangeEvent(this, "selectedNodes", null, mgr.getSelectedNodes()));
            return;
        }
        if (this.explorerMgr != null) {
            this.explorerMgr.removePropertyChangeListener(this.selectedNodesListener);
        }
        if (mgr != null) {
            if (this.selectedNodesListener == null) {
                this.selectedNodesListener = new SelectedNodesListener();
            }
            this.selectedNodesListener.propertyChange(new PropertyChangeEvent(this, "selectedNodes", null, mgr.getSelectedNodes()));
            mgr.addPropertyChangeListener(this.selectedNodesListener);
        }
        this.explorerMgr = mgr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SelectedNodesListener
    implements PropertyChangeListener {
        private Node[] describedNodes;
        static /* synthetic */ Class class$org$openide$nodes$FilterNode;

        SelectedNodesListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Object newVal = evt.getNewValue();
                if (this.describedNodes != null && this.describedNodes.equals(newVal) && evt.getOldValue() != null) {
                    return;
                }
                if (newVal instanceof Node[]) {
                    this.describedNodes = (Node[])newVal;
                    String description = null;
                    int i = 0;
                    while (i < this.describedNodes.length) {
                        String newDesc = this.getNodeDesc(this.describedNodes[i]);
                        if (description == null) {
                            description = newDesc;
                        } else if (!description.equals(newDesc)) {
                            description = null;
                            break;
                        }
                        ++i;
                    }
                    MiniStatusBar.this.setNodeDescription(description);
                }
            }
        }

        private String getNodeDesc(Node n) {
            String nodeDesc = (String)n.getValue(MiniStatusBar.PROP_NODE_DESCRIPTION);
            if (nodeDesc == null && (nodeDesc = n.getShortDescription()) != null && nodeDesc.equals(n.getDisplayName())) {
                nodeDesc = null;
            }
            this.logDescription(n, nodeDesc);
            return nodeDesc;
        }

        private void logDescription(Node n, String desc) {
            if (LOG_NODE_DESCRIPTION) {
                String logMessage;
                if (n instanceof FilterNode) {
                    try {
                        Method getOriginal = (class$org$openide$nodes$FilterNode == null ? (class$org$openide$nodes$FilterNode = SelectedNodesListener.class$("org.openide.nodes.FilterNode")) : class$org$openide$nodes$FilterNode).getDeclaredMethod("getOriginal", new Class[0]);
                        ((AccessibleObject)getOriginal).setAccessible(true);
                        try {
                            n = (Node)getOriginal.invoke((Object)n, new Object[0]);
                            Object var5_5 = null;
                            ((AccessibleObject)getOriginal).setAccessible(false);
                        }
                        catch (Throwable throwable) {
                            Object var5_6 = null;
                            ((AccessibleObject)getOriginal).setAccessible(false);
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                String className = n.getClass().getName();
                if (!loggedClasses.add((Object)className)) {
                    return;
                }
                ErrorManager em = ErrorManager.getDefault();
                if (desc == null || desc.equals(n.getDisplayName())) {
                    logMessage = MessageFormat.format("Node description of {0}: Warning! No description is provided. More info at http://openide.netbeans.org/unbranded-source/browse/~checkout~/openide/api/doc/org/openide/doc-files/upgrade.html", className);
                    em.log(16, logMessage);
                } else {
                    logMessage = MessageFormat.format("Node description of {0}: {1} More info at http://openide.netbeans.org/unbranded-source/browse/~checkout~/openide/api/doc/org/openide/doc-files/upgrade.html", className, desc);
                    em.log(16, logMessage);
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

