/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.LazyUpdater;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceBoundsManager;
import org.netbeans.core.windows.WorkspaceVisibilityManager;
import org.netbeans.core.windows.frames.DesktopPane;
import org.netbeans.core.windows.util.DefaultReplacer;
import org.netbeans.core.windows.util.VersionSerializator;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.awt.ToolbarPool;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class WorkspaceImpl
implements Workspace {
    public static final int PROPERTIES = 1;
    public static final int MODES = 2;
    private static int numberOfWorkspaces = 0;
    private String name;
    private String displayName;
    private String description;
    private String toolbarConfigName = "Standard";
    private final List modes = new ArrayList(10);
    private Mode current;
    private Mode lastActivatedMode;
    private ModeImpl topMaximizedMode;
    private boolean wasMaxMode;
    private boolean wasVisible = false;
    private WindowManagerImpl.TopComponentManager savedManager;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private VersionSerializator serializationManager;
    private WorkspaceVisibilityManager visManager;
    private WorkspaceBoundsManager boundsManager;
    private LazyUpdater updater;
    private String nameBundle;
    private String descriptionBundle;
    private boolean fromBundle;
    private final Set shownTcs = new WeakSet(5);
    private Set pendingShownTcs;
    static final long serialVersionUID = -1865300855714270375L;
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$org$netbeans$core$windows$WorkspaceImpl;

    public WorkspaceImpl() {
        this((String)null);
    }

    public WorkspaceImpl(String name) {
        this(name, name, false);
    }

    public WorkspaceImpl(String name, String displayName) {
        this(name, displayName, false);
    }

    public WorkspaceImpl(String name, String displayName, boolean fromBundle) {
        int postfix = 0;
        if (name == null) {
            this.name = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$WorkspaceImpl == null ? (class$org$netbeans$core$windows$WorkspaceImpl = WorkspaceImpl.class$("org.netbeans.core.windows.WorkspaceImpl")) : class$org$netbeans$core$windows$WorkspaceImpl), (String)"WorkspaceNumber", (Object)new Integer(++numberOfWorkspaces));
        } else {
            this.name = name;
            while (WindowManager.getDefault().findWorkspace(this.name) != null) {
                this.name = name + "_" + ++postfix;
            }
        }
        this.displayName = (displayName == null ? this.name : displayName) + (postfix > 0 ? "_" + postfix : "");
        this.fromBundle = fromBundle;
    }

    public WorkspaceImpl(WorkspaceImpl original) {
        this(original.name, original.getDisplayName());
        this.boundsManager().copyFrom(original.boundsManager());
        this.toolbarConfigName = new String(original.getToolbarConfigName());
        Iterator iter = original.getModeList().iterator();
        while (iter.hasNext()) {
            ModeImpl curMode = (ModeImpl)iter.next();
            ModeImpl newMode = new ModeImpl(this, curMode);
            if (curMode.equals(original.current)) {
                this.current = newMode;
            }
            this.modes.add(newMode);
            newMode.fillTopComponents(curMode);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        this.ensureSectionLoaded(1);
        if (this.fromBundle) {
            String bName = this.nameBundle;
            if (bName == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Workspace " + this.name + " does not specify nameBundle in xml data!"));
            } else {
                try {
                    return NbBundle.getBundle((String)bName).getString(this.displayName);
                }
                catch (MissingResourceException mre) {
                    ErrorManager.getDefault().notify(1, (Throwable)mre);
                }
            }
        }
        return this.displayName;
    }

    public Set getModes() {
        this.ensureSectionLoaded(2);
        return Collections.unmodifiableSet(new HashSet(this.modes));
    }

    public Rectangle getBounds() {
        this.ensureSectionLoaded(1);
        return this.boundsManager().getWorkingSpaceBounds();
    }

    public void activate() {
        final WindowManagerImpl wm = WindowManagerImpl.getInstance();
        if (EventQueue.isDispatchThread()) {
            wm.setCurrentWorkspace(this);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    wm.setCurrentWorkspace(WorkspaceImpl.this);
                }
            });
        }
    }

    public Mode createMode(String name, String displayName, URL icon) {
        return this.createMode(name, displayName, icon, false);
    }

    public Mode findMode(String name) {
        return this.doFindMode(name, true);
    }

    public Mode findMode(TopComponent c) {
        String tc_id;
        this.ensureSectionLoaded(2);
        ModeImpl[] modeArray = null;
        List list = this.modes;
        synchronized (list) {
            modeArray = this.modes.toArray(new ModeImpl[0]);
        }
        int i = 0;
        while (i < modeArray.length) {
            TopComponent[] tcs = modeArray[i].getLoadedTopComponents();
            int y = 0;
            while (y < tcs.length) {
                if (c.equals(tcs[y])) {
                    return modeArray[i];
                }
                ++y;
            }
            ++i;
        }
        PersistenceManager pm = PersistenceManager.getDefault();
        try {
            tc_id = pm.lookupTCStringId(c);
        }
        catch (NotSerializableException nse) {
            String msg = nse.getMessage();
            if (msg != null) {
                ErrorManager.getDefault().log(16, "[WinSys] Component is not serializable. Reason: " + msg);
            }
            return null;
        }
        catch (IOException ioe) {
            ErrorManager em = ErrorManager.getDefault();
            em.annotate((Throwable)ioe, "No TC_ID for [" + c.getName() + "] " + c);
            em.notify(1, (Throwable)ioe);
            return null;
        }
        int i2 = 0;
        while (i2 < modeArray.length) {
            String[] tcIds = modeArray[i2].getTopComponentIds();
            int j = 0;
            while (j < tcIds.length) {
                if (tc_id.equals(tcIds[j])) {
                    return modeArray[i2];
                }
                ++j;
            }
            ++i2;
        }
        return null;
    }

    public void remove() {
        ModeImpl[] modeArray = null;
        List list = this.modes;
        synchronized (list) {
            modeArray = this.modes.toArray(new ModeImpl[0]);
        }
        if (modeArray.length > 0) {
            int i = 0;
            while (i < modeArray.length) {
                modeArray[i].close();
                ++i;
            }
            List list2 = this.modes;
            synchronized (list2) {
                this.modes.clear();
            }
            this.changeSupport.firePropertyChange("modes", null, null);
        }
        Workspace[] wss = WindowManagerImpl.getInstance().getWorkspaces();
        int i = 0;
        i = 0;
        while (i < wss.length) {
            if (this.equals(wss[i])) break;
            ++i;
        }
        if (i < wss.length) {
            Workspace[] nwss = new Workspace[wss.length - 1];
            System.arraycopy(wss, 0, nwss, 0, i);
            System.arraycopy(wss, i + 1, nwss, i, wss.length - (i + 1));
            WindowManagerImpl.getInstance().setWorkspaces(nwss);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + ", displayName=" + this.displayName + "]";
    }

    public void attachUpdater(LazyUpdater updater) {
        this.updater = updater;
    }

    public void save() throws IOException {
        Iterator it = this.getLoadedModeList().iterator();
        while (it.hasNext()) {
            try {
                ((ModeImpl)it.next()).save();
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify(1, (Throwable)exc);
            }
        }
    }

    public String getDisplayNameXML() {
        this.ensureSectionLoaded(1);
        return this.displayName;
    }

    public String getNameBundle() {
        this.ensureSectionLoaded(1);
        return this.nameBundle;
    }

    public void setNameBundle(String nameBundle) {
        this.nameBundle = nameBundle;
    }

    public void setDisplayName(String s) {
        String localDisplay = this.getDisplayName();
        if (localDisplay != null) {
            localDisplay = Actions.cutAmpersand((String)localDisplay);
        }
        String inNoShortcut = Actions.cutAmpersand((String)s);
        if (localDisplay != null && localDisplay.equals(inNoShortcut) || localDisplay == null && inNoShortcut == null) {
            return;
        }
        this.fromBundle = false;
        String oldDisplayName = this.displayName;
        this.displayName = s;
        this.changeSupport.firePropertyChange("displayName", oldDisplayName, this.displayName);
    }

    public void setDisplayNameXML(String s) {
        String oldDisplayName = this.displayName;
        this.displayName = s;
        this.changeSupport.firePropertyChange("displayName", oldDisplayName, this.displayName);
    }

    public String getDescriptionXML() {
        this.ensureSectionLoaded(1);
        return this.description;
    }

    public void setDescriptionXML(String s) {
        this.description = s;
    }

    public String getDescription() {
        this.ensureSectionLoaded(1);
        if (this.descriptionBundle == null || this.description == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Workspace " + this.name + " does not specify description in xml data:" + " descriptionBundle=" + this.descriptionBundle + ", description=" + this.description + " !"));
        } else {
            try {
                return NbBundle.getBundle((String)this.descriptionBundle).getString(this.description);
            }
            catch (MissingResourceException mre) {
                ErrorManager.getDefault().notify(1, (Throwable)mre);
            }
        }
        return this.description;
    }

    public String getDescriptionBundle() {
        this.ensureSectionLoaded(1);
        return this.descriptionBundle;
    }

    public void setDescriptionBundle(String descriptionBundle) {
        this.descriptionBundle = descriptionBundle;
    }

    public Mode getActiveMode() {
        this.ensureSectionLoaded(1);
        return this.current;
    }

    public void setActiveMode(Mode current) {
        ModeImpl m;
        WindowManagerImpl wmi = (WindowManagerImpl)WindowManager.getDefault();
        if (wmi.isExitingIDE()) {
            return;
        }
        this.current = current;
        if (current != null && !(m = (ModeImpl)current).isActive()) {
            m.requestFocus();
        }
    }

    public Mode getLastActivatedMode() {
        return this.lastActivatedMode;
    }

    public void setLastActivatedMode(Mode lastActivatedMode) {
        this.lastActivatedMode = lastActivatedMode;
    }

    public void setShownTcs(Set shownTcs) {
        this.shownTcs.clear();
        this.shownTcs.addAll(shownTcs);
    }

    public Set getShownTcs() {
        return new HashSet(this.shownTcs);
    }

    public void addToShownTcs(TopComponent tc) {
        if (this.shownTcs.contains(tc)) {
            return;
        }
        ((WindowManagerImpl)WindowManager.getDefault()).componentShowing(tc);
        this.shownTcs.add(tc);
    }

    public void removeFromShownTcs(TopComponent tc) {
        if (!this.shownTcs.contains(tc)) {
            return;
        }
        ((WindowManagerImpl)WindowManager.getDefault()).componentHidden(tc);
        this.shownTcs.remove(tc);
    }

    public void setPendingShownTcs(Set pendingShownTcs) {
        this.pendingShownTcs = pendingShownTcs;
    }

    public Set getPendingShownTcs() {
        HashSet hs = new HashSet();
        if (this.pendingShownTcs != null) {
            hs.addAll(this.pendingShownTcs);
        }
        return hs;
    }

    void setTopMaximizedMode(ModeImpl mode) {
        if (this.topMaximizedMode == null ? this.topMaximizedMode == mode : this.topMaximizedMode.equals(mode)) {
            return;
        }
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        if (mode != null) {
            wm.addButtons();
        } else {
            wm.removeButtons();
        }
        this.topMaximizedMode = mode;
        MainWindow.getDefault().updateTitle();
    }

    public ModeImpl getTopMaximizedMode() {
        return this.topMaximizedMode;
    }

    boolean isTopMaximizedMode() {
        return this.topMaximizedMode != null;
    }

    public List getModeList() {
        return this.doGetModeList(true);
    }

    public List getLoadedModeList() {
        return this.doGetModeList(false);
    }

    private List doGetModeList(boolean load) {
        if (load) {
            this.ensureSectionLoaded(2);
        }
        List list = this.modes;
        synchronized (list) {
            ArrayList arrayList = new ArrayList(this.modes);
            return arrayList;
        }
    }

    public List getZOrder() {
        return this.visManager().getZOrder();
    }

    public void setZOrder(List zOrderList) {
        this.visManager().setZOrder(zOrderList);
    }

    public boolean isNameFromBundle() {
        this.ensureSectionLoaded(1);
        return this.fromBundle;
    }

    public void setNameFromBundle(boolean fromBundle) {
        if (this.fromBundle == fromBundle) {
            return;
        }
        String dspName = this.getDisplayName();
        this.fromBundle = fromBundle;
        String dspName2 = this.getDisplayName();
        if (!dspName.equals(dspName2)) {
            this.changeSupport.firePropertyChange("displayName", dspName, dspName2);
        }
    }

    public void setNameFromBundleXML(boolean fromBundle) {
        this.fromBundle = fromBundle;
    }

    public Mode createMode(String name, String displayName, URL icon, boolean userDefined) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot create mode with null name!");
        }
        Mode newMode = this.findLoadedMode(name);
        if (newMode == null) {
            newMode = new ModeImpl(name, displayName, icon, userDefined, this);
            this.addMode(newMode);
        }
        return newMode;
    }

    public Mode findLoadedMode(String name) {
        return this.doFindMode(name, false);
    }

    private Mode doFindMode(String name, boolean load) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot search for mode with null name!");
        }
        if (load) {
            this.ensureSectionLoaded(2);
        }
        Mode[] modeArray = null;
        List list = this.modes;
        synchronized (list) {
            modeArray = this.modes.toArray(new Mode[0]);
        }
        int i = 0;
        while (i < modeArray.length) {
            if (name.equals(modeArray[i].getName())) {
                return modeArray[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isOpened(TopComponent tc) {
        WindowManagerImpl.getInstance();
        return WindowManagerImpl.findManager(tc).isOpened(this);
    }

    public void removeModes() {
        ModeImpl[] modeArray;
        List list = this.modes;
        synchronized (list) {
            if (this.modes.size() == 0) {
                return;
            }
            modeArray = this.modes.toArray(new ModeImpl[0]);
        }
        int i = 0;
        while (i < modeArray.length) {
            modeArray[i].close();
            ++i;
        }
        List list2 = this.modes;
        synchronized (list2) {
            this.modes.clear();
        }
        this.changeSupport.firePropertyChange("modes", null, null);
    }

    public void closeModes() {
        ModeImpl[] modeArray = null;
        List list = this.modes;
        synchronized (list) {
            if (this.modes.size() == 0) {
                return;
            }
            modeArray = this.modes.toArray(new ModeImpl[0]);
        }
        int i = 0;
        while (i < modeArray.length) {
            modeArray[i].setCloseOnlyInMemory(true);
            modeArray[i].close();
            modeArray[i].setCloseOnlyInMemory(false);
            modeArray[i].resetComponents();
            modeArray[i].removeAllClosedComponents();
            modeArray[i].setChanged(false);
            ++i;
        }
        List list2 = this.modes;
        synchronized (list2) {
            this.modes.clear();
        }
        this.changeSupport.firePropertyChange("modes", null, null);
        this.visManager().setDominanceList(null);
    }

    void setWasVisible(boolean b) {
        this.wasVisible = b;
    }

    boolean isWasVisible() {
        return this.wasVisible;
    }

    public void setVisible(boolean visible) {
        this.setVisible(visible, true);
    }

    void setVisible(boolean visible, boolean ensureLoaded) {
        if (visible && ensureLoaded) {
            this.ensureSectionLoaded(3);
        }
        if (visible) {
            this.activateToolbarConfig();
        }
        this.visManager().setVisible(visible);
    }

    public boolean isVisible() {
        return this.visManager().isVisible();
    }

    public void setSavedActive(TopComponent savedActive) {
        this.visManager().setSavedActive(savedActive);
    }

    public String getToolbarConfigName() {
        this.ensureSectionLoaded(1);
        return this.toolbarConfigName;
    }

    public void setToolbarConfigName(String name) {
        this.toolbarConfigName = name;
        if (this.equals(WindowManagerImpl.getInstance().getCurrentWorkspace())) {
            this.activateToolbarConfig();
        }
    }

    private void activateToolbarConfig() {
        ToolbarPool.getDefault().setConfiguration(this.toolbarConfigName);
    }

    public void fireModeChange() {
        this.changeSupport.firePropertyChange("modes", null, null);
    }

    private static void log(String s) {
    }

    private static void logArray(Object[] o) {
        WorkspaceImpl.log("Array: " + o);
        if (o != null) {
            int i = 0;
            while (i < o.length) {
                WorkspaceImpl.log("\t " + i + ": " + o[i]);
                ++i;
            }
        }
    }

    private static void logStack() {
    }

    public void addMode(Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Cannot add null mode to the workspace");
        }
        List list = this.modes;
        synchronized (list) {
            if (this.modes.contains(mode)) {
                return;
            }
            this.modes.add(mode);
        }
        this.changeSupport.firePropertyChange("modes", null, null);
    }

    public void removeMode(Mode mode) {
        boolean removed = false;
        List list = this.modes;
        synchronized (list) {
            removed = this.modes.remove(mode);
        }
        if (removed) {
            this.changeSupport.firePropertyChange("modes", null, null);
        }
    }

    public void setCascadingOrigin(Point cascadingOrigin) {
        this.boundsManager().setCascadingOrigin(cascadingOrigin);
    }

    public Point getCascadingOrigin() {
        this.ensureSectionLoaded(1);
        return this.boundsManager().getCascadingOrigin();
    }

    public Dimension getCascadeStep() {
        this.ensureSectionLoaded(1);
        return this.boundsManager().getCascadeStep();
    }

    public void setCascadeStep(Dimension cascadeStep) {
        this.boundsManager().setCascadeStep(cascadeStep);
    }

    public int getCascadeStepsCount() {
        this.ensureSectionLoaded(1);
        return this.boundsManager().getCascadeStepsCount();
    }

    public void setCascadeStepsCount(int cascadeStepsCount) {
        this.boundsManager().setCascadeStepsCount(cascadeStepsCount);
    }

    public Point getCascadePoint() {
        this.ensureSectionLoaded(1);
        return this.boundsManager().getCascadePoint();
    }

    public void setCascadePoint(Point cascadePoint) {
        this.boundsManager().setCascadePoint(cascadePoint);
    }

    void placeMode(ModeImpl mode, TopComponent tc) {
        this.boundsManager().placeMode(mode, tc);
    }

    void reactivateSavedTc() {
        if (this.savedManager == null) {
            return;
        }
        final TopComponent toBeActivated = this.savedManager.getComponent();
        this.savedManager = null;
        if (toBeActivated != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    toBeActivated.requestFocus();
                }
            });
        }
    }

    void componentActivated(TopComponent activeTc) {
        if (this.visManager().isProcessing()) {
            return;
        }
        Mode activeMode = this.findMode(activeTc);
        if (activeMode != null) {
            List list = this.modes;
            synchronized (list) {
                this.modes.remove(activeMode);
                this.modes.add(0, activeMode);
            }
        }
    }

    private static void excludeUserOrphans(List allModes) {
        List list = allModes;
        synchronized (list) {
            Iterator it = allModes.iterator();
            while (it.hasNext()) {
                ModeImpl next = (ModeImpl)it.next();
                if (!next.isUserDefined() || !next.isOrphan()) continue;
                it.remove();
            }
        }
    }

    public DesktopPane desktopPane() {
        return this.visManager().desktopPane();
    }

    Point getDesktopScreenLocation() {
        this.ensureSectionLoaded(1);
        return this.boundsManager().getDesktopScreenLocation();
    }

    public Rectangle getWorkingSpaceBounds() {
        this.ensureSectionLoaded(1);
        return this.boundsManager().getWorkingSpaceBounds();
    }

    private WorkspaceVisibilityManager visManager() {
        if (this.visManager == null) {
            this.visManager = new WorkspaceVisibilityManager(this);
        }
        return this.visManager;
    }

    private WorkspaceBoundsManager boundsManager() {
        if (this.boundsManager == null) {
            this.boundsManager = new WorkspaceBoundsManager(this);
        }
        return this.boundsManager;
    }

    boolean ensureSectionLoaded(int section) {
        if (this.updater == null) {
            return false;
        }
        try {
            if (!this.updater.isValid()) {
                return false;
            }
            if ((section & this.updater.getLoadedSections()) != section) {
                this.updater.loadDataSection(section);
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
            return false;
        }
        return true;
    }

    private Object writeReplace() throws ObjectStreamException {
        WorkspaceImpl.excludeUserOrphans(this.modes);
        return new SerializationReplacer(this);
    }

    void validateSelf() {
        ModeImpl[] modeArray;
        List list = this.modes;
        synchronized (list) {
            modeArray = this.modes.toArray(new ModeImpl[this.modes.size()]);
        }
        int i = 0;
        while (i < modeArray.length) {
            modeArray[i].validateSelf(this);
            ++i;
        }
    }

    void validateData() {
        this.boundsManager().correctBounds();
        this.visManager().validateModes();
        this.changeSupport.firePropertyChange("modes", null, null);
    }

    public List getDominanceList() {
        return this.visManager().getDominanceList();
    }

    void synchronizeMaxMode() {
        if (this.wasMaxMode) {
            this.wasMaxMode = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WorkspaceImpl.this.desktopPane().setMaxMode(true);
                }
            });
        }
    }

    public void setWasMaxMode(boolean wasMaxMode) {
        this.wasMaxMode = wasMaxMode;
        this.synchronizeMaxMode();
    }

    public boolean getWasMaxMode() {
        return this.wasMaxMode;
    }

    private VersionSerializator serializationManager() {
        if (this.serializationManager == null) {
            this.serializationManager = WorkspaceImpl.createSerializationManager();
        }
        return this.serializationManager;
    }

    private static VersionSerializator createSerializationManager() {
        VersionSerializator result = new VersionSerializator();
        result.putVersion(new Version1());
        result.putVersion(new Version2());
        result.putVersion(new Version3());
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class VSAccess
    implements DefaultReplacer.Access {
        private static final long serialVersionUID = 2367034636261092266L;
        transient VersionSerializator vs;

        public VSAccess(VersionSerializator vs) {
            this.vs = vs;
        }

        public VersionSerializator getVersionSerializator() {
            return this.vs == null ? WorkspaceImpl.createSerializationManager() : this.vs;
        }
    }

    private static class Version3
    extends Version2 {
        public static final String NAME3 = "Version_3.0";
        boolean fromBundle;

        Version3() {
        }

        public String getName() {
            return NAME3;
        }

        public void readData(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readData(in);
            this.fromBundle = (Boolean)in.readObject();
        }

        public void writeData(ObjectOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Object resolveData() throws ObjectStreamException {
            WorkspaceImpl result = (WorkspaceImpl)super.resolveData();
            WorkspaceImpl existing = (WorkspaceImpl)WindowManager.getDefault().findWorkspace(this.name);
            if (existing == null) {
                result.fromBundle = this.fromBundle;
            }
            return result;
        }
    }

    private static class Version2
    extends Version1 {
        public static final String NAME2 = "Version_2.0";
        Point cascadingOrigin;
        WindowManagerImpl.TopComponentManager savedManager;

        Version2() {
        }

        public String getName() {
            return NAME2;
        }

        public void readData(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readData(in);
            this.cascadingOrigin = (Point)in.readObject();
            this.savedManager = (WindowManagerImpl.TopComponentManager)in.readObject();
        }

        public void writeData(ObjectOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Object resolveData() throws ObjectStreamException {
            WorkspaceImpl result = (WorkspaceImpl)super.resolveData();
            WorkspaceImpl existing = (WorkspaceImpl)WindowManager.getDefault().findWorkspace(this.name);
            if (existing == null) {
                result.boundsManager().setCascadingOrigin(this.cascadingOrigin);
                result.savedManager = this.savedManager;
            }
            return result;
        }
    }

    private static class Version1
    implements DefaultReplacer.ResVersionable {
        public static final String NAME = "Version_1.0";
        String name;
        String displayName;
        Dimension cascadeStep;
        int cascadeStepsCount;
        Point cascadePoint;
        String toolbarConfigName;
        HashSet modes;
        Mode current;
        WorkspaceImpl workspace;

        Version1() {
        }

        public String getName() {
            return NAME;
        }

        public void readData(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = (String)in.readObject();
            this.displayName = (String)in.readObject();
            this.cascadeStep = (Dimension)in.readObject();
            this.cascadeStepsCount = (Integer)in.readObject();
            this.cascadePoint = (Point)in.readObject();
            this.toolbarConfigName = (String)in.readObject();
            this.modes = (HashSet)in.readObject();
            this.current = (Mode)in.readObject();
        }

        public void writeData(ObjectOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Object resolveData() throws ObjectStreamException {
            WorkspaceImpl result = (WorkspaceImpl)WindowManager.getDefault().findWorkspace(this.name);
            if (result == null) {
                result = new WorkspaceImpl(this.name);
                result.displayName = this.displayName;
                WorkspaceBoundsManager boundsManager = result.boundsManager();
                boundsManager.setCascadeStep(this.cascadeStep);
                boundsManager.setCascadeStepsCount(this.cascadeStepsCount);
                boundsManager.setCascadePoint(this.cascadePoint);
                result.toolbarConfigName = this.toolbarConfigName;
                result.modes.addAll(this.modes);
                result.current = this.current;
            } else {
                Mode curMode = null;
                Iterator iter = this.modes.iterator();
                while (iter.hasNext()) {
                    curMode = (Mode)iter.next();
                    if (result.findMode(curMode.getName()) != null) continue;
                    result.addMode(curMode);
                }
            }
            return result;
        }
    }

    private static final class SerializationReplacer
    implements Serializable {
        static final long serialVersionUID = -1110255063830989275L;
        private static final String NAME = "name";
        private static final String DISPLAY_NAME = "displayName";
        private static final String CASCADE_STEP = "cascadeStep";
        private static final String CASCADE_STEPS_COUNT = "cascadeStepsCount";
        private static final String CASCADE_POINT = "cascadePoint";
        private static final String CASCADING_ORIGIN = "cascadingOrigin";
        private static final String TOOLBAR_CONFIG_NAME = "toolbarConfigName";
        private static final String MODES = "modes";
        private static final String CURRENT_MODE = "current";
        private static final String ACTIVE_TCM = "activeTCM";
        private static final String FROM_BUNDLE = "fromBundle";
        private static final String DOMINANCE_LIST = "domList";
        private static final String MAX_MODE = "maxMode";
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("displayName", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("cascadeStep", class$java$awt$Dimension == null ? (class$java$awt$Dimension = SerializationReplacer.class$("java.awt.Dimension")) : class$java$awt$Dimension), new ObjectStreamField("cascadeStepsCount", class$java$lang$Integer == null ? (class$java$lang$Integer = SerializationReplacer.class$("java.lang.Integer")) : class$java$lang$Integer), new ObjectStreamField("cascadePoint", class$java$awt$Point == null ? (class$java$awt$Point = SerializationReplacer.class$("java.awt.Point")) : class$java$awt$Point), new ObjectStreamField("cascadingOrigin", class$java$awt$Point == null ? (class$java$awt$Point = SerializationReplacer.class$("java.awt.Point")) : class$java$awt$Point), new ObjectStreamField("toolbarConfigName", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("modes", class$java$util$ArrayList == null ? (class$java$util$ArrayList = SerializationReplacer.class$("java.util.ArrayList")) : class$java$util$ArrayList), new ObjectStreamField("current", class$org$openide$windows$Mode == null ? (class$org$openide$windows$Mode = SerializationReplacer.class$("org.openide.windows.Mode")) : class$org$openide$windows$Mode), new ObjectStreamField("activeTCM", class$org$netbeans$core$windows$WindowManagerImpl$TopComponentManager == null ? (class$org$netbeans$core$windows$WindowManagerImpl$TopComponentManager = SerializationReplacer.class$("org.netbeans.core.windows.WindowManagerImpl$TopComponentManager")) : class$org$netbeans$core$windows$WindowManagerImpl$TopComponentManager), new ObjectStreamField("fromBundle", class$java$lang$Boolean == null ? (class$java$lang$Boolean = SerializationReplacer.class$("java.lang.Boolean")) : class$java$lang$Boolean), new ObjectStreamField("domList", class$java$util$ArrayList == null ? (class$java$util$ArrayList = SerializationReplacer.class$("java.util.ArrayList")) : class$java$util$ArrayList), new ObjectStreamField("maxMode", class$java$lang$Boolean == null ? (class$java$lang$Boolean = SerializationReplacer.class$("java.lang.Boolean")) : class$java$lang$Boolean)};
        transient WorkspaceImpl source;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$awt$Dimension;
        static /* synthetic */ Class class$java$lang$Integer;
        static /* synthetic */ Class class$java$awt$Point;
        static /* synthetic */ Class class$java$util$ArrayList;
        static /* synthetic */ Class class$org$openide$windows$Mode;
        static /* synthetic */ Class class$org$netbeans$core$windows$WindowManagerImpl$TopComponentManager;
        static /* synthetic */ Class class$java$lang$Boolean;

        SerializationReplacer(WorkspaceImpl source) {
            this.source = source;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            ObjectOutputStream.PutField pf = oos.putFields();
            WorkspaceBoundsManager boundsManager = this.source.boundsManager();
            pf.put(NAME, this.source.name);
            pf.put(DISPLAY_NAME, this.source.displayName);
            pf.put(CASCADE_STEP, boundsManager.getCascadeStep());
            pf.put(CASCADE_STEPS_COUNT, new Integer(boundsManager.getCascadeStepsCount()));
            pf.put(CASCADE_POINT, boundsManager.getCascadePoint());
            pf.put(TOOLBAR_CONFIG_NAME, this.source.toolbarConfigName);
            pf.put(MODES, this.source.modes);
            pf.put(CURRENT_MODE, this.source.current);
            pf.put(CASCADING_ORIGIN, boundsManager.getCascadingOrigin());
            pf.put(FROM_BUNDLE, this.source.fromBundle ? Boolean.TRUE : Boolean.FALSE);
            TopComponent activeTc = this.source.visManager().getSavedActive();
            if (activeTc == null) {
                activeTc = TopComponent.getRegistry().getActivated();
            }
            if (activeTc != null && activeTc.isOpened((Workspace)this.source)) {
                pf.put(ACTIVE_TCM, WindowManagerImpl.findManager(activeTc));
            } else {
                pf.put(ACTIVE_TCM, null);
            }
            List domList = this.source.visManager().getDominanceList();
            ArrayList arDomList = null;
            if (domList != null) {
                arDomList = new ArrayList(domList.size());
                arDomList.addAll(domList);
            }
            pf.put(DOMINANCE_LIST, arDomList);
            pf.put(MAX_MODE, WindowUtils.isMdi() && this.source.desktopPane().isMaxMode() ? Boolean.TRUE : Boolean.FALSE);
            oos.writeFields();
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField gf = ois.readFields();
            String name = (String)gf.get(NAME, null);
            this.source = (WorkspaceImpl)WindowManager.getDefault().findWorkspace(name);
            if (this.source == null) {
                this.source = new WorkspaceImpl(name);
            }
            WorkspaceBoundsManager boundsManager = this.source.boundsManager();
            boundsManager.setCascadeStep((Dimension)gf.get(CASCADE_STEP, null));
            boundsManager.setCascadeStepsCount((Integer)gf.get(CASCADE_STEPS_COUNT, null));
            boundsManager.setCascadePoint((Point)gf.get(CASCADE_POINT, null));
            this.source.setToolbarConfigName((String)gf.get(TOOLBAR_CONFIG_NAME, null));
            this.source.current = (Mode)gf.get(CURRENT_MODE, null);
            boundsManager.setCascadingOrigin((Point)gf.get(CASCADING_ORIGIN, null));
            this.source.fromBundle = (Boolean)gf.get(FROM_BUNDLE, null);
            this.source.savedManager = (WindowManagerImpl.TopComponentManager)gf.get(ACTIVE_TCM, null);
            Collection newModes = (Collection)gf.get(MODES, null);
            Iterator it = newModes.iterator();
            while (it.hasNext()) {
                Mode mode = (Mode)it.next();
                if (this.source.findLoadedMode(mode.getName()) != null) continue;
                List list = this.source.modes;
                synchronized (list) {
                    this.source.modes.add(mode);
                }
            }
            if (WindowUtils.hasObjectStreamField(gf, DOMINANCE_LIST)) {
                this.source.visManager().setDominanceList((List)gf.get(DOMINANCE_LIST, null));
            }
            if (WindowUtils.hasObjectStreamField(gf, MAX_MODE)) {
                this.source.setWasMaxMode((Boolean)gf.get(MAX_MODE, null));
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return this.source;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

