/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Container;
import java.awt.Cursor;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.DeferredPerformer;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.DesktopPane;
import org.netbeans.core.windows.frames.FrameType;
import org.netbeans.core.windows.frames.PerimeterLayout;
import org.netbeans.core.windows.layers.ModeData;
import org.netbeans.core.windows.layers.WindowManagerData;
import org.netbeans.core.windows.layers.WorkspaceData;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

class WorkspaceVisibilityManager
implements Runnable,
DeferredPerformer.DeferredCommand {
    private boolean visible = false;
    private WorkspaceImpl workspace;
    private boolean isProcessing = false;
    private List dominanceList;
    private List zOrderList = new ArrayList();
    private TopComponent savedActive;
    private DeferredPerformer.DeferredCommand pendingRequest;
    private DesktopPane desktopPane;
    static /* synthetic */ Class class$org$netbeans$core$windows$WorkspaceVisibilityManager;

    WorkspaceVisibilityManager(WorkspaceImpl workspace) {
        this.workspace = workspace;
    }

    public void setVisible(boolean visible) {
        if (this.pendingRequest != null) {
            if (visible) {
                return;
            }
            boolean cancelled = DeferredPerformer.getDefault().removeRequest(this.pendingRequest);
            this.pendingRequest = null;
        }
        if (visible && !DeferredPerformer.getDefault().canImmediatelly()) {
            this.pendingRequest = this;
            DeferredPerformer.getDefault().putRequest((DeferredPerformer.DeferredCommand)this, new DeferredPerformer.DeferredContext(null, true));
            return;
        }
        this.doSetVisible(visible);
    }

    public void performCommand(DeferredPerformer.DeferredContext context) {
        this.pendingRequest = null;
        this.doSetVisible(true);
    }

    public void run() {
        WindowManagerImpl wmi = (WindowManagerImpl)WindowManager.getDefault();
        if (wmi.isSwitchingWorkspace()) {
            SwingUtilities.invokeLater(this);
        } else if (this.savedActive != null) {
            this.savedActive.requestFocus();
            this.savedActive = null;
        }
    }

    private ModeImpl getActiveMode() {
        TopComponent comp = TopComponent.getRegistry().getActivated();
        if (comp == null) {
            return null;
        }
        return (ModeImpl)this.workspace.findMode(comp);
    }

    private void doSetVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.isProcessing = true;
        this.visible = visible;
        if (!visible) {
            FrameType frame;
            ModeImpl mode = this.getActiveMode();
            if (mode != null && (frame = mode.getFrameInstance()) != null) {
                try {
                    frame.setSelected(false);
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
            }
            this.savedActive = TopComponent.getRegistry().getActivated();
            if (this.savedActive != null && this.workspace.findMode(this.savedActive) == null) {
                this.savedActive = null;
            }
            WindowManagerImpl.getInstance().activateComponent(null);
        }
        Container contentPane = MainWindow.getDefault().getContentPane();
        boolean isMdi = WindowUtils.isMdi();
        if (isMdi && visible && this.desktopPane().getParent() == null) {
            contentPane.add(this.desktopPane());
        }
        this.processModes(visible, isMdi);
        if (isMdi && !visible || !isMdi && this.desktopPane() != null) {
            contentPane.remove(this.desktopPane());
        }
        this.workspace.synchronizeMaxMode();
        contentPane.invalidate();
        contentPane.validate();
        contentPane.repaint();
        if (visible) {
            this.reactivateSavedComponent();
        }
        this.isProcessing = false;
        if (visible) {
            ((WindowManagerImpl)WindowManager.getDefault()).setWasAnyWorkspaceVisible(true);
            this.workspace.setWasVisible(true);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    public TopComponent getSavedActive() {
        return this.savedActive;
    }

    public void setSavedActive(TopComponent savedActive) {
        this.savedActive = savedActive;
    }

    public void setDominanceList(List dominanceList) {
        this.dominanceList = dominanceList;
    }

    public List getDominanceList() {
        List result = this.dominanceList;
        if (result == null && this.visible && WindowUtils.isMdi()) {
            result = ((PerimeterLayout)this.desktopPane().getLayout()).getDominance();
        }
        return result;
    }

    public List getZOrder() {
        if (!WindowUtils.isMdi()) {
            return new ArrayList();
        }
        if (this.isVisible()) {
            this.zOrderList = this.buildZOrderList();
            return this.zOrderList;
        }
        return this.zOrderList;
    }

    public void setZOrder(List zOrderList) {
        if (!WindowUtils.isMdi()) {
            return;
        }
        this.zOrderList = zOrderList;
    }

    private List buildZOrderList() {
        boolean sorted;
        if (!WindowUtils.isMdi()) {
            return new ArrayList();
        }
        List modes = this.workspace.getLoadedModeList();
        ArrayList<ModeImpl> internalModes = new ArrayList<ModeImpl>(modes.size());
        int i = 0;
        while (i < modes.size()) {
            ModeImpl mo = (ModeImpl)modes.get(i);
            if ("org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(mo.getFrameType())) {
                FrameType frameType = mo.getFrameInstance();
                int ind = this.desktopPane().getPosition(frameType);
                internalModes.add(mo);
            }
            ++i;
        }
        int[] index = new int[internalModes.size()];
        int i2 = 0;
        while (i2 < internalModes.size()) {
            ModeImpl mo = (ModeImpl)internalModes.get(i2);
            FrameType frameType = mo.getFrameInstance();
            index[i2] = this.desktopPane().getPosition(frameType);
            ++i2;
        }
        if (internalModes.size() < 2) {
            return internalModes;
        }
        do {
            sorted = true;
            int i3 = 1;
            while (i3 < internalModes.size()) {
                if (index[i3 - 1] > index[i3]) {
                    int ind = index[i3 - 1];
                    index[i3 - 1] = index[i3];
                    index[i3] = ind;
                    Object obj = internalModes.remove(i3);
                    internalModes.add(i3 - 1, (ModeImpl)obj);
                    sorted = false;
                }
                ++i3;
            }
        } while (!sorted);
        return internalModes;
    }

    public void validateModes() {
        List modes = this.workspace.getModeList();
        ArrayList cascadedModes = new ArrayList(modes.size());
        ArrayList nonCascadedModes = new ArrayList(modes.size());
        this.divideModes(modes, cascadedModes, nonCascadedModes);
        if (!nonCascadedModes.isEmpty()) {
            if (this.dominanceList != null) {
                this.prioritize(nonCascadedModes, this.dominanceList);
                this.dominanceList = null;
            }
            this.processModesValidation(nonCascadedModes, false);
        }
        this.processModesValidation(cascadedModes, true);
    }

    DesktopPane desktopPane() {
        if (this.desktopPane == null) {
            this.desktopPane = new DesktopPane();
        }
        return this.desktopPane;
    }

    private void processModes(boolean visible, boolean isMdi) {
        List modes = this.workspace.getModeList();
        ArrayList modesTarget = new ArrayList();
        if (visible) {
            ArrayList cascadedModes = new ArrayList(modes.size());
            ArrayList nonCascadedModes = new ArrayList(modes.size());
            this.divideModes(modes, cascadedModes, nonCascadedModes);
            if (!nonCascadedModes.isEmpty()) {
                boolean setDominance = false;
                if (this.dominanceList != null) {
                    this.prioritize(nonCascadedModes, this.dominanceList);
                    this.dominanceList = null;
                } else {
                    setDominance = true;
                }
                this.addModesVisibility(modesTarget, nonCascadedModes, false);
                if (setDominance) {
                    this.ensureDominance(this.workspace);
                }
            }
            this.sortModes(cascadedModes);
            this.addModesVisibility(modesTarget, cascadedModes, true);
            this.setModesVisibility(modesTarget, visible);
        } else {
            List list;
            if (!isMdi && this.dominanceList == null && !(list = ((PerimeterLayout)this.desktopPane().getLayout()).getDominance()).isEmpty()) {
                this.dominanceList = list;
            }
            if (isMdi) {
                this.dominanceList = list = ((PerimeterLayout)this.desktopPane().getLayout()).getDominance();
                this.zOrderList = this.buildZOrderList();
            }
            this.addModesVisibility(modesTarget, modes, true);
            this.setModesVisibility(modesTarget, visible);
        }
    }

    private void divideModes(List sourceModes, List cascadedModes, List nonCascadedModes) {
        ModeImpl curMode = null;
        Iterator iter = sourceModes.iterator();
        while (iter.hasNext()) {
            curMode = (ModeImpl)iter.next();
            if ("org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(curMode.getFrameType())) {
                nonCascadedModes.add(curMode);
                continue;
            }
            cascadedModes.add(curMode);
        }
    }

    private List sortModes(List cascadedModes) {
        Object curMode = null;
        if (this.zOrderList.size() > 0) {
            Iterator it = this.zOrderList.iterator();
            while (it.hasNext()) {
                cascadedModes.remove(it.next());
            }
            cascadedModes.addAll(this.zOrderList);
        }
        return cascadedModes;
    }

    private void prioritize(List modes, List dominance) {
        String[] dominanceArray = dominance.toArray(new String[dominance.size()]);
        ModeImpl curMode = null;
        Object curConstraint = null;
        ModeImpl[] modesArray = null;
        int idx = 0;
        int i = 0;
        while (i < dominanceArray.length) {
            modesArray = modes.toArray(new ModeImpl[modes.size()]);
            int y = idx;
            while (y < modesArray.length) {
                curMode = modesArray[y];
                curConstraint = curMode.getConstraints();
                if (curConstraint != null && curConstraint.equals(dominanceArray[i])) {
                    Object o = modes.get(idx);
                    modes.set(idx, curMode);
                    modes.set(y, o);
                    ++idx;
                    break;
                }
                ++y;
            }
            ++i;
        }
    }

    private void setModesVisibility(List modes, final boolean visible) {
        block15: {
            final WindowManagerImpl wmi = (WindowManagerImpl)WindowManager.getDefault();
            boolean wasAnyWorkspaceVisible = wmi.isWasAnyWorkspaceVisible();
            final ModeImpl[] modesArray = modes.toArray(new ModeImpl[modes.size()]);
            final boolean isMdi = WindowUtils.isMdi();
            if (wasAnyWorkspaceVisible) {
                final Container contentPane = MainWindow.getDefault().getContentPane();
                if (this.workspace.isWasVisible()) {
                    if (visible) {
                        wmi.setSwitchingWorkspaceIgnoreFocusEvent(true);
                        contentPane.setCursor(Cursor.getPredefinedCursor(3));
                    }
                    try {
                        int i = 0;
                        while (i < modesArray.length) {
                            modesArray[i].setVisible(visible);
                            ++i;
                        }
                        Object var10_12 = null;
                        if (!visible) break block15;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        if (visible) {
                            SwingUtilities.invokeLater(new Runnable(contentPane, wmi){
                                private final /* synthetic */ Container val$contentPane;
                                private final /* synthetic */ WindowManagerImpl val$wmi;
                                {
                                    this.val$contentPane = val$contentPane;
                                    this.val$wmi = val$wmi;
                                }

                                public void run() {
                                    this.val$contentPane.setCursor(null);
                                    this.val$wmi.setSwitchingWorkspaceIgnoreFocusEvent(false);
                                }
                            });
                        }
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    {
                        break block15;
                    }
                }
                if (visible) {
                    wmi.setSwitchingWorkspace(true);
                    contentPane.setCursor(Cursor.getPredefinedCursor(3));
                    if (!isMdi) {
                        String s = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$WorkspaceVisibilityManager == null ? (class$org$netbeans$core$windows$WorkspaceVisibilityManager = WorkspaceVisibilityManager.class$("org.netbeans.core.windows.WorkspaceVisibilityManager")) : class$org$netbeans$core$windows$WorkspaceVisibilityManager), (String)"MSG_SwitchingWorkspaces", (Object)Actions.cutAmpersand((String)this.workspace.getDisplayName()));
                        StatusDisplayer.getDefault().setStatusText(s);
                    }
                    int i = 0;
                    while (i < modesArray.length) {
                        String frameType = modesArray[i].getFrameType();
                        if ("org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(frameType)) {
                            modesArray[i].setVisible(visible);
                        }
                        ++i;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                int i = 0;
                                while (i < modesArray.length) {
                                    String frameType = modesArray[i].getFrameType();
                                    if (!"org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(frameType)) {
                                        modesArray[i].setVisible(visible);
                                    }
                                    ++i;
                                }
                                Object var4_3 = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_4 = null;
                                SwingUtilities.invokeLater(new Runnable(this){
                                    private final /* synthetic */ 2 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    public void run() {
                                        2.access$000(this.this$1).setSwitchingWorkspace(false);
                                        2.access$100(this.this$1).setCursor(null);
                                        2.access$200(this.this$1).desktopPane().repaint();
                                        if (!2.access$300(this.this$1)) {
                                            StatusDisplayer.getDefault().setStatusText("");
                                        }
                                    }
                                });
                                throw throwable;
                            }
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }

                        static /* synthetic */ WindowManagerImpl access$000(2 x0) {
                            return x0.wmi;
                        }

                        static /* synthetic */ Container access$100(2 x0) {
                            return x0.contentPane;
                        }

                        static /* synthetic */ WorkspaceVisibilityManager access$200(2 x0) {
                            return x0.WorkspaceVisibilityManager.this;
                        }

                        static /* synthetic */ boolean access$300(2 x0) {
                            return x0.isMdi;
                        }
                    });
                } else {
                    int i = 0;
                    while (i < modesArray.length) {
                        modesArray[i].setVisible(visible);
                        ++i;
                    }
                }
            } else {
                int i = 0;
                while (i < modesArray.length) {
                    modesArray[i].setVisible(visible);
                    ++i;
                }
            }
        }
    }

    private void addModesVisibility(List modesTarget, List modesSource, boolean reverse) {
        if (reverse) {
            int i = modesSource.size() - 1;
            while (i >= 0) {
                modesTarget.add(modesSource.get(i));
                --i;
            }
        } else {
            int i = 0;
            while (i < modesSource.size()) {
                modesTarget.add(modesSource.get(i));
                ++i;
            }
        }
    }

    private void processModesValidation(List modes, boolean reverse) {
        ModeImpl[] modesArray = modes.toArray(new ModeImpl[modes.size()]);
        if (reverse) {
            int i = modesArray.length - 1;
            while (i >= 0) {
                modesArray[i].validateData();
                --i;
            }
        } else {
            int i = 0;
            while (i < modesArray.length) {
                modesArray[i].validateData();
                ++i;
            }
        }
    }

    private void reactivateSavedComponent() {
        if (this.savedActive != null) {
            SwingUtilities.invokeLater(this);
        } else {
            this.workspace.reactivateSavedTc();
        }
    }

    private void ensureDominance(WorkspaceImpl wi) {
        DataObject[] md = null;
        try {
            PersistenceManager pmanager = PersistenceManager.getDefault();
            FileObject wmo = pmanager.getWindowManagerFolder();
            WindowManagerData wmd = (WindowManagerData)DataObject.find((FileObject)wmo);
            DataObject[] wsp = wmd.getChildren();
            int i = 0;
            while (i < wsp.length) {
                if (wsp[i] instanceof WorkspaceData) {
                    WorkspaceData wsd = (WorkspaceData)wsp[i];
                    if (wi.getName().equals(wsd.getName())) {
                        md = wsd.getChildren();
                        break;
                    }
                }
                ++i;
            }
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        if (md != null) {
            DesktopPane desktop = wi.desktopPane();
            int i = md.length - 1;
            while (i >= 0) {
                if (md[i] instanceof ModeData) {
                    String side;
                    ModeData m = (ModeData)md[i];
                    ModeImpl mode = (ModeImpl)wi.findMode(m.getName());
                    String string = side = mode == null ? null : (String)mode.getConstraints();
                    if (side != null) {
                        desktop.setDominant(side);
                    }
                }
                --i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

