/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.dnd;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.netbeans.core.windows.frames.TopComponentContainer;

public final class DropTargetGlassPane
extends JPanel {
    private Point location;
    private TopComponentContainer.DropIndicator dropIndicator;

    public DropTargetGlassPane() {
        this((TopComponentContainer.DropIndicator)null);
    }

    public DropTargetGlassPane(TopComponentContainer.DropIndicator dropIndicator) {
        this.dropIndicator = dropIndicator;
        this.setOpaque(false);
    }

    public void initialize() {
        if (this.isVisible()) {
            this.revalidate();
        } else {
            this.setVisible(true);
        }
    }

    public void uninitialize() {
        if (this.location != null) {
            this.dragFinished();
        }
        this.setVisible(false);
    }

    public void dragOver(Point location) {
        this.location = location;
        this.repaint();
    }

    public void dragExited() {
        this.location = null;
        this.repaint();
    }

    public void dragExitedHack() {
        if (this.location == null) {
            return;
        }
        this.dragExited();
    }

    public void dragActionChanged(Point location) {
        this.location = location;
        this.repaint();
    }

    public void dragFinished() {
        this.location = null;
        this.repaint();
    }

    public void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        Point position = this.location;
        if (position == null) {
            return;
        }
        Graphics2D g = (Graphics2D)gr;
        Stroke oldStroke = g.getStroke();
        Color oldColor = g.getColor();
        g.setColor(Color.red);
        g.setStroke(DropTargetGlassPane.createIndicationStroke());
        Rectangle r = this.getIndicatorRectangle(position);
        String desc = this.dropIndicator.getDescriptionForLocation(this.location);
        if (r != null) {
            g.drawRect(r.x, r.y, r.width, r.height);
            g.drawRect(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
            g.drawRect(r.x + 2, r.y + 2, r.width - 4, r.height - 4);
            if (desc != null) {
                Font oldFont = g.getFont();
                Font newFont = oldFont.deriveFont(1);
                FontMetrics fm = ((Component)this).getFontMetrics(newFont);
                Rectangle2D rr = fm.getStringBounds(desc, g);
                g.setColor(new Color(255, 255, 255, 200));
                g.fillRect((int)rr.getX() + r.x + 18, (int)rr.getY() + r.y + 18, (int)rr.getWidth() + 4, (int)rr.getHeight() + 4);
                g.setColor(Color.black);
                g.setFont(newFont);
                g.drawString(desc, r.x + 20, r.y + 20);
                g.setFont(oldFont);
            }
        }
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    private Rectangle getIndicatorRectangle(Point location) {
        Shape s = this.dropIndicator.getIndicationForLocation(location);
        return s instanceof Rectangle ? (Rectangle)s : null;
    }

    private static Stroke createIndicationStroke() {
        float[] dashPattern = new float[]{1.0f, 1.0f};
        return new BasicStroke(1.0f, 0, 0, 1.0f, dashPattern, 0.0f);
    }
}

