/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InternalFrameUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.plaf.metal.MetalInternalFrameUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.netbeans.core.actions.AttachFrameAction;
import org.netbeans.core.actions.CloseFrameAction;
import org.netbeans.core.actions.DetachFrameAction;
import org.netbeans.core.actions.MaximizeFrameAction;
import org.netbeans.core.actions.MinimizeFrameAction;
import org.netbeans.core.actions.RestoreFrameAction;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.frames.DesktopPane;
import org.netbeans.core.windows.frames.FrameType;
import org.netbeans.core.windows.frames.FrameTypeListener;
import org.netbeans.core.windows.frames.InternalFrameListenerAdapter;
import org.netbeans.core.windows.frames.LayoutResource;
import org.netbeans.core.windows.frames.NbInternalFrameUI;
import org.netbeans.core.windows.frames.PerimeterPane;
import org.openide.awt.MouseUtils;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class InternalFrameTypeImpl
extends JInternalFrame
implements FrameType,
LayoutResource {
    private int state = 0;
    private HashMap flMap = new HashMap();
    protected static AttachFrameAction attachFrame = (AttachFrameAction)SystemAction.get((Class)(class$org$netbeans$core$actions$AttachFrameAction == null ? (class$org$netbeans$core$actions$AttachFrameAction = InternalFrameTypeImpl.class$("org.netbeans.core.actions.AttachFrameAction")) : class$org$netbeans$core$actions$AttachFrameAction));
    protected static DetachFrameAction detachFrame = (DetachFrameAction)SystemAction.get((Class)(class$org$netbeans$core$actions$DetachFrameAction == null ? (class$org$netbeans$core$actions$DetachFrameAction = InternalFrameTypeImpl.class$("org.netbeans.core.actions.DetachFrameAction")) : class$org$netbeans$core$actions$DetachFrameAction));
    protected static CloseFrameAction closeFrame = (CloseFrameAction)SystemAction.get((Class)(class$org$netbeans$core$actions$CloseFrameAction == null ? (class$org$netbeans$core$actions$CloseFrameAction = InternalFrameTypeImpl.class$("org.netbeans.core.actions.CloseFrameAction")) : class$org$netbeans$core$actions$CloseFrameAction));
    protected static MaximizeFrameAction maximizeFrame = (MaximizeFrameAction)SystemAction.get((Class)(class$org$netbeans$core$actions$MaximizeFrameAction == null ? (class$org$netbeans$core$actions$MaximizeFrameAction = InternalFrameTypeImpl.class$("org.netbeans.core.actions.MaximizeFrameAction")) : class$org$netbeans$core$actions$MaximizeFrameAction));
    protected static MinimizeFrameAction minimizeFrame = (MinimizeFrameAction)SystemAction.get((Class)(class$org$netbeans$core$actions$MinimizeFrameAction == null ? (class$org$netbeans$core$actions$MinimizeFrameAction = InternalFrameTypeImpl.class$("org.netbeans.core.actions.MinimizeFrameAction")) : class$org$netbeans$core$actions$MinimizeFrameAction));
    protected static RestoreFrameAction restoreFrame = (RestoreFrameAction)SystemAction.get((Class)(class$org$netbeans$core$actions$RestoreFrameAction == null ? (class$org$netbeans$core$actions$RestoreFrameAction = InternalFrameTypeImpl.class$("org.netbeans.core.actions.RestoreFrameAction")) : class$org$netbeans$core$actions$RestoreFrameAction));
    private static Border activeBorder;
    private static Border inactiveBorder;
    private Rectangle relativeBounds;
    private Workspace workspace;
    private ModeImpl mode;
    private MouseListener titlePopupInvoker;
    private MouseListener weakTitleListener;
    private Border origBorder;
    private boolean disposed;
    static /* synthetic */ Class class$org$netbeans$core$actions$AttachFrameAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$DetachFrameAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$CloseFrameAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$MaximizeFrameAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$MinimizeFrameAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$RestoreFrameAction;
    static /* synthetic */ Class class$java$awt$event$MouseListener;

    public InternalFrameTypeImpl() {
        this("");
    }

    public InternalFrameTypeImpl(String title) {
        this(title, false);
    }

    public void setCursor(Cursor cursor) {
        WindowManagerImpl wmi = (WindowManagerImpl)WindowManager.getDefault();
        if (!wmi.isSwitchingWorkspace()) {
            super.setCursor(cursor);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.getParent() instanceof PerimeterPane && UIManager.getUI(this) instanceof MetalInternalFrameUI) {
            ComponentUI ui = (ComponentUI)UIManager.get("nb.dockedInternalFrameUI");
            if (ui != null) {
                this.setUI(ui);
            } else {
                this.setUI(new NbInternalFrameUI(this));
            }
        }
    }

    public InternalFrameTypeImpl(String title, boolean resizable) {
        this(title, resizable, false);
    }

    public InternalFrameTypeImpl(String title, boolean resizable, boolean closable) {
        this(title, resizable, closable, false);
    }

    public InternalFrameTypeImpl(String title, boolean resizable, boolean closable, boolean maximizable) {
        this(title, resizable, closable, maximizable, false);
    }

    public InternalFrameTypeImpl(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable);
        this.initialize();
        this.createBorder();
    }

    protected void initialize() {
        this.getRootPane().getGlassPane().setVisible(true);
        this.revalidate();
    }

    public void dispose() {
        this.disposed = true;
        super.dispose();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.disposed = false;
        }
        super.setVisible(visible);
    }

    public void moveToFront() {
        super.moveToFront();
        if (this.isMaximum()) {
            this.mode.setTopMaximized();
        }
    }

    private synchronized void createBorder() {
        Color color;
        if (activeBorder == null) {
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                activeBorder = UIManager.getBorder("nb.maxFrameActiveBorder");
                if (activeBorder == null) {
                    color = MetalLookAndFeel.getPrimaryControlDarkShadow();
                    activeBorder = BorderFactory.createLineBorder(color, 2);
                }
            } else {
                color = UIManager.getColor("InternalFrame.activeTitleBackground");
                activeBorder = BorderFactory.createLineBorder(color, 2);
            }
        }
        if (inactiveBorder == null) {
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                inactiveBorder = UIManager.getBorder("nb.maxFrameInactiveBorder");
                if (inactiveBorder == null) {
                    color = UIManager.getColor("controlShadow");
                    inactiveBorder = BorderFactory.createLineBorder(color, 2);
                }
            } else {
                color = UIManager.getColor("InternalFrame.inactiveTitleBackground");
                inactiveBorder = BorderFactory.createLineBorder(color, 2);
            }
        }
    }

    public Container getRootPaneContainer() {
        return this;
    }

    public void setState(int state) throws PropertyVetoException {
        switch (state) {
            case 1: {
                this.setIcon(true);
                break;
            }
            case 0: {
                if (this.isIcon()) {
                    this.setIcon(false);
                    break;
                }
                if (!this.isMaximum()) break;
                this.setMaximum(false);
                break;
            }
            case 6: {
                this.setMaximum(true);
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Tried to set an illegal state: " + state + " for " + this);
            }
        }
    }

    public void setIcon(boolean b) throws PropertyVetoException {
        int newState;
        int n = newState = b ? 1 : 0;
        if (this.state == newState) {
            return;
        }
        if (!this.isSelected()) {
            this.setSelected(true);
        }
        super.setIcon(b);
        this.state = newState;
    }

    public void setSelected(boolean selected) throws PropertyVetoException {
        super.setSelected(selected);
        if (this.isMaximum()) {
            if (selected) {
                this.setBorder(activeBorder);
            } else {
                this.setBorder(inactiveBorder);
            }
        }
    }

    public void setMaximum(boolean b) throws PropertyVetoException {
        DesktopPane desktop;
        int newState;
        if (this.disposed) {
            return;
        }
        if (this.getParent() == null) {
            return;
        }
        int n = newState = b ? 6 : 0;
        if (this.state == newState) {
            return;
        }
        if (!b && (desktop = this.getOurDesktopPane()) != null && desktop.isMaxMode() && !this.isSelected()) {
            return;
        }
        if (b) {
            this.origBorder = this.getBorder();
            if (this.isSelected()) {
                this.setBorder(activeBorder);
            } else {
                this.setBorder(inactiveBorder);
            }
            this.setCaptionHeight(0);
        } else {
            this.setBorder(this.origBorder);
            Integer i = (Integer)UIManager.get("nb.desktopFrameCaptionHeight");
            if (i != null) {
                this.setCaptionHeight(i);
            } else {
                this.setCaptionHeight(20);
            }
        }
        this.revalidate();
        this.repaint();
        super.setMaximum(b);
        this.state = newState;
        Collection ifas = this.flMap.values();
        Iterator ifaIter = ifas.iterator();
        while (ifaIter.hasNext()) {
            InternalFrameListenerAdapter ifa = (InternalFrameListenerAdapter)ifaIter.next();
            if (b) {
                ifa.internalFrameMaximized();
                continue;
            }
            ifa.internalFrameNormalized();
        }
    }

    private DesktopPane getOurDesktopPane() {
        Container result = this;
        while (result != null && !(result instanceof DesktopPane)) {
            result = result.getParent();
        }
        return (DesktopPane)result;
    }

    public int getState() {
        return this.state;
    }

    public synchronized void addFrameTypeListener(FrameTypeListener fl) {
        InternalFrameListenerAdapter ifa = new InternalFrameListenerAdapter(this, fl);
        this.addInternalFrameListener(ifa);
        this.flMap.put(fl, ifa);
    }

    public synchronized void removeFrameTypeListener(FrameTypeListener fl) {
        InternalFrameListenerAdapter ifa = (InternalFrameListenerAdapter)this.flMap.remove(fl);
        if (ifa != null) {
            this.removeInternalFrameListener(ifa);
        }
    }

    public int getType() {
        return 0;
    }

    public Image getIconImage() {
        if (this.getFrameIcon() instanceof ImageIcon) {
            return ((ImageIcon)this.getFrameIcon()).getImage();
        }
        return null;
    }

    public void setIconImage(Image icon) {
        this.setFrameIcon(new ImageIcon(icon));
    }

    public Component getIcon() {
        return this.getDesktopIcon();
    }

    public void setUI(InternalFrameUI ui) {
        InternalFrameUI oldUi;
        JComponent titlePane;
        if (this.weakTitleListener != null && (titlePane = this.obtainTitlePane(oldUi = this.getUI())) != null) {
            titlePane.removeMouseListener(this.weakTitleListener);
        }
        super.setUI(ui);
        JComponent titlePane2 = this.obtainTitlePane(ui);
        if (titlePane2 != null) {
            this.weakTitleListener = (MouseListener)WeakListener.create((Class)(class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = InternalFrameTypeImpl.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener), (EventListener)this.titlePopupInvoker(), (Object)titlePane2);
            titlePane2.addMouseListener(this.weakTitleListener);
        }
        if (ui instanceof NbInternalFrameUI) {
            Integer i = (Integer)UIManager.get("nb.desktopFrameCaptionHeight");
            if (i != null) {
                this.setCaptionHeight(i);
            } else {
                this.setCaptionHeight(20);
            }
        } else {
            this.setCaptionHeight(20);
        }
    }

    protected JComponent obtainTitlePane(InternalFrameUI ui) {
        if (ui instanceof BasicInternalFrameUI) {
            BasicInternalFrameUI bui = (BasicInternalFrameUI)ui;
            JComponent north = bui.getNorthPane();
            return north;
        }
        return null;
    }

    private MouseListener titlePopupInvoker() {
        if (this.titlePopupInvoker == null) {
            this.titlePopupInvoker = new MouseAdapter(){

                public void mouseReleased(MouseEvent evt) {
                    if (MouseUtils.isRightMouseButton((MouseEvent)evt)) {
                        JPopupMenu popup = InternalFrameTypeImpl.createPopupMenu(InternalFrameTypeImpl.this);
                        popup.show(InternalFrameTypeImpl.this, evt.getX(), evt.getY());
                    }
                }
            };
        }
        return this.titlePopupInvoker;
    }

    private static JPopupMenu createPopupMenu(InternalFrameTypeImpl frame) {
        return Utilities.actionsToPopup((Action[])new Action[]{attachFrame, detachFrame, restoreFrame, minimizeFrame, maximizeFrame, null, closeFrame}, (Component)frame);
    }

    public boolean setCaptionHeight(int height) {
        JComponent north = this.obtainTitlePane(this.getUI());
        if (north == null) {
            return false;
        }
        Dimension oldPref = north.getPreferredSize();
        oldPref.height = height;
        north.setPreferredSize(oldPref);
        return true;
    }

    public void attachToMode(ModeImpl mode) {
        this.mode = mode;
    }

    public ModeImpl getMode() {
        return this.mode;
    }

    public Rectangle getRelativeBounds() {
        return this.relativeBounds;
    }

    public void setRelativeBounds(Rectangle rect) {
        this.relativeBounds = rect == null ? null : (Rectangle)rect.clone();
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace ws) {
        this.workspace = ws;
    }

    public void restoreSubcomponentFocus() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

