/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.Action;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.Keymap;
import org.netbeans.core.windows.MainWindow;
import org.openide.ErrorManager;
import org.openide.actions.ActionManager;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

class ShortcutAndMenuKeyEventProcessor {
    private boolean wasPopupDisplayed;
    private KeyEvent lastKeyPressed;
    static /* synthetic */ Class class$javax$swing$text$Keymap;
    static /* synthetic */ Class class$org$openide$actions$ActionManager;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;
    static /* synthetic */ Class class$java$awt$Container;
    static /* synthetic */ Class class$javax$swing$JComponent;

    ShortcutAndMenuKeyEventProcessor() {
        try {
            Class<?> keyEventDispatcher = Class.forName("java.awt.KeyEventDispatcher");
            Class<?> keyEventPostProcessor = Class.forName("java.awt.KeyEventPostProcessor");
            Class<?> kfm = Class.forName("java.awt.KeyboardFocusManager");
            Method getCurrentKeyboardFocusManagerMethod = kfm.getMethod("getCurrentKeyboardFocusManager", new Class[0]);
            Object manager = getCurrentKeyboardFocusManagerMethod.invoke(null, new Object[0]);
            Method addKeyEventDispatcherMethod = kfm.getMethod("addKeyEventDispatcher", Class.forName("java.awt.KeyEventDispatcher"));
            Method addKeyEventPostProcessorMethod = kfm.getMethod("addKeyEventPostProcessor", Class.forName("java.awt.KeyEventPostProcessor"));
            Object eventDispatcherProxy = Proxy.newProxyInstance(keyEventDispatcher.getClassLoader(), new Class[]{keyEventDispatcher, keyEventPostProcessor}, new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    boolean res = ShortcutAndMenuKeyEventProcessor.this.dispatchKeyEvent((KeyEvent)args[0]);
                    return res ? Boolean.TRUE : Boolean.FALSE;
                }
            });
            Object eventPostProcessorProxy = Proxy.newProxyInstance(keyEventDispatcher.getClassLoader(), new Class[]{keyEventDispatcher, keyEventPostProcessor}, new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    boolean res = ShortcutAndMenuKeyEventProcessor.this.postProcessKeyEvent((KeyEvent)args[0]);
                    return res ? Boolean.TRUE : Boolean.FALSE;
                }
            });
            addKeyEventDispatcherMethod.invoke(manager, eventDispatcherProxy);
            addKeyEventPostProcessorMethod.invoke(manager, eventPostProcessorProxy);
        }
        catch (Exception x) {
            ErrorManager.getDefault().notify((Throwable)x);
        }
    }

    public boolean postProcessKeyEvent(KeyEvent ev) {
        if (ev.isConsumed()) {
            return false;
        }
        if (this.processShortcut(ev)) {
            return true;
        }
        Window w = SwingUtilities.windowForComponent(ev.getComponent());
        if (w instanceof Dialog) {
            return false;
        }
        MainWindow mw = MainWindow.getDefault();
        if (w == mw) {
            return false;
        }
        JMenuBar mb = mw.getJMenuBar();
        if (mb == null) {
            return false;
        }
        boolean pressed = ev.getID() == 401;
        boolean res = ShortcutAndMenuKeyEventProcessor.invokeProcessKeyBindingsForAllComponents(ev, mw, pressed);
        if (res) {
            ev.consume();
        }
        return res;
    }

    public boolean dispatchKeyEvent(KeyEvent ev) {
        MenuElement[] arr;
        int mods;
        if (Utilities.getOperatingSystem() == 16 && (mods = ev.getModifiers()) == 4) {
            mods = mods & 0xFFFFFFFB | 8;
            ev.setModifiers(mods);
        }
        if (ev.getID() == 401 && ev.getModifiers() == 3 && (ev.getKeyCode() == 19 || ev.getKeyCode() == 3)) {
            Object source = ev.getSource();
            if (source instanceof Component) {
                Window w = SwingUtilities.windowForComponent((Component)source);
                Component focused = SwingUtilities.findFocusOwner(w);
                System.err.println("*** ShortcutAndMenuKeyEventProcessor: current focus owner = " + focused);
            }
            ev.consume();
            return true;
        }
        if (ev.getID() == 401) {
            this.lastKeyPressed = ev;
        }
        if ((arr = MenuSelectionManager.defaultManager().getSelectedPath()) == null || arr.length == 0) {
            this.wasPopupDisplayed = false;
            if (Utilities.isWindows() && ev.getModifiers() == 1 && ev.getKeyCode() == 121) {
                return this.processShortcut(ev);
            }
            return false;
        }
        if (!this.wasPopupDisplayed && this.lastKeyPressed != null && ev.getID() == 400 && this.lastKeyPressed.getModifiers() == 8 && ev.getModifiers() == 8 && this.lastKeyPressed.getKeyChar() == ev.getKeyChar()) {
            this.wasPopupDisplayed = true;
            ev.consume();
            return true;
        }
        this.wasPopupDisplayed = true;
        MenuSelectionManager.defaultManager().processKeyEvent(ev);
        if (!ev.isConsumed() && arr[0] instanceof JMenuBar) {
            ev.setSource(MainWindow.getDefault());
        }
        return ev.isConsumed();
    }

    private boolean processShortcut(KeyEvent ev) {
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(ev);
        Window w = SwingUtilities.windowForComponent(ev.getComponent());
        if (!ShortcutAndMenuKeyEventProcessor.isTransmodalAction(ks) && w instanceof Dialog) {
            return false;
        }
        ActionEvent aev = new ActionEvent(ev.getSource(), 1001, Utilities.keyToString((KeyStroke)ks));
        Keymap root = (Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = ShortcutAndMenuKeyEventProcessor.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap);
        Action a = root.getAction(ks);
        if (a != null && a.isEnabled()) {
            ActionManager am = (ActionManager)Lookup.getDefault().lookup(class$org$openide$actions$ActionManager == null ? (class$org$openide$actions$ActionManager = ShortcutAndMenuKeyEventProcessor.class$("org.openide.actions.ActionManager")) : class$org$openide$actions$ActionManager);
            am.invokeAction(a, aev);
            ev.consume();
            return true;
        }
        return false;
    }

    private static boolean invokeProcessKeyBindingsForAllComponents(KeyEvent e, Container container, boolean pressed) {
        try {
            Method m = (class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = ShortcutAndMenuKeyEventProcessor.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).getDeclaredMethod("processKeyBindingsForAllComponents", class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = ShortcutAndMenuKeyEventProcessor.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent, class$java$awt$Container == null ? (class$java$awt$Container = ShortcutAndMenuKeyEventProcessor.class$("java.awt.Container")) : class$java$awt$Container, Boolean.TYPE);
            if (m == null) {
                return false;
            }
            ((AccessibleObject)m).setAccessible(true);
            Boolean b = (Boolean)m.invoke(null, e, container, pressed ? Boolean.TRUE : Boolean.FALSE);
            return b;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isTransmodalAction(KeyStroke key) {
        Keymap root = (Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = ShortcutAndMenuKeyEventProcessor.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap);
        Action a = root.getAction(key);
        if (a == null) {
            return false;
        }
        Object val = a.getValue("OpenIDE-Transmodal-Action");
        return val != null && val.equals(Boolean.TRUE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

