/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.netbeans.core.ui.ArrowsTabbedPaneUI;
import org.netbeans.core.ui.PopupTabbedPaneUI;
import org.netbeans.core.windows.TabbedContainerUIManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.dnd.TopComponentDragSupport;
import org.netbeans.core.windows.dnd.WindowDnDManager;
import org.netbeans.core.windows.frames.CloseButtonTabbedPane;
import org.netbeans.core.windows.frames.DefaultContainerImpl;
import org.netbeans.core.windows.frames.MultiTabbedContainerImpl;
import org.netbeans.core.windows.frames.PerimeterLayout;
import org.netbeans.core.windows.frames.PerimeterPane;
import org.netbeans.core.windows.frames.SplittedContainerImpl$SerializationReplacer;
import org.netbeans.core.windows.frames.TCCTabbedAreaImpl;
import org.netbeans.core.windows.frames.TabHandlePopupListener;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.actions.NextTabAction;
import org.openide.actions.PreviousTabAction;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class SplitContainerImpl
extends DefaultContainerImpl
implements ChangeListener,
ComponentListener {
    private TopComponent wasSelected;
    private static final ArrayList positionNames = new ArrayList(5);
    private final Map constraints = new HashMap(15);
    private final CloseButtonTabbedPane[] tabbedContainer = new CloseButtonTabbedPane[positionNames.size()];
    private final Dimension[] prefTabbedSize = new Dimension[positionNames.size()];
    private final int[] selectedTabs = new int[positionNames.size()];
    private final Map tabbedContainer2Constraint = new HashMap(10);
    private final Map constrs2Areas = new HashMap(10);
    private final List areas = new ArrayList(5);
    private final Map borders = new WeakHashMap(5);
    private int counter = 0;
    private final PerimeterPane contentPane = new PerimeterPane();
    private final FocusListener tabbedFocusListener = new TabbedContainerFocusL();
    private ArrayList serConstraints;
    private ArrayList serSelectedTabs;
    private TopComponent requestedTC = null;
    private final Object COMPONENT_LOCK = new Object();
    private static final int WEST_X = 0;
    private static final int CENTER_X = 1;
    private static final int EAST_X = 2;
    private static final int NORTH_Y = 0;
    private static final int CENTER_Y = 1;
    private static final int SOUTH_Y = 2;
    public static final String DEFAULT_CONTAINER = "defaultContainer";
    public static final String CONSTRAINTS_LIST = "constraintsArray";
    public static final String TABBED_CONTAINERS_SIZE = "tabbedSizesArray";
    public static final String INDEX_OF_SELECTED_TAB = "selectedTabIndexes";
    static /* synthetic */ Class class$org$netbeans$core$windows$frames$SplitContainerImpl;

    public SplitContainerImpl() {
        int i = 0;
        while (i < positionNames.size()) {
            this.selectedTabs[i] = -1;
            ++i;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPane, "Center");
    }

    protected void actionPerformed(TopComponent selected, SystemAction action, boolean processed) {
        if (processed) {
            return;
        }
        if (action instanceof NextTabAction || action instanceof PreviousTabAction) {
            CloseButtonTabbedPane tab = this.tabbedContainer[positionNames.indexOf(this.constraints.get(selected))];
            int count = tab.getTabCount();
            int index = tab.getSelectedIndex();
            if (count <= 1 || index == -1) {
                return;
            }
            int delta = action instanceof NextTabAction ? 1 : -1;
            int newIndex = (index + delta + count) % count;
            tab.setSelectedIndex(newIndex);
        }
    }

    void updateNextAndPreviousState() {
        TopComponent selected = this.getSelectedTopComponent();
        if (selected == null) {
            return;
        }
        Container tab = null;
        int tabIndex = positionNames.indexOf(this.constraints.get(selected));
        if (tabIndex >= 0 && tabIndex < this.tabbedContainer.length) {
            tab = this.tabbedContainer[tabIndex];
        }
        if (tab != null && tab.getComponentCount() > 1) {
            DefaultContainerImpl.nextTab.setActionPerformer((ActionPerformer)this);
            DefaultContainerImpl.prevTab.setActionPerformer((ActionPerformer)this);
        } else {
            DefaultContainerImpl.nextTab.setActionPerformer(null);
            DefaultContainerImpl.prevTab.setActionPerformer(null);
        }
    }

    public void requestVisible(TopComponent tc) {
        int tabIndex;
        CloseButtonTabbedPane tabTC = this.tabbedContainer[positionNames.indexOf(this.constraints.get(tc))];
        TopComponent selected = this.getSelectedTopComponent();
        CloseButtonTabbedPane tabSEL = null;
        if (selected != null && (tabIndex = positionNames.indexOf(this.constraints.get(selected))) >= 0 && tabIndex < this.tabbedContainer.length) {
            tabSEL = this.tabbedContainer[tabIndex];
        }
        if (this.isActivated()) {
            if (tabTC == tabSEL) {
                tc.requestFocus();
            } else if (tabTC != null && tabTC.indexOfComponent((Component)tc) >= 0) {
                tabTC.removeChangeListener(this);
                tabTC.setSelectedComponent((Component)tc);
                tabTC.addChangeListener(this);
            }
        } else if (tabTC != null && tabTC.indexOfComponent((Component)tc) >= 0) {
            tabTC.removeChangeListener(this);
            this.setSelectedTopComponent(tc);
            tabTC.addChangeListener(this);
            if (tabTC == tabSEL) {
                this.requestedTC = tc;
            } else if (tabSEL != null && tabSEL.indexOfComponent((Component)selected) >= 0) {
                tabSEL.removeChangeListener(this);
                this.setSelectedTopComponent(selected);
                tabSEL.addChangeListener(this);
            }
        }
    }

    public boolean canAdd(TopComponent[] tc) {
        return true;
    }

    public Object getConstraints(TopComponent tc) {
        return this.constraints.get(tc);
    }

    public void destroy() {
        this.contentPane.destroy();
        this.remove(this.contentPane);
    }

    public TopComponentContainer.Area getArea(Object constraint) {
        return (TopComponentContainer.Area)this.constrs2Areas.get(constraint);
    }

    public List getAreas() {
        return this.areas;
    }

    public List getConstraintsOrder() {
        return ((PerimeterLayout)this.contentPane.getLayout()).getDominance();
    }

    public void setConstraintsOrder(List constraints) {
        PerimeterLayout perim = (PerimeterLayout)this.contentPane.getLayout();
        int i = constraints.size() - 1;
        while (i >= 0) {
            Object constr = constraints.get(i);
            if (!"CENTER".equals(constr)) {
                perim.setDominant((String)constraints.get(i));
            }
            --i;
        }
    }

    protected void attachComponents() {
        TopComponent selected;
        TopComponent[] curComps = this.getTopComponents();
        if (this.constraints.size() == 1 && SplitContainerImpl.hasAlonePolicy(selected = this.getSelectedTopComponent())) {
            this.addTCIntoPane(selected);
            this.revalidate();
            return;
        }
        HashMap constraint2alone = new HashMap(5);
        int i = 0;
        while (i < curComps.length) {
            Object constraint = this.constraints.get(curComps[i]);
            if (constraint2alone.get(constraint) == null) {
                constraint2alone.put(constraint, curComps[i]);
            } else {
                constraint2alone.put(constraint, Boolean.FALSE);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < curComps.length) {
            TopComponent tc = curComps[i2];
            if (SplitContainerImpl.hasAlonePolicy(tc) && constraint2alone.containsValue(tc)) {
                this.adjustTCBoundsFromArea(tc);
                this.addTCIntoPane(tc);
            } else {
                int tabIndex = positionNames.indexOf(this.constraints.get(tc));
                this.openTabbedContainer(tabIndex, tc, this.constraints.get(tc));
                this.tabbedContainer[tabIndex].removeChangeListener(this);
                this.addTCIntoTab(tc, tabIndex, false);
                this.tabbedContainer[tabIndex].addChangeListener(this);
            }
            ++i2;
        }
        this.resetSelection();
    }

    private void resetSelection() {
        TopComponent[] curComps = this.getTopComponents();
        TopComponent select = null;
        if (this.wasSelected != null && this.containsTopComponent(this.wasSelected)) {
            select = this.wasSelected;
        } else if (curComps.length > 0) {
            select = curComps[0];
        }
        if (select != null) {
            int index = positionNames.indexOf(this.constraints.get(select));
            if (this.tabbedContainer[index] != null) {
                this.tabbedContainer[index].setSelectedComponent((Component)select);
            }
            SplitContainerImpl.ensureTCIsVisible(select);
            this.setSelectedTopComponent(select);
        }
        int i = 0;
        while (i < this.tabbedContainer.length) {
            Component sel;
            Component component = sel = this.tabbedContainer[i] == null ? null : this.tabbedContainer[i].getSelectedComponent();
            if (sel != null) {
                sel.setVisible(true);
            }
            ++i;
        }
    }

    public void checkShownComponents() {
        int i = 0;
        while (i < this.tabbedContainer.length) {
            Component sel;
            Component component = sel = this.tabbedContainer[i] == null ? null : this.tabbedContainer[i].getSelectedComponent();
            if (sel instanceof TopComponent) {
                this.updateShownComponents((TopComponent)sel);
            }
            ++i;
        }
    }

    private void adjustTCBoundsFromArea(TopComponent tc) {
        Dimension prefSize = this.getAreaDimension(this.constraints.get(tc));
        if (prefSize != null) {
            tc.setSize(prefSize);
        }
    }

    private void setPrefTabbedSizeForArea(Object constraint) {
        if (this.prefTabbedSize[positionNames.indexOf(constraint)] == null) {
            this.prefTabbedSize[SplitContainerImpl.positionNames.indexOf((Object)constraint)] = this.getAreaDimension(constraint);
        }
    }

    private Dimension getAreaDimension(Object constraint) {
        Rectangle areaBounds;
        TopComponentContainer.Area area = (TopComponentContainer.Area)this.constrs2Areas.get(constraint);
        if (area != null && (areaBounds = area.getBounds()) != null) {
            return new Dimension(areaBounds.width, areaBounds.height);
        }
        return null;
    }

    protected void detachComponents() {
        TopComponent selected;
        if (this.constraints.size() == 1 && SplitContainerImpl.hasAlonePolicy(selected = this.getSelectedTopComponent())) {
            this.removeTCFromPane(selected);
            return;
        }
        this.wasSelected = this.getSelectedTopComponent();
        int i = 0;
        while (i < positionNames.size()) {
            if (this.tabbedContainer[i] != null) {
                this.selectedTabs[i] = this.tabbedContainer[i].getSelectedIndex();
                this.tabbedContainer[i].removeChangeListener(this);
                this.tabbedContainer[i].removeAll();
                this.tabbedContainer[i].addChangeListener(this);
                if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) < 0) {
                    this.tabbedContainer[i].updateUI();
                    this.changeUI(i);
                }
            } else {
                this.selectedTabs[i] = -1;
                Component comp = this.contentPane.getComponentAt((String)positionNames.get(i));
                if (comp instanceof TopComponent) {
                    this.removeTCFromPane((TopComponent)comp);
                }
            }
            ++i;
        }
    }

    protected void componentAdded(TopComponent tc) {
        this.componentAdded(tc, "CENTER", Integer.MAX_VALUE, null);
    }

    protected void componentAdded(TopComponent tc, Object constr, int orderWeight, TopComponentContainer.Area area) {
        if (positionNames.indexOf(constr) == -1) {
            throw new IllegalArgumentException("invalid constraint: " + constr);
        }
        Object object = this.COMPONENT_LOCK;
        synchronized (object) {
            TopComponentContainer.Area curArea;
            TopComponent[] tcs = this.getTopComponents();
            this.constraints.put(tc, constr);
            int position = this.addToArea(tc, constr, orderWeight, area);
            if (this.constraints.size() == 1 && SplitContainerImpl.hasAlonePolicy(tc)) {
                this.setPrefTabbedSizeForArea(this.constraints.get(tc));
                this.addTCIntoPane(tc);
                this.setSelectedTopComponent(tc);
                return;
            }
            if (this.constraints.size() == 2) {
                TopComponent current = tcs[0];
                if (current.equals(tc)) {
                    current = tcs[1];
                }
                if (this.constraints.get(current) == this.constraints.get(tc) || !SplitContainerImpl.hasAlonePolicy(current)) {
                    this.resetTCFromPaneToTab(current);
                }
            }
            if ((curArea = (TopComponentContainer.Area)this.constrs2Areas.get(constr)).getComponentsList().size() == 1 && SplitContainerImpl.hasAlonePolicy(tc)) {
                this.adjustTCBoundsFromArea(tc);
                this.addTCIntoPane(tc);
                this.revalidate();
            } else {
                Component aloneInArea;
                if (curArea.getComponentsList().size() == 2 && (aloneInArea = this.contentPane.getComponentAt((String)constr)) instanceof TopComponent) {
                    this.resetTCFromPaneToTab((TopComponent)aloneInArea);
                }
                int tabIndex = positionNames.indexOf(constr);
                this.openTabbedContainer(tabIndex, tc, constr);
                this.insertTCIntoTab(tc, tabIndex, position);
            }
        }
    }

    private void addTCIntoPane(TopComponent tc) {
        if (this.isAttached()) {
            SplitContainerImpl.ensureTCIsVisible(tc);
            this.updateShownComponents(tc);
            tc.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.contentPane.add((Component)tc, this.constraints.get(tc));
            tc.addComponentListener(this);
        }
    }

    private void resetTCFromPaneToTab(TopComponent tc) {
        int index = positionNames.indexOf(this.constraints.get(tc));
        this.removeTCFromPane(tc);
        this.openTabbedContainer(index, tc, this.getConstraints(tc));
        this.addTCIntoTab(tc, index, true);
    }

    private void addTCIntoTab(TopComponent tc, int index, boolean checkPrevComp) {
        if (!this.isAttached()) {
            return;
        }
        SplitContainerImpl.ensureTCIsVisible(tc);
        if (SplitContainerImpl.containsTC(this.tabbedContainer[index], tc)) {
            return;
        }
        Component c = this.tabbedContainer[index].getSelectedComponent();
        Image icon = tc.getIcon();
        this.tabbedContainer[index].addTab(tc.getName() + CloseButtonTabbedPane.TAB_NAME_TRAILING_SPACE, icon == null ? null : new ImageIcon(icon), (Component)tc, tc.getToolTipText());
        if (checkPrevComp && c != null && c.isVisible()) {
            c.setVisible(false);
        }
    }

    private void insertTCIntoTab(TopComponent tc, int tabIndex, int position) {
        if (!this.isAttached()) {
            return;
        }
        SplitContainerImpl.ensureTCIsVisible(tc);
        CloseButtonTabbedPane tabPane = this.tabbedContainer[tabIndex];
        if (SplitContainerImpl.containsTC(tabPane, tc)) {
            return;
        }
        int tabCount = tabPane.getTabCount();
        if (position > tabCount) {
            position = tabCount;
        }
        Component c = tabPane.getSelectedComponent();
        Image icon = tc.getIcon();
        tabPane.insertTab(tc.getName() + CloseButtonTabbedPane.TAB_NAME_TRAILING_SPACE, icon == null ? null : new ImageIcon(icon), (Component)tc, tc.getToolTipText(), position);
        if (c != null && c.isVisible()) {
            c.setVisible(false);
        }
    }

    private static boolean containsTC(JTabbedPane tabPane, TopComponent tc) {
        Component[] cs = tabPane.getComponents();
        int i = 0;
        while (i < cs.length) {
            if (cs[i] == tc) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void ensureTCIsVisible(TopComponent tc) {
        if (!tc.isVisible()) {
            tc.setVisible(true);
        }
    }

    protected void componentRemoved(TopComponent tc) {
        Object object = this.COMPONENT_LOCK;
        synchronized (object) {
            TopComponent left;
            int tabIndex;
            TopComponent[] tcs = this.getTopComponents();
            if (this.constraints.size() == 1 && SplitContainerImpl.hasAlonePolicy(tc)) {
                this.removeFromArea(tc);
                this.constraints.remove(tc);
                this.doActivateComponent(null);
                this.removeTCFromPane(tc);
                return;
            }
            boolean reactivatedSelection = false;
            if (tc == this.contentPane.getComponentAt((String)this.constraints.get(tc))) {
                this.removeTCFromPane(tc);
                this.revalidate();
            } else {
                this.removeTCFromTab(tc);
                tabIndex = positionNames.indexOf(this.constraints.get(tc));
                if (tabIndex >= 0 && tabIndex < this.tabbedContainer.length && this.tabbedContainer[tabIndex] == null) {
                    this.reactivateSelectedComponent();
                    reactivatedSelection = true;
                }
            }
            tabIndex = positionNames.indexOf(this.constraints.get(tc));
            this.removeFromArea(tc);
            this.constraints.remove(tc);
            this.removeTCFromPane(tc);
            JTabbedPane tab = null;
            if (tabIndex >= 0 && tabIndex < this.tabbedContainer.length) {
                tab = this.tabbedContainer[tabIndex];
            }
            if (tab != null && tab.getTabCount() == 1 && SplitContainerImpl.hasAlonePolicy(left = (TopComponent)tab.getComponentAt(0))) {
                this.removeTCFromTab(left);
                this.addTCIntoPane(left);
                this.setSelectedTopComponent(left);
                this.reactivateSelectedComponent();
                reactivatedSelection = true;
            }
            if (tab != null) {
                TopComponent selected = (TopComponent)tab.getSelectedComponent();
                this.setSelectedTopComponent(selected);
                this.reactivateSelectedComponent();
                reactivatedSelection = true;
            }
            if (this.constraints.size() == 1) {
                TopComponent singleTc = tcs[0];
                if (SplitContainerImpl.hasAlonePolicy(singleTc)) {
                    this.removeTCFromTab(singleTc);
                    this.addTCIntoPane(singleTc);
                }
                if (this.isAttached()) {
                    this.mode.updateTitle();
                }
            }
            if (tcs.length > 0 && !reactivatedSelection) {
                TopComponent firstTc = tcs[0];
                this.setSelectedTopComponent(firstTc);
                this.reactivateSelectedComponent();
            }
        }
    }

    private void removeTCFromPane(TopComponent tc) {
        tc.removeComponentListener(this);
        this.contentPane.remove((Component)tc);
        tc.setBorder((Border)this.borders.get(tc));
    }

    private void removeTCFromTab(TopComponent tc) {
        int tabIndex = positionNames.indexOf(this.constraints.get(tc));
        if (tabIndex < 0 || tabIndex >= this.tabbedContainer.length) {
            return;
        }
        CloseButtonTabbedPane tab = this.tabbedContainer[tabIndex];
        if (tab != null) {
            if (tab.indexOfComponent((Component)tc) != -1) {
                tab.removeChangeListener(this);
                tab.remove((Component)tc);
                tab.addChangeListener(this);
                tc.getAccessibleContext().setAccessibleParent(null);
            }
            if (tab.getTabCount() == 0) {
                this.closeTabbedContainer(tabIndex);
            }
        }
    }

    static boolean hasAlonePolicy(TopComponent tc) {
        if (tc == null) {
            return false;
        }
        String tabPolicy = (String)tc.getClientProperty("TabPolicy");
        return "HideWhenAlone".equals(tabPolicy);
    }

    private static Border createSplitBorder() {
        return BorderFactory.createEmptyBorder(0, 0, 0, 0);
    }

    private int addToArea(TopComponent tc, Object constr, int orderWeight, TopComponentContainer.Area area) {
        TopComponentContainer.Area curArea = (TopComponentContainer.Area)this.constrs2Areas.get(constr);
        if (area != null && curArea == null) {
            this.constrs2Areas.put(constr, area);
            this.areas.add(area);
            curArea = area;
        }
        if (curArea == null) {
            curArea = new TCCTabbedAreaImpl(constr);
            this.constrs2Areas.put(constr, curArea);
            this.areas.add(curArea);
        }
        int position = this.findPosition(orderWeight, constr);
        curArea.getComponentsList().add(position, tc);
        return position;
    }

    private void removeFromArea(TopComponent tc) {
        Object constraint = this.constraints.get(tc);
        TopComponentContainer.Area curArea = (TopComponentContainer.Area)this.constrs2Areas.get(constraint);
        if (curArea == null) {
            return;
        }
        List compList = curArea.getComponentsList();
        compList.remove(tc);
        if (compList.size() <= 0) {
            this.constrs2Areas.remove(constraint);
            this.areas.remove(curArea);
            if (this.isAttached()) {
                HashMap<Object, TopComponentContainer.Area> modeAreas = this.mode.getAreas();
                modeAreas = modeAreas == null ? new HashMap() : new HashMap(modeAreas);
                modeAreas.put(constraint, curArea);
                this.mode.setAreas(modeAreas);
            }
        }
    }

    protected void componentIconChanged(TopComponent tc, Image icon) {
        if (!this.containsTopComponent(tc)) {
            return;
        }
        if (this.constraints.size() > 0) {
            CloseButtonTabbedPane tab = this.tabbedContainer[positionNames.indexOf(this.constraints.get(tc))];
            if (tab == null) {
                return;
            }
            int index = tab.indexOfComponent((Component)tc);
            if (index < 0) {
                return;
            }
            tab.setIconAt(index, new ImageIcon(icon));
            if (this.isAttached()) {
                tab.revalidate();
                tab.repaint();
            }
        }
    }

    protected void componentNameChanged(TopComponent tc) {
        if (!this.containsTopComponent(tc)) {
            return;
        }
        String newName = tc.getName();
        CloseButtonTabbedPane tab = this.tabbedContainer[positionNames.indexOf(this.constraints.get(tc))];
        if (tab != null) {
            int index = tab.indexOfComponent((Component)tc);
            if (index < 0) {
                return;
            }
            tab.setTitleAt(index, newName + CloseButtonTabbedPane.TAB_NAME_TRAILING_SPACE);
            tab.setToolTipTextAt(index, tc.getToolTipText());
        }
        this.firePropertyChange("name", null, newName);
    }

    protected void componentSelected(TopComponent tc) {
        TopComponentContainer.Area area;
        CloseButtonTabbedPane tab;
        int tabIndex;
        if (tc == null) {
            return;
        }
        SplitContainerImpl.ensureTCIsVisible(tc);
        if (this.constraints.size() > 0 && (tabIndex = positionNames.indexOf(this.constraints.get(tc))) >= 0 && tabIndex < this.tabbedContainer.length && (tab = this.tabbedContainer[tabIndex]) != null && tab.indexOfComponent((Component)tc) >= 0) {
            tab.setSelectedComponent((Component)tc);
            Component[] cs = tab.getComponents();
            int i = 0;
            while (i < cs.length) {
                if (cs[i] != tc && cs[i].isVisible() && cs[i] instanceof TopComponent) {
                    cs[i].setVisible(false);
                }
                ++i;
            }
        }
        if ((area = (TopComponentContainer.Area)this.constrs2Areas.get(this.constraints.get(tc))) != null) {
            area.setSelectedTopComponent(tc);
        }
    }

    protected List getHiddingComponents(Set shownTcs, TopComponent showing) {
        Object constr = this.constraints.get(showing);
        List<TopComponent> hidding = null;
        Iterator it = shownTcs.iterator();
        while (it.hasNext()) {
            TopComponent tc = (TopComponent)it.next();
            if (this.constraints.get(tc) != constr) continue;
            it.remove();
            hidding = Collections.singletonList(tc);
            break;
        }
        return hidding;
    }

    public void stateChanged(ChangeEvent e) {
        JTabbedPane tab = (JTabbedPane)e.getSource();
        if (!this.isVisible() || !this.isShowing() || tab.getTabCount() <= 0) {
            return;
        }
        int index = tab.getSelectedIndex();
        TopComponent current = index < 0 ? null : (TopComponent)tab.getComponentAt(index);
        this.setSelectedTopComponent(current);
        this.reactivateSelectedComponent();
    }

    public void setAttached(boolean attached) {
        super.setAttached(attached);
        if (attached) {
            ActivateTopComponentOnMouseClick.install();
        }
    }

    public void validateData() {
        super.validateData();
        if (this.serConstraints != null) {
            Iterator constraintsIter = ((AbstractList)this.serConstraints).iterator();
            TopComponent[] tcs = this.getTopComponents();
            int i = 0;
            while (i < tcs.length) {
                if (constraintsIter.hasNext()) {
                    Object curConstraint = constraintsIter.next();
                    TopComponent curTc = tcs[i];
                    TopComponentContainer.Area curArea = (TopComponentContainer.Area)this.constrs2Areas.get(curConstraint);
                    if (curArea == null || !curArea.getComponentsList().contains(curTc)) {
                        this.componentAdded(curTc, curConstraint, Integer.MAX_VALUE, null);
                    }
                }
                ++i;
            }
            this.serConstraints = null;
        }
        if (this.serSelectedTabs != null) {
            Iterator selectedTabIterator = ((AbstractList)this.serSelectedTabs).iterator();
            int i = 0;
            while (i < positionNames.size() && selectedTabIterator.hasNext()) {
                this.selectedTabs[i] = (Integer)selectedTabIterator.next();
                ++i;
            }
            this.serConstraints = null;
        } else {
            int i = 0;
            while (i < positionNames.size()) {
                this.selectedTabs[i] = -1;
                ++i;
            }
        }
        this.wasSelected = this.getSelectedTopComponent();
    }

    public void changeUI() {
        int count = this.tabbedContainer.length;
        int i = 0;
        while (i < count) {
            this.changeUI(i);
            ++i;
        }
    }

    public void changeUI(int index) {
        if (this.tabbedContainer[index] != null) {
            boolean jdk14 = Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0;
            switch (TabbedContainerUIManager.getDefault().getTabbedContainerUI()) {
                case 1: {
                    if (jdk14) {
                        MultiTabbedContainerImpl.setTabLayoutPolicyForPane(0, this.tabbedContainer[index]);
                        break;
                    }
                    if (this.tabbedContainer[index].getUI() instanceof BasicTabbedPaneUI) break;
                    SplitContainerImpl.updateUITypeForTab(this.tabbedContainer[index], 0);
                    break;
                }
                case 2: {
                    if (jdk14) {
                        MultiTabbedContainerImpl.setTabLayoutPolicyForPane(1, this.tabbedContainer[index]);
                        break;
                    }
                    if (this.tabbedContainer[index].getUI() instanceof ArrowsTabbedPaneUI) break;
                    SplitContainerImpl.updateUITypeForTab(this.tabbedContainer[index], 1);
                    break;
                }
                case 3: {
                    if (jdk14) {
                        MultiTabbedContainerImpl.setTabLayoutPolicyForPane(1, this.tabbedContainer[index]);
                        break;
                    }
                    if (this.tabbedContainer[index].getUI() instanceof PopupTabbedPaneUI) break;
                    SplitContainerImpl.updateUITypeForTab(this.tabbedContainer[index], 2);
                    break;
                }
                case 4: {
                    if (jdk14) {
                        MultiTabbedContainerImpl.setTabLayoutPolicyForPane(1, this.tabbedContainer[index]);
                        break;
                    }
                    if (this.tabbedContainer[index].getUI() instanceof ArrowsTabbedPaneUI) break;
                    SplitContainerImpl.updateUITypeForTab(this.tabbedContainer[index], 1);
                }
            }
        }
    }

    private void openTabbedContainer(int i, TopComponent firstTc, Object constraint) {
        if (this.tabbedContainer[i] != null) {
            return;
        }
        this.tabbedContainer[i] = new CloseButtonTabbedPane();
        if (WindowManagerImpl.isWindowDnDEnabled()) {
            WindowDnDManager.getDefault().getWindowDragSource().createDefaultDragGestureRecognizer(this.tabbedContainer[i], 3, TopComponentDragSupport.getDefault());
        }
        this.changeUI(i);
        if (!Boolean.getBoolean("netbeans.windows.tabs_on_top")) {
            this.tabbedContainer[i].setTabPlacement(3);
        }
        if (this.prefTabbedSize[i] == null) {
            Dimension prefSize = this.getAreaDimension(constraint);
            if (prefSize == null) {
                prefSize = firstTc.getSize();
            }
            Insets insets = this.tabbedContainer[i].getInsets();
            prefSize.width += insets.left + insets.right;
            prefSize.height += insets.top + insets.bottom;
            this.prefTabbedSize[i] = prefSize;
        }
        this.tabbedContainer[i].setPreferredSize(this.prefTabbedSize[i]);
        TabHandlePopupListener.install();
        this.tabbedContainer[i].addChangeListener(this);
        this.tabbedContainer[i].addFocusListener(this.tabbedFocusListener);
        this.tabbedContainer[i].addComponentListener(this);
        this.tabbedContainer[i].getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$frames$SplitContainerImpl == null ? (class$org$netbeans$core$windows$frames$SplitContainerImpl = SplitContainerImpl.class$("org.netbeans.core.windows.frames.SplitContainerImpl")) : class$org$netbeans$core$windows$frames$SplitContainerImpl), (String)"ACSN_TabbedContainer"));
        this.tabbedContainer[i].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$frames$SplitContainerImpl == null ? (class$org$netbeans$core$windows$frames$SplitContainerImpl = SplitContainerImpl.class$("org.netbeans.core.windows.frames.SplitContainerImpl")) : class$org$netbeans$core$windows$frames$SplitContainerImpl), (String)"ACSD_TabbedContainer"));
        this.tabbedContainer2Constraint.put(this.tabbedContainer[i], positionNames.get(i));
        this.tabbedContainer[i].setBorder(SplitContainerImpl.createSplitBorder());
        ++this.counter;
        this.contentPane.add((Component)this.tabbedContainer[i], positionNames.get(i));
    }

    private void closeTabbedContainer(int i) {
        if (this.tabbedContainer[i] == null) {
            return;
        }
        this.tabbedContainer[i].removeChangeListener(this);
        this.tabbedContainer[i].removeFocusListener(this.tabbedFocusListener);
        this.tabbedContainer[i].removeComponentListener(this);
        this.tabbedContainer2Constraint.remove(this.tabbedContainer[i]);
        this.prefTabbedSize[i] = this.tabbedContainer[i].getSize();
        this.contentPane.remove(this.tabbedContainer[i]);
        this.tabbedContainer[i] = null;
        --this.counter;
        int j = 0;
        while (j < positionNames.size()) {
            if (this.tabbedContainer[j] != null) {
                this.tabbedContainer[j].setPreferredSize(this.tabbedContainer[j].getSize());
                this.setSelectedTopComponent((TopComponent)this.tabbedContainer[j].getSelectedComponent());
            }
            ++j;
        }
    }

    public Object getConstraintForLocation(Point location) {
        Rectangle rectangle = this.getBounds();
        return SplitContainerImpl.extractConstraint(this.getPosition(new int[]{0, 0, 0}, new int[]{0, 0, 0}, location, rectangle));
    }

    public String getDescriptionForLocation(Point location) {
        Object constraint = this.getConstraintForLocation(location);
        String key = null;
        if (constraint == "CENTER") {
            key = "LBL_PerimeterLayoutCenter";
        } else if (constraint == "NORTH") {
            key = "LBL_PerimeterLayoutNorth";
        } else if (constraint == "SOUTH") {
            key = "LBL_PerimeterLayoutSouth";
        } else if (constraint == "WEST") {
            key = "LBL_PerimeterLayoutWest";
        } else if (constraint == "EAST") {
            key = "LBL_PerimeterLayoutEast";
        }
        return key == null ? null : NbBundle.getMessage((Class)(class$org$netbeans$core$windows$frames$SplitContainerImpl == null ? (class$org$netbeans$core$windows$frames$SplitContainerImpl = SplitContainerImpl.class$("org.netbeans.core.windows.frames.SplitContainerImpl")) : class$org$netbeans$core$windows$frames$SplitContainerImpl), (String)key);
    }

    public Shape getIndicationForLocation(Point location) {
        String constraint;
        Rectangle rectangle = this.getBounds();
        int[] xSpaces = new int[]{0, 0, 0};
        int[] ySpaces = new int[]{0, 0, 0};
        Point position = this.getPosition(xSpaces, ySpaces, location, rectangle);
        if (position.x == 1) {
            rectangle.y = this.sumArray(ySpaces, position.y);
            rectangle.height = ySpaces[position.y];
        }
        if (position.y == 1) {
            rectangle.x = this.sumArray(xSpaces, position.x);
            rectangle.width = xSpaces[position.x];
        }
        if ((constraint = SplitContainerImpl.extractConstraint(position)) != null) {
            Component comp = this.contentPane.getComponentAt(constraint);
            if (comp != null) {
                return comp.getBounds();
            }
            PerimeterLayout pl = (PerimeterLayout)this.contentPane.getLayout();
            Rectangle rect = pl.getPossibleBounds(this, PerimeterLayout.sideNames.indexOf(constraint), (Rectangle)WindowDnDManager.getDefault().getOriginalBounds().clone());
            if (rect != null) {
                return rect;
            }
        }
        return rectangle;
    }

    private Point getPosition(int[] xSpaces, int[] ySpaces, Point location, Rectangle rectangle) {
        int xPosition;
        this.getSectorLengths(true, xSpaces, new int[]{3, 4, 2}, rectangle.width);
        this.getSectorLengths(false, ySpaces, new int[]{0, 4, 1}, rectangle.height);
        int n = location.x < xSpaces[0] ? 0 : (xPosition = location.x < xSpaces[0] + xSpaces[1] ? 1 : 2);
        int yPosition = location.y < ySpaces[0] ? 0 : (location.y < ySpaces[0] + ySpaces[1] ? 1 : 2);
        int adjust = SplitContainerImpl.adjustPosition(xPosition, yPosition, location, rectangle);
        if (adjust == -1) {
            xPosition = 1;
        } else if (adjust == 1) {
            yPosition = 1;
        }
        return new Point(xPosition, yPosition);
    }

    private static int adjustPosition(int xPosition, int yPosition, Point location, Rectangle rectangle) {
        if (xPosition == 1 || yPosition == 1) {
            return 0;
        }
        if (xPosition == 0 && yPosition == 0 && location.x > location.y || xPosition == 2 && yPosition == 0 && rectangle.width - location.x > location.y || xPosition == 0 && yPosition == 2 && location.x > rectangle.height - location.y || xPosition == 2 && yPosition == 2 && rectangle.width - location.x > rectangle.height - location.y) {
            return -1;
        }
        return 1;
    }

    private static String extractConstraint(Point position) {
        String result = "CENTER";
        if (position.x == 0) {
            result = "WEST";
        } else if (position.x == 1) {
            if (position.y == 0) {
                result = "NORTH";
            } else if (position.y == 1) {
                result = "CENTER";
            } else if (position.y == 2) {
                result = "SOUTH";
            }
        } else if (position.x == 2) {
            result = "EAST";
        }
        return result;
    }

    private void getSectorLengths(boolean doWidth, int[] array, int[] indexes, int length) {
        int sum = 0;
        int existing = 0;
        if (array.length != indexes.length) {
            throw new IllegalStateException("Diff array lengths:" + array.length + "<>" + indexes.length);
        }
        int i = 0;
        while (i < array.length) {
            array[i] = this.getSectorLength(doWidth, indexes[i], sum);
            sum += array[i];
            if (array[i] > 0) {
                ++existing;
            }
            ++i;
        }
        if (existing == 0 || existing == 1) {
            array[0] = array[2] = length / 4;
            array[1] = length / 2;
        } else if (existing == 2) {
            if (array[0] != 0) {
                if (array[1] != 0) {
                    array[1] = array[2] = array[1] / 2;
                } else {
                    array[1] = array[0] / 2 + array[2] / 2;
                    array[0] = array[0] / 2;
                    array[2] = array[2] / 2;
                }
            } else {
                array[0] = array[1] = array[1] / 2;
            }
        }
    }

    private int getSectorLength(boolean doWidth, int index, int sum) {
        if (this.tabbedContainer[index] == null) {
            return 0;
        }
        Rectangle bounds = this.tabbedContainer[index].getBounds();
        if (doWidth) {
            return bounds.x + bounds.width - sum;
        }
        return bounds.y + bounds.height - sum;
    }

    private int sumArray(int[] array, int count) {
        int sum = 0;
        int i = 0;
        while (i < count) {
            sum += array[i];
            ++i;
        }
        return sum;
    }

    public void componentHidden(ComponentEvent ev) {
    }

    public void componentShown(ComponentEvent ev) {
    }

    public void componentResized(ComponentEvent ev) {
        this.updateAreaBounds(ev);
    }

    public void componentMoved(ComponentEvent ev) {
        this.updateAreaBounds(ev);
    }

    private void updateAreaBounds(ComponentEvent evt) {
        Component comp = evt.getComponent();
        Object constr = null;
        if (comp instanceof JTabbedPane) {
            constr = this.tabbedContainer2Constraint.get(comp);
        } else if (comp instanceof TopComponent) {
            if (!this.containsTopComponent((TopComponent)comp)) {
                comp.removeComponentListener(this);
                return;
            }
            constr = this.constraints.get(comp);
        }
        TopComponentContainer.Area curArea = (TopComponentContainer.Area)this.constrs2Areas.get(constr);
        curArea.setBounds(comp.getBounds());
    }

    protected void componentFocusGained(TopComponent tc, FocusEvent ev) {
        if (tc != this.getSelectedTopComponent() && this.requestedTC != null && this.containsTopComponent(this.requestedTC)) {
            tc = this.requestedTC;
        }
        this.requestedTC = null;
        super.componentFocusGained(tc, ev);
        if (tc != this.getSelectedTopComponent()) {
            int j = positionNames.indexOf(this.constraints.get(tc));
            CloseButtonTabbedPane tab = this.tabbedContainer[j];
            if (tab != null) {
                tab.removeChangeListener(this);
            }
            this.setSelectedTopComponent(tc);
            this.reactivateSelectedComponent();
            if (tab != null) {
                tab.addChangeListener(this);
            }
        }
    }

    private static void updateUITypeForTab(CloseButtonTabbedPane dynUITab, int uiType) {
        dynUITab.setUIType(uiType);
        SwingUtilities.updateComponentTreeUI(dynUITab);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SplittedContainerImpl$SerializationReplacer(this);
    }

    void writeData(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField pf = oos.putFields();
        pf.put(DEFAULT_CONTAINER, new DefaultContainerImpl.SerializedData(this));
        List<TopComponent> tcList = Arrays.asList(this.getTopComponents());
        ArrayList constraintsList = new ArrayList(tcList.size());
        Iterator<TopComponent> iter = tcList.iterator();
        while (iter.hasNext()) {
            constraintsList.add(this.constraints.get(iter.next()));
        }
        pf.put(CONSTRAINTS_LIST, constraintsList);
        ArrayList<Dimension> tabbedContSize = new ArrayList<Dimension>(this.prefTabbedSize.length);
        int i = 0;
        while (i < this.prefTabbedSize.length) {
            tabbedContSize.add(this.tabbedContainer[i] == null ? this.prefTabbedSize[i] : this.tabbedContainer[i].getSize());
            ++i;
        }
        pf.put(TABBED_CONTAINERS_SIZE, tabbedContSize);
        ArrayList<Integer> selectedTabIndex = new ArrayList<Integer>(positionNames.size());
        int i2 = 0;
        while (i2 < positionNames.size()) {
            selectedTabIndex.add(this.tabbedContainer[i2] == null ? new Integer(-1) : new Integer(this.tabbedContainer[i2].getSelectedIndex()));
            ++i2;
        }
        pf.put(INDEX_OF_SELECTED_TAB, selectedTabIndex);
        oos.writeFields();
    }

    void readData(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ArrayList tabbedContSize;
        ObjectInputStream.GetField gf = ois.readFields();
        this.attachData((DefaultContainerImpl.SerializedData)gf.get(DEFAULT_CONTAINER, null));
        this.serConstraints = (ArrayList)gf.get(CONSTRAINTS_LIST, null);
        if (WindowUtils.hasObjectStreamField(gf, TABBED_CONTAINERS_SIZE) && (tabbedContSize = (ArrayList)gf.get(TABBED_CONTAINERS_SIZE, null)) != null) {
            Dimension[] tabSizes = tabbedContSize.toArray(new Dimension[0]);
            System.arraycopy(tabSizes, 0, this.prefTabbedSize, 0, this.prefTabbedSize.length);
        }
        if (WindowUtils.hasObjectStreamField(gf, INDEX_OF_SELECTED_TAB)) {
            this.serSelectedTabs = (ArrayList)gf.get(INDEX_OF_SELECTED_TAB, null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        positionNames.add("NORTH");
        positionNames.add("SOUTH");
        positionNames.add("EAST");
        positionNames.add("WEST");
        positionNames.add("CENTER");
    }

    private class TabbedContainerFocusL
    extends FocusAdapter {
        TabbedContainerFocusL() {
        }

        public void focusGained(FocusEvent ev) {
            TopComponent tc = (TopComponent)((JTabbedPane)ev.getComponent()).getSelectedComponent();
            if (tc != null && tc != SplitContainerImpl.this.getSelectedTopComponent()) {
                if (!SplitContainerImpl.this.containsTopComponent(tc)) {
                    ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("TopComponent " + tc + " is not in container for mode " + SplitContainerImpl.this.mode + "!"));
                    return;
                }
                SplitContainerImpl.this.setSelectedTopComponent(tc);
                SplitContainerImpl.this.reactivateSelectedComponent();
            }
        }
    }

    private static class ActivateTopComponentOnMouseClick
    implements AWTEventListener {
        private static boolean installed;

        private ActivateTopComponentOnMouseClick() {
        }

        static synchronized void install() {
            if (installed) {
                return;
            }
            installed = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new ActivateTopComponentOnMouseClick(), 16L);
        }

        public void eventDispatched(AWTEvent ev) {
            if (ev.getID() != 501) {
                return;
            }
            if (!(ev.getSource() instanceof Component)) {
                return;
            }
            Component comp = (Component)ev.getSource();
            while (comp != null && !(comp instanceof SplitContainerImpl) && !(comp instanceof TopComponent)) {
                comp = comp.getParent();
            }
            if (comp instanceof TopComponent) {
                TopComponentContainer tcc;
                TopComponent tc = (TopComponent)comp;
                while (comp != null && !(comp instanceof SplitContainerImpl)) {
                    comp = comp.getParent();
                }
                if (comp instanceof TopComponentContainer && (tcc = (TopComponentContainer)((Object)comp)).containsTopComponent(tc)) {
                    tcc.setSelectedTopComponent(tc);
                }
                if (comp instanceof SplitContainerImpl) {
                    ((SplitContainerImpl)comp).reactivateSelectedComponent();
                }
            }
        }
    }
}

