/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.layers;

import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.LazyUpdater;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.UIModeManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.layers.ICFolderImpl;
import org.netbeans.core.windows.layers.InvalidDataException;
import org.netbeans.core.windows.layers.ModeData;
import org.netbeans.core.windows.layers.ProducerCookie;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.modules.ModuleInfo;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.openide.windows.Mode;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class WorkspaceData
extends DataFolder
implements CookieSet.Factory {
    private static final String INSTANCE_DTD_ID_1_0 = "-//NetBeans//DTD Workspace Properties 1.0//EN";
    private static final String INSTANCE_DTD_ID_1_1 = "-//NetBeans//DTD Workspace Properties 1.1//EN";
    private FileObject workspaceConfigFO;
    private InstanceCookieImpl instCookieImpl;
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$WorkspaceData;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$ResetCookie;
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$ProducerCookie;

    public WorkspaceData(FileObject pf, FileObject siblink, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        this.initCookies();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$windows$layers$WorkspaceData == null ? (class$org$netbeans$core$windows$layers$WorkspaceData = WorkspaceData.class$("org.netbeans.core.windows.layers.WorkspaceData")) : class$org$netbeans$core$windows$layers$WorkspaceData);
    }

    public boolean isRenameAllowed() {
        return false;
    }

    public boolean isDeleteAllowed() {
        try {
            return this.getWorkspaceImpl() != WindowManager.getDefault().getCurrentWorkspace();
        }
        catch (IOException ioe) {
            return false;
        }
    }

    protected void handleDelete() throws IOException {
        this.getWorkspaceImpl().remove();
        super.handleDelete();
    }

    private void initCookies() {
        this.getCookieSet().add(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = WorkspaceData.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie, (CookieSet.Factory)this);
        this.getCookieSet().add(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = WorkspaceData.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie, (CookieSet.Factory)this);
        this.getCookieSet().add(class$org$netbeans$core$windows$layers$ResetCookie == null ? (class$org$netbeans$core$windows$layers$ResetCookie = WorkspaceData.class$("org.netbeans.core.windows.layers.ResetCookie")) : class$org$netbeans$core$windows$layers$ResetCookie, (CookieSet.Factory)this);
        this.getCookieSet().add(class$org$netbeans$core$windows$layers$ProducerCookie == null ? (class$org$netbeans$core$windows$layers$ProducerCookie = WorkspaceData.class$("org.netbeans.core.windows.layers.ProducerCookie")) : class$org$netbeans$core$windows$layers$ProducerCookie, (CookieSet.Factory)this);
    }

    WorkspaceImpl getWorkspaceImpl() throws IOException {
        return this.instanceCookieImpl().obtainWorkspaceImpl();
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz == (class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = WorkspaceData.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie) || clazz == (class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = WorkspaceData.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) || clazz == (class$org$netbeans$core$windows$layers$ResetCookie == null ? (class$org$netbeans$core$windows$layers$ResetCookie = WorkspaceData.class$("org.netbeans.core.windows.layers.ResetCookie")) : class$org$netbeans$core$windows$layers$ResetCookie) || clazz == (class$org$netbeans$core$windows$layers$ProducerCookie == null ? (class$org$netbeans$core$windows$layers$ProducerCookie = WorkspaceData.class$("org.netbeans.core.windows.layers.ProducerCookie")) : class$org$netbeans$core$windows$layers$ProducerCookie)) {
            return this.instanceCookieImpl();
        }
        return null;
    }

    private synchronized InstanceCookieImpl instanceCookieImpl() {
        if (this.instCookieImpl != null) {
            return this.instCookieImpl;
        }
        this.instCookieImpl = new InstanceCookieImpl(this);
        return this.instCookieImpl;
    }

    FileObject getWorkspaceConfigFO() {
        if (this.workspaceConfigFO == null) {
            Iterator iter = this.secondaryEntries().iterator();
            while (iter.hasNext()) {
                this.workspaceConfigFO = ((MultiDataObject.Entry)iter.next()).getFile();
            }
        }
        return this.workspaceConfigFO;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class PropertyHandler
    extends DefaultHandler {
        private WorkspaceData folder;
        private FileObject fo;
        private WorkspaceConfig workspaceConfig;
        boolean hasMdiSdi = false;
        private final Object RW_LOCK = new Object();
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$WorkspaceData;

        public PropertyHandler(WorkspaceData folder) {
            this.folder = folder;
            this.fo = folder.getWorkspaceConfigFO();
        }

        public WorkspaceConfig readData() throws SAXException, IOException {
            this.hasMdiSdi = false;
            this.workspaceConfig = new WorkspaceConfig();
            this.workspaceConfig.invalid = true;
            Object object = this.RW_LOCK;
            synchronized (object) {
                this.getXMLParser().parse(new InputSource(this.fo.getInputStream()));
            }
            return this.workspaceConfig;
        }

        public void startElement(String nameSpace, String name, String qname, Attributes attrs) throws SAXException {
            if ("name".equals(qname)) {
                this.handleName(attrs);
            } else if ("module".equals(qname)) {
                this.handleModule(attrs);
            } else if ("ui-type".equals(qname)) {
                this.handleUIType(attrs);
            } else if ("cascade".equals(qname)) {
                this.handleCascade(attrs);
            } else if ("active".equals(qname)) {
                this.handleActive(attrs);
            } else if ("mode".equals(qname)) {
                this.handleMode(attrs);
            } else if ("toolbar".equals(qname)) {
                this.handleToolbar(attrs);
            } else if ("description".equals(qname)) {
                this.handleDescription(attrs);
            } else if ("desktop".equals(qname)) {
                this.handleDesktop(attrs);
            }
        }

        public void endElement(String nameSpace, String name, String qname) throws SAXException {
            if ("ui-type".equals(qname) && this.workspaceConfig.uiType == UIModeManager.getDefault().getUIMode()) {
                this.hasMdiSdi = true;
                this.workspaceConfig.invalid = false;
            }
        }

        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }

        public void warning(SAXParseException ex) throws SAXException {
        }

        private void handleName(Attributes attrs) {
            this.workspaceConfig.name = attrs.getValue("unique");
            this.workspaceConfig.displayName = attrs.getValue("display");
            this.workspaceConfig.fromBundle = "true".equals(attrs.getValue("from-bundle"));
            if (this.workspaceConfig.fromBundle) {
                this.workspaceConfig.nameBundle = attrs.getValue("bundle");
            }
        }

        private void handleDescription(Attributes attrs) {
            this.workspaceConfig.description = attrs.getValue("display");
            this.workspaceConfig.descriptionBundle = attrs.getValue("bundle");
        }

        private void handleModule(Attributes attrs) {
            String moduleCodeName = attrs.getValue("name");
            this.workspaceConfig.moduleCodeNameBase = null;
            this.workspaceConfig.moduleCodeNameRelease = null;
            this.workspaceConfig.moduleSpecificationVersion = null;
            if (moduleCodeName != null) {
                int i = moduleCodeName.indexOf(47);
                if (i != -1) {
                    this.workspaceConfig.moduleCodeNameBase = moduleCodeName.substring(0, i);
                    this.workspaceConfig.moduleCodeNameRelease = moduleCodeName.substring(i + 1);
                    PropertyHandler.checkReleaseCode(this.workspaceConfig);
                } else {
                    this.workspaceConfig.moduleCodeNameBase = moduleCodeName;
                }
                this.workspaceConfig.moduleSpecificationVersion = attrs.getValue("spec");
            }
        }

        private static void checkReleaseCode(WorkspaceConfig wsConfig) {
            if ("null".equals(wsConfig.moduleCodeNameRelease)) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Module release code was saved as null string for module " + wsConfig.moduleCodeNameBase + "! Repairing."));
                wsConfig.moduleCodeNameRelease = null;
            }
        }

        private void handleUIType(Attributes attrs) {
            String uiTypeStr = attrs.getValue("type");
            if ("mdi".equals(uiTypeStr)) {
                this.workspaceConfig.clear();
                this.workspaceConfig.uiType = 2;
            } else if ("sdi".equals(uiTypeStr)) {
                this.workspaceConfig.clear();
                this.workspaceConfig.uiType = 1;
            } else {
                this.workspaceConfig.uiType = 0;
                this.workspaceConfig.invalid = false;
            }
        }

        private void handleCascade(Attributes attrs) {
            String annotation;
            if (this.hasMdiSdi) {
                return;
            }
            if (this.workspaceConfig.cascadeOrigin == null) {
                this.workspaceConfig.cascadeOrigin = new Point();
            }
            if (this.workspaceConfig.cascadeCurrent == null) {
                this.workspaceConfig.cascadeCurrent = new Point();
            }
            if (this.workspaceConfig.cascadeStep == null) {
                this.workspaceConfig.cascadeStep = new Dimension();
            }
            try {
                this.workspaceConfig.cascadeOrigin.x = Integer.parseInt(attrs.getValue("origin-x"));
                this.workspaceConfig.cascadeOrigin.y = Integer.parseInt(attrs.getValue("origin-y"));
            }
            catch (NumberFormatException exc) {
                this.workspaceConfig.cascadeOrigin = null;
                annotation = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$WorkspaceData == null ? (class$org$netbeans$core$windows$layers$WorkspaceData = PropertyHandler.class$("org.netbeans.core.windows.layers.WorkspaceData")) : class$org$netbeans$core$windows$layers$WorkspaceData), (String)"EXC_WorkspaceCascadeOrigin", (Object[])new Object[]{this.fo.getName()});
                ErrorManager.getDefault().annotate((Throwable)exc, annotation);
                ErrorManager.getDefault().notify(16, (Throwable)exc);
            }
            try {
                this.workspaceConfig.cascadeStep.width = Integer.parseInt(attrs.getValue("step-x"));
                this.workspaceConfig.cascadeStep.height = Integer.parseInt(attrs.getValue("step-y"));
            }
            catch (NumberFormatException exc) {
                this.workspaceConfig.cascadeStep = null;
                annotation = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$WorkspaceData == null ? (class$org$netbeans$core$windows$layers$WorkspaceData = PropertyHandler.class$("org.netbeans.core.windows.layers.WorkspaceData")) : class$org$netbeans$core$windows$layers$WorkspaceData), (String)"EXC_WorkspaceCascadeStep", (Object[])new Object[]{this.fo.getName()});
                ErrorManager.getDefault().annotate((Throwable)exc, annotation);
                ErrorManager.getDefault().notify(16, (Throwable)exc);
            }
            try {
                this.workspaceConfig.cascadeCount = Integer.parseInt(attrs.getValue("count"));
            }
            catch (NumberFormatException exc) {
                this.workspaceConfig.cascadeCount = 0;
                annotation = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$WorkspaceData == null ? (class$org$netbeans$core$windows$layers$WorkspaceData = PropertyHandler.class$("org.netbeans.core.windows.layers.WorkspaceData")) : class$org$netbeans$core$windows$layers$WorkspaceData), (String)"EXC_WorkspaceCascadeCount", (Object[])new Object[]{this.fo.getName()});
                ErrorManager.getDefault().annotate((Throwable)exc, annotation);
                ErrorManager.getDefault().notify(16, (Throwable)exc);
            }
            try {
                this.workspaceConfig.cascadeCurrent.x = Integer.parseInt(attrs.getValue("current-x"));
                this.workspaceConfig.cascadeCurrent.y = Integer.parseInt(attrs.getValue("current-y"));
            }
            catch (NumberFormatException exc) {
                this.workspaceConfig.cascadeCurrent = null;
                annotation = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$WorkspaceData == null ? (class$org$netbeans$core$windows$layers$WorkspaceData = PropertyHandler.class$("org.netbeans.core.windows.layers.WorkspaceData")) : class$org$netbeans$core$windows$layers$WorkspaceData), (String)"EXC_WorkspaceCascadeCurrent", (Object[])new Object[]{this.fo.getName()});
                ErrorManager.getDefault().annotate((Throwable)exc, annotation);
                ErrorManager.getDefault().notify(16, (Throwable)exc);
            }
        }

        private void handleActive(Attributes attrs) {
            if (this.hasMdiSdi) {
                return;
            }
            this.workspaceConfig.activeModeName = attrs.getValue("mode");
        }

        private void handleMode(Attributes attrs) {
            if (this.hasMdiSdi) {
                return;
            }
        }

        private void handleToolbar(Attributes attrs) {
            if (this.hasMdiSdi) {
                return;
            }
            this.workspaceConfig.toolbarConfiguration = attrs.getValue("configuration");
        }

        private void handleDesktop(Attributes attrs) {
            if (this.hasMdiSdi) {
                return;
            }
            this.workspaceConfig.desktopMaximized = "true".equals(attrs.getValue("maximized"));
        }

        public void endDocument() throws SAXException {
        }

        public void ignorableWhitespace(char[] values, int param, int param2) throws SAXException {
        }

        public void skippedEntity(String str) throws SAXException {
        }

        public void processingInstruction(String str, String str1) throws SAXException {
        }

        public void endPrefixMapping(String str) throws SAXException {
        }

        public void startPrefixMapping(String str, String str1) throws SAXException {
        }

        public void characters(char[] values, int param, int param2) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void writeData() throws IOException {
            StringBuffer buff = this.fillBuffer();
            Object object = this.RW_LOCK;
            synchronized (object) {
                this.fo.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(this, buff){
                    private final /* synthetic */ StringBuffer val$buff;
                    private final /* synthetic */ PropertyHandler this$0;
                    {
                        this.this$0 = this$0;
                        this.val$buff = val$buff;
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() throws IOException {
                        FileLock lock;
                        block3: {
                            lock = PropertyHandler.access$300(this.this$0).lock();
                            OutputStreamWriter osw = null;
                            try {
                                OutputStream os = PropertyHandler.access$300(this.this$0).getOutputStream(lock);
                                osw = new OutputStreamWriter(os, "UTF-8");
                                osw.write(this.val$buff.toString());
                                Object var5_4 = null;
                                if (osw == null) break block3;
                            }
                            catch (Throwable throwable) {
                                Object var5_5 = null;
                                if (osw != null) {
                                    osw.close();
                                }
                                lock.releaseLock();
                                throw throwable;
                            }
                            osw.close();
                        }
                        lock.releaseLock();
                    }
                });
            }
        }

        private StringBuffer fillBuffer() throws IOException {
            WorkspaceImpl wi = this.folder.getWorkspaceImpl();
            StringBuffer buff = new StringBuffer(800);
            buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            buff.append("<workspace version=\"1.1\">\n");
            this.appendName(wi, buff);
            this.appendDescription(wi, buff);
            this.appendModule(wi, buff);
            buff.append("    <ui-type type=\"any\">\n");
            this.appendCascade(wi, buff);
            this.appendActive(wi, buff);
            this.appendMode(wi, buff);
            this.appendToolbar(wi, buff);
            this.appendDesktop(wi, buff);
            buff.append("    </ui-type>\n");
            buff.append("</workspace>\n");
            return buff;
        }

        private void appendName(WorkspaceImpl workspaceImpl, StringBuffer buff) throws CharConversionException {
            buff.append("    <name");
            buff.append(" unique=\"");
            buff.append(XMLUtil.toAttributeValue((String)workspaceImpl.getName()));
            buff.append("\" display=\"");
            buff.append(XMLUtil.toAttributeValue((String)workspaceImpl.getDisplayNameXML()));
            buff.append("\" from-bundle=\"");
            if (workspaceImpl.isNameFromBundle()) {
                buff.append("true");
                buff.append("\" bundle=\"");
                buff.append(workspaceImpl.getNameBundle());
            } else {
                buff.append("false");
            }
            buff.append("\" />\n");
        }

        private void appendDescription(WorkspaceImpl workspaceImpl, StringBuffer buff) throws CharConversionException {
            if (workspaceImpl.getDescriptionXML() == null) {
                return;
            }
            buff.append("    <description display=\"");
            buff.append(XMLUtil.toAttributeValue((String)workspaceImpl.getDescriptionXML()));
            buff.append("\" bundle=\"");
            buff.append(workspaceImpl.getDescriptionBundle());
            buff.append("\" />\n");
        }

        private void appendModule(WorkspaceImpl workspaceImpl, StringBuffer buff) {
            if (this.workspaceConfig == null) {
                return;
            }
            if (this.workspaceConfig.moduleCodeNameBase != null) {
                buff.append("    <module");
                buff.append(" name=\"");
                buff.append(this.workspaceConfig.moduleCodeNameBase);
                if (this.workspaceConfig.moduleCodeNameRelease != null) {
                    buff.append("/" + this.workspaceConfig.moduleCodeNameRelease);
                }
                if (this.workspaceConfig.moduleSpecificationVersion != null) {
                    buff.append("\" spec=\"");
                    buff.append(this.workspaceConfig.moduleSpecificationVersion);
                }
                buff.append("\" />\n");
            }
        }

        private void appendCascade(WorkspaceImpl workspaceImpl, StringBuffer buff) {
            buff.append("        <cascade");
            Point origin = workspaceImpl.getCascadingOrigin();
            buff.append(" origin-x=\"");
            buff.append(origin.x);
            buff.append("\" origin-y=\"");
            buff.append(origin.y);
            Dimension step = workspaceImpl.getCascadeStep();
            buff.append("\" step-x=\"");
            buff.append(step.width);
            buff.append("\" step-y=\"");
            buff.append(step.height);
            buff.append("\" count=\"");
            buff.append(workspaceImpl.getCascadeStepsCount());
            Point current = workspaceImpl.getCascadePoint();
            buff.append("\" current-x=\"");
            buff.append(current.x);
            buff.append("\" current-y=\"");
            buff.append(current.y);
            buff.append("\" />\n");
        }

        private void appendActive(WorkspaceImpl workspaceImpl, StringBuffer buff) throws CharConversionException {
            buff.append("        <active");
            buff.append(" mode=\"");
            Mode m = workspaceImpl.getActiveMode();
            if (m != null) {
                buff.append(XMLUtil.toAttributeValue((String)m.getName()));
            }
            buff.append("\" />\n");
        }

        private void appendMode(WorkspaceImpl workspaceImpl, StringBuffer buff) throws CharConversionException {
            buff.append("        <mode");
            buff.append(" />\n");
        }

        private void appendToolbar(WorkspaceImpl workspaceImpl, StringBuffer buff) throws CharConversionException {
            buff.append("        <toolbar");
            buff.append(" configuration=\"");
            if (workspaceImpl.getToolbarConfigName() != null) {
                buff.append(XMLUtil.toAttributeValue((String)workspaceImpl.getToolbarConfigName()));
            }
            buff.append("\" />\n");
        }

        private void appendDesktop(WorkspaceImpl workspaceImpl, StringBuffer buff) {
            if (!WindowUtils.isMdi()) {
                return;
            }
            buff.append("        <desktop");
            buff.append(" maximized=\"");
            buff.append(workspaceImpl.desktopPane().isMaxMode() ? "true" : "false");
            buff.append("\" />\n");
        }

        private XMLReader getXMLParser() throws SAXException {
            XMLReader parser = XMLUtil.createXMLReader();
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            parser.setEntityResolver(this);
            return parser;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (WorkspaceData.INSTANCE_DTD_ID_1_0.equals(publicId) || WorkspaceData.INSTANCE_DTD_ID_1_1.equals(publicId)) {
                ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
                return new InputSource(is);
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ FileObject access$300(PropertyHandler x0) {
            return x0.fo;
        }
    }

    static final class InstanceCookieImpl
    extends ICFolderImpl
    implements SaveCookie,
    LazyUpdater,
    ProducerCookie,
    PropertyChangeListener {
        WorkspaceImpl workspaceImpl;
        PropertyHandler propertyHandler;
        WorkspaceConfig wc;
        private int loadedSections;
        private int currLoadedSections;
        private PropertyChangeListener weakPropertyChangeL;
        private IOException ioException;
        private final Object DATA_ID_LOCK = new Object();
        static /* synthetic */ Class class$org$openide$windows$Mode;
        static /* synthetic */ Class class$org$netbeans$core$windows$WorkspaceImpl;
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$WorkspaceData;
        static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

        public InstanceCookieImpl(DataFolder df) {
            super(df, FileUtil.findBrother((FileObject)df.getPrimaryFile(), (String)"wswksp"), class$org$openide$windows$Mode == null ? (class$org$openide$windows$Mode = InstanceCookieImpl.class$("org.openide.windows.Mode")) : class$org$openide$windows$Mode);
        }

        protected void clean() {
            this.childrenCookies = null;
            if (this.workspaceImpl != null) {
                this.workspaceImpl.removeModes();
                this.workspaceImpl.attachUpdater(null);
                this.workspaceImpl = null;
            }
        }

        public String instanceName() {
            return (class$org$netbeans$core$windows$WorkspaceImpl == null ? (class$org$netbeans$core$windows$WorkspaceImpl = InstanceCookieImpl.class$("org.netbeans.core.windows.WorkspaceImpl")) : class$org$netbeans$core$windows$WorkspaceImpl).getName();
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return class$org$netbeans$core$windows$WorkspaceImpl == null ? (class$org$netbeans$core$windows$WorkspaceImpl = InstanceCookieImpl.class$("org.netbeans.core.windows.WorkspaceImpl")) : class$org$netbeans$core$windows$WorkspaceImpl;
        }

        protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
            if (!(this.folder.isValid() && this.folder.getPrimaryFile().isValid() && ((WorkspaceData)this.folder).getWorkspaceConfigFO().isValid())) {
                throw new FileNotFoundException();
            }
            WorkspaceImpl wi = this.obtainWorkspaceImpl();
            if (this.childrenCookies == null) {
                wi.attachUpdater(this);
            }
            InstanceCookie[] oldCookies = this.childrenCookies;
            this.childrenCookies = cookies;
            this.updateAll(oldCookies, cookies);
            this.installListeners();
            return wi;
        }

        private void deleteFiles(boolean cleanAll) {
            WindowUtils.deleteOneFO(((WorkspaceData)this.folder).getWorkspaceConfigFO());
            if (cleanAll) {
                WindowUtils.deleteOneFO(this.folder.getPrimaryFile());
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("enabled".equals(evt.getPropertyName())) {
                ModuleInfo src = (ModuleInfo)evt.getSource();
                if (!((Boolean)evt.getNewValue()).booleanValue()) {
                    this.deleteFiles(false);
                }
            }
        }

        private void updateAll(InstanceCookie[] oldCookies, InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
            if ((this.loadedSections & 1) != 0 || (this.loadedSections & 2) != 0) {
                this.readProperties();
                if (this.wc.moduleCodeNameBase != null) {
                    ModuleInfo curModuleInfo = WindowUtils.findModule(this.wc.moduleCodeNameBase, this.wc.moduleCodeNameRelease, this.wc.moduleSpecificationVersion);
                    if (curModuleInfo != null && curModuleInfo.isEnabled()) {
                        if (this.weakPropertyChangeL == null) {
                            this.weakPropertyChangeL = WeakListener.propertyChange((PropertyChangeListener)this, (Object)curModuleInfo);
                            curModuleInfo.addPropertyChangeListener(this.weakPropertyChangeL);
                        }
                    } else {
                        this.deleteFiles(false);
                        return;
                    }
                }
                this.setProperties();
            }
            if ((this.loadedSections & 1) != 0) {
                // empty if block
            }
            if ((this.loadedSections & 2) != 0) {
                this.updateModes(oldCookies, cookies);
            }
        }

        protected void updateProperties() throws IOException {
            if ((this.loadedSections & 1) != 0) {
                this.readProperties();
                this.setProperties();
            }
        }

        protected Object getDataLock() {
            return this.DATA_ID_LOCK;
        }

        private boolean readProperties() throws IOException {
            if (this.propertyHandler == null) {
                this.propertyHandler = new PropertyHandler((WorkspaceData)this.folder);
            }
            this.wc = null;
            try {
                this.wc = this.propertyHandler.readData();
            }
            catch (SAXException exc) {
                exc.printStackTrace();
                String msg = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$WorkspaceData == null ? (class$org$netbeans$core$windows$layers$WorkspaceData = InstanceCookieImpl.class$("org.netbeans.core.windows.layers.WorkspaceData")) : class$org$netbeans$core$windows$layers$WorkspaceData), (String)"EXC_WorkspaceParse", (Object[])new Object[]{this.folder.getName()});
                IOException ioe = new IOException(msg);
                ErrorManager.getDefault().annotate((Throwable)ioe, (Throwable)exc);
                throw ioe;
            }
            return true;
        }

        protected void setProperties() throws IOException {
            if (this.wc.invalid) {
                return;
            }
            WorkspaceImpl wi = this.obtainWorkspaceImpl();
            wi.setNameFromBundleXML(this.wc.fromBundle);
            wi.setNameBundle(this.wc.nameBundle);
            wi.setDisplayNameXML(this.wc.displayName);
            wi.setDescriptionBundle(this.wc.descriptionBundle);
            wi.setDescriptionXML(this.wc.description);
            wi.setCascadingOrigin(this.wc.cascadeOrigin);
            wi.setCascadeStep(this.wc.cascadeStep);
            wi.setCascadeStepsCount(this.wc.cascadeCount);
            wi.setToolbarConfigName(this.wc.toolbarConfiguration);
            wi.setWasMaxMode(this.wc.desktopMaximized);
        }

        private void updateModes(InstanceCookie[] oldCookies, InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
            if (cookies == null) {
                System.err.println("COOKIES == null");
                Thread.dumpStack();
                return;
            }
            ModeImpl[] modes = oldCookies == null || oldCookies.length == 0 ? this.createModes(cookies) : this.removeAddModes(oldCookies, cookies);
            ArrayList<ModeImpl> zOrderList = new ArrayList<ModeImpl>(modes.length);
            int i = modes.length - 1;
            while (i >= 0) {
                if (modes[i] != null && "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(modes[i].getFrameType())) {
                    zOrderList.add(modes[i]);
                }
                --i;
            }
            ModeImpl activeMode = null;
            int i2 = 0;
            while (i2 < modes.length) {
                if (modes[i2] != null) {
                    if (modes[i2].getName() == null) {
                        System.err.println("NAME IS NULL: " + modes[i2]);
                    }
                    if (this.wc == null) {
                        System.err.println("WC is NULL");
                    }
                    if (modes[i2].getName().equals(this.wc.activeModeName)) {
                        activeMode = modes[i2];
                    }
                }
                ++i2;
            }
            WorkspaceImpl wi = this.obtainWorkspaceImpl();
            wi.setActiveMode(activeMode);
            wi.setZOrder(zOrderList);
            this.childrenCookies = cookies;
        }

        private ModeImpl[] removeAddModes(InstanceCookie[] o, InstanceCookie[] n) throws IOException, ClassNotFoundException {
            Object mi;
            WorkspaceImpl wi = this.obtainWorkspaceImpl();
            HashSet<InstanceCookie> nset = new HashSet<InstanceCookie>(Arrays.asList(n));
            int i = 0;
            while (i < o.length) {
                if (!nset.contains(o[i])) {
                    mi = null;
                    try {
                        mi = (ModeImpl)o[i].instanceCreate();
                    }
                    catch (InvalidDataException exc) {
                        Object obj = exc.getData();
                        if (obj != null && obj instanceof String) {
                            String name = (String)obj;
                            mi = (ModeImpl)wi.findLoadedMode(name);
                        }
                    }
                    catch (FileNotFoundException exc) {
                        // empty catch block
                    }
                    if (mi != null) {
                        mi.close();
                        wi.removeMode((Mode)mi);
                    }
                }
                ++i;
            }
            mi = new ModeImpl[n.length];
            int i2 = 0;
            while (i2 < n.length) {
                mi[i2] = (ModeImpl)n[i2].instanceCreate();
                ++i2;
            }
            return mi;
        }

        private ModeImpl[] createModes(InstanceCookie[] cookies) throws IOException {
            ModeImpl[] m = new ModeImpl[cookies.length];
            int i = 0;
            while (i < cookies.length) {
                try {
                    m[i] = (ModeImpl)cookies[i].instanceCreate();
                }
                catch (FileNotFoundException exc) {
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                }
                catch (ClassNotFoundException exc) {
                    exc.printStackTrace();
                }
                ++i;
            }
            return m;
        }

        private List orderModes(List modeDatas, List dSides) throws IOException {
            ModeData[] dominance = new ModeData[dSides.size()];
            Iterator it = modeDatas.iterator();
            LinkedList<ModeData> floatingModes = new LinkedList<ModeData>();
            while (it.hasNext()) {
                ModeData md = (ModeData)((Object)it.next());
                ModeImpl m = md.getModeImpl();
                int idx = dSides.indexOf(m.getConstraints());
                if (-1 != idx) {
                    dominance[idx] = md;
                    continue;
                }
                floatingModes.add(md);
            }
            LinkedList<ModeData> res = new LinkedList<ModeData>(Arrays.asList(dominance));
            WorkspaceImpl wi = this.obtainWorkspaceImpl();
            List modes = wi.getZOrder();
            ArrayList<ModeData> orderedModes = new ArrayList<ModeData>();
            int i = modes.size() - 1;
            while (i >= 0) {
                int j = 0;
                while (j < floatingModes.size()) {
                    ModeData md = (ModeData)((Object)floatingModes.get(j));
                    if (md.getName().equals(((Mode)modes.get(i)).getName())) {
                        orderedModes.add(md);
                        floatingModes.remove((Object)md);
                        break;
                    }
                    ++j;
                }
                --i;
            }
            res.addAll(orderedModes);
            res.addAll(floatingModes);
            return res;
        }

        private WorkspaceImpl obtainWorkspaceImpl() throws IOException {
            if (this.workspaceImpl == null) {
                FileObject primaryFile = this.folder.getPrimaryFile();
                String wName = WindowUtils.unescape(primaryFile.getName());
                WindowManagerImpl wmi = (WindowManagerImpl)WindowManager.getDefault();
                this.workspaceImpl = (WorkspaceImpl)wmi.findLoadedWorkspace(wName);
                if (this.workspaceImpl == null) {
                    this.workspaceImpl = new WorkspaceImpl(wName, null);
                }
            }
            return this.workspaceImpl;
        }

        public void save() throws IOException {
            if (this.wc != null && this.wc.invalid) {
                return;
            }
            if (this.propertyHandler == null) {
                this.propertyHandler = new PropertyHandler((WorkspaceData)this.folder);
            }
            this.propertyHandler.writeData();
            WorkspaceImpl wi = this.obtainWorkspaceImpl();
            List modes = wi.getLoadedModeList();
            FileObject wFo = this.folder.getPrimaryFile();
            ArrayList<DataObject> arrModes = new ArrayList<DataObject>();
            int i = 0;
            while (i < modes.size()) {
                String modeName = WindowUtils.escape(((Mode)modes.get(i)).getName());
                wFo.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(this, wFo, modeName){
                    private final /* synthetic */ FileObject val$wFo;
                    private final /* synthetic */ String val$modeName;
                    private final /* synthetic */ InstanceCookieImpl this$0;
                    {
                        this.this$0 = this$0;
                        this.val$wFo = val$wFo;
                        this.val$modeName = val$modeName;
                    }

                    public void run() throws IOException {
                        FileObject fo = this.val$wFo.getFileObject(this.val$modeName, "wsmode");
                        if (fo == null) {
                            fo = this.val$wFo.createData(this.val$modeName, "wsmode");
                        }
                        if ((fo = this.val$wFo.getFileObject(this.val$modeName)) == null) {
                            this.val$wFo.createFolder(this.val$modeName);
                        }
                    }
                });
                DataObject curDo = DataObject.find((FileObject)wFo.getFileObject(modeName));
                SaveCookie sc = (SaveCookie)curDo.getCookie(class$org$openide$cookies$SaveCookie == null ? InstanceCookieImpl.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
                if (sc != null) {
                    sc.save();
                } else {
                    ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("No save cookie for data obj " + curDo));
                }
                arrModes.add(curDo);
                ++i;
            }
            WorkspaceImpl wsImpl = this.obtainWorkspaceImpl();
            ArrayList dSides = new ArrayList();
            RequestProcessor.Task rpTask = RequestProcessor.getDefault().create(new Runnable(this, dSides, arrModes){
                private final /* synthetic */ List val$dSides;
                private final /* synthetic */ ArrayList val$arrModes;
                private final /* synthetic */ InstanceCookieImpl this$0;
                {
                    this.this$0 = this$0;
                    this.val$dSides = val$dSides;
                    this.val$arrModes = val$arrModes;
                }

                public void run() {
                    try {
                        if (!this.val$dSides.isEmpty()) {
                            List l = InstanceCookieImpl.access$100(this.this$0, this.val$arrModes, this.val$dSides);
                            this.this$0.folder.setOrder(l.toArray(new DataObject[l.size()]));
                        }
                        this.this$0.childrenCookies = this.this$0.createCookies();
                    }
                    catch (ClassNotFoundException e) {
                        this.this$0.childrenCookies = null;
                        IOException ioe = new IOException("Problem saving " + (this.this$0.workspaceImpl != null ? this.this$0.workspaceImpl.toString() : " null"));
                        ErrorManager.getDefault().annotate((Throwable)ioe, (Throwable)e);
                        InstanceCookieImpl.access$202(this.this$0, ioe);
                    }
                    catch (IOException ioe) {
                        InstanceCookieImpl.access$202(this.this$0, ioe);
                    }
                }
            });
            if (SwingUtilities.isEventDispatchThread()) {
                List dl = wsImpl.getDominanceList();
                if (dl != null) {
                    dSides.addAll(dl);
                }
                rpTask.run();
            } else {
                SwingUtilities.invokeLater(new Runnable(this, wsImpl, dSides, rpTask){
                    private final /* synthetic */ WorkspaceImpl val$wsImpl;
                    private final /* synthetic */ List val$dSides;
                    private final /* synthetic */ RequestProcessor.Task val$rpTask;
                    private final /* synthetic */ InstanceCookieImpl this$0;
                    {
                        this.this$0 = this$0;
                        this.val$wsImpl = val$wsImpl;
                        this.val$dSides = val$dSides;
                        this.val$rpTask = val$rpTask;
                    }

                    public void run() {
                        List dl = this.val$wsImpl.getDominanceList();
                        if (dl != null) {
                            this.val$dSides.addAll(dl);
                        }
                        this.val$rpTask.schedule(0);
                    }
                });
                rpTask.waitFinished();
            }
            if (this.ioException != null) {
                IOException ioe = this.ioException;
                this.ioException = null;
                throw ioe;
            }
        }

        public int getLoadedSections() {
            return this.currLoadedSections;
        }

        public int disposeDataSection(int data_id) throws IOException {
            this.loadedSections &= ~data_id;
            throw new UnsupportedOperationException();
        }

        public int loadDataSection(int data_id) throws IOException {
            Object object = this.DATA_ID_LOCK;
            synchronized (object) {
                if (data_id == (this.loadedSections & data_id)) {
                    int n = this.loadedSections;
                    return n;
                }
                this.loadedSections |= data_id;
                try {
                    try {
                        InstanceCookie[] oldCookies = this.childrenCookies;
                        this.childrenCookies = this.createCookies();
                        this.updateAll(oldCookies, this.childrenCookies);
                    }
                    catch (ClassNotFoundException e) {
                        IOException ioe = new IOException("Problem loading section " + data_id + " of " + (this.workspaceImpl != null ? this.workspaceImpl.toString() : " null"));
                        ErrorManager.getDefault().annotate((Throwable)ioe, (Throwable)e);
                        throw ioe;
                    }
                    Object var6_6 = null;
                    this.currLoadedSections = this.loadedSections;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    this.currLoadedSections = this.loadedSections;
                    throw throwable;
                }
            }
            return this.loadedSections;
        }

        public Object getProduct() throws IOException {
            return this.obtainWorkspaceImpl();
        }

        public void resetComponents() {
            this.childrenCookies = null;
        }

        public void reset() {
            super.reset();
            this.workspaceImpl = null;
            this.loadedSections = 0;
            this.currLoadedSections = 0;
            this.childrenCookies = null;
        }

        public void destroy() throws IOException {
            this.deleteFiles(true);
        }

        public boolean isValid() {
            return this.folder.isValid() && this.folder.getPrimaryFile().isValid() && ((WorkspaceData)this.folder).getWorkspaceConfigFO().isValid();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ List access$100(InstanceCookieImpl x0, List x1, List x2) throws IOException {
            return x0.orderModes(x1, x2);
        }

        static /* synthetic */ IOException access$202(InstanceCookieImpl x0, IOException x1) {
            x0.ioException = x1;
            return x0.ioException;
        }
    }

    private static final class WorkspaceConfig {
        public boolean fromBundle;
        public String name;
        public String displayName;
        public String nameBundle;
        public String description;
        public String descriptionBundle;
        public String moduleCodeNameBase;
        public String moduleCodeNameRelease;
        public String moduleSpecificationVersion;
        public int uiType;
        public String activeModeName;
        public String toolbarConfiguration;
        public Point cascadeOrigin;
        public Point cascadeCurrent;
        public Dimension cascadeStep;
        public int cascadeCount;
        public boolean invalid;
        public boolean desktopMaximized;

        WorkspaceConfig() {
        }

        public void clear() {
            this.activeModeName = null;
            this.toolbarConfiguration = null;
            this.cascadeOrigin = null;
            this.cascadeCurrent = null;
            this.cascadeStep = null;
            this.cascadeCount = 0;
        }
    }
}

