/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.toolbars;

import org.netbeans.core.windows.toolbars.ToolbarConfiguration;
import org.netbeans.core.windows.toolbars.ToolbarConstraints;
import org.openide.awt.Toolbar;

public class ToolbarDnDListener
implements Toolbar.DnDListener {
    protected static final int BASIC_HEIGHT_2 = 19;
    protected static final int BASIC_HEIGHT_4 = 9;
    private ToolbarConstraints draggedToolbar;
    private ToolbarConfiguration configuration;

    public ToolbarDnDListener(ToolbarConfiguration conf) {
        this.configuration = conf;
    }

    protected void moveToolbar2EndHorizontally(ToolbarConstraints tc, int dx) {
        if (dx == 0) {
            return;
        }
        if (dx < 0) {
            tc.moveLeft2End(-dx);
        }
        if (dx > 0) {
            tc.moveRight2End(dx);
        }
    }

    protected void moveToolbarHorizontally(ToolbarConstraints tc, int dx) {
        if (dx == 0) {
            return;
        }
        if (dx < 0) {
            tc.moveLeft(-dx);
        }
        if (dx > 0) {
            tc.moveRight(dx);
        }
    }

    protected void moveToolbarVertically(ToolbarConstraints tc, int dy) {
        if (dy == 0) {
            return;
        }
        if (dy < 0) {
            this.moveUp(tc, -dy);
        }
        if (dy > 0) {
            this.moveDown(tc, dy);
        }
    }

    protected void moveUp(ToolbarConstraints tc, int dy) {
        if (dy < 19) {
            return;
        }
        int rI = tc.rowIndex();
        if (this.draggedToolbar.isAlone() && rI == 0) {
            return;
        }
        int pos = rI - 1;
        tc.destroy();
        int plus = 0;
        int rowCount = this.configuration.getRowCount();
        int i = pos;
        while (i < pos + tc.getRowCount()) {
            this.configuration.getRow(i + plus).addToolbar(tc, tc.getPosition());
            if (rowCount != this.configuration.getRowCount()) {
                rowCount = this.configuration.getRowCount();
                ++plus;
            }
            ++i;
        }
        this.configuration.checkToolbarRows();
    }

    public void moveDown(ToolbarConstraints tc, int dy) {
        int rI = tc.rowIndex();
        int step = 19;
        if (this.draggedToolbar.isAlone()) {
            if (rI == this.configuration.getRowCount() - tc.getRowCount()) {
                return;
            }
            step = 9;
        }
        if (dy < step) {
            return;
        }
        int pos = rI + 1;
        tc.destroy();
        int i = pos;
        while (i < pos + tc.getRowCount()) {
            this.configuration.getRow(i).addToolbar(tc, tc.getPosition());
            ++i;
        }
        this.configuration.checkToolbarRows();
    }

    public void dragToolbar(Toolbar.DnDEvent e) {
        if (this.draggedToolbar == null) {
            this.draggedToolbar = this.configuration.getToolbarConstraints(e.getName());
        }
        switch (e.getType()) {
            case 3: {
                return;
            }
            case 2: {
                this.moveToolbar2EndHorizontally(this.draggedToolbar, e.getDX());
                break;
            }
            case 1: {
                this.moveToolbarVertically(this.draggedToolbar, e.getDY());
            }
        }
        if (e.getType() == 1) {
            this.moveToolbarHorizontally(this.draggedToolbar, e.getDX());
        }
        this.draggedToolbar.updatePosition();
        this.configuration.revalidateWindow();
    }

    public void dropToolbar(Toolbar.DnDEvent e) {
        this.dragToolbar(e);
        this.configuration.reflectChanges();
        this.draggedToolbar = null;
    }
}

