/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.UIModeManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.WindowTypesManager;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class WindowUtils {
    private static final char OPEN = '[';
    private static final char CLOSE = ']';
    static /* synthetic */ Class class$org$netbeans$core$windows$util$WindowUtils;
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;

    private WindowUtils() {
    }

    public static void convertRectangle(Rectangle rect, Dimension oldDimension, Dimension newDimension) {
        if (oldDimension.equals(newDimension)) {
            return;
        }
        double dx = (double)newDimension.width / (double)oldDimension.width;
        double dy = (double)newDimension.height / (double)oldDimension.height;
        rect.x = (int)((double)rect.x * dx);
        rect.y = (int)((double)rect.y * dy);
        rect.width = (int)((double)rect.width * dx);
        rect.height = (int)((double)rect.height * dy);
    }

    public static final boolean isMdi() {
        return UIModeManager.getDefault().getUIMode() == 2;
    }

    public static ModeImpl findConstrainedMode(Workspace workspace, Object constraints) {
        return WindowUtils.findConstrainedMode(workspace, constraints, false);
    }

    public static ModeImpl findConstrainedMode(Workspace workspace, Object constraints, boolean onlyVisible) {
        Iterator iter = ((WorkspaceImpl)workspace).getLoadedModeList().iterator();
        while (iter.hasNext()) {
            ModeImpl curMode = (ModeImpl)iter.next();
            if (onlyVisible && curMode.getLoadedOpenedTopComponents().length <= 0) continue;
            Object curConstraints = curMode.getLoadedConstraints();
            if (!(constraints == null ? curConstraints == null : constraints.equals(curConstraints))) continue;
            return curMode;
        }
        return null;
    }

    public static void changeModeConstraints(ModeImpl mode, Object constraints) {
        WindowUtils.changeModeConstraints(mode, constraints, false);
    }

    public static void changeModeConstraints(ModeImpl mode, Object constraints, boolean preserveOld) {
        ModeImpl conflictingMode;
        boolean setConstraints = true;
        if (constraints != null && !"CENTER".equals(constraints) && (conflictingMode = WindowUtils.findConstrainedMode(mode.getWorkspace(), constraints)) != null && conflictingMode.isVisible() && !mode.equals(conflictingMode)) {
            String defaultFrame = WindowTypesManager.getDefaultFrame();
            if (preserveOld) {
                mode.setConstraints(null);
                mode.setFrameType(defaultFrame);
                setConstraints = false;
            } else {
                conflictingMode.setConstraints(null);
                conflictingMode.setFrameType(defaultFrame);
            }
        }
        if (setConstraints) {
            mode.setConstraints(constraints);
        }
    }

    public static ModeImpl getActiveMode() {
        TopComponent comp = TopComponent.getRegistry().getActivated();
        if (comp == null) {
            return null;
        }
        WorkspaceImpl curWorkspace = (WorkspaceImpl)WindowManager.getDefault().getCurrentWorkspace();
        return (ModeImpl)curWorkspace.findMode(comp);
    }

    public static boolean changeActiveMode(Object constraints, String frameType) {
        ModeImpl activeMode = WindowUtils.getActiveMode();
        if (activeMode == null) {
            return false;
        }
        boolean wasVisible = activeMode.isVisible();
        if (wasVisible) {
            activeMode.setVisible(false);
        }
        WindowUtils.changeModeConstraints(activeMode, constraints);
        activeMode.setFrameType(frameType);
        if (wasVisible) {
            activeMode.setVisible(true);
            MainWindow.getDefault().getContentPane().validate();
        }
        return true;
    }

    public static ModeImpl dockIntoNewMode(TopComponent tc, boolean clone) {
        return WindowUtils.dockIntoNewMode(tc, clone, null, null);
    }

    public static ModeImpl dockIntoNewMode(TopComponent tc, boolean clone, Rectangle bounds) {
        return WindowUtils.dockIntoNewMode(tc, clone, bounds, null);
    }

    public static ModeImpl dockIntoNewMode(TopComponent tc, boolean clone, Rectangle bounds, String frameType) {
        WindowManagerImpl wm = (WindowManagerImpl)WindowManager.getDefault();
        WorkspaceImpl curWorkspace = (WorkspaceImpl)wm.getCurrentWorkspace();
        String modeName = WindowManagerImpl.findUnusedModeName(tc.getName(), curWorkspace);
        ModeImpl singleMode = (ModeImpl)curWorkspace.createMode(modeName, modeName, clone ? ((ModeImpl)curWorkspace.findMode(tc)).getIconURL() : WindowUtils.getIconURL("nbresloc:/org/netbeans/core/resources/frames/default.gif"), true);
        if (frameType != null) {
            singleMode.setFrameType(frameType);
        }
        if (bounds != null) {
            singleMode.setBounds(bounds);
        }
        if (clone) {
            if (tc instanceof TopComponent.Cloneable) {
                TopComponent newComp = ((TopComponent.Cloneable)tc).cloneComponent();
                newComp.setIcon(tc.getIcon());
                singleMode.dockInto(newComp);
                newComp.open();
            }
        } else {
            singleMode.dockInto(tc);
        }
        return singleMode;
    }

    public static boolean hasObjectStreamField(ObjectInputStream.GetField gf, String fieldName) {
        ObjectStreamField[] osf = gf.getObjectStreamClass().getFields();
        int i = 0;
        while (i < osf.length) {
            if (fieldName.equals(osf[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final URL getIconURL(String url) {
        URL result = null;
        try {
            result = new URL(url);
        }
        catch (MalformedURLException exc) {
            ErrorManager.getDefault().log(16, NbBundle.getMessage((Class)(class$org$netbeans$core$windows$util$WindowUtils == null ? (class$org$netbeans$core$windows$util$WindowUtils = WindowUtils.class$("org.netbeans.core.windows.util.WindowUtils")) : class$org$netbeans$core$windows$util$WindowUtils), (String)"LOG_NoIcon", (Object[])new Object[]{url}));
        }
        return result;
    }

    public static final String convertConstraint2Perim(String constraint) {
        if ("left".equals(constraint)) {
            return "WEST";
        }
        if ("right".equals(constraint)) {
            return "EAST";
        }
        if ("top".equals(constraint)) {
            return "NORTH";
        }
        if ("bottom".equals(constraint)) {
            return "SOUTH";
        }
        if ("center".equals(constraint)) {
            return "CENTER";
        }
        return null;
    }

    public static final String stringId2RefName(String stringId) {
        return stringId.substring(stringId.indexOf(47) + 1);
    }

    public static final String refName2StringId(String refName) {
        return "wstopcomp/" + refName;
    }

    public static final String convertConstraint2Xml(String constraint) {
        if ("WEST".equals(constraint)) {
            return "left";
        }
        if ("EAST".equals(constraint)) {
            return "right";
        }
        if ("NORTH".equals(constraint)) {
            return "top";
        }
        if ("SOUTH".equals(constraint)) {
            return "bottom";
        }
        if ("CENTER".equals(constraint)) {
            return "center";
        }
        return null;
    }

    public static final int parseUIType(String uiType) {
        if ("mdi".equals(uiType)) {
            return 2;
        }
        if ("sdi".equals(uiType)) {
            return 1;
        }
        return -1;
    }

    public static final ModuleInfo findModule(String codeNameBase, String strRelease, String strSpec) {
        SpecificationVersion spec = null;
        int release = -1;
        if (strRelease != null) {
            try {
                release = Integer.parseInt(strRelease);
            }
            catch (NumberFormatException nfe) {
                ErrorManager.getDefault().notify(16, (Throwable)nfe);
            }
        }
        if (strSpec != null) {
            spec = new SpecificationVersion(strSpec);
        }
        Lookup.Result modulesResult = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = WindowUtils.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo));
        Collection infos = modulesResult.allInstances();
        ModuleInfo curInfo = null;
        boolean equalsName = false;
        Iterator iter = infos.iterator();
        while (iter.hasNext()) {
            curInfo = (ModuleInfo)iter.next();
            if (!curInfo.getCodeNameBase().equals(codeNameBase)) continue;
            if (release < 0 && spec == null || curInfo.getCodeNameRelease() > release) {
                return curInfo;
            }
            if (release >= 0 && curInfo.getCodeNameRelease() != release || spec != null && curInfo.getSpecificationVersion().compareTo((Object)spec) < 0) continue;
            return curInfo;
        }
        return null;
    }

    public static final String convertFrameType(int newUIMode, Object constraint) {
        if (newUIMode == 1) {
            return "org.netbeans.core.windows.frames.TopFrameTypeImpl";
        }
        if (newUIMode == 2) {
            if (constraint != null && !"CENTER".equals(constraint)) {
                return "org.netbeans.core.windows.frames.DesktopFrameTypeImpl";
            }
            return "org.netbeans.core.windows.frames.InternalFrameTypeImpl";
        }
        return null;
    }

    public static String escape(String text) {
        int len = text.length();
        StringBuffer escaped = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c == '/' || c == ':' || c == '\\' || c == '[' || c == ']' || c == '<' || c == '>' || c == '?' || c == '*' || c == '|' || c == ' ' && i == len - 1 || c == '.' || c == '\"' || c < ' ' || c > '~' || c == '#') {
                escaped.append('#');
                String hex = Integer.toString(c, 16).toUpperCase();
                if (hex.length() < 4) {
                    escaped.append('0');
                }
                if (hex.length() < 3) {
                    escaped.append('0');
                }
                if (hex.length() < 2) {
                    escaped.append('0');
                }
                escaped.append(hex);
            } else {
                escaped.append(c);
            }
            ++i;
        }
        return escaped.toString();
    }

    public static String unescape(String text) {
        int len = text.length();
        StringBuffer unesc = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c == '#') {
                if (i + 4 >= len) {
                    ErrorManager.getDefault().log(16, "trailing garbage in instance name: " + text);
                    break;
                }
                try {
                    char[] hex = new char[4];
                    text.getChars(i + 1, i + 5, hex, 0);
                    unesc.append((char)Integer.parseInt(new String(hex), 16));
                }
                catch (NumberFormatException nfe) {
                    ErrorManager.getDefault().notify(1, (Throwable)nfe);
                }
                i += 4;
            } else {
                unesc.append(c);
            }
            ++i;
        }
        return unesc.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteOneFO(FileObject fo) {
        FileLock lock = null;
        if (!fo.isValid()) return;
        try {
            try {
                lock = fo.lock();
                fo.delete(lock);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                Object var4_3 = null;
                if (lock == null) return;
                lock.releaseLock();
                return;
            }
            Object var4_2 = null;
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (lock == null) throw throwable;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
    }

    public static void hideAllFrames() {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            ((Component)frames[i]).setVisible(false);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

