/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.util;

import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.SwingUtilities;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeText;
import org.netbeans.tax.io.TreeStreamResult;
import org.netbeans.tax.io.TreeWriter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.xml.XMLUtil;

public final class TAXUtil {
    public static void setAttributeValue(TreeAttribute attribute, String value) throws TreeException {
        try {
            attribute.setValue(XMLUtil.toAttributeValue((String)value));
        }
        catch (CharConversionException exc) {
            throw new TreeException(exc);
        }
    }

    public static void setTextData(TreeText text, String value) throws TreeException {
        try {
            text.setData(XMLUtil.toElementContent((String)value));
        }
        catch (CharConversionException exc) {
            throw new TreeException(exc);
        }
    }

    public static void notifyWarning(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
        });
    }

    public static String printableValue(String value) {
        if (value == null) {
            return "<null>";
        }
        int MAX_LENGTH = 33;
        int len = Math.min(value.length(), MAX_LENGTH);
        StringBuffer sb = new StringBuffer(2 * len);
        int i = 0;
        while (i < len) {
            char ch = value.charAt(i);
            if ('\r' == ch) {
                sb.append("\\r");
            } else if ('\n' == ch) {
                sb.append("\\n");
            } else if ('\t' == ch) {
                sb.append("\\t");
            } else if ('\b' == ch) {
                sb.append("\\b");
            } else if ('\f' == ch) {
                sb.append("\\f");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        if (value.length() > len) {
            sb.append("...");
        }
        return sb.toString();
    }

    public static void notifyTreeException(TreeException exc) {
        TAXUtil.notifyWarning(exc.getMessage());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String treeToString(TreeDocumentRoot doc) throws IOException {
        StringWriter out = new StringWriter();
        TreeStreamResult result = new TreeStreamResult(out);
        TreeWriter writer = result.getWriter(doc);
        try {
            try {
                writer.writeDocument();
                String string = out.toString();
                Object var6_6 = null;
                try {
                    out.close();
                    return string;
                }
                catch (IOException ioex) {
                    // empty catch block
                }
                return string;
            }
            catch (TreeException ex) {
                throw new IOException("Cannot read tree " + ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {}
            catch (IOException ioex) {
                throw throwable;
            }
            out.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] treeToByteArray(TreeDocumentRoot doc) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        TreeStreamResult result = new TreeStreamResult(out);
        TreeWriter writer = result.getWriter(doc);
        try {
            try {
                byte[] array;
                writer.writeDocument();
                byte[] byArray = array = out.toByteArray();
                Object var7_7 = null;
                try {
                    out.close();
                    return byArray;
                }
                catch (IOException ioex) {
                    // empty catch block
                }
                return byArray;
            }
            catch (TreeException ex) {
                throw new IOException("Cannot read tree " + ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {}
            catch (IOException ioex) {
                throw throwable;
            }
            out.close();
            throw throwable;
        }
    }
}

