/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.HandleLayer;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.ErrorManager;

class ComponentDragger {
    private FormDesigner formDesigner;
    private HandleLayer handleLayer;
    private RADVisualComponent[] selectedComponents;
    private Point hotspot;
    private Point mousePosition;
    private int resizeType;
    private RADVisualContainer targetMetaContainer;
    private boolean fixedTarget;
    private Container targetContainer;
    private Container targetContainerDel;
    private static FormLoaderSettings formSettings = FormEditor.getFormSettings();

    ComponentDragger(FormDesigner formDesigner, HandleLayer handleLayer, RADVisualComponent[] selectedComponents, Point hotspot, RADVisualContainer fixedTargetMetaContainer) {
        this.formDesigner = formDesigner;
        this.handleLayer = handleLayer;
        this.selectedComponents = selectedComponents;
        this.hotspot = hotspot;
        this.mousePosition = hotspot;
        this.resizeType = 0;
        if (fixedTargetMetaContainer != null) {
            this.targetMetaContainer = fixedTargetMetaContainer;
            this.fixedTarget = true;
        }
    }

    ComponentDragger(FormDesigner formDesigner, HandleLayer handleLayer, RADVisualComponent[] selectedComponents, Point hotspot, int resizeType) {
        this.formDesigner = formDesigner;
        this.handleLayer = handleLayer;
        this.selectedComponents = selectedComponents;
        this.hotspot = hotspot;
        this.mousePosition = hotspot;
        this.resizeType = resizeType;
    }

    void drag(Point p) {
        this.mousePosition = p;
    }

    void paintDragFeedback(Graphics2D g) {
        Stroke oldStroke = g.getStroke();
        BasicStroke stroke = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{1.0f, 4.0f}, 0.0f);
        g.setStroke(stroke);
        Color oldColor = g.getColor();
        g.setColor(formSettings.getSelectionBorderColor());
        ArrayList constraints = new ArrayList(this.selectedComponents.length);
        ArrayList indices = new ArrayList(this.selectedComponents.length);
        boolean constraintsOK = this.computeConstraints(this.mousePosition, constraints, indices);
        Point contPos = null;
        LayoutSupportManager layoutSupport = null;
        if (constraintsOK) {
            contPos = SwingUtilities.convertPoint(this.targetContainerDel, 0, 0, this.handleLayer);
            layoutSupport = this.targetMetaContainer.getLayoutSupport();
            if (this.resizeType == 0) {
                this.paintTargetContainerFeedback(g, this.targetContainerDel);
            }
        }
        int i = 0;
        while (i < this.selectedComponents.length) {
            RADVisualComponent metacomp = this.selectedComponents[i];
            boolean drawn = false;
            if (constraintsOK) {
                Component comp = (Component)this.formDesigner.getComponent(metacomp);
                LayoutConstraints constr = (LayoutConstraints)constraints.get(i);
                int index = (Integer)indices.get(i);
                if (constr != null || index >= 0) {
                    g.translate(contPos.x, contPos.y);
                    drawn = layoutSupport.paintDragFeedback(this.targetContainer, this.targetContainerDel, comp, constr, index, g);
                    g.translate(-contPos.x, -contPos.y);
                }
            }
            if (!drawn) {
                this.paintDragFeedback(g, metacomp);
            }
            ++i;
        }
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    void dropComponents(Point point) {
        RADVisualComponent[] compsMovedWithinTarget;
        RADVisualComponent[] compsMovedFromOutside;
        int i;
        int i2;
        int index;
        int i3;
        ArrayList<LayoutConstraints> constraints = null;
        ArrayList indices = null;
        if (this.targetMetaContainer != null ? !this.computeConstraints(point, constraints = new ArrayList<LayoutConstraints>(this.selectedComponents.length), indices = new ArrayList(this.selectedComponents.length)) : this.handleLayer.mouseOnVisual(point)) {
            return;
        }
        FormModel formModel = this.formDesigner.getModel();
        LayoutSupportManager layoutSupport = null;
        RADVisualComponent[] originalComponents = null;
        LayoutConstraints[] originalConstraints = null;
        ArrayList<Integer> movedFromOutside = null;
        ArrayList<RADVisualComponent> movedWithinTarget = null;
        if (this.targetMetaContainer != null) {
            layoutSupport = this.targetMetaContainer.getLayoutSupport();
            originalComponents = this.targetMetaContainer.getSubComponents();
            originalConstraints = new LayoutConstraints[originalComponents.length];
            this.adjustIndices(indices);
            int i4 = 0;
            while (i4 < this.selectedComponents.length) {
                if (this.selectedComponents[i4].getParentContainer() != this.targetMetaContainer) {
                    if (movedFromOutside == null) {
                        movedFromOutside = new ArrayList<Integer>(this.selectedComponents.length);
                    }
                    movedFromOutside.add(new Integer(i4));
                } else {
                    if (movedWithinTarget == null) {
                        movedWithinTarget = new ArrayList<RADVisualComponent>(this.selectedComponents.length);
                    }
                    movedWithinTarget.add(this.selectedComponents[i4]);
                }
                ++i4;
            }
            if (movedFromOutside != null && movedFromOutside.size() > 0) {
                int count = movedFromOutside.size();
                RADVisualComponent[] newComps = new RADVisualComponent[count];
                LayoutConstraints[] newConstr = new LayoutConstraints[count];
                i3 = 0;
                while (i3 < count) {
                    int index2 = (Integer)movedFromOutside.get(i3);
                    newComps[i3] = this.selectedComponents[index2];
                    newConstr[i3] = (LayoutConstraints)constraints.get(index2);
                    ++i3;
                }
                int j = (Integer)movedFromOutside.get(0);
                int jj = (Integer)indices.get(j);
                try {
                    layoutSupport.acceptNewComponents(newComps, newConstr, jj);
                }
                catch (RuntimeException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                    return;
                }
                int i5 = 0;
                while (i5 < count) {
                    index = (Integer)movedFromOutside.get(i5);
                    constraints.set(index, newConstr[i5]);
                    ++i5;
                }
                movedFromOutside.clear();
            }
        }
        int n = this.selectedComponents.length + (originalComponents != null ? originalComponents.length : 0);
        ArrayList<RADVisualComponent> newComponents = new ArrayList<RADVisualComponent>(n);
        ArrayList<LayoutConstraints> newConstraints = new ArrayList<LayoutConstraints>(n);
        int newI = 0;
        i3 = 0;
        while (i3 < n) {
            newComponents.add(null);
            newConstraints.add(null);
            ++i3;
        }
        if (this.targetMetaContainer != null) {
            i2 = 0;
            while (i2 < this.selectedComponents.length) {
                int index3 = (Integer)indices.get(i2);
                if (index3 >= 0 && index3 < n && this.checkTarget(this.selectedComponents[i2])) {
                    while (newComponents.get(index3) != null) {
                        if (++index3 != n) continue;
                        index3 = 0;
                    }
                    newComponents.set(index3, this.selectedComponents[i2]);
                }
                ++i2;
            }
            int i6 = 0;
            while (i6 < originalComponents.length) {
                RADVisualComponent metacomp = originalComponents[i6];
                originalConstraints[i6] = layoutSupport.getConstraints(metacomp);
                index = newComponents.indexOf(metacomp);
                if (index < 0) {
                    while (newComponents.get(newI) != null) {
                        ++newI;
                    }
                    newComponents.set(newI, metacomp);
                    newConstraints.set(newI, originalConstraints[i6]);
                }
                ++i6;
            }
        }
        i2 = 0;
        while (i2 < this.selectedComponents.length) {
            RADVisualComponent metacomp = this.selectedComponents[i2];
            int index4 = newComponents.indexOf(metacomp);
            if (index4 >= 0) {
                newConstraints.set(index4, (LayoutConstraints)(constraints != null ? (Object)constraints.get(i2) : null));
            } else if (this.checkTarget(metacomp)) {
                while (newComponents.get(newI) != null) {
                    ++newI;
                }
                newComponents.set(newI, metacomp);
                newConstraints.set(newI, (LayoutConstraints)(constraints != null ? (Object)constraints.get(i2) : null));
            }
            ++i2;
        }
        int i7 = 0;
        while (i7 < n) {
            RADVisualComponent metacomp = (RADVisualComponent)newComponents.get(i7);
            if (metacomp != null) {
                RADVisualContainer parentCont = metacomp.getParentContainer();
                if (parentCont != this.targetMetaContainer) {
                    if (movedFromOutside == null) {
                        movedFromOutside = new ArrayList(this.selectedComponents.length);
                    }
                    movedFromOutside.add((Integer)((Object)metacomp));
                    formModel.removeComponentFromContainer(metacomp);
                }
            } else {
                newComponents.remove(i7);
                newConstraints.remove(i7);
                --i7;
                --n;
            }
            ++i7;
        }
        if (n == 0) {
            return;
        }
        boolean undoRedoOn = formModel.isUndoRedoRecording();
        if (undoRedoOn) {
            formModel.setUndoRedoRecording(false);
        }
        RADComponent[] newCompsArray = new RADVisualComponent[n];
        LayoutConstraints[] newConstrArray = new LayoutConstraints[n];
        if (this.targetMetaContainer != null) {
            int i8 = 0;
            while (i8 < n) {
                newCompsArray[i8] = (RADVisualComponent)newComponents.get(i8);
                newConstrArray[i8] = (LayoutConstraints)newConstraints.get(i8);
                ++i8;
            }
            layoutSupport.removeAll();
            this.targetMetaContainer.initSubComponents(newCompsArray);
            layoutSupport.addComponents((RADVisualComponent[])newCompsArray, newConstrArray, 0);
        } else {
            ComponentContainer othersMetaCont = formModel.getModelContainer();
            i = 0;
            while (i < n) {
                newCompsArray[i] = (RADVisualComponent)newComponents.get(i);
                othersMetaCont.add(newCompsArray[i]);
                ++i;
            }
        }
        if (movedFromOutside != null) {
            n = movedFromOutside.size();
            compsMovedFromOutside = new RADVisualComponent[n];
            i = 0;
            while (i < n) {
                compsMovedFromOutside[i] = (RADVisualComponent)movedFromOutside.get(i);
                formModel.fireComponentAdded(compsMovedFromOutside[i], false);
                ++i;
            }
        } else {
            compsMovedFromOutside = new RADVisualComponent[]{};
            formModel.fireComponentsReordered(this.targetMetaContainer, new int[0]);
        }
        if (movedWithinTarget != null) {
            n = movedWithinTarget.size();
            compsMovedWithinTarget = new RADVisualComponent[n];
            int i9 = 0;
            while (i9 < n) {
                compsMovedWithinTarget[i9] = (RADVisualComponent)movedWithinTarget.get(i9);
                formModel.fireComponentLayoutChanged(compsMovedWithinTarget[i9], null, null, null);
                ++i9;
            }
        } else {
            compsMovedWithinTarget = new RADVisualComponent[]{};
        }
        if (undoRedoOn) {
            DropUndoableEdit dropUndo = new DropUndoableEdit();
            dropUndo.formModel = formModel;
            dropUndo.targetContainer = this.targetMetaContainer;
            dropUndo.targetComponentsBeforeMove = originalComponents;
            dropUndo.targetConstraintsBeforeMove = originalConstraints;
            dropUndo.targetComponentsAfterMove = newCompsArray;
            dropUndo.targetConstraintsAfterMove = newConstrArray;
            dropUndo.componentsMovedFromOutside = compsMovedFromOutside;
            dropUndo.componentsMovedWithinTarget = compsMovedWithinTarget;
            formModel.addUndoableEdit(dropUndo);
        }
        if (undoRedoOn) {
            formModel.setUndoRedoRecording(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComponentDragger.this.formDesigner.setSelectedComponents(ComponentDragger.this.selectedComponents);
            }
        });
    }

    private boolean computeConstraints(Point p, List constraints, List indices) {
        if (this.selectedComponents == null || this.selectedComponents.length == 0) {
            return false;
        }
        if (!this.fixedTarget) {
            RADVisualContainer rADVisualContainer = this.targetMetaContainer = this.resizeType == 0 ? this.handleLayer.getMetaContainerAt(p) : this.selectedComponents[0].getParentContainer();
            if (this.targetMetaContainer == null) {
                return false;
            }
        }
        RADVisualContainer fixTargetContainer = null;
        block0: do {
            if (fixTargetContainer != null) {
                this.targetMetaContainer = fixTargetContainer;
                fixTargetContainer = null;
            }
            LayoutSupportManager layoutSupport = this.targetMetaContainer.getLayoutSupport();
            this.targetContainer = (Container)this.formDesigner.getComponent(this.targetMetaContainer);
            if (this.targetContainer == null) {
                return false;
            }
            this.targetContainerDel = this.targetMetaContainer.getContainerDelegate(this.targetContainer);
            if (this.targetContainerDel == null) {
                return false;
            }
            Point posInCont = SwingUtilities.convertPoint(this.handleLayer, p, this.targetContainerDel);
            int i = 0;
            while (i < this.selectedComponents.length) {
                LayoutConstraints constr = null;
                int index = -1;
                RADVisualComponent metacomp = this.selectedComponents[i];
                Component comp = (Component)this.formDesigner.getComponent(metacomp);
                if (comp != null) {
                    if (!this.checkTarget(metacomp)) {
                        fixTargetContainer = metacomp.getParentContainer();
                        constraints.clear();
                        indices.clear();
                        if (fixTargetContainer != null) continue block0;
                        return false;
                    }
                    if (this.resizeType == 0) {
                        Point posInComp = SwingUtilities.convertPoint(this.handleLayer, this.hotspot, comp);
                        index = layoutSupport.getNewIndex(this.targetContainer, this.targetContainerDel, comp, metacomp.getComponentIndex(), posInCont, posInComp);
                        constr = layoutSupport.getNewConstraints(this.targetContainer, this.targetContainerDel, comp, metacomp.getComponentIndex(), posInCont, posInComp);
                    } else {
                        int up = 0;
                        int down = 0;
                        int left = 0;
                        int right = 0;
                        if ((this.resizeType & 2) != 0) {
                            down = p.y - this.hotspot.y;
                        } else if ((this.resizeType & 1) != 0) {
                            up = this.hotspot.y - p.y;
                        }
                        if ((this.resizeType & 8) != 0) {
                            right = p.x - this.hotspot.x;
                        } else if ((this.resizeType & 4) != 0) {
                            left = this.hotspot.x - p.x;
                        }
                        Insets sizeChanges = new Insets(up, left, down, right);
                        constr = layoutSupport.getResizedConstraints(this.targetContainer, this.targetContainerDel, comp, metacomp.getComponentIndex(), sizeChanges, posInCont);
                    }
                }
                constraints.add(constr);
                indices.add(new Integer(index));
                ++i;
            }
        } while (fixTargetContainer != null);
        return true;
    }

    private boolean checkTarget(RADVisualComponent metacomp) {
        if (!(metacomp instanceof RADVisualContainer)) {
            return true;
        }
        RADComponent targetCont = this.targetMetaContainer;
        while (targetCont != null) {
            if (targetCont == metacomp) {
                return false;
            }
            targetCont = targetCont.getParentComponent();
        }
        return true;
    }

    private void adjustIndices(List indices) {
        int prevIndex = -1;
        int prevCorrection = 0;
        int i = 0;
        while (i < indices.size()) {
            int index = (Integer)indices.get(i);
            if (index >= 0) {
                int correction;
                if (index == prevIndex) {
                    correction = prevCorrection;
                } else {
                    correction = 0;
                    RADVisualComponent[] targetComps = this.targetMetaContainer.getSubComponents();
                    int j = 0;
                    while (j < index) {
                        RADVisualComponent tComp = targetComps[j];
                        boolean isSelected = false;
                        int k = 0;
                        while (k < this.selectedComponents.length) {
                            if (tComp == this.selectedComponents[k]) {
                                isSelected = true;
                                break;
                            }
                            ++k;
                        }
                        if (isSelected) {
                            ++correction;
                        }
                        ++j;
                    }
                    prevIndex = index;
                    prevCorrection = correction;
                }
                if (correction != 0) {
                    indices.set(i, new Integer(index -= correction));
                }
            }
            ++i;
        }
    }

    private void paintDragFeedback(Graphics2D g, RADVisualComponent metacomp) {
        Object comp = this.formDesigner.getComponent(metacomp);
        if (!(comp instanceof Component) || !((Component)comp).isShowing()) {
            return;
        }
        Component component = (Component)comp;
        Rectangle rect = component.getBounds();
        rect = SwingUtilities.convertRectangle(component.getParent(), rect, this.handleLayer);
        rect.translate(this.mousePosition.x - this.hotspot.x, this.mousePosition.y - this.hotspot.y);
        g.draw(new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height));
        if (metacomp instanceof RADVisualContainer) {
            RADVisualComponent[] children = ((RADVisualContainer)metacomp).getSubComponents();
            int i = 0;
            while (i < children.length) {
                this.paintDragFeedback(g, children[i]);
                ++i;
            }
        }
    }

    private void paintTargetContainerFeedback(Graphics2D g, Container cont) {
        Stroke oldStroke = g.getStroke();
        BasicStroke stroke = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{2.0f, 8.0f}, 0.0f);
        g.setStroke(stroke);
        Color oldColor = g.getColor();
        g.setColor(formSettings.getDragBorderColor());
        Rectangle rect = new Rectangle(new Point(0, 0), cont.getSize());
        rect = SwingUtilities.convertRectangle(cont, rect, this.handleLayer);
        g.draw(new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height));
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    private static class DropUndoableEdit
    extends AbstractUndoableEdit {
        FormModel formModel;
        RADVisualContainer targetContainer;
        RADVisualComponent[] targetComponentsBeforeMove;
        LayoutConstraints[] targetConstraintsBeforeMove;
        RADVisualComponent[] targetComponentsAfterMove;
        LayoutConstraints[] targetConstraintsAfterMove;
        RADVisualComponent[] componentsMovedFromOutside;
        RADVisualComponent[] componentsMovedWithinTarget;

        private DropUndoableEdit() {
        }

        public void undo() throws CannotUndoException {
            super.undo();
            boolean undoRedoOn = this.formModel.isUndoRedoRecording();
            if (undoRedoOn) {
                this.formModel.setUndoRedoRecording(false);
            }
            int i = 0;
            while (i < this.componentsMovedFromOutside.length) {
                this.formModel.removeComponentFromContainer(this.componentsMovedFromOutside[i]);
                ++i;
            }
            if (this.targetContainer != null) {
                LayoutSupportManager layoutSupport = this.targetContainer.getLayoutSupport();
                layoutSupport.removeAll();
                this.targetContainer.initSubComponents(this.targetComponentsBeforeMove);
                layoutSupport.addComponents(this.targetComponentsBeforeMove, this.targetConstraintsBeforeMove, 0);
                int i2 = 0;
                while (i2 < this.componentsMovedWithinTarget.length) {
                    this.formModel.fireComponentLayoutChanged(this.componentsMovedWithinTarget[i2], null, null, null);
                    ++i2;
                }
            }
            if (undoRedoOn) {
                this.formModel.setUndoRedoRecording(true);
            }
        }

        public void redo() throws CannotRedoException {
            int i;
            super.redo();
            boolean undoRedoOn = this.formModel.isUndoRedoRecording();
            if (undoRedoOn) {
                this.formModel.setUndoRedoRecording(false);
            }
            if (this.targetContainer != null) {
                LayoutSupportManager layoutSupport = this.targetContainer.getLayoutSupport();
                layoutSupport.removeAll();
                this.targetContainer.initSubComponents(this.targetComponentsAfterMove);
                layoutSupport.addComponents(this.targetComponentsAfterMove, this.targetConstraintsAfterMove, 0);
            } else {
                ComponentContainer othersMetaCont = this.formModel.getModelContainer();
                i = 0;
                while (i < this.targetComponentsAfterMove.length) {
                    othersMetaCont.add(this.targetComponentsAfterMove[i]);
                    ++i;
                }
            }
            int i2 = 0;
            while (i2 < this.componentsMovedFromOutside.length) {
                this.formModel.fireComponentAdded(this.componentsMovedFromOutside[i2], false);
                ++i2;
            }
            i = 0;
            while (i < this.componentsMovedWithinTarget.length) {
                this.formModel.fireComponentLayoutChanged(this.componentsMovedWithinTarget[i], null, null, null);
                ++i;
            }
            if (undoRedoOn) {
                this.formModel.setUndoRedoRecording(true);
            }
        }

        public String getUndoPresentationName() {
            return "";
        }

        public String getRedoPresentationName() {
            return "";
        }
    }
}

