/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.netbeans.modules.form.FormCookie;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.actions.FormEditorAction;
import org.netbeans.modules.form.actions.ReloadAction;
import org.netbeans.modules.form.actions.TestAction;
import org.netbeans.modules.form.palette.CPManager;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.awt.SplittedPanel;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;

public class ComponentInspector
extends ExplorerPanel
implements Serializable {
    private TestAction testAction = (TestAction)SharedClassObject.findObject((Class)(class$org$netbeans$modules$form$actions$TestAction == null ? (class$org$netbeans$modules$form$actions$TestAction = ComponentInspector.class$("org.netbeans.modules.form.actions.TestAction")) : class$org$netbeans$modules$form$actions$TestAction), (boolean)true);
    private FormEditorAction inspectorAction = (FormEditorAction)SharedClassObject.findObject((Class)(class$org$netbeans$modules$form$actions$FormEditorAction == null ? (class$org$netbeans$modules$form$actions$FormEditorAction = ComponentInspector.class$("org.netbeans.modules.form.actions.FormEditorAction")) : class$org$netbeans$modules$form$actions$FormEditorAction), (boolean)true);
    private ReloadAction reloadAction = (ReloadAction)SharedClassObject.findObject((Class)(class$org$netbeans$modules$form$actions$ReloadAction == null ? (class$org$netbeans$modules$form$actions$ReloadAction = ComponentInspector.class$("org.netbeans.modules.form.actions.ReloadAction")) : class$org$netbeans$modules$form$actions$ReloadAction), (boolean)true);
    private DeleteAction deleteAction = (DeleteAction)SharedClassObject.findObject((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = ComponentInspector.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction), (boolean)true);
    private CopyAction copyAction = (CopyAction)SharedClassObject.findObject((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = ComponentInspector.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction), (boolean)true);
    private CutAction cutAction = (CutAction)SharedClassObject.findObject((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = ComponentInspector.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction), (boolean)true);
    private PasteAction pasteAction = (PasteAction)SharedClassObject.findObject((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ComponentInspector.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction), (boolean)true);
    private ActionPerformer copyActionPerformer = new CopyCutActionPerformer(true);
    private ActionPerformer cutActionPerformer = new CopyCutActionPerformer(false);
    private ActionPerformer deleteActionPerformer = new DeleteActionPerformer();
    private boolean actionsAttached = false;
    private ClipboardListener clipboardListener;
    private FormEditorSupport focusedForm;
    private boolean dontSynchronizeSelectedNodes = false;
    private SplittedPanel split;
    private PropertySheetView sheet;
    private static EmptyInspectorNode emptyInspectorNode;
    private static final String EMPTY_INSPECTOR_ICON_BASE = "org/netbeans/modules/form/resources/emptyInspector";
    private static final String iconURL = "org/netbeans/modules/form/resources/inspector.gif";
    private static String INSPECTOR_TITLE;
    private static ComponentInspector instance;
    static /* synthetic */ Class class$org$netbeans$modules$form$actions$TestAction;
    static /* synthetic */ Class class$org$netbeans$modules$form$actions$FormEditorAction;
    static /* synthetic */ Class class$org$netbeans$modules$form$actions$ReloadAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$java$awt$datatransfer$Clipboard;

    public static ComponentInspector getInstance() {
        if (instance == null) {
            instance = new ComponentInspector();
        }
        return instance;
    }

    private ComponentInspector() {
        ExplorerManager manager = this.getExplorerManager();
        emptyInspectorNode = new EmptyInspectorNode();
        manager.setRootContext((Node)emptyInspectorNode);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.createSplit();
        this.setIcon(Utilities.loadImage((String)iconURL));
        if (INSPECTOR_TITLE == null) {
            INSPECTOR_TITLE = FormUtils.getBundleString("CTL_InspectorTitle");
        }
        this.setName(INSPECTOR_TITLE);
        ((JComponent)((Object)this)).putClientProperty("TabPolicy", "HideWhenAlone");
        this.setToolTipText(FormUtils.getBundleString("HINT_ComponentInspector"));
        manager.addPropertyChangeListener((PropertyChangeListener)new NodeSelectionListener());
    }

    private void createSplit() {
        this.split = new SplittedPanel();
        BeanTreeView treeView = new BeanTreeView();
        this.sheet = new PropertySheetView();
        this.split.add((Component)treeView, SplittedPanel.ADD_FIRST);
        this.split.add((Component)this.sheet, SplittedPanel.ADD_SECOND);
        this.split.setSplitType(1);
        this.split.setSplitPosition(30);
        this.sheet.setDisplayWritableOnly(FormEditor.getFormSettings().getDisplayWritableOnly());
        this.sheet.addPropertyChangeListener(new PropertiesDisplayListener());
        ((Container)((Object)this)).add("Center", (Component)this.split);
        treeView.getAccessibleContext().setAccessibleName(FormUtils.getBundleString("ACS_ComponentTree"));
        treeView.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_ComponentTree"));
    }

    protected void componentActivated() {
        this.attachActions();
    }

    protected void componentDeactivated() {
        this.detachActions();
    }

    synchronized void attachActions() {
        this.actionsAttached = true;
        this.updateActions();
        Clipboard c = this.getClipboard();
        if (c instanceof ExClipboard) {
            ExClipboard clip = (ExClipboard)c;
            if (this.clipboardListener == null) {
                this.clipboardListener = new ClipboardChangesListener();
            }
            clip.addClipboardListener(this.clipboardListener);
        }
    }

    synchronized void detachActions() {
        this.actionsAttached = false;
        Clipboard c = this.getClipboard();
        if (c instanceof ExClipboard) {
            ExClipboard clip = (ExClipboard)c;
            clip.removeClipboardListener(this.clipboardListener);
        }
        if (this.deleteActionPerformer == this.deleteAction.getActionPerformer()) {
            this.deleteAction.setActionPerformer(null);
        }
        if (this.copyActionPerformer == this.copyAction.getActionPerformer()) {
            this.copyAction.setActionPerformer(null);
            this.pasteAction.setPasteTypes(null);
        }
        if (this.cutActionPerformer == this.cutAction.getActionPerformer()) {
            this.cutAction.setActionPerformer(null);
        }
    }

    boolean getActionsAttached() {
        return this.actionsAttached;
    }

    public void focusForm(FormEditorSupport form) {
        if (this.focusedForm != form) {
            this.focusFormInAwtThread(form, 0);
        }
    }

    public void focusForm(FormEditorSupport form, boolean visible) {
        if (this.focusedForm != form) {
            this.focusFormInAwtThread(form, visible ? 1 : -1);
        }
    }

    private void focusFormInAwtThread(final FormEditorSupport form, final int visibility) {
        if (EventQueue.isDispatchThread()) {
            this.focusFormImpl(form, visibility);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ComponentInspector.this.focusFormImpl(form, visibility);
                }
            });
        }
    }

    private void focusFormImpl(FormEditorSupport form, int visibility) {
        this.focusedForm = form;
        if (form == null) {
            this.testAction.setFormModel(null);
            this.inspectorAction.setEnabled(false);
            this.reloadAction.setForm(null);
            ((Container)((Object)this)).remove((Component)this.split);
            this.createSplit();
            this.getExplorerManager().setRootContext((Node)emptyInspectorNode);
        } else {
            this.testAction.setFormModel(form.getFormModel());
            this.inspectorAction.setEnabled(true);
            this.reloadAction.setForm(form);
            Node formNode = form.getFormRootNode();
            if (formNode == null) {
                System.err.println("Warning: FormEditorSupport.getFormRootNode() returns null");
                this.getExplorerManager().setRootContext((Node)emptyInspectorNode);
            } else {
                this.sheet.setDisplayWritableOnly(!form.getFormModel().isReadOnly() && FormEditor.getFormSettings().getDisplayWritableOnly());
                this.dontSynchronizeSelectedNodes = true;
                this.getExplorerManager().setRootContext(formNode);
                this.dontSynchronizeSelectedNodes = false;
            }
        }
        this.setName(INSPECTOR_TITLE);
        if (visibility > 0) {
            this.open();
            this.setCloseOperation(1);
        } else if (visibility < 0) {
            this.setCloseOperation(0);
            this.close();
        }
    }

    protected void updateTitle() {
        this.setName(INSPECTOR_TITLE);
    }

    public FormEditorSupport getFocusedForm() {
        return this.focusedForm;
    }

    void setSelectedNodes(Node[] nodes, FormEditorSupport form) throws PropertyVetoException {
        if (form == this.focusedForm) {
            this.dontSynchronizeSelectedNodes = true;
            this.getExplorerManager().setSelectedNodes(nodes);
            this.dontSynchronizeSelectedNodes = false;
        }
    }

    Node[] getSelectedNodes() {
        return this.getExplorerManager().getSelectedNodes();
    }

    private void updateActions() {
        int n;
        boolean noPerformers = false;
        Node[] selected = this.getExplorerManager().getSelectedNodes();
        int n2 = n = selected != null ? selected.length : 0;
        if (n > 0) {
            int i;
            if (n > 1) {
                HashMap allNodes = new HashMap(101);
                i = 0;
                while (i < n) {
                    if (!this.checkNodeParents(selected[i], allNodes)) {
                        noPerformers = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!noPerformers) {
                i = 0;
                while (i < n) {
                    if (!selected[i].canCopy()) {
                        this.copyAction.setActionPerformer(null);
                        break;
                    }
                    ++i;
                }
                if (i == n) {
                    this.copyAction.setActionPerformer(this.copyActionPerformer);
                }
                i = 0;
                while (i < n) {
                    if (!selected[i].canCut()) {
                        this.cutAction.setActionPerformer(null);
                        break;
                    }
                    ++i;
                }
                if (i == n) {
                    this.cutAction.setActionPerformer(this.cutActionPerformer);
                }
                i = 0;
                while (i < n) {
                    if (!selected[i].canDestroy()) {
                        this.deleteAction.setActionPerformer(null);
                        break;
                    }
                    ++i;
                }
                if (i == n) {
                    this.deleteAction.setActionPerformer(this.deleteActionPerformer);
                }
            }
        } else {
            noPerformers = true;
        }
        if (noPerformers) {
            this.deleteAction.setActionPerformer(null);
            this.copyAction.setActionPerformer(null);
            this.cutAction.setActionPerformer(null);
        }
        this.updatePasteAction();
    }

    private void updatePasteAction() {
        Clipboard clipboard;
        Transferable trans;
        Node[] selected = this.getExplorerManager().getSelectedNodes();
        if (selected != null && selected.length == 1 && (trans = (clipboard = this.getClipboard()).getContents(this)) != null) {
            Node node = selected[0];
            PasteType[] pasteTypes = node.getPasteTypes(trans);
            if (pasteTypes.length != 0) {
                this.pasteAction.setPasteTypes(pasteTypes);
                return;
            }
            boolean multiFlavor = false;
            try {
                multiFlavor = trans.isDataFlavorSupported(ExTransferable.multiFlavor);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (multiFlavor) {
                try {
                    MultiTransferObject mto = (MultiTransferObject)trans.getTransferData(ExTransferable.multiFlavor);
                    int n = mto.getCount();
                    Transferable[] t = new Transferable[n];
                    PasteType[] p = new PasteType[n];
                    int i = 0;
                    while (i < n) {
                        t[i] = mto.getTransferableAt(i);
                        pasteTypes = node.getPasteTypes(t[i]);
                        if (pasteTypes.length == 0) break;
                        p[i] = pasteTypes[0];
                        ++i;
                    }
                    if (i == n) {
                        this.pasteAction.setPasteTypes(new PasteType[]{new MultiPasteType(t, p)});
                        return;
                    }
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
        this.pasteAction.setPasteTypes(null);
    }

    private boolean checkNodeParents(Node node, Map set) {
        if (set.get(node) != null) {
            return false;
        }
        set.put(node, this);
        node = node.getParentNode();
        while (node != null) {
            if (set.put(node, node) == this) {
                return false;
            }
            node = node.getParentNode();
        }
        return true;
    }

    public UndoRedo getUndoRedo() {
        UndoRedo.Manager ur = this.focusedForm != null ? this.focusedForm.getFormUndoRedoManager() : null;
        return ur != null ? ur : super.getUndoRedo();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.component-inspector");
    }

    public Dimension getPreferredSize() {
        return new Dimension(250, 400);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    private Clipboard getClipboard() {
        Clipboard c = (Clipboard)Lookup.getDefault().lookup(class$java$awt$datatransfer$Clipboard == null ? (class$java$awt$datatransfer$Clipboard = ComponentInspector.class$("java.awt.datatransfer.Clipboard")) : class$java$awt$datatransfer$Clipboard);
        if (c == null) {
            c = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return c;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 7424646018839457544L;

        public Object readResolve() {
            return ComponentInspector.getInstance();
        }
    }

    private static class EmptyInspectorNode
    extends AbstractNode {
        public EmptyInspectorNode() {
            super(Children.LEAF);
            this.setIconBase(ComponentInspector.EMPTY_INSPECTOR_ICON_BASE);
        }

        public boolean canRename() {
            return false;
        }
    }

    private class MultiPasteType
    extends PasteType
    implements Mutex.ExceptionAction {
        private Transferable[] transIn;
        private PasteType[] pasteTypes;

        MultiPasteType(Transferable[] t, PasteType[] p) {
            this.transIn = t;
            this.pasteTypes = p;
        }

        public Transferable paste() throws IOException {
            if (EventQueue.isDispatchThread()) {
                return this.doPaste();
            }
            try {
                return (Transferable)Mutex.EVENT.readAccess((Mutex.ExceptionAction)this);
            }
            catch (MutexException ex) {
                Exception e = ex.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                e.printStackTrace();
                return ExTransferable.EMPTY;
            }
        }

        public Object run() throws Exception {
            return this.doPaste();
        }

        private Transferable doPaste() throws IOException {
            Transferable[] transOut = new Transferable[this.transIn.length];
            int i = 0;
            while (i < this.pasteTypes.length) {
                Transferable newTrans = this.pasteTypes[i].paste();
                transOut[i] = newTrans != null ? newTrans : this.transIn[i];
                ++i;
            }
            return new ExTransferable.Multi(transOut);
        }
    }

    private class CopyCutActionPerformer
    implements ActionPerformer {
        private boolean copy;

        public CopyCutActionPerformer(boolean copy) {
            this.copy = copy;
        }

        public void performAction(SystemAction action) {
            Transferable trans;
            Node[] selected = ComponentInspector.this.getExplorerManager().getSelectedNodes();
            if (selected == null || selected.length == 0) {
                trans = null;
            } else if (selected.length == 1) {
                trans = this.getTransferableOwner(selected[0]);
            } else {
                Transferable[] transArray = new Transferable[selected.length];
                int i = 0;
                while (i < selected.length) {
                    transArray[i] = this.getTransferableOwner(selected[i]);
                    if (transArray[i] == null) {
                        return;
                    }
                    ++i;
                }
                trans = new ExTransferable.Multi(transArray);
            }
            if (trans != null) {
                Clipboard clipboard = ComponentInspector.this.getClipboard();
                clipboard.setContents(trans, new StringSelection(""));
            }
        }

        private Transferable getTransferableOwner(Node node) {
            try {
                return this.copy ? node.clipboardCopy() : node.clipboardCut();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return null;
            }
        }
    }

    private class DeleteActionPerformer
    implements ActionPerformer,
    Mutex.Action {
        private Node[] nodesToDestroy;
        static /* synthetic */ Class class$org$openide$explorer$ExplorerActions;

        private DeleteActionPerformer() {
        }

        public void performAction(SystemAction action) {
            Node[] selected = ComponentInspector.this.getExplorerManager().getSelectedNodes();
            if (selected == null || selected.length == 0) {
                return;
            }
            if (ExplorerPanel.isConfirmDelete() && !this.confirmDelete(selected)) {
                return;
            }
            try {
                ComponentInspector.this.getExplorerManager().setSelectedNodes(new Node[0]);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.nodesToDestroy = selected;
            if (EventQueue.isDispatchThread()) {
                this.doDelete();
            } else {
                Mutex.EVENT.readAccess((Mutex.Action)this);
            }
        }

        public Object run() {
            this.doDelete();
            return null;
        }

        private void doDelete() {
            if (this.nodesToDestroy != null) {
                int i = 0;
                while (i < this.nodesToDestroy.length) {
                    try {
                        this.nodesToDestroy[i].destroy();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    ++i;
                }
                this.nodesToDestroy = null;
            }
        }

        private boolean confirmDelete(Node[] selected) {
            String title;
            String message;
            if (selected.length == 1) {
                message = NbBundle.getMessage((Class)(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = DeleteActionPerformer.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions), (String)"MSG_ConfirmDeleteObject", (Object)selected[0].getDisplayName());
                title = NbBundle.getMessage((Class)(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = DeleteActionPerformer.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions), (String)"MSG_ConfirmDeleteObjectTitle");
            } else {
                message = NbBundle.getMessage((Class)(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = DeleteActionPerformer.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions), (String)"MSG_ConfirmDeleteObjects", (Object)new Integer(selected.length));
                title = NbBundle.getMessage((Class)(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = DeleteActionPerformer.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions), (String)"MSG_ConfirmDeleteObjectsTitle");
            }
            NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)message, title, 0);
            return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc));
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class PropertiesDisplayListener
    implements PropertyChangeListener {
        private PropertiesDisplayListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("displayWritableOnly".equals(evt.getPropertyName())) {
                FormEditor.getFormSettings().setDisplayWritableOnly(ComponentInspector.this.sheet.getDisplayWritableOnly());
            }
        }
    }

    private class ClipboardChangesListener
    implements ClipboardListener {
        private ClipboardChangesListener() {
        }

        public void clipboardChanged(ClipboardEvent ev) {
            if (!ev.isConsumed()) {
                ComponentInspector.this.updatePasteAction();
            }
        }
    }

    private class NodeSelectionListener
    implements PropertyChangeListener,
    ActionListener {
        private Timer timer = new Timer(150, this);
        static /* synthetic */ Class class$org$netbeans$modules$form$RADComponentCookie;
        static /* synthetic */ Class class$org$netbeans$modules$form$FormCookie;

        NodeSelectionListener() {
            this.timer.setCoalesce(true);
            this.timer.setRepeats(false);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!"selectedNodes".equals(evt.getPropertyName())) {
                return;
            }
            this.timer.start();
        }

        public void actionPerformed(ActionEvent evt) {
            if (ComponentInspector.this.actionsAttached) {
                ComponentInspector.this.updateActions();
            }
            if (ComponentInspector.this.focusedForm == null) {
                return;
            }
            FormDesigner designer = ComponentInspector.this.focusedForm.getFormDesigner();
            if (designer == null) {
                return;
            }
            Node[] selected = ComponentInspector.this.getExplorerManager().getSelectedNodes();
            if (CPManager.getDefault().getMode() == 1) {
                if (selected.length == 0) {
                    return;
                }
                RADComponentCookie cookie = (RADComponentCookie)selected[0].getCookie(class$org$netbeans$modules$form$RADComponentCookie == null ? (class$org$netbeans$modules$form$RADComponentCookie = NodeSelectionListener.class$("org.netbeans.modules.form.RADComponentCookie")) : class$org$netbeans$modules$form$RADComponentCookie);
                if (cookie != null && cookie.getRADComponent() == designer.getConnectionSource() && selected.length > 1) {
                    cookie = (RADComponentCookie)selected[selected.length - 1].getCookie(class$org$netbeans$modules$form$RADComponentCookie == null ? (class$org$netbeans$modules$form$RADComponentCookie = NodeSelectionListener.class$("org.netbeans.modules.form.RADComponentCookie")) : class$org$netbeans$modules$form$RADComponentCookie);
                }
                if (cookie != null) {
                    designer.connectBean(cookie.getRADComponent(), true);
                }
            } else if (!ComponentInspector.this.dontSynchronizeSelectedNodes) {
                designer.clearSelectionImpl();
                int i = 0;
                while (i < selected.length) {
                    Node node;
                    FormCookie formCookie = (FormCookie)selected[i].getCookie(class$org$netbeans$modules$form$FormCookie == null ? NodeSelectionListener.class$("org.netbeans.modules.form.FormCookie") : class$org$netbeans$modules$form$FormCookie);
                    if (formCookie != null && (node = formCookie.getOriginalNode()) instanceof RADComponentNode) {
                        designer.addComponentToSelectionImpl(((RADComponentNode)node).getRADComponent());
                    }
                    ++i;
                }
                designer.repaintSelection();
            }
            this.timer.stop();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

