/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.fakepeer.FakePeerContainer;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;

class ComponentLayer
extends JPanel {
    private static FormLoaderSettings formSettings = FormEditor.getFormSettings();
    private static final int HORIZONTAL_MARGIN = 12;
    private static final int VERTICAL_MARGIN = 12;
    private Container componentContainer = new FakePeerContainer();
    private DesignerPanel designerPanel;

    ComponentLayer() {
        this.componentContainer.setLayout(new BorderLayout());
        this.componentContainer.setBackground(Color.white);
        this.componentContainer.setFont(FakePeerSupport.getDefaultAWTFont());
        this.designerPanel = new DesignerPanel();
        this.designerPanel.setLayout(new BorderLayout());
        this.designerPanel.add((Component)this.componentContainer, "Center");
        this.setLayout(new FlowLayout(0, 12, 12));
        this.add(this.designerPanel);
        this.updateBackground();
    }

    Container getComponentContainer() {
        return this.componentContainer;
    }

    Rectangle getDesignerBounds() {
        Rectangle r = new Rectangle(this.designerPanel.getDesignerSize());
        Insets i = this.designerPanel.getInsets();
        r.x = 12 + i.left;
        r.y = 12 + i.top;
        return r;
    }

    Dimension getDesignerSize() {
        return this.designerPanel.getDesignerSize();
    }

    Insets getDesignerOutsets() {
        return this.designerPanel.getInsets();
    }

    void updateDesignerSize(Dimension size) {
        if (size != null && !size.equals(this.designerPanel.getDesignerSize())) {
            this.designerPanel.setDesignerSize(size);
            this.revalidate();
            this.repaint();
        }
    }

    void setTopDesignComponent(Component component) {
        if (this.componentContainer.getComponentCount() > 0) {
            this.componentContainer.removeAll();
        }
        this.componentContainer.add(component, "Center");
    }

    void updateVisualSettings() {
        this.updateBackground();
        this.designerPanel.updateBorder();
    }

    private void updateBackground() {
        this.setBackground(formSettings.getFormDesignerBackgroundColor());
    }

    private static class DesignerPanel
    extends JPanel {
        private static int BORDER_THICKNESS = 5;
        private Dimension designerSize = new Dimension(400, 300);

        DesignerPanel() {
            this.updateBorder();
        }

        void updateBorder() {
            this.setBorder(new LineBorder(formSettings.getFormDesignerBorderColor(), BORDER_THICKNESS));
        }

        Dimension getDesignerSize() {
            return this.designerSize;
        }

        void setDesignerSize(Dimension size) {
            this.designerSize = size;
        }

        public Dimension getPreferredSize() {
            Dimension size = new Dimension(this.designerSize);
            Insets insets = this.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }
    }
}

