/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.form.CreationDescriptor;
import org.netbeans.modules.form.CreationFactory;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeExpressionOrigin;
import org.netbeans.modules.form.codestructure.CodeStructure;

public class ConstructorsDescriptor
implements CreationDescriptor {
    private Class describedClass;
    private ConstructorCreator[] constructors;
    private Object[] defaultConstrParams;
    private Constructor defaultConstructor;
    private static final Class[] emptyTypes = new Class[0];
    private static final String[] emptyNames = new String[0];
    private static final Object[] emptyParams = new Object[0];

    public ConstructorsDescriptor(Class descClass, Class[][] constrParamTypes, String[][] constrPropNames, Object[] defParams) throws NoSuchMethodException {
        this.describedClass = descClass;
        if (constrParamTypes != null && constrParamTypes.length > 0) {
            this.constructors = new ConstructorCreator[constrParamTypes.length];
            int i = 0;
            while (i < constrParamTypes.length) {
                this.constructors[i] = new ConstructorCreator(this.describedClass, constrParamTypes[i], constrPropNames[i]);
                ++i;
            }
        }
        Object[] objectArray = this.defaultConstrParams = defParams == null ? emptyParams : defParams;
        if (this.defaultConstrParams.length > 0) {
            this.findDefaultConstructor();
        }
    }

    public ConstructorsDescriptor(Class descClass) {
        block2: {
            this.describedClass = descClass;
            try {
                ConstructorCreator creator = new ConstructorCreator(this.describedClass, emptyTypes, emptyNames);
                this.constructors = new ConstructorCreator[]{creator};
            }
            catch (NoSuchMethodException ex) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                System.out.println("[WARNING] No default constructor for " + descClass.getName());
                ex.printStackTrace();
            }
        }
        this.defaultConstrParams = emptyParams;
    }

    public Class getDescribedClass() {
        return this.describedClass;
    }

    public CreationDescriptor.Creator[] getCreators() {
        return this.constructors;
    }

    public CreationDescriptor.Creator findBestCreator(FormProperty[] properties, int style) {
        if (this.constructors == null) {
            return null;
        }
        int[] evals = CreationFactory.evaluateCreators(this.constructors, properties, (style & 1) != 0);
        int best = CreationFactory.getBestCreator(this.constructors, properties, evals, (style & 2) != 0);
        return this.constructors[best];
    }

    public Object createDefaultInstance() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.defaultConstrParams.length == 0) {
            return this.describedClass.newInstance();
        }
        return this.defaultConstructor.newInstance(this.defaultConstrParams);
    }

    private void findDefaultConstructor() throws NoSuchMethodException {
        Constructor<?>[] constructors = this.describedClass.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            Class<?>[] paramTypes = constructors[i].getParameterTypes();
            if (paramTypes.length == this.defaultConstrParams.length) {
                int ii = 0;
                while (ii < paramTypes.length) {
                    Class<?> cls = paramTypes[ii];
                    Object param = this.defaultConstrParams[ii];
                    if (cls.isPrimitive() ? param == null || param instanceof Integer && cls != Integer.TYPE || param instanceof Boolean && cls != Boolean.TYPE || param instanceof Double && cls != Double.TYPE || param instanceof Long && cls != Long.TYPE || param instanceof Float && cls != Float.TYPE || param instanceof Short && cls != Short.TYPE || param instanceof Byte && cls != Byte.TYPE || param instanceof Character && cls != Character.TYPE : param != null && !cls.isInstance(param)) break;
                    ++ii;
                }
                if (ii == paramTypes.length) {
                    this.defaultConstructor = constructors[i];
                    return;
                }
            }
            ++i;
        }
        throw new NoSuchMethodException();
    }

    static class ConstructorCreator
    implements CreationDescriptor.Creator {
        private Class theClass;
        private Constructor constructor;
        private String[] constructorPropNames;

        ConstructorCreator(Class cls, Class[] paramTypes, String[] propNames) throws NoSuchMethodException {
            if (paramTypes == null) {
                paramTypes = emptyTypes;
            }
            if (propNames == null) {
                propNames = emptyNames;
            }
            if (paramTypes.length != propNames.length) {
                throw new IllegalArgumentException();
            }
            this.constructor = cls.getConstructor(paramTypes);
            this.theClass = cls;
            this.constructorPropNames = propNames;
        }

        public final int getParameterCount() {
            return this.constructorPropNames.length;
        }

        public final Class[] getParameterTypes() {
            return this.constructor.getParameterTypes();
        }

        public final Class[] getExceptionTypes() {
            return this.constructor.getExceptionTypes();
        }

        public final String[] getPropertyNames() {
            return this.constructorPropNames;
        }

        public Object createInstance(FormProperty[] props) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Object[] paramValues = new Object[this.constructorPropNames.length];
            try {
                int i = 0;
                while (i < this.constructorPropNames.length) {
                    FormProperty prop = CreationFactory.findProperty(this.constructorPropNames[i], props);
                    if (prop == null) {
                        return null;
                    }
                    paramValues[i] = prop.getRealValue();
                    ++i;
                }
            }
            catch (Exception ex) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    ex.printStackTrace();
                }
                throw new InstantiationException(ex.getMessage());
            }
            return this.constructor.newInstance(paramValues);
        }

        public String getJavaCreationCode(FormProperty[] props) {
            StringBuffer buf = new StringBuffer();
            buf.append("new ");
            buf.append(this.theClass.getName().replace('$', '.'));
            buf.append("(");
            int i = 0;
            while (i < this.constructorPropNames.length) {
                FormProperty prop = CreationFactory.findProperty(this.constructorPropNames[i], props);
                if (prop == null) {
                    return null;
                }
                buf.append(prop.getJavaInitializationString());
                if (i + 1 < this.constructorPropNames.length) {
                    buf.append(", ");
                }
                ++i;
            }
            buf.append(")");
            return buf.toString();
        }

        public CodeExpressionOrigin getCodeOrigin(CodeExpression[] params) {
            return CodeStructure.createOrigin(this.constructor, params);
        }
    }
}

