/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;

class CopySupport {
    private static final String flavorMimeType = "application/x-form-metacomponent;class=java.lang.Object";
    private static DataFlavor copyFlavor;
    private static DataFlavor cutFlavor;

    CopySupport() {
    }

    static DataFlavor getComponentCopyFlavor() {
        if (copyFlavor == null) {
            copyFlavor = new DataFlavor(flavorMimeType, "COMPONENT_COPY_FLAVOR");
        }
        return copyFlavor;
    }

    static DataFlavor getComponentCutFlavor() {
        if (cutFlavor == null) {
            cutFlavor = new DataFlavor(flavorMimeType, "COMPONENT_CUT_FLAVOR");
        }
        return cutFlavor;
    }

    public static boolean canPasteCut(RADComponent sourceComponent, FormModel targetForm, RADComponent targetComponent) {
        if (sourceComponent.getFormModel() != targetForm) {
            return true;
        }
        if (targetComponent == null) {
            return targetForm.getModelContainer().getIndexOf(sourceComponent) < 0;
        }
        return sourceComponent != targetComponent && sourceComponent.getParentComponent() != targetComponent && !sourceComponent.isParentComponent(targetComponent);
    }

    static class InstancePaste
    extends PasteType
    implements Mutex.ExceptionAction {
        private Transferable transferable;
        private FormModel targetForm;
        private RADComponent targetComponent;
        static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

        public InstancePaste(Transferable t, FormModel targetForm, RADComponent targetComponent) {
            this.transferable = t;
            this.targetForm = targetForm;
            this.targetComponent = targetComponent;
        }

        public Transferable paste() throws IOException {
            if (EventQueue.isDispatchThread()) {
                return this.doPaste();
            }
            try {
                return (Transferable)Mutex.EVENT.readAccess((Mutex.ExceptionAction)this);
            }
            catch (MutexException ex) {
                Exception e = ex.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                e.printStackTrace();
                return this.transferable;
            }
        }

        public Object run() throws Exception {
            return this.doPaste();
        }

        private Transferable doPaste() throws IOException {
            InstanceCookie ic = (InstanceCookie)NodeTransfer.cookie((Transferable)this.transferable, (int)1, (Class)(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstancePaste.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie));
            if (ic != null) {
                this.targetForm.getComponentCreator().createComponent(ic, this.targetComponent, null);
            }
            return this.transferable;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class RADPaste
    extends PasteType
    implements Mutex.ExceptionAction {
        private Transferable transferable;
        private FormModel targetForm;
        private RADComponent targetComponent;

        public RADPaste(Transferable t, FormModel targetForm, RADComponent targetComponent) {
            this.transferable = t;
            this.targetForm = targetForm;
            this.targetComponent = targetComponent;
        }

        public String getName() {
            return FormUtils.getBundleString(this.isComponentCut() ? "CTL_CutPaste" : "CTL_CopyPaste");
        }

        public Transferable paste() throws IOException {
            if (EventQueue.isDispatchThread()) {
                return this.doPaste();
            }
            try {
                return (Transferable)Mutex.EVENT.readAccess((Mutex.ExceptionAction)this);
            }
            catch (MutexException ex) {
                Exception e = ex.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                e.printStackTrace();
                return ExTransferable.EMPTY;
            }
        }

        public Object run() throws Exception {
            return this.doPaste();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Transferable doPaste() throws IOException {
            boolean fromCut = this.isComponentCut();
            RADComponent sourceComponent = this.getSourceComponent(fromCut);
            if (sourceComponent == null) {
                return null;
            }
            if (!fromCut || sourceComponent.getCodeExpression() == null) {
                this.targetForm.getComponentCreator().copyComponent(sourceComponent, this.targetComponent);
                return null;
            }
            FormModel sourceForm = sourceComponent.getFormModel();
            if (sourceForm != this.targetForm || this.targetComponent != null && !sourceComponent.getClass().isAssignableFrom(this.targetComponent.getClass())) {
                if (this.targetForm.getComponentCreator().copyComponent(sourceComponent, this.targetComponent) == null) return null;
                RADComponentNode sourceNode = sourceComponent.getNodeReference();
                if (sourceNode == null) throw new IllegalStateException();
                sourceNode.destroy();
                return ExTransferable.EMPTY;
            }
            if (!CopySupport.canPasteCut(sourceComponent, this.targetForm, this.targetComponent) || !MetaComponentCreator.canAddComponent(sourceComponent.getBeanClass(), this.targetComponent)) {
                return null;
            }
            sourceForm.removeComponentFromContainer(sourceComponent);
            if (sourceComponent instanceof RADVisualComponent && this.targetComponent instanceof RADVisualContainer) {
                RADVisualContainer visualCont = (RADVisualContainer)this.targetComponent;
                LayoutSupportManager layoutSupport = visualCont.getLayoutSupport();
                RADVisualComponent[] compArray = new RADVisualComponent[]{(RADVisualComponent)sourceComponent};
                LayoutConstraints[] constrArray = new LayoutConstraints[]{layoutSupport.getStoredConstraints(compArray[0])};
                try {
                    layoutSupport.acceptNewComponents(compArray, constrArray, -1);
                }
                catch (RuntimeException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                    return this.transferable;
                }
                visualCont.add(sourceComponent);
                layoutSupport.addComponents(compArray, constrArray, -1);
                this.targetForm.fireComponentAdded(sourceComponent, false);
                return ExTransferable.EMPTY;
            }
            ComponentContainer targetContainer = this.targetComponent instanceof ComponentContainer ? (ComponentContainer)((Object)this.targetComponent) : null;
            this.targetForm.addComponent(sourceComponent, targetContainer);
            return ExTransferable.EMPTY;
        }

        boolean isComponentCut() {
            return this.transferable.isDataFlavorSupported(CopySupport.getComponentCutFlavor());
        }

        RADComponent getSourceComponent(boolean fromCut) throws IOException {
            RADComponent sourceComponent = null;
            try {
                Object obj = this.transferable.getTransferData(fromCut ? CopySupport.getComponentCutFlavor() : CopySupport.getComponentCopyFlavor());
                if (obj instanceof RADComponent) {
                    sourceComponent = (RADComponent)obj;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
            return sourceComponent;
        }
    }

    static class RADTransferable
    implements Transferable {
        private RADComponent radComponent;
        private DataFlavor[] flavors;

        RADTransferable(DataFlavor flavor, RADComponent radComponent) {
            this(new DataFlavor[]{flavor}, radComponent);
        }

        RADTransferable(DataFlavor[] flavors, RADComponent radComponent) {
            this.flavors = flavors;
            this.radComponent = radComponent;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            int i = 0;
            while (i < this.flavors.length) {
                if (this.flavors[i] == flavor) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if ("x-form-metacomponent".equals(flavor.getSubType())) {
                return this.radComponent;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

