/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.EventCustomEditor;
import org.netbeans.modules.form.FormEvents;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Utilities;

class EventProperty
extends PropertySupport.ReadWrite {
    private static String NO_EVENT;
    private Event event;
    private String selectedEventHandler;
    static /* synthetic */ Class class$java$lang$String;

    EventProperty(Event event, String eventId) {
        super(eventId, class$java$lang$String == null ? (class$java$lang$String = EventProperty.class$("java.lang.String")) : class$java$lang$String, event.getListenerMethod().getName(), event.getListenerMethod().getName());
        this.event = event;
        ((FeatureDescriptor)((Object)this)).setShortDescription(event.getEventSetDescriptor().getListenerType().getName());
    }

    Event getEvent() {
        return this.event;
    }

    private FormEvents getFormEvents() {
        return this.getComponent().getFormModel().getFormEvents();
    }

    private RADComponent getComponent() {
        return this.event.getComponent();
    }

    private Method getListenerMethod() {
        return this.event.getListenerMethod();
    }

    String[] getEventHandlers() {
        return this.event.getEventHandlers();
    }

    public Object getValue() {
        if (this.selectedEventHandler == null && this.event.hasEventHandlers()) {
            this.selectedEventHandler = (String)this.event.getEventHandlerList().get(0);
        }
        return this.selectedEventHandler;
    }

    public void setValue(Object val) {
        int i;
        Change change = null;
        String newSelectedHandler = null;
        if (val instanceof Change) {
            change = (Change)val;
        } else if (val instanceof String) {
            String[] handlers = this.getEventHandlers();
            if (handlers.length > 0) {
                String current;
                String string = current = this.selectedEventHandler != null ? this.selectedEventHandler : handlers[0];
                if ("".equals(val)) {
                    change = new Change();
                    change.getRemoved().add(current);
                    i = 0;
                    while (i < handlers.length) {
                        if (!handlers[i].equals(current)) {
                            newSelectedHandler = handlers[i];
                            break;
                        }
                        ++i;
                    }
                } else {
                    newSelectedHandler = (String)val;
                    boolean ignore = false;
                    int i2 = 0;
                    while (i2 < handlers.length) {
                        if (handlers[i2].equals(val)) {
                            ignore = true;
                            break;
                        }
                        ++i2;
                    }
                    if (!ignore) {
                        change = new Change();
                        change.getRenamedNewNames().add(val);
                        change.getRenamedOldNames().add(current);
                    }
                }
            } else {
                change = new Change();
                change.getAdded().add((String)val);
                newSelectedHandler = (String)val;
            }
        } else if (val == null) {
            if (this.selectedEventHandler == null) {
                return;
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (change != null) {
            FormEvents formEvents = this.getFormEvents();
            if (change.hasRemoved()) {
                Iterator it = change.getRemoved().iterator();
                while (it.hasNext()) {
                    formEvents.detachEvent(this.event, (String)it.next());
                }
            }
            if (change.hasRenamed()) {
                i = 0;
                while (i < change.getRenamedOldNames().size()) {
                    String oldName = (String)change.getRenamedOldNames().get(i);
                    String newName = (String)change.getRenamedNewNames().get(i);
                    if (Utilities.isJavaIdentifier((String)newName)) {
                        try {
                            formEvents.renameEventHandler(oldName, newName);
                            Event[] events = formEvents.getEventsForHandler(newName);
                            int j = 0;
                            while (j < events.length) {
                                Node.Property prop = events[j].getComponent().getPropertyByName(((FeatureDescriptor)((Object)this)).getName());
                                if (prop != null && prop != this) {
                                    try {
                                        if (oldName.equals(prop.getValue())) {
                                            prop.setValue((Object)newName);
                                        }
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                ++j;
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            ErrorManager.getDefault().notify(16, (Throwable)ex);
                            newSelectedHandler = null;
                        }
                    }
                    ++i;
                }
            }
            if (change.hasAdded()) {
                Iterator it = change.getAdded().iterator();
                while (it.hasNext()) {
                    String handlerName = (String)it.next();
                    if (!Utilities.isJavaIdentifier((String)handlerName)) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormUtils.getFormattedBundleString("FMT_MSG_InvalidJavaIdentifier", new Object[]{handlerName}), 0));
                        continue;
                    }
                    try {
                        formEvents.attachEvent(this.event, handlerName, null);
                    }
                    catch (IllegalArgumentException ex) {
                        ErrorManager.getDefault().notify(16, (Throwable)ex);
                        newSelectedHandler = null;
                    }
                }
            }
        }
        this.selectedEventHandler = newSelectedHandler;
        RADComponentNode node = this.getComponent().getNodeReference();
        if (node != null) {
            node.firePropertyChangeHelper(((FeatureDescriptor)((Object)this)).getName(), null, null);
        }
    }

    public boolean canWrite() {
        return !this.isReadOnly();
    }

    private boolean isReadOnly() {
        return this.getComponent().isReadOnly();
    }

    public PropertyEditor getPropertyEditor() {
        return new EventEditor();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class EventComboBox
    extends JComboBox {
        private EventComboBox() {
        }

        public void addKeyListener(KeyListener l) {
            super.addKeyListener(l);
            this.getEditor().getEditorComponent().addKeyListener(l);
        }

        public void removeKeyListener(KeyListener l) {
            super.removeKeyListener(l);
            this.getEditor().getEditorComponent().removeKeyListener(l);
        }

        public void addFocusListener(FocusListener l) {
            super.addFocusListener(l);
            if (this.getEditor() != null) {
                this.getEditor().getEditorComponent().addFocusListener(l);
            }
        }

        public void removeFocusListener(FocusListener l) {
            super.removeFocusListener(l);
            if (this.getEditor() != null) {
                this.getEditor().getEditorComponent().removeFocusListener(l);
            }
        }
    }

    private class EventEditor
    extends PropertyEditorSupport
    implements EnhancedPropertyEditor {
        ActionListener comboSelectListener = null;
        FocusListener comboEditFocusListener = null;
        EventComboBox eventCombo;

        private EventEditor() {
        }

        public String getAsText() {
            if (this.getValue() == null) {
                if (NO_EVENT == null) {
                    NO_EVENT = FormUtils.getBundleString("CTL_NoEvent");
                }
                return NO_EVENT;
            }
            return this.getValue().toString();
        }

        public void setAsText(String selected) {
            this.setValue(selected);
        }

        public boolean supportsEditingTaggedValues() {
            return false;
        }

        public Component getInPlaceCustomEditor() {
            this.eventCombo = new EventComboBox();
            this.eventCombo.setEditable(!EventProperty.this.isReadOnly());
            String[] handlers = EventProperty.this.getEventHandlers();
            if (handlers.length == 0) {
                String newName = EventProperty.this.getFormEvents().findFreeHandlerName(EventProperty.this.getEvent(), EventProperty.this.getComponent());
                this.eventCombo.getEditor().setItem(newName);
            } else {
                int i = 0;
                while (i < handlers.length) {
                    this.eventCombo.addItem(handlers[i]);
                    ++i;
                }
                if (EventProperty.this.selectedEventHandler != null) {
                    this.eventCombo.setSelectedItem(EventProperty.this.selectedEventHandler);
                }
            }
            if (this.comboSelectListener == null) {
                this.comboSelectListener = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        int i;
                        if (!EventProperty.this.event.hasEventHandlers() || (i = eventCombo.getSelectedIndex()) < 0) {
                            return;
                        }
                        eventCombo.getEditor().getEditorComponent().removeFocusListener(comboEditFocusListener);
                        String selected = (String)eventCombo.getItemAt(i);
                        this.setValue(selected);
                        EventProperty.this.getFormEvents().attachEvent(EventProperty.this.getEvent(), selected, null);
                    }
                };
            }
            this.eventCombo.addActionListener(this.comboSelectListener);
            if (EventProperty.this.isReadOnly()) {
                return this.eventCombo;
            }
            if (this.comboEditFocusListener == null) {
                this.comboEditFocusListener = new FocusAdapter(this){
                    private final /* synthetic */ EventEditor this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void focusLost(FocusEvent evt) {
                        this.this$1.eventCombo.removeActionListener(this.this$1.comboSelectListener);
                        this.this$1.setValue(EventProperty.access$600(EventEditor.access$700(this.this$1)));
                    }

                    public void focusGained(FocusEvent evt) {
                        this.this$1.eventCombo.getEditor().selectAll();
                    }
                };
            }
            this.eventCombo.getEditor().getEditorComponent().addFocusListener(this.comboEditFocusListener);
            this.eventCombo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ EventEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        this.this$1.eventCombo.removeActionListener(this.this$1.comboSelectListener);
                        this.this$1.eventCombo.getEditor().getEditorComponent().removeFocusListener(this.this$1.comboEditFocusListener);
                        this.this$1.setValue(EventProperty.access$600(EventEditor.access$700(this.this$1)));
                    } else if (e.getKeyCode() == 10) {
                        this.this$1.eventCombo.removeActionListener(this.this$1.comboSelectListener);
                        this.this$1.eventCombo.getEditor().getEditorComponent().removeFocusListener(this.this$1.comboEditFocusListener);
                        String selected = (String)this.this$1.eventCombo.getEditor().getItem();
                        this.this$1.setValue(selected);
                        if (selected == null || "".equals(selected)) {
                            if (EventProperty.access$600(EventEditor.access$700(this.this$1)) != null) {
                                this.this$1.setValue(EventProperty.access$600(EventEditor.access$700(this.this$1)));
                            }
                        } else if (EventProperty.access$600(EventEditor.access$700(this.this$1)) != null) {
                            EventProperty.access$500(EventEditor.access$700(this.this$1)).attachEvent(EventEditor.access$700(this.this$1).getEvent(), EventProperty.access$600(EventEditor.access$700(this.this$1)), null);
                        }
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ EventEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    this.this$1.eventCombo.getEditor().getEditorComponent().requestFocus();
                }
            });
            return this.eventCombo;
        }

        public boolean hasInPlaceCustomEditor() {
            return !EventProperty.this.isReadOnly() || EventProperty.this.event.hasEventHandlers();
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public Component getCustomEditor() {
            if (EventProperty.this.isReadOnly()) {
                return null;
            }
            EventCustomEditor ed = new EventCustomEditor(EventProperty.this);
            DialogDescriptor dd = new DialogDescriptor((Object)ed, FormUtils.getFormattedBundleString("FMT_MSG_HandlersFor", new Object[]{EventProperty.this.getListenerMethod().getName()}), true, new ActionListener(this, ed){
                private final /* synthetic */ EventCustomEditor val$ed;
                private final /* synthetic */ EventEditor this$1;
                {
                    this.this$1 = this$1;
                    this.val$ed = val$ed;
                }

                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource().equals(NotifyDescriptor.OK_OPTION)) {
                        this.val$ed.doChanges();
                    }
                }
            });
            return DialogDisplayer.getDefault().createDialog(dd);
        }
    }

    static class Change {
        private List added;
        private List removed;
        private List renamedOldName;
        private List renamedNewName;

        Change() {
        }

        boolean hasAdded() {
            return this.added != null && this.added.size() > 0;
        }

        boolean hasRemoved() {
            return this.removed != null && this.removed.size() > 0;
        }

        boolean hasRenamed() {
            return this.renamedOldName != null && this.renamedOldName.size() > 0;
        }

        List getAdded() {
            if (this.added == null) {
                this.added = new ArrayList();
            }
            return this.added;
        }

        List getRemoved() {
            if (this.removed == null) {
                this.removed = new ArrayList();
            }
            return this.removed;
        }

        List getRenamedOldNames() {
            if (this.renamedOldName == null) {
                this.renamedOldName = new ArrayList();
            }
            return this.renamedOldName;
        }

        List getRenamedNewNames() {
            if (this.renamedNewName == null) {
                this.renamedNewName = new ArrayList();
            }
            return this.renamedNewName;
        }
    }
}

