/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import javax.accessibility.Accessible;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormCustomEditorAdvanced;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyCookie;
import org.netbeans.modules.form.FormPropertyEditor;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.RADProperty;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class FormCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    private static final int DEFAULT_WIDTH = 350;
    private static final int DEFAULT_HEIGHT = 350;
    private FormPropertyEditor editor;
    private PropertyEditor[] allEditors;
    private Component[] allCustomEditors;
    private boolean[] validValues;
    private String preCode;
    private String postCode;
    private JComboBox editorsCombo;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel cardPanel;
    private JButton advancedButton;
    static /* synthetic */ Class class$org$netbeans$modules$form$FormPropertyCookie;

    public FormCustomEditor(FormPropertyEditor editor, Component currentCustomEditor) {
        int currentIndex;
        this.initComponents();
        this.advancedButton.setText(FormUtils.getBundleString("CTL_Advanced"));
        this.advancedButton.setMnemonic(FormUtils.getBundleString("CTL_Advanced_mnemonic").charAt(0));
        if (editor.getProperty() instanceof RADProperty) {
            this.advancedButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    FormCustomEditor.this.showAdvancedSettings();
                }
            });
        } else {
            this.advancedButton.setEnabled(false);
        }
        this.jLabel1.setText(FormUtils.getBundleString("LAB_SelectMode"));
        this.jLabel1.setDisplayedMnemonic(FormUtils.getBundleString("LAB_SelectMode.mnemonic").charAt(0));
        this.jLabel1.setLabelFor(this.editorsCombo);
        this.editor = editor;
        this.preCode = editor.getProperty().getPreCode();
        this.postCode = editor.getProperty().getPostCode();
        this.allEditors = editor.getAllEditors();
        PropertyEditor currentEditor = editor.getCurrentEditor();
        if (currentEditor != null) {
            currentIndex = -1;
            int i = 0;
            while (i < this.allEditors.length) {
                if (currentEditor.getClass().equals(this.allEditors[i].getClass())) {
                    currentIndex = i;
                    this.allEditors[i] = currentEditor;
                    break;
                }
                ++i;
            }
            if (currentIndex == -1) {
                PropertyEditor[] editors = new PropertyEditor[this.allEditors.length + 1];
                editors[0] = currentEditor;
                System.arraycopy(this.allEditors, 0, editors, 1, this.allEditors.length);
                this.allEditors = editors;
                currentIndex = 0;
            }
        } else {
            currentIndex = 0;
        }
        this.allCustomEditors = new Component[this.allEditors.length];
        this.validValues = new boolean[this.allEditors.length];
        PropertyEnv env = editor.getPropertyEnv();
        Object currentValue = editor.getValue();
        int i = 0;
        while (i < this.allEditors.length) {
            PropertyEditor prEd = this.allEditors[i];
            editor.getPropertyContext().initPropertyEditor(prEd);
            boolean valueSet = false;
            if (i == currentIndex) {
                valueSet = true;
            } else {
                Object defaultValue;
                if (env != null && prEd instanceof ExPropertyEditor) {
                    ((ExPropertyEditor)prEd).attachEnv(env);
                }
                if (currentValue != null) {
                    Object realValue;
                    if (editor.getPropertyType().isAssignableFrom(currentValue.getClass())) {
                        prEd.setValue(currentValue);
                        valueSet = true;
                    } else if (currentValue instanceof FormDesignValue && (realValue = ((FormDesignValue)currentValue).getDesignValue()) != FormDesignValue.IGNORED_VALUE) {
                        prEd.setValue(realValue);
                        valueSet = true;
                    }
                }
                if (!valueSet && (defaultValue = editor.getProperty().getDefaultValue()) != BeanSupport.NO_VALUE) {
                    prEd.setValue(defaultValue);
                    valueSet = true;
                }
            }
            this.validValues[i] = valueSet;
            String editorName = prEd instanceof NamedPropertyEditor ? ((NamedPropertyEditor)prEd).getDisplayName() : Utilities.getShortClassName(prEd.getClass());
            Component custEd = null;
            if (i == currentIndex) {
                custEd = currentCustomEditor;
            } else if (prEd.supportsCustomEditor()) {
                custEd = prEd.getCustomEditor();
            }
            if (custEd == null || custEd instanceof Window) {
                JPanel p = new JPanel(new GridBagLayout());
                JLabel label = new JLabel(FormUtils.getBundleString("CTL_PropertyEditorDoesNot"));
                p.add(label);
                p.getAccessibleContext().setAccessibleDescription(label.getText());
                custEd = p;
            }
            this.allCustomEditors[i] = custEd;
            this.cardPanel.add(editorName, custEd);
            this.editorsCombo.addItem(editorName);
            ++i;
        }
        this.editorsCombo.setSelectedIndex(currentIndex);
        CardLayout cl = (CardLayout)this.cardPanel.getLayout();
        cl.show(this.cardPanel, (String)this.editorsCombo.getSelectedItem());
        this.editorsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CardLayout cl2 = (CardLayout)FormCustomEditor.this.cardPanel.getLayout();
                cl2.show(FormCustomEditor.this.cardPanel, (String)FormCustomEditor.this.editorsCombo.getSelectedItem());
                int i = FormCustomEditor.this.editorsCombo.getSelectedIndex();
                HelpCtx helpCtx = i < 0 ? null : HelpCtx.findHelp((Component)FormCustomEditor.this.cardPanel.getComponent(i));
                String helpID = helpCtx != null ? helpCtx.getHelpID() : "";
                HelpCtx.setHelpIDString((JComponent)FormCustomEditor.this, (String)helpID);
                FormCustomEditor.this.updateAccessibleDescription(i < 0 ? null : FormCustomEditor.this.cardPanel.getComponent(i));
            }
        });
        this.updateAccessibleDescription(this.cardPanel.getComponent(currentIndex));
        this.advancedButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_Advanced"));
        this.editorsCombo.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_BTN_SelectMode"));
    }

    private void updateAccessibleDescription(Component comp) {
        if (comp instanceof Accessible && comp.getAccessibleContext().getAccessibleDescription() != null) {
            this.getAccessibleContext().setAccessibleDescription(FormUtils.getFormattedBundleString("ACSD_FormCustomEditor", new Object[]{comp.getAccessibleContext().getAccessibleDescription()}));
        } else {
            this.getAccessibleContext().setAccessibleDescription(null);
        }
    }

    private void initComponents() {
        this.editorsCombo = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.cardPanel = new JPanel();
        this.advancedButton = new JButton();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new Insets(12, 5, 0, 11);
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.editorsCombo, gridBagConstraints1);
        this.jLabel1.setText("jLabel1");
        this.jLabel1.setLabelFor(this.editorsCombo);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(12, 12, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints1);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new EtchedBorder());
        this.cardPanel.setLayout(new CardLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(12, 12, 11, 11);
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.jPanel1.add((Component)this.cardPanel, gridBagConstraints2);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(12, 12, 0, 11);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints1);
        this.advancedButton.setText("jButton1");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.gridheight = 0;
        gridBagConstraints1.insets = new Insets(12, 12, 0, 11);
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.advancedButton, gridBagConstraints1);
    }

    public Dimension getPreferredSize() {
        Dimension inh = super.getPreferredSize();
        return new Dimension(Math.max(inh.width, 350), Math.max(inh.height, 350));
    }

    private void showAdvancedSettings() {
        FormCustomEditorAdvanced fcea = new FormCustomEditorAdvanced(this.preCode, this.postCode);
        DialogDescriptor dd = new DialogDescriptor((Object)fcea, FormUtils.getFormattedBundleString("FMT_CTL_AdvancedInitializationCode", new Object[]{((FeatureDescriptor)((Object)this.editor.getProperty())).getName()}));
        dd.setHelpCtx(new HelpCtx("gui.source.modifying.property"));
        DialogDisplayer.getDefault().createDialog(dd).show();
        if (dd.getValue() == NotifyDescriptor.OK_OPTION) {
            this.preCode = fcea.getPreCode();
            this.postCode = fcea.getPostCode();
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        Component currentCustomEditor;
        int currentIndex = this.editorsCombo.getSelectedIndex();
        PropertyEditor currentEditor = currentIndex > -1 ? this.allEditors[currentIndex] : null;
        Component component = currentCustomEditor = currentIndex > -1 ? this.allCustomEditors[currentIndex] : null;
        Object value = currentCustomEditor instanceof EnhancedCustomPropertyEditor ? ((EnhancedCustomPropertyEditor)currentCustomEditor).getPropertyValue() : (currentIndex > -1 ? (this.validValues[currentIndex] ? currentEditor.getValue() : BeanSupport.NO_VALUE) : this.editor.getValue());
        if (currentIndex > -1) {
            Object[] nodes = this.editor.getPropertyEnv().getBeans();
            if (nodes == null || nodes.length <= 1) {
                FormProperty prop = this.editor.getProperty();
                prop.setPreCode(this.preCode);
                prop.setPostCode(this.postCode);
                value = new FormProperty.ValueWithEditor(value, currentEditor);
            } else {
                String propName = ((FeatureDescriptor)((Object)this.editor.getProperty())).getName();
                int i = 0;
                while (i < nodes.length) {
                    Node node;
                    FormPropertyCookie propCookie;
                    if (!(nodes[i] instanceof Node) || (propCookie = (FormPropertyCookie)(node = (Node)nodes[i]).getCookie(class$org$netbeans$modules$form$FormPropertyCookie == null ? FormCustomEditor.class$("org.netbeans.modules.form.FormPropertyCookie") : class$org$netbeans$modules$form$FormPropertyCookie)) == null) break;
                    FormProperty prop = propCookie.getProperty(propName);
                    if (prop != null) {
                        prop.setPreCode(this.preCode);
                        prop.setPostCode(this.postCode);
                    }
                    ++i;
                }
                value = new FormProperty.ValueWithEditor(value, currentIndex);
            }
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

