/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.ComponentLayer;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.HandleLayer;
import org.netbeans.modules.form.InPlaceEditLayer;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.netbeans.modules.form.VisualReplicator;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.wizard.ConnectionWizard;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class FormDesigner
extends TopComponent {
    static final String FORM_MODE_NAME = "Form";
    static final String PROP_DESIGNER_SIZE = "designerSize";
    private JLayeredPane layeredPane;
    private ComponentLayer componentLayer;
    private HandleLayer handleLayer;
    private InPlaceEditLayer textEditLayer;
    private FormProperty editedProperty;
    private RADVisualComponent topDesignComponent;
    private FormModel formModel;
    private FormModelListener formModelListener;
    private FormEditorSupport formEditorSupport;
    private VisualReplicator replicator = new VisualReplicator(null, new Class[]{class$java$awt$Window == null ? (class$java$awt$Window = FormDesigner.class$("java.awt.Window")) : class$java$awt$Window, class$java$applet$Applet == null ? (class$java$applet$Applet = FormDesigner.class$("java.applet.Applet")) : class$java$applet$Applet, class$java$awt$MenuComponent == null ? (class$java$awt$MenuComponent = FormDesigner.class$("java.awt.MenuComponent")) : class$java$awt$MenuComponent}, 3);
    private final ArrayList selectedComponents = new ArrayList();
    private RADComponent connectionSource;
    private RADComponent connectionTarget;
    private static String iconURL = "org/netbeans/modules/form/resources/formDesigner.gif";
    static /* synthetic */ Class class$java$awt$Window;
    static /* synthetic */ Class class$java$applet$Applet;
    static /* synthetic */ Class class$java$awt$MenuComponent;
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$javax$swing$RootPaneContainer;

    public FormDesigner() {
        this(null);
    }

    FormDesigner(FormModel formModel) {
        ((JComponent)((Object)this)).putClientProperty("PersistenceType", "OnlyOpened");
        this.setIcon(Utilities.loadImage((String)iconURL));
        this.formModelListener = new FormListener();
        this.componentLayer = new ComponentLayer();
        this.handleLayer = new HandleLayer(this);
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setLayout(new OverlayLayout(this.layeredPane));
        this.layeredPane.add((Component)this.componentLayer, new Integer(1000));
        this.layeredPane.add((Component)this.handleLayer, new Integer(1001));
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add(new JScrollPane(this.layeredPane), "Center");
        this.setModel(formModel);
    }

    public void initialize() {
        this.updateWholeDesigner();
    }

    void setModel(FormModel m) {
        if (this.formModel != null) {
            this.formModel.removeFormModelListener(this.formModelListener);
            this.topDesignComponent = null;
        }
        this.formModel = m;
        if (this.formModel != null) {
            this.formModel.addFormModelListener(this.formModelListener);
            this.formEditorSupport = FormEditorSupport.getSupport(this.formModel);
            this.resetTopDesignComponent(false);
            this.updateName(this.formModel.getName());
            this.handleLayer.setViewOnly(this.formModel.isReadOnly());
            this.componentLayer.updateDesignerSize(this.getStoredDesignerSize());
        } else {
            this.formEditorSupport = null;
        }
    }

    FormModel getModel() {
        return this.formModel;
    }

    FormEditorSupport getFormEditorSupport() {
        return this.formEditorSupport;
    }

    public Object getComponent(RADComponent metacomp) {
        return this.replicator.getClonedComponent(metacomp);
    }

    public RADComponent getMetaComponent(Object comp) {
        return this.replicator.getMetaComponent(comp);
    }

    ComponentLayer getComponentLayer() {
        return this.componentLayer;
    }

    public RADVisualComponent getTopDesignComponent() {
        return this.topDesignComponent;
    }

    public void setTopDesignComponent(RADVisualComponent component, boolean update) {
        this.topDesignComponent = component;
        if (update) {
            this.setSelectedComponent(this.topDesignComponent);
            this.updateWholeDesigner();
        }
    }

    public void resetTopDesignComponent(boolean update) {
        this.topDesignComponent = this.formModel.getTopRADComponent() instanceof RADVisualComponent ? (RADVisualComponent)this.formModel.getTopRADComponent() : null;
        if (update) {
            this.setSelectedComponent(this.topDesignComponent);
            this.updateWholeDesigner();
        }
    }

    public boolean isInDesignedTree(RADComponent metacomp) {
        return this.topDesignComponent != null && (this.topDesignComponent == metacomp || this.topDesignComponent.isParentComponent(metacomp));
    }

    void updateWholeDesigner() {
        if (this.formModelListener != null) {
            this.formModelListener.formChanged(null);
        }
        this.updateName(this.formModel.getName());
    }

    public static Container createFormView(final RADVisualComponent metacomp, final Class contClass) throws Exception {
        return (Container)FormLAF.executeWithLookAndFeel(new Mutex.ExceptionAction(){

            public Object run() throws Exception {
                VisualReplicator r = new VisualReplicator(contClass, null, 0);
                r.setTopMetaComponent(metacomp);
                return r.createClone();
            }
        });
    }

    Dimension getStoredDesignerSize() {
        RADComponent metacomp = this.formModel.getTopRADComponent();
        if (metacomp == null) {
            return null;
        }
        return (Dimension)metacomp.getAuxValue(PROP_DESIGNER_SIZE);
    }

    void setStoredDesignerSize(Dimension size) {
        RADComponent metacomp = this.formModel.getTopRADComponent();
        if (metacomp instanceof RADVisualFormContainer) {
            ((RADVisualFormContainer)metacomp).setDesignerSize(size);
        } else if (metacomp != null) {
            metacomp.setAuxValue(PROP_DESIGNER_SIZE, size);
        }
    }

    List getSelectedComponents() {
        return this.selectedComponents;
    }

    boolean isComponentSelected(RADComponent metacomp) {
        return this.selectedComponents.contains(metacomp);
    }

    void setSelectedComponent(RADComponent metacomp) {
        this.clearSelectionImpl();
        this.addComponentToSelectionImpl(metacomp);
        this.repaintSelection();
        this.updateActivatedNodes();
    }

    void setSelectedComponents(RADComponent[] metacomps) {
        this.clearSelectionImpl();
        int i = 0;
        while (i < metacomps.length) {
            this.addComponentToSelectionImpl(metacomps[i]);
            ++i;
        }
        this.repaintSelection();
        this.updateActivatedNodes();
    }

    void setSelectedNode(FormNode node) {
        if (node instanceof RADComponentNode) {
            this.setSelectedComponent(((RADComponentNode)node).getRADComponent());
        } else {
            this.clearSelectionImpl();
            this.repaintSelection();
            ComponentInspector ci = ComponentInspector.getInstance();
            if (ci.getFocusedForm() != this.formEditorSupport) {
                return;
            }
            Node[] selectedNodes = new Node[]{node};
            try {
                ci.setSelectedNodes(selectedNodes, this.formEditorSupport);
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
            this.setActivatedNodes(selectedNodes);
        }
    }

    void addComponentToSelection(RADComponent metacomp) {
        this.addComponentToSelectionImpl(metacomp);
        this.repaintSelection();
        this.updateActivatedNodes();
    }

    void addComponentsToSelection(RADComponent[] metacomps) {
        int i = 0;
        while (i < metacomps.length) {
            this.addComponentToSelectionImpl(metacomps[i]);
            ++i;
        }
        this.repaintSelection();
        this.updateActivatedNodes();
    }

    void removeComponentFromSelection(RADComponent metacomp) {
        this.removeComponentFromSelectionImpl(metacomp);
        this.repaintSelection();
        this.updateActivatedNodes();
    }

    public void clearSelection() {
        this.clearSelectionImpl();
        this.repaintSelection();
        this.updateActivatedNodes();
    }

    void addComponentToSelectionImpl(RADComponent metacomp) {
        if (metacomp != null) {
            this.selectedComponents.add(metacomp);
            if (metacomp instanceof RADVisualComponent) {
                this.ensureComponentIsShown((RADVisualComponent)metacomp);
            }
        }
    }

    void removeComponentFromSelectionImpl(RADComponent metacomp) {
        ((AbstractCollection)this.selectedComponents).remove(metacomp);
    }

    void clearSelectionImpl() {
        this.selectedComponents.clear();
    }

    void repaintSelection() {
        this.handleLayer.repaint();
    }

    RADVisualComponent getNextVisualComponent(boolean forward) {
        RADVisualComponent currentComp = null;
        int n = this.selectedComponents.size();
        if (n > 0) {
            if (n > 1) {
                return null;
            }
            Object sel = this.selectedComponents.get(0);
            if (sel instanceof RADVisualComponent) {
                currentComp = (RADVisualComponent)sel;
            } else {
                return null;
            }
        }
        return this.getNextVisualComponent(currentComp, forward);
    }

    RADVisualComponent getNextVisualComponent(RADVisualComponent comp, boolean forward) {
        RADVisualComponent[] subComps2;
        if (comp == null) {
            return this.topDesignComponent;
        }
        if (this.getComponent(comp) == null) {
            return null;
        }
        if (forward) {
            RADVisualComponent[] subComps2;
            if (comp instanceof RADVisualContainer && (subComps2 = ((RADVisualContainer)comp).getSubComponents()).length > 0) {
                return subComps2[0];
            }
            if (comp == this.topDesignComponent) {
                return this.topDesignComponent;
            }
            RADVisualContainer cont = comp.getParentContainer();
            if (cont == null) {
                return null;
            }
            int i = cont.getIndexOf(comp);
            while (i >= 0) {
                subComps2 = cont.getSubComponents();
                if (i + 1 < subComps2.length) {
                    return subComps2[i + 1];
                }
                if (cont == this.topDesignComponent) break;
                comp = cont;
                if ((cont = comp.getParentContainer()) == null) {
                    return null;
                }
                i = cont.getIndexOf(comp);
            }
            return this.topDesignComponent;
        }
        if (comp != this.topDesignComponent) {
            RADVisualContainer cont = comp.getParentContainer();
            if (cont == null) {
                return null;
            }
            int i = cont.getIndexOf(comp);
            if (i >= 0) {
                if (i == 0) {
                    return cont;
                }
                subComps2 = cont.getSubComponents();
                comp = subComps2[i - 1];
            } else {
                comp = this.topDesignComponent;
            }
        }
        while (comp instanceof RADVisualContainer && (subComps2 = ((RADVisualContainer)comp).getSubComponents()).length > 0) {
            comp = subComps2[subComps2.length - 1];
        }
        return comp;
    }

    void updateActivatedNodes() {
        ComponentInspector ci = ComponentInspector.getInstance();
        if (ci.getFocusedForm() != this.formEditorSupport) {
            return;
        }
        Node[] selectedNodes = new Node[this.selectedComponents.size()];
        Iterator iter = ((AbstractList)this.selectedComponents).iterator();
        int i = 0;
        while (iter.hasNext()) {
            RADComponent metacomp = (RADComponent)iter.next();
            selectedNodes[i++] = metacomp.getNodeReference();
        }
        try {
            ci.setSelectedNodes(selectedNodes, this.formEditorSupport);
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
        this.setActivatedNodes(selectedNodes);
    }

    void updateName(String name) {
        if (this.topDesignComponent != null && this.topDesignComponent != this.formModel.getTopRADComponent()) {
            name = name + " / " + this.topDesignComponent.getName();
        }
        if (this.formModel.isReadOnly()) {
            name = name + " " + FormUtils.getBundleString("CTL_FormTitle_RO");
        }
        this.setName(name);
        this.setToolTipText(name);
    }

    void updateVisualSettings() {
        this.componentLayer.updateVisualSettings();
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
    }

    private void ensureComponentIsShown(RADVisualComponent metacomp) {
        Component comp = (Component)this.getComponent(metacomp);
        RADVisualContainer metacont = metacomp.getParentContainer();
        if (comp == null) {
            if (metacont != null) {
                metacont.getLayoutSupport().selectComponent(metacont.getIndexOf(metacomp));
            }
            return;
        }
        if (comp.isShowing()) {
            return;
        }
        if (!this.isInDesignedTree(metacomp)) {
            return;
        }
        Component topComp = (Component)this.getComponent(this.topDesignComponent);
        if (topComp == null || !topComp.isShowing()) {
            return;
        }
        RADVisualComponent child = metacomp;
        while (metacont != null) {
            Container cont = (Container)this.getComponent(metacont);
            LayoutSupportManager laysup = metacont.getLayoutSupport();
            Container contDelegate = metacont.getContainerDelegate(cont);
            laysup.selectComponent(child.getComponentIndex());
            laysup.arrangeContainer(cont, contDelegate);
            if (metacont == this.topDesignComponent || cont.isShowing()) break;
            child = metacont;
            metacont = metacont.getParentContainer();
        }
    }

    void connectBean(RADComponent metacomp, boolean showDialog) {
        if (this.connectionSource == null) {
            this.connectionSource = metacomp;
            this.handleLayer.repaint();
        } else {
            if (metacomp == this.connectionSource) {
                if (this.connectionTarget != null) {
                    this.resetConnection();
                    CPManager.getDefault().setMode(0);
                }
                return;
            }
            this.connectionTarget = metacomp;
            this.handleLayer.repaint();
            if (showDialog) {
                if (this.connectionTarget != null) {
                    this.createConnection(this.connectionSource, this.connectionTarget);
                }
                CPManager.getDefault().setMode(0);
            }
        }
    }

    public RADComponent getConnectionSource() {
        return this.connectionSource;
    }

    public RADComponent getConnectionTarget() {
        return this.connectionTarget;
    }

    public void resetConnection() {
        if (this.connectionSource != null || this.connectionTarget != null) {
            this.connectionSource = null;
            this.connectionTarget = null;
            this.handleLayer.repaint();
        }
    }

    private void createConnection(RADComponent source, RADComponent target) {
        ConnectionWizard cw = new ConnectionWizard(this.formModel, source, target);
        if (cw.show()) {
            final Event event = cw.getSelectedEvent();
            final String eventName = cw.getEventName();
            String bodyText = cw.getGeneratedCode();
            this.formModel.getFormEvents().attachEvent(event, eventName, bodyText);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FormDesigner.this.formModel.getFormEvents().attachEvent(event, eventName, null);
                }
            });
        }
    }

    public void startInPlaceEditing(RADComponent metacomp) {
        if (this.formModel.isReadOnly()) {
            return;
        }
        if (this.textEditLayer != null && this.textEditLayer.isVisible()) {
            return;
        }
        if (!this.isEditableInPlace(metacomp)) {
            return;
        }
        Component comp = (Component)this.getComponent(metacomp);
        if (comp == null) {
            this.notifyCannotEditInPlace();
            return;
        }
        RADProperty property = metacomp.getBeanProperty("text");
        if (property == null) {
            return;
        }
        String editText = null;
        try {
            Object text = property.getRealValue();
            if (!(text instanceof String)) {
                text = "";
            }
            editText = (String)text;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.editedProperty = property;
        if (this.textEditLayer == null) {
            this.textEditLayer = new InPlaceEditLayer();
            this.textEditLayer.setVisible(false);
            this.textEditLayer.addFinishListener(new InPlaceEditLayer.FinishListener(){

                public void editingFinished(boolean textChanged) {
                    FormDesigner.this.finishInPlaceEditing(FormDesigner.this.textEditLayer.isTextChanged());
                }
            });
            this.layeredPane.add((Component)this.textEditLayer, new Integer(2001));
        }
        try {
            this.textEditLayer.setEditedComponent(comp, editText);
        }
        catch (IllegalArgumentException ex) {
            this.notifyCannotEditInPlace();
            return;
        }
        this.textEditLayer.requestFocus();
        this.textEditLayer.setVisible(true);
        this.handleLayer.setVisible(false);
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
    }

    private void finishInPlaceEditing(boolean applyChanges) {
        if (applyChanges) {
            try {
                this.editedProperty.setValue(this.textEditLayer.getEditedText());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.textEditLayer.setVisible(false);
        this.handleLayer.setVisible(true);
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
        this.handleLayer.requestFocus();
        this.editedProperty = null;
    }

    public boolean isEditableInPlace(RADComponent metacomp) {
        Component comp = (Component)this.getComponent(metacomp);
        if (comp == null) {
            return false;
        }
        RADComponent parent = metacomp.getParentComponent();
        while (parent != null) {
            if (!(class$javax$swing$JComponent == null ? FormDesigner.class$("javax.swing.JComponent") : class$javax$swing$JComponent).isAssignableFrom(parent.getBeanClass()) && !(class$javax$swing$RootPaneContainer == null ? FormDesigner.class$("javax.swing.RootPaneContainer") : class$javax$swing$RootPaneContainer).isAssignableFrom(parent.getBeanClass())) {
                return false;
            }
            parent = parent.getParentComponent();
        }
        return InPlaceEditLayer.supportsEditingFor(metacomp.getBeanClass(), false);
    }

    private void notifyCannotEditInPlace() {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormUtils.getBundleString("MSG_ComponentNotShown"), 2));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.formeditor");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.formEditorSupport == null) {
            return;
        }
        super.writeExternal(out);
        out.writeObject((Object)this.formEditorSupport.getFormDataObject());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        Object o = in.readObject();
        if (o instanceof FormDataObject) {
            this.formEditorSupport = ((FormDataObject)((Object)o)).getFormEditor();
            this.formEditorSupport.setFormDesigner(this);
            if (!this.formEditorSupport.isOpened()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (FormDesigner.this.formEditorSupport.loadForm()) {
                            FormDesigner.this.setModel(FormDesigner.this.formEditorSupport.getFormModel());
                            FormDesigner.this.initialize();
                            ComponentInspector.getInstance().focusForm(FormDesigner.this.formEditorSupport);
                            if (FormDesigner.this.formEditorSupport.getOpenedPanes() == null) {
                                FormDesigner.this.formEditorSupport.open();
                            }
                        }
                    }
                });
            }
        }
    }

    public void open(Workspace workspace) {
        if (workspace == null) {
            workspace = WindowManager.getDefault().getCurrentWorkspace();
        }
        if (this.isOpened(workspace)) {
            return;
        }
        Mode mode = workspace.findMode(FORM_MODE_NAME);
        if (mode != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open(workspace);
    }

    public boolean canClose(Workspace workspace, boolean last) {
        boolean canClose = super.canClose(workspace, last);
        if (canClose && this.isOpened() && this.formEditorSupport != null) {
            this.formEditorSupport.designerToBeClosed(workspace);
        }
        return canClose;
    }

    protected void componentActivated() {
        super.componentActivated();
        if (this.formModel == null) {
            return;
        }
        ComponentInspector ci = ComponentInspector.getInstance();
        if (ci.getFocusedForm() != this.formEditorSupport) {
            ComponentInspector.getInstance().focusForm(this.formEditorSupport);
            if (CPManager.getDefault().getMode() == 1) {
                this.clearSelection();
            } else {
                this.updateActivatedNodes();
            }
        }
        ci.attachActions();
        if (this.textEditLayer == null || !this.textEditLayer.isVisible()) {
            this.handleLayer.requestFocus();
        }
    }

    protected void componentDeactivated() {
        if (this.formModel == null) {
            return;
        }
        if (this.textEditLayer != null && this.textEditLayer.isVisible()) {
            this.textEditLayer.finishEditing(false);
        }
        ComponentInspector.getInstance().detachActions();
        this.resetConnection();
        super.componentDeactivated();
    }

    public UndoRedo getUndoRedo() {
        UndoRedo.Manager ur = this.formModel != null ? this.formModel.getUndoRedoManager() : null;
        return ur != null ? ur : super.getUndoRedo();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FormListener
    implements FormModelListener,
    Runnable {
        private FormModelEvent[] events;

        private FormListener() {
        }

        public void formChanged(FormModelEvent[] events) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(this, events){
                    private final /* synthetic */ FormModelEvent[] val$events;
                    private final /* synthetic */ FormListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$events = val$events;
                    }

                    public void run() {
                        FormListener.access$500(this.this$1, this.val$events);
                    }
                });
            } else {
                this.processEvents(events);
            }
        }

        private void processEvents(FormModelEvent[] events) {
            boolean lafBlock;
            this.events = events;
            if (events == null) {
                lafBlock = true;
            } else {
                lafBlock = false;
                boolean modifying = false;
                int i = 0;
                while (i < events.length) {
                    FormModelEvent ev = events[i];
                    if (ev.isModifying()) {
                        modifying = true;
                    }
                    if (ev.getChangeType() == 7 && ev.getCreatedDeleted()) {
                        lafBlock = true;
                        break;
                    }
                    ++i;
                }
                if (!modifying) {
                    return;
                }
            }
            if (lafBlock) {
                FormLAF.executeWithLookAndFeel(this);
            } else {
                this.performUpdates();
            }
        }

        public void run() {
            this.performUpdates();
        }

        private void performUpdates() {
            Component comp;
            if (this.events == null) {
                FormDesigner.this.replicator.setTopMetaComponent(FormDesigner.this.topDesignComponent);
                Component formClone = (Component)FormDesigner.this.replicator.createClone();
                if (formClone != null) {
                    formClone.setVisible(true);
                    FormDesigner.this.componentLayer.setTopDesignComponent(formClone);
                }
                FormDesigner.this.updateName(FormDesigner.this.formModel.getName());
                return;
            }
            FormModelEvent[] events = this.events;
            this.events = null;
            int prevType = 0;
            ComponentContainer prevContainer = null;
            boolean updateDone = false;
            int i = 0;
            while (i < events.length) {
                FormModelEvent ev = events[i];
                int type = ev.getChangeType();
                ComponentContainer metacont = ev.getContainer();
                if (type == 4 || type == 5 || type == 6) {
                    if (prevType != 4 && prevType != 5 && prevType != 6 || prevContainer != metacont) {
                        FormDesigner.this.replicator.updateContainerLayout((RADVisualContainer)metacont);
                        updateDone = true;
                    }
                } else if (type == 7) {
                    if (prevType != 7 || prevContainer != metacont) {
                        FormDesigner.this.replicator.updateAddedComponents(metacont);
                        updateDone = true;
                    }
                } else if (type == 8) {
                    RADComponent removed = ev.getComponent();
                    if (removed instanceof RADVisualComponent && (removed == FormDesigner.this.topDesignComponent || removed.isParentComponent(FormDesigner.this.topDesignComponent))) {
                        FormDesigner.this.resetTopDesignComponent(false);
                        FormDesigner.this.updateWholeDesigner();
                        return;
                    }
                    FormDesigner.this.replicator.removeComponent(ev.getComponent(), ev.getContainer());
                    updateDone = true;
                } else if (type == 9) {
                    if (prevType != 9 || prevContainer != metacont) {
                        FormDesigner.this.replicator.reorderComponents(metacont);
                        updateDone = true;
                    }
                } else if (type == 10) {
                    FormDesigner.this.replicator.updateComponentProperty(ev.getComponentProperty());
                    updateDone = true;
                } else if (type == 11 && FormDesigner.PROP_DESIGNER_SIZE.equals(ev.getPropertyName())) {
                    FormDesigner.this.componentLayer.updateDesignerSize(FormDesigner.this.getStoredDesignerSize());
                }
                prevType = type;
                prevContainer = metacont;
                ++i;
            }
            if (updateDone && (comp = (Component)FormDesigner.this.getComponent(FormDesigner.this.topDesignComponent)) != null && (comp = comp.getParent()) != null) {
                comp.invalidate();
                comp.validate();
                comp.repaint();
            }
        }

        static /* synthetic */ void access$500(FormListener x0, FormModelEvent[] x1) {
            x0.processEvents(x1);
        }
    }
}

