/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormRootNode;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.PersistenceException;
import org.netbeans.modules.form.PersistenceManager;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.PaletteTopComponent;
import org.netbeans.modules.java.JavaEditor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.Task;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class FormEditorSupport
extends JavaEditor {
    static final String NO_WORKSPACE = "None";
    private static final int LOADING = 1;
    private static final int SAVING = 2;
    private FormModel formModel;
    private FormDataObject formDataObject;
    private FormRootNode formRootNode;
    private FormDesigner formDesigner;
    private ArrayList floatingWindows;
    private PersistenceManager persistenceManager;
    private ArrayList persistenceErrors;
    private boolean formLoaded = false;
    private boolean openOnEditing = false;
    private FormModelListener formListener;
    private static PropertyChangeListener workspacesListener;
    private static PropertyChangeListener settingsListener;
    private static PropertyChangeListener topcompsListener;
    private static PropertyChangeListener paletteListener;
    private UndoRedo.Manager editorUndoManager;
    private static Hashtable openForms;
    static ClassLoader userClassLoader;

    public FormEditorSupport(MultiDataObject.Entry javaEntry, FormDataObject formDataObject) {
        super(javaEntry);
        this.formDataObject = formDataObject;
    }

    public void openForm() {
        StatusDisplayer.getDefault().setStatusText(FormUtils.getFormattedBundleString("FMT_OpeningForm", new Object[]{this.formDataObject.getPrimaryFile().getNameExt()}));
        final boolean openGui = this.activateWorkspace();
        this.open();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JFrame mainWin = (JFrame)WindowManager.getDefault().getMainWindow();
                StatusDisplayer.getDefault().setStatusText(FormUtils.getFormattedBundleString("FMT_OpeningForm", new Object[]{FormEditorSupport.this.formDataObject.getFormFile().getNameExt()}));
                RepaintManager.currentManager(mainWin).paintDirtyRegions();
                mainWin.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
                mainWin.getGlassPane().setVisible(true);
                try {
                    FormEditorSupport.this.loadFormData();
                }
                catch (PersistenceException ex) {
                    FormEditorSupport.this.logPersistenceError(ex, 0);
                }
                if (FormEditorSupport.this.formLoaded) {
                    if (openGui) {
                        FormEditorSupport.this.openGUI();
                    } else {
                        ComponentInspector.getInstance().focusForm(FormEditorSupport.this);
                    }
                }
                StatusDisplayer.getDefault().setStatusText("");
                mainWin.getGlassPane().setVisible(false);
                mainWin.getGlassPane().setCursor(null);
                FormEditorSupport.this.reportErrors(1);
            }
        });
    }

    public boolean loadForm() {
        if (this.formLoaded) {
            return true;
        }
        if (EventQueue.isDispatchThread()) {
            try {
                this.loadFormData();
            }
            catch (PersistenceException ex) {
                this.logPersistenceError(ex, 0);
            }
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        try {
                            FormEditorSupport.this.loadFormData();
                        }
                        catch (PersistenceException ex) {
                            FormEditorSupport.this.logPersistenceError(ex, 0);
                        }
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.formLoaded;
    }

    public boolean isOpened() {
        return this.formLoaded;
    }

    public void saveDocument() throws IOException {
        IOException ioEx = null;
        try {
            this.saveFormData();
            super.saveDocument();
        }
        catch (PersistenceException ex) {
            Throwable t = ex.getOriginalException();
            if (t instanceof IOException) {
                ioEx = (IOException)t;
            }
            ioEx = new IOException("Cannot save the form");
            ErrorManager.getDefault().annotate((Throwable)ioEx, t != null ? t : ex);
        }
        this.reportErrors(2);
        if (ioEx != null) {
            throw ioEx;
        }
    }

    protected void saveDocumentIfNecessary(boolean parse) throws IOException {
        IOException ioEx = null;
        try {
            this.saveFormData();
            super.saveDocumentIfNecessary(parse);
        }
        catch (PersistenceException ex) {
            Throwable t = ex.getOriginalException();
            if (t instanceof IOException) {
                ioEx = (IOException)t;
            }
            ioEx = new IOException("Cannot save the form");
            ErrorManager.getDefault().annotate((Throwable)ioEx, t != null ? t : ex);
        }
        this.reportErrors(2);
        if (ioEx != null) {
            throw ioEx;
        }
    }

    public boolean saveForm() {
        try {
            this.saveFormData();
            return true;
        }
        catch (PersistenceException ex) {
            this.logPersistenceError(ex, 0);
            return false;
        }
    }

    public final FormDataObject getFormDataObject() {
        return this.formDataObject;
    }

    public final Node getFormRootNode() {
        return this.formRootNode;
    }

    public final FormModel getFormModel() {
        return this.formModel;
    }

    public Throwable[] getPersistenceErrors() {
        if (!this.anyPersistenceError()) {
            return new Throwable[0];
        }
        Throwable[] errors = new Throwable[this.persistenceErrors.size()];
        this.persistenceErrors.toArray(errors);
        return errors;
    }

    public void reportErrors(int operation) {
        if (!this.anyPersistenceError()) {
            return;
        }
        ErrorManager errorManager = ErrorManager.getDefault();
        boolean checkLoadingErrors = operation == 1 && this.formLoaded;
        boolean anyNonFatalLoadingError = false;
        Iterator it = ((AbstractList)this.persistenceErrors).iterator();
        while (it.hasNext()) {
            Throwable th;
            Throwable t = (Throwable)it.next();
            if (t instanceof PersistenceException && (th = ((PersistenceException)t).getOriginalException()) != null) {
                t = th;
            }
            if (checkLoadingErrors && !anyNonFatalLoadingError) {
                ErrorManager.Annotation[] annotations = errorManager.findAnnotations(t);
                int severity = 0;
                if (annotations != null) {
                    int i = 0;
                    while (i < annotations.length) {
                        int s = annotations[i].getSeverity();
                        if (s > severity) {
                            severity = s;
                        }
                        ++i;
                    }
                } else {
                    severity = 4096;
                }
                if (severity > 16) {
                    anyNonFatalLoadingError = true;
                }
            }
            errorManager.notify(t);
        }
        if (checkLoadingErrors && anyNonFatalLoadingError) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)FormUtils.getBundleString("MSG_FormLoadedWithErrors"), FormUtils.getBundleString("CTL_FormLoadedWithErrors"), -1, 2, new Object[]{NotifyDescriptor.OK_OPTION}, null));
                }
            });
        }
        this.resetPersistenceErrorLog();
    }

    public void registerFloatingWindow(Window window) {
        if (this.floatingWindows == null) {
            this.floatingWindows = new ArrayList();
        } else {
            ((AbstractCollection)this.floatingWindows).remove(window);
        }
        this.floatingWindows.add(window);
    }

    public void unregisterFloatingWindow(Window window) {
        if (this.floatingWindows != null) {
            ((AbstractCollection)this.floatingWindows).remove(window);
        }
    }

    FormDesigner getFormDesigner() {
        if (!this.formLoaded) {
            return null;
        }
        if (this.formDesigner == null) {
            this.formDesigner = new FormDesigner(this.formModel);
            if (this.formListener != null) {
                this.formModel.removeFormModelListener(this.formListener);
                this.formModel.addFormModelListener(this.formListener);
            }
        } else if (this.formDesigner.getModel() == null) {
            this.formDesigner.setModel(this.formModel);
        }
        return this.formDesigner;
    }

    void setFormDesigner(FormDesigner formDesigner) {
        this.formDesigner = formDesigner;
    }

    void markFormModified() {
        if (this.formLoaded && !this.formDataObject.isModified()) {
            super.notifyModified();
        }
    }

    void updateFormName(String name) {
        if (!this.formLoaded) {
            return;
        }
        this.formModel.setName(name);
        this.formModel.getFormDesigner().updateName(name);
        this.formRootNode.updateName(name);
        this.formModel.fireFormChanged();
    }

    void updateNodeChildren(ComponentContainer metacont) {
        FormNode node = metacont == null || metacont == this.formModel.getModelContainer() ? (this.formRootNode != null ? this.formRootNode.getOthersNode() : null) : (metacont instanceof RADComponent ? ((RADComponent)((Object)metacont)).getNodeReference() : null);
        if (node != null) {
            node.updateChildren();
        }
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        this.editorUndoManager = super.createUndoRedoManager();
        return this.editorUndoManager;
    }

    void discardEditorUndoableEdits() {
        if (this.editorUndoManager != null) {
            this.editorUndoManager.discardAllEdits();
        }
    }

    UndoRedo.Manager getFormUndoRedoManager() {
        return this.formModel != null ? this.formModel.getUndoRedoManager() : null;
    }

    public static FormModel[] getOpenedForms() {
        Hashtable hashtable = openForms;
        synchronized (hashtable) {
            Collection forms = openForms.values();
            ArrayList<FormModel> list = new ArrayList<FormModel>(forms.size());
            Iterator it = forms.iterator();
            while (it.hasNext()) {
                FormEditorSupport fes = (FormEditorSupport)((Object)it.next());
                if (!fes.formLoaded) continue;
                list.add(fes.getFormModel());
            }
            FormModel[] formsArray = new FormModel[list.size()];
            list.toArray(formsArray);
            FormModel[] formModelArray = formsArray;
            return formModelArray;
        }
    }

    public static FormDesigner getFormDesigner(FormModel formModel) {
        FormEditorSupport fes = (FormEditorSupport)((Object)openForms.get(formModel));
        return fes != null ? fes.getFormDesigner() : null;
    }

    public static FormDataObject getFormDataObject(FormModel formModel) {
        FormEditorSupport fes = (FormEditorSupport)((Object)openForms.get(formModel));
        return fes != null ? fes.getFormDataObject() : null;
    }

    public static FormEditorSupport getSupport(FormModel formModel) {
        return (FormEditorSupport)((Object)openForms.get(formModel));
    }

    private void superOpen() {
        super.open();
    }

    private void openForm(boolean dontSwitchWS, final boolean openGui) {
        if (!dontSwitchWS) {
            this.activateWorkspace();
        }
        this.open();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    FormEditorSupport.this.loadFormData();
                }
                catch (PersistenceException ex) {
                    FormEditorSupport.this.logPersistenceError(ex, 0);
                }
                if (FormEditorSupport.this.formLoaded) {
                    if (openGui) {
                        FormEditorSupport.this.openGUI();
                    } else {
                        ComponentInspector.getInstance().focusForm(FormEditorSupport.this);
                    }
                }
                FormEditorSupport.this.reportErrors(1);
            }
        });
    }

    private void loadFormData() throws PersistenceException {
        if (this.formLoaded) {
            return;
        }
        this.resetPersistenceErrorLog();
        this.persistenceManager = this.recognizeForm(this.formDataObject);
        this.formModel = new FormModel();
        this.formModel.setName(this.formDataObject.getName());
        this.formModel.setReadOnly(this.formDataObject.isReadOnly());
        openForms.put(this.formModel, this);
        PersistenceManager persistenceManager = this.persistenceManager;
        synchronized (persistenceManager) {
            try {
                FormLAF.executeWithLookAndFeel(new Mutex.ExceptionAction(){

                    public Object run() throws Exception {
                        FormEditorSupport.this.persistenceManager.loadForm(FormEditorSupport.this.formDataObject, FormEditorSupport.this.formModel, FormEditorSupport.this.persistenceErrors);
                        return null;
                    }
                });
            }
            catch (PersistenceException ex) {
                this.persistenceManager = null;
                openForms.remove(this.formModel);
                this.formModel = null;
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        this.formLoaded = true;
        this.formModel.fireFormLoaded();
        this.formRootNode = new FormRootNode(this.formModel);
        this.formRootNode.getChildren().getNodes();
        this.formDataObject.getNodeDelegate().getChildren().add(new Node[]{this.formRootNode});
        this.attachFormListener();
        FormEditorSupport.attachSettingsListener();
        FormEditorSupport.attachTopComponentsListener();
        FormEditorSupport.attachPaletteListener();
    }

    private PersistenceManager recognizeForm(FormDataObject formDO) throws PersistenceException {
        PersistenceException ex;
        Iterator it = PersistenceManager.getManagers();
        if (!it.hasNext()) {
            PersistenceException ex2 = new PersistenceException("No persistence manager registered");
            ErrorManager.getDefault().annotate((Throwable)ex2, 65536, null, FormUtils.getBundleString("MSG_ERR_NoPersistenceManager"), null, null);
            throw ex2;
        }
        do {
            PersistenceManager pm;
            PersistenceManager persistenceManager = pm = (PersistenceManager)it.next();
            synchronized (persistenceManager) {
                try {
                    if (pm.canLoadForm(formDO)) {
                        this.resetPersistenceErrorLog();
                        PersistenceManager persistenceManager2 = pm;
                        return persistenceManager2;
                    }
                }
                catch (PersistenceException ex3) {
                    this.logPersistenceError(ex3);
                }
            }
        } while (it.hasNext());
        if (!this.anyPersistenceError()) {
            ex = new PersistenceException("Form file format not recognized");
            ErrorManager.getDefault().annotate((Throwable)ex, 65536, null, FormUtils.getBundleString("MSG_ERR_NotRecognizedForm"), null, null);
        } else {
            Throwable annotateT = null;
            int n = this.persistenceErrors.size();
            if (n == 1) {
                ex = (PersistenceException)this.persistenceErrors.get(0);
                Throwable t = ex.getOriginalException();
                annotateT = t != null ? t : ex;
                n = 0;
            } else {
                annotateT = ex = new PersistenceException("Form file cannot be loaded");
            }
            ErrorManager.getDefault().annotate(annotateT, FormUtils.getBundleString("MSG_ERR_LoadingErrors"));
            int i = 0;
            while (i < n) {
                PersistenceException pe = (PersistenceException)this.persistenceErrors.get(i);
                Throwable t = pe.getOriginalException();
                ErrorManager.getDefault().annotate((Throwable)ex, t != null ? t : pe);
                ++i;
            }
            this.resetPersistenceErrorLog();
        }
        throw ex;
    }

    private void logPersistenceError(Throwable t) {
        this.logPersistenceError(t, -1);
    }

    private void logPersistenceError(Throwable t, int index) {
        if (this.persistenceErrors == null) {
            this.persistenceErrors = new ArrayList();
        }
        if (index < 0) {
            this.persistenceErrors.add(t);
        } else {
            this.persistenceErrors.add(index, t);
        }
    }

    private void resetPersistenceErrorLog() {
        if (this.persistenceErrors != null) {
            this.persistenceErrors.clear();
        } else {
            this.persistenceErrors = new ArrayList();
        }
    }

    private boolean anyPersistenceError() {
        return this.persistenceErrors != null && !this.persistenceErrors.isEmpty();
    }

    private boolean activateWorkspace() {
        FormEditorSupport.attachWorkspacesListener();
        String currentWSName = WindowManager.getDefault().getCurrentWorkspace().getName();
        String formWSName = FormEditor.getFormSettings().getWorkspace();
        if ("Editing".equals(currentWSName) || "Visual".equals(currentWSName) || formWSName.equals(NO_WORKSPACE) || formWSName.equals(currentWSName)) {
            Workspace formWorkspace;
            this.openOnEditing = false;
            if (!formWSName.equals(currentWSName) && !formWSName.equals(NO_WORKSPACE) && (formWorkspace = WindowManager.getDefault().findWorkspace(formWSName)) != null) {
                formWorkspace.activate();
            }
            return true;
        }
        this.openOnEditing = true;
        return false;
    }

    private synchronized void openGUI() {
        FormDesigner designer = this.getFormDesigner();
        if (designer == null) {
            return;
        }
        designer.initialize();
        designer.open();
        ComponentInspector.getInstance().open();
        ComponentInspector.getInstance().focusForm(this, true);
        PaletteTopComponent.getInstance().open();
        designer.requestFocus();
    }

    private void saveFormData() throws PersistenceException {
        if (this.formLoaded && !this.formDataObject.formFileReadOnly()) {
            this.formModel.fireFormToBeSaved();
            this.resetPersistenceErrorLog();
            PersistenceManager persistenceManager = this.persistenceManager;
            synchronized (persistenceManager) {
                this.persistenceManager.saveForm(this.formDataObject, this.formModel, this.persistenceErrors);
            }
        }
    }

    protected void notifyClosed() {
        super.notifyClosed();
        if (this.formLoaded) {
            this.closeForm();
        }
    }

    public void reloadForm() {
        if (this.canClose()) {
            this.reloadDocument();
        }
    }

    protected Task reloadDocumentTask() {
        boolean guiWasOpened;
        boolean reloadForm = this.formLoaded;
        boolean bl = guiWasOpened = this.formDesigner != null && this.formDesigner.isOpened(WindowManager.getDefault().getCurrentWorkspace());
        if (this.formLoaded) {
            this.closeForm();
        }
        Task docLoadTask = super.reloadDocumentTask();
        if (reloadForm) {
            this.openForm(true, guiWasOpened);
        }
        return docLoadTask;
    }

    private synchronized void closeForm() {
        this.formModel.fireFormToBeClosed();
        openForms.remove(this.formModel);
        this.formLoaded = false;
        if (this.formDataObject.isValid()) {
            this.formDataObject.getNodeDelegate().getChildren().remove(new Node[]{this.formRootNode});
        }
        this.detachFormListener();
        if (openForms.isEmpty()) {
            if (this.formDesigner != null) {
                this.formDesigner.setModel(null);
            }
            ComponentInspector.getInstance().focusForm(null, false);
            FormEditorSupport.detachWorkspacesListener();
            FormEditorSupport.detachSettingsListener();
            FormEditorSupport.detachTopComponentsListener();
            FormEditorSupport.detachPaletteListener();
            PaletteTopComponent palette = PaletteTopComponent.getInstance();
            palette.setCloseOperation(0);
            palette.close();
            userClassLoader = null;
        } else {
            FormEditorSupport next = (FormEditorSupport)((Object)openForms.values().iterator().next());
            ComponentInspector.getInstance().focusForm(next);
        }
        if (this.floatingWindows != null) {
            if (this.floatingWindows.size() > 0) {
                Iterator it = ((List)this.floatingWindows.clone()).iterator();
                while (it.hasNext()) {
                    Window window = (Window)it.next();
                    if (!window.isVisible()) continue;
                    ((Component)window).setVisible(false);
                }
            }
            this.floatingWindows = null;
        }
        if (this.formDesigner != null) {
            this.formDesigner.setCloseOperation(0);
            this.formDesigner.close();
            this.formDesigner = null;
        }
        this.formRootNode = null;
        this.formDesigner = null;
        this.persistenceManager = null;
        this.persistenceErrors = null;
        this.formModel = null;
    }

    void designerToBeClosed(Workspace ws) {
        Mode mode;
        if (this.formDesigner == null) {
            return;
        }
        if (ws == null) {
            ws = WindowManager.getDefault().getCurrentWorkspace();
        }
        if ((mode = ws.findMode((TopComponent)this.formDesigner)) != null && "Form".equals(mode.getName())) {
            TopComponent inspector = null;
            TopComponent palette = null;
            TopComponent[] modeComponents = mode.getTopComponents();
            int i = 0;
            while (i < modeComponents.length) {
                TopComponent tc = modeComponents[i];
                if (tc.isOpened(ws)) {
                    if (tc instanceof FormDesigner) {
                        if (tc != this.formDesigner) {
                            palette = null;
                            inspector = null;
                            break;
                        }
                    } else if (tc instanceof ComponentInspector) {
                        inspector = tc;
                    } else if (tc instanceof PaletteTopComponent) {
                        palette = tc;
                    }
                }
                ++i;
            }
            if (inspector != null) {
                inspector.setCloseOperation(1);
                inspector.close(ws);
            }
            if (palette != null) {
                palette.setCloseOperation(1);
                palette.close(ws);
            }
        }
    }

    private void attachFormListener() {
        if (this.formListener != null || this.formDataObject.isReadOnly()) {
            return;
        }
        this.formListener = new FormModelListener(){

            public void formChanged(FormModelEvent[] events) {
                boolean modifying = false;
                HashSet<ComponentContainer> changedContainers = events.length > 0 ? new HashSet<ComponentContainer>() : null;
                HashSet<RADComponent> compsToSelect = null;
                FormNode nodeToSelect = null;
                int i = 0;
                while (i < events.length) {
                    int type;
                    FormModelEvent ev = events[i];
                    if (ev.isModifying()) {
                        modifying = true;
                    }
                    if ((type = ev.getChangeType()) == 4 || type == 5 || type == 7 || type == 8 || type == 9) {
                        ComponentContainer cont = ev.getContainer();
                        if (changedContainers == null || !changedContainers.contains(cont)) {
                            FormEditorSupport.this.updateNodeChildren(cont);
                            if (changedContainers != null) {
                                changedContainers.add(cont);
                            }
                        }
                        if (type == 8) {
                            FormNode select = cont instanceof RADComponent ? ((RADComponent)((Object)cont)).getNodeReference() : FormEditorSupport.this.formRootNode.getOthersNode();
                            if (!(nodeToSelect instanceof RADComponentNode)) {
                                if (nodeToSelect != FormEditorSupport.this.formRootNode) {
                                    nodeToSelect = select;
                                }
                            } else if (nodeToSelect != select) {
                                nodeToSelect = FormEditorSupport.this.formRootNode;
                            }
                        } else if (type == 4) {
                            nodeToSelect = ((RADVisualContainer)cont).getLayoutNodeReference();
                        } else if (type == 7 && ev.getComponent().isInModel()) {
                            if (compsToSelect == null) {
                                compsToSelect = new HashSet<RADComponent>();
                            }
                            compsToSelect.add(ev.getComponent());
                            compsToSelect.remove(ev.getContainer());
                        }
                    }
                    ++i;
                }
                if (FormEditorSupport.this.formDesigner != null) {
                    if (compsToSelect != null) {
                        RADComponent[] comps = new RADComponent[compsToSelect.size()];
                        compsToSelect.toArray(comps);
                        FormEditorSupport.this.formDesigner.setSelectedComponents(comps);
                    } else if (nodeToSelect != null) {
                        FormEditorSupport.this.formDesigner.setSelectedNode(nodeToSelect);
                    }
                }
                if (modifying) {
                    FormEditorSupport.this.markFormModified();
                }
            }
        };
        this.formModel.addFormModelListener(this.formListener);
    }

    private void detachFormListener() {
        if (this.formListener != null) {
            this.formModel.removeFormModelListener(this.formListener);
            this.formListener = null;
        }
    }

    private static void attachWorkspacesListener() {
        if (workspacesListener != null) {
            return;
        }
        workspacesListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (!"currentWorkspace".equals(evt.getPropertyName())) {
                    return;
                }
                Workspace ws = WindowManager.getDefault().getCurrentWorkspace();
                if (ws == null) {
                    return;
                }
                String currentWSName = ws.getName();
                String formWSName = FormEditor.getFormSettings().getWorkspace();
                if ("Editing".equals(currentWSName) || "Visual".equals(currentWSName) || formWSName.equals(FormEditorSupport.NO_WORKSPACE) || formWSName.equals(currentWSName)) {
                    boolean anyWaitingForm = false;
                    Collection forms = openForms.values();
                    Iterator it = forms.iterator();
                    while (it.hasNext()) {
                        FormEditorSupport fes = (FormEditorSupport)((Object)it.next());
                        if (!fes.openOnEditing) continue;
                        fes.openOnEditing = false;
                        fes.openGUI();
                        anyWaitingForm = true;
                    }
                    if (anyWaitingForm) {
                        return;
                    }
                }
                if (formWSName.equals(currentWSName) && !formWSName.equals(FormEditorSupport.NO_WORKSPACE)) {
                    return;
                }
                Mode formMode = ws.findMode("Form");
                if (formMode == null) {
                    return;
                }
                boolean modeOpened = false;
                TopComponent[] comps = formMode.getTopComponents();
                int i = 0;
                while (i < comps.length) {
                    if (comps[i].isOpened(ws)) {
                        modeOpened = true;
                        break;
                    }
                    ++i;
                }
                if (modeOpened) {
                    Collection forms = openForms.values();
                    Iterator it = forms.iterator();
                    while (it.hasNext()) {
                        FormEditorSupport fes = (FormEditorSupport)((Object)it.next());
                        fes.getFormDesigner().open(ws);
                    }
                }
            }
        };
        WindowManager.getDefault().addPropertyChangeListener(workspacesListener);
    }

    private static void detachWorkspacesListener() {
        if (workspacesListener != null) {
            WindowManager.getDefault().removePropertyChangeListener(workspacesListener);
            workspacesListener = null;
        }
    }

    private static void attachSettingsListener() {
        if (settingsListener != null) {
            return;
        }
        settingsListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Enumeration enumeration = openForms.keys();
                while (enumeration.hasMoreElements()) {
                    FormModel formModel = (FormModel)enumeration.nextElement();
                    String propName = evt.getPropertyName();
                    if ("useIndentEngine".equals(propName) || "generateOnSave".equals(propName) || "variablesModifier".equals(propName) || "variablesLocal".equals(propName) || "listenerGenerationStyle".equals(propName)) {
                        formModel.fireSyntheticPropertyChanged(null, propName, evt.getOldValue(), evt.getNewValue());
                        continue;
                    }
                    if (!"selectionBorderSize".equals(propName) && !"selectionBorderColor".equals(propName) && !"connectionBorderColor".equals(propName) && !"formDesignerBackgroundColor".equals(propName) && !"formDesignerBorderColor".equals(propName)) continue;
                    formModel.getFormDesigner().updateVisualSettings();
                }
            }
        };
        FormEditor.getFormSettings().addPropertyChangeListener(settingsListener);
    }

    private static void detachSettingsListener() {
        if (settingsListener != null) {
            FormEditor.getFormSettings().removePropertyChangeListener(settingsListener);
            settingsListener = null;
        }
    }

    private static void attachTopComponentsListener() {
        if (topcompsListener != null) {
            return;
        }
        topcompsListener = new PropertyChangeListener(){
            static /* synthetic */ Class class$org$openide$cookies$SourceCookie;
            static /* synthetic */ Class class$org$openide$loaders$DataObject;

            public void propertyChange(PropertyChangeEvent evt) {
                if ("activated".equals(evt.getPropertyName())) {
                    TopComponent tc = TopComponent.getRegistry().getActivated();
                    if (!(tc instanceof JavaEditor.JavaEditorComponent)) {
                        return;
                    }
                    Node[] nodes = tc.getActivatedNodes();
                    if (nodes == null || nodes.length != 1) {
                        return;
                    }
                    SourceCookie srcCookie = (SourceCookie)nodes[0].getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = 9.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
                    if (srcCookie == null) {
                        return;
                    }
                    DataObject dobj = (DataObject)srcCookie.getSource().getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = 9.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    if (dobj == null) {
                        return;
                    }
                    FormEditorSupport selectedForm = ComponentInspector.getInstance().getFocusedForm();
                    Iterator it = openForms.values().iterator();
                    while (it.hasNext()) {
                        FormEditorSupport fes = (FormEditorSupport)((Object)it.next());
                        if (fes.getFormDataObject() != dobj) continue;
                        if (fes == selectedForm) break;
                        fes.gotoForm();
                        ComponentInspector.getInstance().focusForm(fes);
                        break;
                    }
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
        TopComponent.getRegistry().addPropertyChangeListener(topcompsListener);
    }

    private static void detachTopComponentsListener() {
        if (topcompsListener != null) {
            TopComponent.getRegistry().removePropertyChangeListener(topcompsListener);
            topcompsListener = null;
        }
    }

    private static void attachPaletteListener() {
        if (paletteListener != null) {
            return;
        }
        paletteListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("mode".equals(evt.getPropertyName()) && new Integer(2).equals(evt.getNewValue())) {
                    FormDesigner designer = ComponentInspector.getInstance().getFocusedForm().getFormDesigner();
                    designer.requestFocus();
                    designer.componentActivated();
                }
            }
        };
        CPManager.getDefault().addPropertyChangeListener(paletteListener);
    }

    private static void detachPaletteListener() {
        if (paletteListener != null) {
            CPManager.getDefault().removePropertyChangeListener(paletteListener);
            paletteListener = null;
        }
    }

    public void gotoEditor() {
        super.open();
    }

    public void gotoForm() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (FormEditorSupport.this.formModel != null && FormEditorSupport.this.formModel.getFormDesigner().isOpened()) {
                    FormEditorSupport.this.formModel.getFormDesigner().requestVisible();
                }
            }
        });
    }

    static {
        openForms = new Hashtable();
    }
}

