/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.util.HashMap;
import java.util.Map;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

class FormLAF {
    private static LookAndFeel defaultLookAndFeel;
    private static DefaultMetalTheme defaultMetalTheme;
    private static Map ideDefaults;
    private static int useIdeLaf;
    private static boolean lafBlockEntered;

    private FormLAF() {
    }

    static Object executeWithLookAndFeel(final Mutex.ExceptionAction act) throws Exception {
        try {
            if (FormLAF.checkUseIdeLaf()) {
                return Mutex.EVENT.readAccess(act);
            }
            return Mutex.EVENT.readAccess(new Mutex.ExceptionAction(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Object run() throws Exception {
                    Object object;
                    boolean restoreAfter = true;
                    try {
                        if (lafBlockEntered) {
                            restoreAfter = false;
                        } else {
                            lafBlockEntered = true;
                            FormLAF.useDefaultLookAndFeel();
                            restoreAfter = true;
                        }
                        object = act.run();
                        Object var4_3 = null;
                        if (!restoreAfter) return object;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (!restoreAfter) throw throwable;
                        FormLAF.useIDELookAndFeel();
                        lafBlockEntered = false;
                        throw throwable;
                    }
                    FormLAF.useIDELookAndFeel();
                    lafBlockEntered = false;
                    return object;
                }
            });
        }
        catch (MutexException ex) {
            throw ex.getException();
        }
    }

    static void executeWithLookAndFeel(final Runnable run) {
        Mutex.EVENT.readAccess(new Mutex.Action(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Object run() {
                if (FormLAF.checkUseIdeLaf()) {
                    run.run();
                    return null;
                }
                boolean restoreAfter = true;
                try {
                    if (lafBlockEntered) {
                        restoreAfter = false;
                    } else {
                        lafBlockEntered = true;
                        FormLAF.useDefaultLookAndFeel();
                        restoreAfter = true;
                    }
                    run.run();
                    Object var3_2 = null;
                    if (!restoreAfter) return null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (!restoreAfter) throw throwable;
                    FormLAF.useIDELookAndFeel();
                    lafBlockEntered = false;
                    throw throwable;
                }
                FormLAF.useIDELookAndFeel();
                lafBlockEntered = false;
                return null;
            }
        });
    }

    private static boolean checkUseIdeLaf() {
        if (useIdeLaf == -1) {
            useIdeLaf = System.getProperty("netbeans.form.use_idelaf") != null ? 1 : 0;
        }
        return useIdeLaf > 0;
    }

    private static void useDefaultLookAndFeel() {
        if (defaultLookAndFeel == null) {
            try {
                String lafName = UIManager.getLookAndFeel().getClass().getName();
                defaultLookAndFeel = (LookAndFeel)Class.forName(lafName).newInstance();
                defaultLookAndFeel.initialize();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            catch (LinkageError ex) {
                ex.printStackTrace();
                return;
            }
        }
        if (ideDefaults == null) {
            FormLAF.saveIDELookAndFeelDefaults();
        }
        if (defaultLookAndFeel instanceof MetalLookAndFeel) {
            if (defaultMetalTheme == null) {
                defaultMetalTheme = new DefaultMetalTheme();
            }
            MetalLookAndFeel.setCurrentTheme(defaultMetalTheme);
        }
        FormLAF.copyMap(UIManager.getDefaults(), defaultLookAndFeel.getDefaults());
    }

    private static void useIDELookAndFeel() {
        if (ideDefaults != null) {
            FormLAF.copyMap(UIManager.getDefaults(), ideDefaults);
        }
    }

    private static void saveIDELookAndFeelDefaults() {
        if (FormLAF.checkUseIdeLaf()) {
            return;
        }
        if (ideDefaults != null) {
            return;
        }
        UIDefaults defaults = UIManager.getDefaults();
        UIDefaults lafDefaults = UIManager.getLookAndFeelDefaults();
        ideDefaults = new HashMap(defaults.size() + lafDefaults.size());
        FormLAF.copyMap(ideDefaults, lafDefaults);
        FormLAF.copyMap(ideDefaults, defaults);
    }

    private static void copyMap(Map dest, Map src) {
        Object[] keys = src.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            src.get(keys[i]);
            ++i;
        }
        dest.putAll(src);
    }

    static {
        useIdeLaf = -1;
    }
}

