/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.CodeGenerator;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormEvents;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.JavaCodeGenerator;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADFormContainer;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.awt.UndoRedo;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class FormModel {
    private RADComponent topRADComponent;
    private Class formBaseClass;
    private ArrayList otherComponents = new ArrayList(10);
    private ComponentContainer modelContainer;
    private String formName;
    private boolean readOnly = false;
    private boolean formLoaded = false;
    private UndoRedo.Manager undoRedoManager;
    private boolean undoRedoRecording = false;
    private CompoundEdit compoundEdit;
    private FormEvents formEvents;
    private ArrayList listeners;
    private EventBroker eventBroker;
    private MetaComponentCreator metaCreator;
    private CodeStructure codeStructure = new CodeStructure(false);
    private CodeGenerator codeGenerator;
    private static int traceCount = 0;
    private static final boolean TRACE = false;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$java$lang$Object;

    FormModel() {
    }

    public void setFormBaseClass(Class formClass) throws Exception {
        if (this.formBaseClass != null) {
            throw new IllegalStateException("Form type already initialized.");
        }
        RADComponent topComp = (class$java$awt$Component == null ? (class$java$awt$Component = FormModel.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(formClass) ? (FormUtils.isContainer(formClass) ? new RADVisualFormContainer() : new RADVisualComponent()) : ((class$java$lang$Object == null ? (class$java$lang$Object = FormModel.class$("java.lang.Object")) : class$java$lang$Object) != formClass ? new RADFormContainer() : null);
        if (topComp != null) {
            this.topRADComponent = topComp;
            topComp.initialize(this);
            topComp.initInstance(formClass);
            topComp.setInModel(true);
        }
        this.formBaseClass = formClass;
    }

    public Class getFormBaseClass() {
        return this.formBaseClass;
    }

    void setName(String name) {
        this.formName = name;
    }

    void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public final String getName() {
        return this.formName;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isFormLoaded() {
        return this.formLoaded;
    }

    public final FormDesigner getFormDesigner() {
        return FormEditorSupport.getFormDesigner(this);
    }

    public final FormDataObject getFormDataObject() {
        return FormEditorSupport.getFormDataObject(this);
    }

    public ComponentContainer getModelContainer() {
        if (this.modelContainer == null) {
            this.modelContainer = new ModelContainer();
        }
        return this.modelContainer;
    }

    public final RADComponent getTopRADComponent() {
        return this.topRADComponent;
    }

    public RADComponent findRADComponent(String name) {
        Iterator allComps = this.getMetaComponents().iterator();
        while (allComps.hasNext()) {
            RADComponent comp = (RADComponent)allComps.next();
            if (!name.equals(comp.getName())) continue;
            return comp;
        }
        return null;
    }

    public List getMetaComponents() {
        ArrayList list = new ArrayList();
        FormModel.collectMetaComponents(this.getModelContainer(), list);
        return list;
    }

    public RADVisualComponent[] getVisualComponents() {
        ArrayList<RADComponent> list = new ArrayList<RADComponent>();
        if (this.topRADComponent instanceof RADVisualComponent) {
            list.add(this.topRADComponent);
        }
        if (this.topRADComponent instanceof RADVisualContainer) {
            FormModel.collectVisualMetaComponents((RADVisualContainer)this.topRADComponent, list);
        }
        return list.toArray(new RADVisualComponent[list.size()]);
    }

    public RADComponent[] getOtherComponents(boolean recursively) {
        ArrayList<RADComponent> list = new ArrayList<RADComponent>();
        Iterator it = ((AbstractList)this.otherComponents).iterator();
        while (it.hasNext()) {
            RADComponent comp = (RADComponent)it.next();
            list.add(comp);
            if (!recursively || !(comp instanceof ComponentContainer)) continue;
            FormModel.collectMetaComponents((ComponentContainer)((Object)comp), list);
        }
        return list.toArray(new RADComponent[list.size()]);
    }

    public RADComponent[] getNonVisualComponents() {
        return this.otherComponents.toArray(new RADComponent[this.otherComponents.size()]);
    }

    public FormEvents getFormEvents() {
        if (this.formEvents == null) {
            this.formEvents = new FormEvents(this);
        }
        return this.formEvents;
    }

    private static void collectMetaComponents(ComponentContainer cont, List list) {
        RADComponent[] comps = cont.getSubBeans();
        int i = 0;
        while (i < comps.length) {
            RADComponent comp = comps[i];
            list.add(comp);
            if (comp instanceof ComponentContainer) {
                FormModel.collectMetaComponents((ComponentContainer)((Object)comp), list);
            }
            ++i;
        }
    }

    private static void collectVisualMetaComponents(RADVisualContainer cont, List list) {
        RADVisualComponent[] comps = cont.getSubComponents();
        int i = 0;
        while (i < comps.length) {
            RADVisualComponent comp = comps[i];
            list.add(comp);
            if (comp instanceof RADVisualContainer) {
                FormModel.collectVisualMetaComponents((RADVisualContainer)comp, list);
            }
            ++i;
        }
    }

    public MetaComponentCreator getComponentCreator() {
        if (this.metaCreator == null) {
            this.metaCreator = new MetaComponentCreator(this);
        }
        return this.metaCreator;
    }

    public void addComponent(RADComponent metacomp, ComponentContainer parentContainer) {
        boolean newlyAdded;
        if (parentContainer != null) {
            parentContainer.add(metacomp);
        } else {
            metacomp.setParentComponent(null);
            this.otherComponents.add(metacomp);
        }
        boolean bl = newlyAdded = !metacomp.isInModel();
        if (newlyAdded) {
            FormModel.setInModelRecursively(metacomp, true);
        }
        this.fireComponentAdded(metacomp, newlyAdded);
    }

    public void addVisualComponent(RADVisualComponent metacomp, RADVisualContainer parentContainer, LayoutConstraints constraints) {
        boolean newlyAdded;
        LayoutSupportManager layoutSupport = parentContainer.getLayoutSupport();
        RADVisualComponent[] compArray = new RADVisualComponent[]{metacomp};
        LayoutConstraints[] constrArray = new LayoutConstraints[]{constraints};
        layoutSupport.acceptNewComponents(compArray, constrArray, -1);
        parentContainer.add(metacomp);
        layoutSupport.addComponents(compArray, constrArray, -1);
        boolean bl = newlyAdded = !metacomp.isInModel();
        if (newlyAdded) {
            FormModel.setInModelRecursively(metacomp, true);
        }
        this.fireComponentAdded(metacomp, newlyAdded);
    }

    public void setContainerLayout(RADVisualContainer metacont, LayoutSupportDelegate layoutDelegate, LayoutManager lmInstance) throws Exception {
        LayoutSupportDelegate current = metacont.getLayoutSupport().getLayoutDelegate();
        metacont.setLayoutSupportDelegate(layoutDelegate, lmInstance);
        this.fireContainerLayoutExchanged(metacont, current, layoutDelegate);
    }

    public void removeComponentFromContainer(RADComponent metacomp) {
        RADComponent parent = metacomp.getParentComponent();
        ComponentContainer parentContainer = parent instanceof ComponentContainer ? (ComponentContainer)((Object)parent) : this.getModelContainer();
        int index = parentContainer.getIndexOf(metacomp);
        parentContainer.remove(metacomp);
        this.fireComponentRemoved(metacomp, parentContainer, index, false, null, null);
    }

    public void removeComponent(RADComponent metacomp) {
        RADComponent parent;
        if (this.formEvents != null) {
            this.removeEventHandlersRecursively(metacomp);
        }
        ComponentContainer parentContainer = (parent = metacomp.getParentComponent()) instanceof ComponentContainer ? (ComponentContainer)((Object)parent) : this.getModelContainer();
        int index = parentContainer.getIndexOf(metacomp);
        parentContainer.remove(metacomp);
        Object codeStructureMark1 = null;
        Object codeStructureMark2 = null;
        boolean codeStructureUndoRedo = this.codeStructure.isUndoRedoRecording();
        if (this.undoRedoRecording && !codeStructureUndoRedo) {
            this.codeStructure.setUndoRedoRecording(true);
            codeStructureMark1 = this.codeStructure.markForUndo();
        }
        metacomp.removeCodeExpression();
        metacomp.setInModel(false);
        if (metacomp instanceof ComponentContainer) {
            FormModel.releaseComponent(metacomp);
        }
        if (this.undoRedoRecording && !codeStructureUndoRedo) {
            codeStructureMark2 = this.codeStructure.markForUndo();
            if (codeStructureMark2.equals(codeStructureMark1)) {
                codeStructureMark1 = null;
                codeStructureMark2 = null;
            }
            this.codeStructure.setUndoRedoRecording(false);
        }
        this.fireComponentRemoved(metacomp, parentContainer, index, true, codeStructureMark1, codeStructureMark2);
    }

    private void removeEventHandlersRecursively(RADComponent comp) {
        int i;
        if (comp instanceof ComponentContainer) {
            RADComponent[] subcomps = ((ComponentContainer)((Object)comp)).getSubBeans();
            i = 0;
            while (i < subcomps.length) {
                this.removeEventHandlersRecursively(subcomps[i]);
                ++i;
            }
        }
        Event[] events = comp.getKnownEvents();
        i = 0;
        while (i < events.length) {
            if (events[i].hasEventHandlers()) {
                this.getFormEvents().detachEvent(events[i]);
            }
            ++i;
        }
    }

    private static void releaseComponent(RADComponent metacomp) {
        RADComponent[] comps = ((ComponentContainer)((Object)metacomp)).getSubBeans();
        int i = 0;
        int n = comps.length;
        while (i < n) {
            metacomp = comps[i];
            metacomp.releaseCodeExpression();
            metacomp.setInModel(false);
            if (metacomp instanceof ComponentContainer) {
                FormModel.releaseComponent(metacomp);
            }
            ++i;
        }
    }

    static void setInModelRecursively(RADComponent metacomp, boolean inModel) {
        metacomp.setInModel(inModel);
        if (metacomp instanceof ComponentContainer) {
            RADComponent[] comps = ((ComponentContainer)((Object)metacomp)).getSubBeans();
            int i = 0;
            while (i < comps.length) {
                FormModel.setInModelRecursively(comps[i], inModel);
                ++i;
            }
        }
    }

    public void setUndoRedoRecording(boolean record) {
        FormModel.t("turning undo/redo recording " + (record ? "on" : "off"));
        this.undoRedoRecording = record;
    }

    public boolean isUndoRedoRecording() {
        return this.undoRedoRecording;
    }

    public boolean startCompoundEdit() {
        if (this.compoundEdit == null) {
            FormModel.t("starting compound edit");
            this.compoundEdit = new CompoundEdit();
            return true;
        }
        return false;
    }

    public CompoundEdit endCompoundEdit() {
        if (this.compoundEdit != null) {
            FormModel.t("ending compound edit");
            this.compoundEdit.end();
            if (this.undoRedoRecording && this.compoundEdit.isSignificant()) {
                this.getUndoRedoManager().undoableEditHappened(new UndoableEditEvent(this, this.compoundEdit));
            }
            CompoundEdit edit = this.compoundEdit;
            this.compoundEdit = null;
            return edit;
        }
        return null;
    }

    public boolean isCompoundEditInProgress() {
        return this.compoundEdit != null && this.compoundEdit.isInProgress();
    }

    public void addUndoableEdit(UndoableEdit edit) {
        FormModel.t("adding undoable edit");
        if (this.isCompoundEditInProgress()) {
            this.compoundEdit.addEdit(edit);
        } else {
            this.getUndoRedoManager().undoableEditHappened(new UndoableEditEvent(this, edit));
        }
    }

    UndoRedo.Manager getUndoRedoManager() {
        if (this.undoRedoManager == null) {
            this.undoRedoManager = new UndoRedoManager();
            this.undoRedoManager.setLimit(50);
        }
        return this.undoRedoManager;
    }

    public synchronized void addFormModelListener(FormModelListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public synchronized void removeFormModelListener(FormModelListener l) {
        if (this.listeners != null) {
            ((AbstractCollection)this.listeners).remove(l);
        }
    }

    public void fireFormLoaded() {
        FormModel.t("firing form loaded");
        this.formLoaded = true;
        if (this.undoRedoManager != null) {
            this.undoRedoManager.discardAllEdits();
        }
        if (!this.readOnly && !Boolean.getBoolean("netbeans.form.no_undo")) {
            this.setUndoRedoRecording(true);
        }
        this.initializeCodeGenerator();
        this.fireEvents(new FormModelEvent[]{new FormModelEvent(this, 1)});
    }

    public void fireFormToBeSaved() {
        FormModel.t("firing form to be saved");
        this.fireEvents(new FormModelEvent[]{new FormModelEvent(this, 2)});
    }

    public void fireFormToBeClosed() {
        FormModel.t("firing form to be closed");
        if (this.undoRedoManager != null) {
            this.undoRedoManager.discardAllEdits();
        }
        this.fireEvents(new FormModelEvent[]{new FormModelEvent(this, 3)});
    }

    public FormModelEvent fireContainerLayoutExchanged(RADVisualContainer metacont, LayoutSupportDelegate oldLayout, LayoutSupportDelegate newLayout) {
        FormModel.t("firing container layout exchange, container: " + (metacont != null ? metacont.getName() : "null"));
        FormModelEvent ev = new FormModelEvent(this, 4);
        ev.setLayout(metacont, oldLayout, newLayout);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacont != null && oldLayout != newLayout) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireContainerLayoutChanged(RADVisualContainer metacont, String propName, Object oldValue, Object newValue) {
        FormModel.t("firing container layout change, container: " + (metacont != null ? metacont.getName() : "null") + ", property: " + propName);
        FormModelEvent ev = new FormModelEvent(this, 5);
        ev.setComponentAndContainer(metacont, metacont);
        ev.setProperty(propName, oldValue, newValue);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacont != null && propName != null && oldValue != newValue) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireComponentLayoutChanged(RADVisualComponent metacomp, String propName, Object oldValue, Object newValue) {
        FormModel.t("firing component layout change: " + (metacomp != null ? metacomp.getName() : "null"));
        FormModelEvent ev = new FormModelEvent(this, 6);
        ev.setComponentAndContainer(metacomp, null);
        ev.setProperty(propName, oldValue, newValue);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacomp != null && propName != null && oldValue != newValue) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireComponentAdded(RADComponent metacomp, boolean addedNew) {
        FormModel.t("firing component added: " + (metacomp != null ? metacomp.getName() : "null"));
        FormModelEvent ev = new FormModelEvent(this, 7);
        ev.setAddData(metacomp, null, addedNew);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacomp != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireComponentRemoved(RADComponent metacomp, ComponentContainer metacont, int index, boolean removedFromModel, Object codeStructureMark1, Object codeStructureMark2) {
        FormModel.t("firing component removed: " + (metacomp != null ? metacomp.getName() : "null"));
        FormModelEvent ev = new FormModelEvent(this, 8);
        ev.setRemoveData(metacomp, metacont, index, removedFromModel, codeStructureMark1, codeStructureMark2);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacomp != null && metacont != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireComponentsReordered(ComponentContainer metacont, int[] perm) {
        FormModel.t("firing components reorder in container: " + (metacont instanceof RADComponent ? ((RADComponent)((Object)metacont)).getName() : "<top>"));
        FormModelEvent ev = new FormModelEvent(this, 9);
        ev.setComponentAndContainer(null, metacont);
        ev.setReordering(perm);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacont != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireComponentPropertyChanged(RADComponent metacomp, String propName, Object oldValue, Object newValue) {
        FormModel.t("firing component property change, component: " + (metacomp != null ? metacomp.getName() : "<null component>") + ", property: " + propName);
        FormModelEvent ev = new FormModelEvent(this, 10);
        ev.setComponentAndContainer(metacomp, null);
        ev.setProperty(propName, oldValue, newValue);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacomp != null && propName != null && oldValue != newValue) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireSyntheticPropertyChanged(RADComponent metacomp, String propName, Object oldValue, Object newValue) {
        FormModel.t("firing synthetic property change, component: " + (metacomp != null ? metacomp.getName() : "null") + ", property: " + propName);
        FormModelEvent ev = new FormModelEvent(this, 11);
        ev.setComponentAndContainer(metacomp, null);
        ev.setProperty(propName, oldValue, newValue);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacomp != null && propName != null && oldValue != newValue) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireEventHandlerAdded(Event event, String handler, String bodyText, boolean createdNew) {
        FormModel.t("event handler added: " + handler);
        FormModelEvent ev = new FormModelEvent(this, 12);
        ev.setEvent(event, handler, bodyText, createdNew);
        this.sendEvent(ev);
        if (this.undoRedoRecording && event != null && handler != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireEventHandlerRemoved(Event event, String handler, boolean handlerDeleted) {
        FormModel.t("firing event handler removed: " + handler);
        FormModelEvent ev = new FormModelEvent(this, 13);
        ev.setEvent(event, handler, null, handlerDeleted);
        this.sendEvent(ev);
        if (this.undoRedoRecording && event != null && handler != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireEventHandlerRenamed(String oldHandlerName, String newHandlerName) {
        FormModel.t("event handler renamed: " + oldHandlerName + " to " + newHandlerName);
        FormModelEvent ev = new FormModelEvent(this, 14);
        ev.setEvent(oldHandlerName, newHandlerName);
        this.sendEvent(ev);
        if (this.undoRedoRecording && oldHandlerName != null && newHandlerName != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireFormChanged() {
        FormModel.t("firing form change");
        FormModelEvent ev = new FormModelEvent(this, 15);
        this.sendEvent(ev);
        return ev;
    }

    public void fireEvents(FormModelEvent[] events) {
        ArrayList targets;
        FormModel formModel = this;
        synchronized (formModel) {
            if (this.listeners == null) {
                return;
            }
            targets = (ArrayList)this.listeners.clone();
        }
        int i = 0;
        while (i < targets.size()) {
            FormModelListener l = (FormModelListener)targets.get(i);
            l.formChanged(events);
            ++i;
        }
    }

    void sendEvent(FormModelEvent ev) {
        EventBroker broker = this.getEventBroker();
        if (broker != null) {
            broker.sendEvent(ev);
        } else {
            FormModel.t("no event broker, firing event directly: " + ev.getChangeType());
            this.fireEvents(new FormModelEvent[]{ev});
        }
    }

    EventBroker getEventBroker() {
        if (this.eventBroker == null && this.isFormLoaded()) {
            this.eventBroker = new EventBroker();
        }
        return this.eventBroker;
    }

    CodeStructure getCodeStructure() {
        return this.codeStructure;
    }

    CodeGenerator getCodeGenerator() {
        if (this.codeGenerator == null) {
            this.codeGenerator = new JavaCodeGenerator();
        }
        return this.codeGenerator;
    }

    void initializeCodeGenerator() {
        this.getCodeGenerator().initialize(this);
    }

    static void t(String str) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class ModelContainer
    implements ComponentContainer {
        ModelContainer() {
        }

        public RADComponent[] getSubBeans() {
            int n = FormModel.this.otherComponents.size();
            if (FormModel.this.topRADComponent != null) {
                ++n;
            }
            RADComponent[] comps = new RADComponent[n];
            FormModel.this.otherComponents.toArray(comps);
            if (FormModel.this.topRADComponent != null) {
                comps[n - 1] = FormModel.this.topRADComponent;
            }
            return comps;
        }

        public void initSubComponents(RADComponent[] initComponents) {
            FormModel.this.otherComponents.clear();
            int i = 0;
            while (i < initComponents.length) {
                if (initComponents[i] != FormModel.this.topRADComponent) {
                    FormModel.this.otherComponents.add(initComponents[i]);
                }
                ++i;
            }
        }

        public void reorderSubComponents(int[] perm) {
            RADComponent[] components = new RADComponent[FormModel.this.otherComponents.size()];
            int i = 0;
            while (i < perm.length) {
                components[perm[i]] = (RADComponent)FormModel.this.otherComponents.get(i);
                ++i;
            }
            FormModel.this.otherComponents.clear();
            FormModel.this.otherComponents.addAll(Arrays.asList(components));
        }

        public void add(RADComponent comp) {
            comp.setParentComponent(null);
            FormModel.this.otherComponents.add(comp);
        }

        public void remove(RADComponent comp) {
            if (((AbstractCollection)FormModel.this.otherComponents).remove(comp)) {
                comp.setParentComponent(null);
            }
        }

        public int getIndexOf(RADComponent comp) {
            int index = FormModel.this.otherComponents.indexOf(comp);
            if (index < 0 && comp == FormModel.this.topRADComponent) {
                index = FormModel.this.otherComponents.size();
            }
            return index;
        }
    }

    private class EventBroker
    implements Runnable {
        private List eventsList;
        private boolean compoundUndoStarted;

        private EventBroker() {
        }

        public void sendEvent(FormModelEvent ev) {
            if (!this.placeEvent(ev)) {
                FormModel.t("firing event directly from event broker: " + ev.getChangeType());
                FormModel.this.fireEvents(new FormModelEvent[]{ev});
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private synchronized boolean placeEvent(FormModelEvent ev) {
            if (this.eventsList == null) {
                if (!ev.isModifying() || !EventQueue.isDispatchThread()) return false;
                this.eventsList = new ArrayList();
                this.eventsList.add(ev);
                boolean bl = this.compoundUndoStarted = FormModel.this.isUndoRedoRecording() && FormModel.this.startCompoundEdit();
                if (this.compoundUndoStarted) {
                    FormModel.t("compound undoable edit started from event broker");
                }
                EventQueue.invokeLater(this);
                return true;
            } else {
                this.eventsList.add(ev);
            }
            return true;
        }

        private synchronized List pickUpEvents() {
            List list = this.eventsList;
            this.eventsList = null;
            if (this.compoundUndoStarted) {
                this.compoundUndoStarted = false;
                FormModel.this.endCompoundEdit();
            }
            return list;
        }

        public void run() {
            List list = this.pickUpEvents();
            if (list != null && !list.isEmpty()) {
                FormModelEvent[] events = new FormModelEvent[list.size()];
                list.toArray(events);
                FormModel.t("firing event batch of " + list.size() + " events from event broker");
                FormModel.this.fireEvents(events);
            }
        }
    }

    static class UndoRedoManager
    extends UndoRedo.Manager {
        private Mutex.ExceptionAction runUndo = new Mutex.ExceptionAction(){

            public Object run() throws Exception {
                this.superUndo();
                return null;
            }
        };
        private Mutex.ExceptionAction runRedo = new Mutex.ExceptionAction(this){
            private final /* synthetic */ UndoRedoManager this$0;
            {
                this.this$0 = this$0;
            }

            public Object run() throws Exception {
                this.this$0.superRedo();
                return null;
            }
        };

        UndoRedoManager() {
        }

        public void superUndo() throws CannotUndoException {
            super.undo();
        }

        public void superRedo() throws CannotRedoException {
            super.redo();
        }

        public void undo() throws CannotUndoException {
            if (EventQueue.isDispatchThread()) {
                this.superUndo();
            } else {
                try {
                    Mutex.EVENT.readAccess(this.runUndo);
                }
                catch (MutexException ex) {
                    Exception e = ex.getException();
                    if (e instanceof CannotUndoException) {
                        throw (CannotUndoException)e;
                    }
                    e.printStackTrace();
                }
            }
        }

        public void redo() throws CannotRedoException {
            if (EventQueue.isDispatchThread()) {
                this.superRedo();
            } else {
                try {
                    Mutex.EVENT.readAccess(this.runRedo);
                }
                catch (MutexException ex) {
                    Exception e = ex.getException();
                    if (e instanceof CannotRedoException) {
                        throw (CannotRedoException)e;
                    }
                    e.printStackTrace();
                }
            }
        }
    }
}

