/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormEvents;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.nodes.Node;

public class FormModelEvent
extends EventObject {
    public static final int FORM_LOADED = 1;
    public static final int FORM_TO_BE_SAVED = 2;
    public static final int FORM_TO_BE_CLOSED = 3;
    public static final int CONTAINER_LAYOUT_EXCHANGED = 4;
    public static final int CONTAINER_LAYOUT_CHANGED = 5;
    public static final int COMPONENT_LAYOUT_CHANGED = 6;
    public static final int COMPONENT_ADDED = 7;
    public static final int COMPONENT_REMOVED = 8;
    public static final int COMPONENTS_REORDERED = 9;
    public static final int COMPONENT_PROPERTY_CHANGED = 10;
    public static final int SYNTHETIC_PROPERTY_CHANGED = 11;
    public static final int EVENT_HANDLER_ADDED = 12;
    public static final int EVENT_HANDLER_REMOVED = 13;
    public static final int EVENT_HANDLER_RENAMED = 14;
    public static final int OTHER_CHANGE = 15;
    private int changeType;
    private boolean createdDeleted;
    private RADComponent component;
    private ComponentContainer container;
    private LayoutConstraints constraints;
    private int componentIndex = -1;
    private int[] reordering;
    private Object codeUndoRedoStart;
    private Object codeUndoRedoEnd;
    private String propertyName;
    private Object oldPropertyValue;
    private Object newPropertyValue;
    private Event componentEvent;
    private UndoableEdit undoableEdit;
    private FormModelEvent additionalEvent;
    private static List interestList;

    FormModelEvent(FormModel source, int changeType) {
        super(source);
        this.changeType = changeType;
        FormModelEvent.informInterestedEvents(this);
    }

    void setProperty(String propName, Object oldValue, Object newValue) {
        this.propertyName = propName;
        this.oldPropertyValue = oldValue;
        this.newPropertyValue = newValue;
    }

    void setComponentAndContainer(RADComponent metacomp, ComponentContainer metacont) {
        this.component = metacomp;
        this.container = metacont != null ? metacont : FormModelEvent.deriveContainer(metacomp);
    }

    void setLayout(RADVisualContainer metacont, LayoutSupportDelegate oldLayoutSupp, LayoutSupportDelegate newLayoutSupp) {
        this.component = metacont;
        this.container = metacont;
        this.oldPropertyValue = oldLayoutSupp;
        this.newPropertyValue = newLayoutSupp;
    }

    void setReordering(int[] perm) {
        this.reordering = perm;
    }

    void setAddData(RADComponent metacomp, ComponentContainer metacont, boolean addedNew) {
        this.setComponentAndContainer(metacomp, metacont);
        this.createdDeleted = addedNew;
        if (this.component instanceof RADVisualComponent && this.container instanceof RADVisualContainer) {
            this.componentIndex = this.container.getIndexOf(this.component);
            if (this.componentIndex >= 0) {
                LayoutSupportManager laysup = ((RADVisualContainer)this.container).getLayoutSupport();
                this.constraints = laysup.getConstraints(this.componentIndex);
            }
        }
    }

    void setRemoveData(RADComponent metacomp, ComponentContainer metacont, int index, boolean removedFromModel, Object codeStructureMark1, Object codeStructureMark2) {
        this.component = metacomp;
        this.container = metacont;
        this.componentIndex = index;
        this.codeUndoRedoStart = codeStructureMark1;
        this.codeUndoRedoEnd = codeStructureMark2;
        this.createdDeleted = removedFromModel;
        if (metacomp instanceof RADVisualComponent && metacont instanceof RADVisualContainer) {
            LayoutSupportManager laysup = ((RADVisualContainer)metacont).getLayoutSupport();
            this.constraints = laysup.getStoredConstraints((RADVisualComponent)metacomp);
        }
    }

    void setEvent(Event event, String handler, String bodyText, boolean createdNew) {
        if (event != null) {
            this.component = event.getComponent();
        }
        this.componentEvent = event;
        this.propertyName = handler;
        this.newPropertyValue = bodyText;
        this.createdDeleted = createdNew;
    }

    void setEvent(String oldHandlerName, String newHandlerName) {
        this.oldPropertyValue = oldHandlerName;
        this.propertyName = newHandlerName;
        this.newPropertyValue = newHandlerName;
    }

    void setChangeType(int changeType) {
        this.changeType = changeType;
    }

    private static ComponentContainer deriveContainer(RADComponent comp) {
        if (comp == null) {
            return null;
        }
        if (comp.getParentComponent() instanceof ComponentContainer) {
            return (ComponentContainer)((Object)comp.getParentComponent());
        }
        if (comp.getParentComponent() == null) {
            return comp.getFormModel().getModelContainer();
        }
        return null;
    }

    public final FormModel getFormModel() {
        return (FormModel)this.getSource();
    }

    public final int getChangeType() {
        return this.changeType;
    }

    public final boolean isModifying() {
        return this.changeType != 1 && this.changeType != 2 && this.changeType != 3 && (this.changeType != 12 || this.componentEvent != null);
    }

    public final boolean getCreatedDeleted() {
        return this.createdDeleted;
    }

    public final ComponentContainer getContainer() {
        return this.container;
    }

    public final RADComponent getComponent() {
        return this.component;
    }

    public final LayoutConstraints getComponentLayoutConstraints() {
        return this.constraints;
    }

    public final int getComponentIndex() {
        return this.componentIndex;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public final RADProperty getComponentProperty() {
        return this.component != null && this.propertyName != null ? this.component.getBeanProperty(this.propertyName) : null;
    }

    public final Object getOldPropertyValue() {
        return this.oldPropertyValue;
    }

    public final Object getNewPropertyValue() {
        return this.newPropertyValue;
    }

    public final LayoutSupportDelegate getOldLayoutSupport() {
        return (LayoutSupportDelegate)this.oldPropertyValue;
    }

    public final LayoutSupportDelegate getNewLayoutSupport() {
        return (LayoutSupportDelegate)this.newPropertyValue;
    }

    public final int[] getReordering() {
        return this.reordering;
    }

    public final Event getComponentEvent() {
        return this.componentEvent;
    }

    public final String getEventHandler() {
        return this.propertyName;
    }

    public final String getOldEventHandler() {
        return (String)this.oldPropertyValue;
    }

    public final String getNewEventHandler() {
        return (String)this.newPropertyValue;
    }

    public final String getNewEventHandlerContent() {
        return this.changeType == 12 || this.changeType == 13 ? (String)this.newPropertyValue : null;
    }

    public final String getOldEventHandlerContent() {
        if (this.changeType == 12 || this.changeType == 13) {
            if (this.additionalEvent != null) {
                if (this.additionalEvent.changeType == 13 || this.additionalEvent.changeType == 12) {
                    this.oldPropertyValue = this.additionalEvent.oldPropertyValue;
                }
                this.additionalEvent = null;
            }
            return (String)this.oldPropertyValue;
        }
        return null;
    }

    public final void setOldEventHandlerContent(String text) {
        if (this.changeType == 12 || this.changeType == 13) {
            this.oldPropertyValue = text;
        }
    }

    UndoableEdit getUndoableEdit() {
        if (this.undoableEdit == null) {
            this.undoableEdit = new FormUndoableEdit();
        }
        return this.undoableEdit;
    }

    private static void addToInterestList(FormModelEvent ev) {
        if (interestList == null) {
            interestList = new ArrayList();
        } else {
            interestList.remove(ev);
        }
        interestList.add(ev);
    }

    private static void removeFromInterestList(FormModelEvent ev) {
        if (interestList != null) {
            interestList.remove(ev);
        }
    }

    private static void informInterestedEvents(FormModelEvent newEvent) {
        if (interestList != null) {
            Iterator it = interestList.iterator();
            while (it.hasNext()) {
                ((FormModelEvent)it.next()).newEventCreated(newEvent);
            }
        }
    }

    private void newEventCreated(FormModelEvent newEvent) {
        this.additionalEvent = newEvent;
    }

    private class FormUndoableEdit
    extends AbstractUndoableEdit {
        private FormUndoableEdit() {
        }

        public void undo() throws CannotUndoException {
            super.undo();
            boolean undoRedoOn = FormModelEvent.this.getFormModel().isUndoRedoRecording();
            if (undoRedoOn) {
                FormModelEvent.this.getFormModel().setUndoRedoRecording(false);
            }
            switch (FormModelEvent.this.changeType) {
                case 4: {
                    FormModel.t("UNDO: container layout change");
                    this.undoContainerLayoutExchange();
                    break;
                }
                case 5: {
                    FormModel.t("UNDO: container layout property change");
                    this.undoContainerLayoutChange();
                    break;
                }
                case 6: {
                    FormModel.t("UNDO: component layout constraints change");
                    this.undoComponentLayoutChange();
                    break;
                }
                case 9: {
                    FormModel.t("UNDO: components reorder");
                    this.undoComponentsReorder();
                    break;
                }
                case 7: {
                    FormModel.t("UNDO: component addition");
                    this.undoComponentAddition();
                    break;
                }
                case 8: {
                    FormModel.t("UNDO: component removal");
                    this.undoComponentRemoval();
                    break;
                }
                case 10: {
                    FormModel.t("UNDO: component property change");
                    this.undoComponentPropertyChange();
                    break;
                }
                case 11: {
                    FormModel.t("UNDO: synthetic property change");
                    this.undoSyntheticPropertyChange();
                    break;
                }
                case 12: {
                    FormModel.t("UNDO: event handler addition");
                    this.undoEventHandlerAddition();
                    break;
                }
                case 13: {
                    FormModel.t("UNDO: event handler removal");
                    this.undoEventHandlerRemoval();
                    break;
                }
                case 14: {
                    FormModel.t("UNDO: event handler renaming");
                    this.undoEventHandlerRenaming();
                    break;
                }
                default: {
                    FormModel.t("UNDO: " + FormModelEvent.this.changeType);
                }
            }
            if (undoRedoOn) {
                FormModelEvent.this.getFormModel().setUndoRedoRecording(true);
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            boolean undoRedoOn = FormModelEvent.this.getFormModel().isUndoRedoRecording();
            if (undoRedoOn) {
                FormModelEvent.this.getFormModel().setUndoRedoRecording(false);
            }
            switch (FormModelEvent.this.changeType) {
                case 4: {
                    FormModel.t("REDO: container layout change");
                    this.redoContainerLayoutExchange();
                    break;
                }
                case 5: {
                    FormModel.t("REDO: container layout property change");
                    this.redoContainerLayoutChange();
                    break;
                }
                case 6: {
                    FormModel.t("REDO: component layout constraints change");
                    this.redoComponentLayoutChange();
                    break;
                }
                case 9: {
                    FormModel.t("REDO: components reorder");
                    this.redoComponentsReorder();
                    break;
                }
                case 7: {
                    FormModel.t("REDO: component addition");
                    this.redoComponentAddition();
                    break;
                }
                case 8: {
                    FormModel.t("REDO: component removal");
                    this.redoComponentRemoval();
                    break;
                }
                case 10: {
                    FormModel.t("REDO: component property change");
                    this.redoComponentPropertyChange();
                    break;
                }
                case 11: {
                    FormModel.t("REDO: synthetic property change");
                    this.redoSyntheticPropertyChange();
                    break;
                }
                case 12: {
                    FormModel.t("REDO: event handler addition");
                    this.redoEventHandlerAddition();
                    break;
                }
                case 13: {
                    FormModel.t("REDO: event handler removal");
                    this.redoEventHandlerRemoval();
                    break;
                }
                case 14: {
                    FormModel.t("REDO: event handler renaming");
                    this.redoEventHandlerRenaming();
                    break;
                }
                default: {
                    FormModel.t("REDO: " + FormModelEvent.this.changeType);
                }
            }
            if (undoRedoOn) {
                FormModelEvent.this.getFormModel().setUndoRedoRecording(true);
            }
        }

        public String getUndoPresentationName() {
            return "";
        }

        public String getRedoPresentationName() {
            return "";
        }

        public void die() {
            if (FormModelEvent.this.codeUndoRedoStart != null && FormModelEvent.this.codeUndoRedoEnd != null) {
                FormModelEvent.this.getFormModel().getCodeStructure().releaseUndoableChanges(FormModelEvent.this.codeUndoRedoStart, FormModelEvent.this.codeUndoRedoEnd);
            }
        }

        private void undoContainerLayoutExchange() {
            try {
                FormModelEvent.this.getFormModel().setContainerLayout((RADVisualContainer)FormModelEvent.this.getContainer(), FormModelEvent.this.getOldLayoutSupport(), null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private void redoContainerLayoutExchange() {
            try {
                FormModelEvent.this.getFormModel().setContainerLayout((RADVisualContainer)FormModelEvent.this.getContainer(), FormModelEvent.this.getNewLayoutSupport(), null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private void undoContainerLayoutChange() {
            Node.Property prop;
            LayoutSupportManager laysup;
            LayoutSupportManager layoutSupportManager = laysup = FormModelEvent.this.getComponent() instanceof RADVisualContainer ? ((RADVisualContainer)FormModelEvent.this.getComponent()).getLayoutSupport() : null;
            if (laysup != null && (prop = laysup.getLayoutProperty(FormModelEvent.this.getPropertyName())) != null) {
                try {
                    prop.setValue(FormModelEvent.this.getOldPropertyValue());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void redoContainerLayoutChange() {
            Node.Property prop;
            LayoutSupportManager laysup;
            LayoutSupportManager layoutSupportManager = laysup = FormModelEvent.this.getComponent() instanceof RADVisualContainer ? ((RADVisualContainer)FormModelEvent.this.getComponent()).getLayoutSupport() : null;
            if (laysup != null && (prop = laysup.getLayoutProperty(FormModelEvent.this.getPropertyName())) != null) {
                try {
                    prop.setValue(FormModelEvent.this.getNewPropertyValue());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void undoComponentLayoutChange() {
            if (FormModelEvent.this.getComponent() instanceof RADVisualComponent) {
                ((RADVisualComponent)FormModelEvent.this.getComponent()).getConstraintsProperties();
                Node.Property prop = FormModelEvent.this.getComponent().getPropertyByName(FormModelEvent.this.getPropertyName());
                if (prop != null) {
                    try {
                        prop.setValue(FormModelEvent.this.getOldPropertyValue());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        private void redoComponentLayoutChange() {
            if (FormModelEvent.this.getComponent() instanceof RADVisualComponent) {
                ((RADVisualComponent)FormModelEvent.this.getComponent()).getConstraintsProperties();
                Node.Property prop = FormModelEvent.this.getComponent().getPropertyByName(FormModelEvent.this.getPropertyName());
                if (prop != null) {
                    try {
                        prop.setValue(FormModelEvent.this.getNewPropertyValue());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        private void undoComponentAddition() {
            this.redoComponentRemoval();
        }

        private void redoComponentAddition() {
            this.undoComponentRemoval();
        }

        private void undoComponentRemoval() {
            if (FormModelEvent.this.codeUndoRedoStart != null && !FormModelEvent.this.getFormModel().getCodeStructure().undoToMark(FormModelEvent.this.codeUndoRedoStart)) {
                return;
            }
            RADComponent[] currentSubComps = FormModelEvent.this.getContainer().getSubBeans();
            RADComponent[] undoneSubComps = new RADComponent[currentSubComps.length + 1];
            if (FormModelEvent.this.componentIndex < 0) {
                FormModelEvent.this.componentIndex = currentSubComps.length;
            }
            int i = 0;
            int j = 0;
            while (j < undoneSubComps.length) {
                if (i == FormModelEvent.this.componentIndex) {
                    undoneSubComps[j] = FormModelEvent.this.getComponent();
                    if (i == currentSubComps.length) break;
                    ++j;
                }
                undoneSubComps[j] = currentSubComps[i];
                ++i;
                ++j;
            }
            FormModelEvent.this.getContainer().initSubComponents(undoneSubComps);
            if (FormModelEvent.this.getContainer() instanceof RADVisualContainer && FormModelEvent.this.getComponent() instanceof RADVisualComponent) {
                LayoutSupportManager layoutSupport = ((RADVisualContainer)FormModelEvent.this.getContainer()).getLayoutSupport();
                layoutSupport.addComponents(new RADVisualComponent[]{(RADVisualComponent)FormModelEvent.this.getComponent()}, new LayoutConstraints[]{FormModelEvent.this.getComponentLayoutConstraints()}, FormModelEvent.this.componentIndex);
            }
            if (FormModelEvent.this.getCreatedDeleted()) {
                FormModel.setInModelRecursively(FormModelEvent.this.getComponent(), true);
            }
            FormModelEvent.this.getFormModel().fireComponentAdded(FormModelEvent.this.getComponent(), FormModelEvent.this.getCreatedDeleted());
        }

        private void redoComponentRemoval() {
            if (FormModelEvent.this.getCreatedDeleted()) {
                FormModelEvent.this.getFormModel().removeComponent(FormModelEvent.this.getComponent());
            } else {
                FormModelEvent.this.getFormModel().removeComponentFromContainer(FormModelEvent.this.getComponent());
            }
            if (FormModelEvent.this.codeUndoRedoEnd != null) {
                FormModelEvent.this.getFormModel().getCodeStructure().redoToMark(FormModelEvent.this.codeUndoRedoEnd);
            }
        }

        private void undoComponentsReorder() {
            if (FormModelEvent.this.getContainer() != null && FormModelEvent.this.reordering != null) {
                int[] revPerm = new int[FormModelEvent.this.reordering.length];
                int i = 0;
                while (i < FormModelEvent.this.reordering.length) {
                    revPerm[((FormModelEvent)FormModelEvent.this).reordering[i]] = i;
                    ++i;
                }
                FormModelEvent.this.getContainer().reorderSubComponents(revPerm);
                FormModelEvent.this.getFormModel().fireComponentsReordered(FormModelEvent.this.getContainer(), revPerm);
            }
        }

        private void redoComponentsReorder() {
            if (FormModelEvent.this.getContainer() != null && FormModelEvent.this.reordering != null) {
                FormModelEvent.this.getContainer().reorderSubComponents(FormModelEvent.this.reordering);
                FormModelEvent.this.getFormModel().fireComponentsReordered(FormModelEvent.this.getContainer(), FormModelEvent.this.reordering);
            }
        }

        private void undoComponentPropertyChange() {
            Node.Property prop = FormModelEvent.this.getComponent().getPropertyByName(FormModelEvent.this.getPropertyName());
            if (prop != null) {
                try {
                    prop.setValue(FormModelEvent.this.getOldPropertyValue());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void redoComponentPropertyChange() {
            Node.Property prop = FormModelEvent.this.getComponent().getPropertyByName(FormModelEvent.this.getPropertyName());
            if (prop != null) {
                try {
                    prop.setValue(FormModelEvent.this.getNewPropertyValue());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void undoSyntheticPropertyChange() {
            block6: {
                String propName;
                block4: {
                    block5: {
                        propName = FormModelEvent.this.getPropertyName();
                        if (!propName.startsWith("$$$_")) break block4;
                        if (!propName.startsWith("$$$_preCode_")) break block5;
                        FormProperty prop = (FormProperty)FormModelEvent.this.getComponent().getPropertyByName(propName.substring("$$$_preCode_".length()));
                        prop.setPreCode((String)FormModelEvent.this.getOldPropertyValue());
                        break block6;
                    }
                    if (!propName.startsWith("$$$_postCode_")) break block6;
                    FormProperty prop = (FormProperty)FormModelEvent.this.getComponent().getPropertyByName(propName.substring("$$$_postCode_".length()));
                    prop.setPostCode((String)FormModelEvent.this.getOldPropertyValue());
                    break block6;
                }
                Node.Property[] props = FormModelEvent.this.getComponent().getSyntheticProperties();
                int i = 0;
                while (i < props.length) {
                    if (props[i].getName().equals(propName)) {
                        try {
                            props[i].setValue(FormModelEvent.this.getOldPropertyValue());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                    ++i;
                }
            }
        }

        private void redoSyntheticPropertyChange() {
            block6: {
                String propName;
                block4: {
                    block5: {
                        propName = FormModelEvent.this.getPropertyName();
                        if (!propName.startsWith("$$$_")) break block4;
                        if (!propName.startsWith("$$$_preCode_")) break block5;
                        FormProperty prop = (FormProperty)FormModelEvent.this.getComponent().getPropertyByName(propName.substring("$$$_preCode_".length()));
                        prop.setPreCode((String)FormModelEvent.this.getNewPropertyValue());
                        break block6;
                    }
                    if (!propName.startsWith("$$$_postCode_")) break block6;
                    FormProperty prop = (FormProperty)FormModelEvent.this.getComponent().getPropertyByName(propName.substring("$$$_postCode_".length()));
                    prop.setPostCode((String)FormModelEvent.this.getNewPropertyValue());
                    break block6;
                }
                Node.Property[] props = FormModelEvent.this.getComponent().getSyntheticProperties();
                int i = 0;
                while (i < props.length) {
                    if (props[i].getName().equals(propName)) {
                        try {
                            props[i].setValue(FormModelEvent.this.getNewPropertyValue());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                    ++i;
                }
            }
        }

        private void undoEventHandlerAddition() {
            Event event = FormModelEvent.this.getComponentEvent();
            if (event == null) {
                return;
            }
            FormModelEvent.addToInterestList(FormModelEvent.this);
            FormModelEvent.this.getFormModel().getFormEvents().detachEvent(event, FormModelEvent.this.getEventHandler());
            FormModelEvent.removeFromInterestList(FormModelEvent.this);
            Node.Property prop = FormModelEvent.this.getComponent().getPropertyByName(event.getId());
            if (prop != null) {
                try {
                    if (FormModelEvent.this.getEventHandler().equals(prop.getValue())) {
                        prop.setValue(null);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void redoEventHandlerAddition() {
            Event event = FormModelEvent.this.getComponentEvent();
            if (event == null) {
                return;
            }
            FormModelEvent.this.getFormModel().getFormEvents().attachEvent(event, FormModelEvent.this.getEventHandler(), FormModelEvent.this.getOldEventHandlerContent());
            Node.Property prop = FormModelEvent.this.getComponent().getPropertyByName(event.getId());
            if (prop != null) {
                try {
                    prop.setValue((Object)FormModelEvent.this.getEventHandler());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void undoEventHandlerRemoval() {
            Event event = FormModelEvent.this.getComponentEvent();
            if (event == null) {
                return;
            }
            FormModelEvent.this.getFormModel().getFormEvents().attachEvent(event, FormModelEvent.this.getEventHandler(), FormModelEvent.this.getOldEventHandlerContent());
            Node.Property prop = FormModelEvent.this.getComponent().getPropertyByName(event.getId());
            if (prop != null) {
                try {
                    prop.setValue((Object)FormModelEvent.this.getEventHandler());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void redoEventHandlerRemoval() {
            Event event = FormModelEvent.this.getComponentEvent();
            if (event == null) {
                return;
            }
            FormModelEvent.addToInterestList(FormModelEvent.this);
            FormModelEvent.this.getFormModel().getFormEvents().detachEvent(event, FormModelEvent.this.getEventHandler());
            FormModelEvent.removeFromInterestList(FormModelEvent.this);
            Node.Property prop = FormModelEvent.this.getComponent().getPropertyByName(event.getId());
            if (prop != null) {
                try {
                    if (FormModelEvent.this.getEventHandler().equals(prop.getValue())) {
                        prop.setValue(null);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void undoEventHandlerRenaming() {
            FormEvents formEvents = FormModelEvent.this.getFormModel().getFormEvents();
            formEvents.renameEventHandler(FormModelEvent.this.getNewEventHandler(), FormModelEvent.this.getOldEventHandler());
            Event[] events = formEvents.getEventsForHandler(FormModelEvent.this.getOldEventHandler());
            int i = 0;
            while (i < events.length) {
                Node.Property prop = events[i].getComponent().getPropertyByName(events[i].getId());
                if (prop != null) {
                    try {
                        prop.setValue((Object)FormModelEvent.this.getOldEventHandler());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ++i;
            }
        }

        private void redoEventHandlerRenaming() {
            FormEvents formEvents = FormModelEvent.this.getFormModel().getFormEvents();
            formEvents.renameEventHandler(FormModelEvent.this.getOldEventHandler(), FormModelEvent.this.getNewEventHandler());
            Event[] events = formEvents.getEventsForHandler(FormModelEvent.this.getNewEventHandler());
            int i = 0;
            while (i < events.length) {
                Node.Property prop = events[i].getComponent().getPropertyByName(events[i].getId());
                if (prop != null) {
                    try {
                        prop.setValue((Object)FormModelEvent.this.getNewEventHandler());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ++i;
            }
        }
    }
}

