/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormCustomEditor;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormPropertyEditorManager;
import org.netbeans.modules.form.FormUtils;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;

public class FormPropertyEditor
implements PropertyEditor,
PropertyChangeListener,
EnhancedPropertyEditor,
ExPropertyEditor {
    private static String NO_VALUE_TEXT;
    private Object value = BeanSupport.NO_VALUE;
    private FormProperty property;
    private WeakReference propertyEnv;
    private PropertyEditor[] allEditors;
    private PropertyChangeSupport changeSupport;

    FormPropertyEditor(FormProperty property) {
        this.property = property;
        PropertyEditor prEd = property.getCurrentEditor();
        if (prEd != null) {
            prEd.addPropertyChangeListener(this);
            this.value = prEd.getValue();
        }
    }

    Class getPropertyType() {
        return this.property.getValueType();
    }

    FormProperty getProperty() {
        return this.property;
    }

    FormPropertyContext getPropertyContext() {
        return this.property.getPropertyContext();
    }

    PropertyEnv getPropertyEnv() {
        return this.propertyEnv != null ? (PropertyEnv)this.propertyEnv.get() : null;
    }

    PropertyEditor getCurrentEditor() {
        return this.property.getCurrentEditor();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        PropertyEditor prEd = this.property.getCurrentEditor();
        if (prEd != null) {
            this.value = prEd.getValue();
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FormPropertyEditor.this.firePropertyChange();
                return null;
            }
        });
    }

    public void setValue(Object newValue) {
        this.value = newValue;
        PropertyEditor prEd = this.property.getCurrentEditor();
        if (this.value != BeanSupport.NO_VALUE && prEd != null) {
            prEd.setValue(this.value);
        }
    }

    public Object getValue() {
        PropertyEditor prEd = this.property.getCurrentEditor();
        return prEd != null ? prEd.getValue() : this.value;
    }

    public boolean isPaintable() {
        PropertyEditor prEd = this.property.getCurrentEditor();
        return prEd != null ? prEd.isPaintable() : false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        PropertyEditor prEd = this.property.getCurrentEditor();
        if (prEd != null) {
            prEd.paintValue(gfx, box);
        }
    }

    public String getJavaInitializationString() {
        PropertyEditor prEd = this.property.getCurrentEditor();
        return prEd != null ? prEd.getJavaInitializationString() : null;
    }

    public String getAsText() {
        if (this.value == BeanSupport.NO_VALUE) {
            if (NO_VALUE_TEXT == null) {
                NO_VALUE_TEXT = FormUtils.getBundleString("CTL_ValueNotSet");
            }
            return NO_VALUE_TEXT;
        }
        PropertyEditor prEd = this.property.getCurrentEditor();
        return prEd != null ? prEd.getAsText() : null;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        PropertyEditor prEd = this.property.getCurrentEditor();
        if (prEd != null) {
            prEd.setAsText(text);
        }
    }

    public String[] getTags() {
        PropertyEditor prEd = this.property.getCurrentEditor();
        return prEd != null ? prEd.getTags() : null;
    }

    public Component getCustomEditor() {
        Component customEditor;
        PropertyEditor prEd = this.property.getCurrentEditor();
        if (prEd != null && prEd.supportsCustomEditor()) {
            customEditor = prEd.getCustomEditor();
            if (customEditor instanceof Window) {
                return customEditor;
            }
        } else {
            customEditor = null;
        }
        return new FormCustomEditor(this, customEditor);
    }

    public boolean supportsCustomEditor() {
        PropertyEditor[] editors = this.getAllEditors();
        if (editors.length > 1) {
            return true;
        }
        if (editors.length == 1) {
            return editors[0].supportsCustomEditor();
        }
        return false;
    }

    synchronized PropertyEditor[] getAllEditors() {
        if (this.allEditors == null) {
            PropertyEditor expliciteEditor = this.property.getExpliciteEditor();
            PropertyEditor[] typeEditors = FormPropertyEditorManager.getAllEditors(this.property.getValueType());
            if (expliciteEditor != null) {
                int i = 0;
                while (i < typeEditors.length) {
                    if (expliciteEditor.getClass().equals(typeEditors[i].getClass())) {
                        typeEditors[i] = expliciteEditor;
                        expliciteEditor = null;
                        break;
                    }
                    ++i;
                }
            }
            if (expliciteEditor != null) {
                this.allEditors = new PropertyEditor[typeEditors.length + 1];
                this.allEditors[0] = expliciteEditor;
                System.arraycopy(typeEditors, 0, this.allEditors, 1, typeEditors.length);
            } else {
                this.allEditors = typeEditors;
            }
        }
        return this.allEditors;
    }

    public Component getInPlaceCustomEditor() {
        PropertyEditor prEd = this.property.getCurrentEditor();
        return prEd instanceof EnhancedPropertyEditor ? ((EnhancedPropertyEditor)prEd).getInPlaceCustomEditor() : null;
    }

    public boolean hasInPlaceCustomEditor() {
        PropertyEditor prEd = this.property.getCurrentEditor();
        return prEd instanceof EnhancedPropertyEditor ? ((EnhancedPropertyEditor)prEd).hasInPlaceCustomEditor() : false;
    }

    public boolean supportsEditingTaggedValues() {
        PropertyEditor prEd = this.property.getCurrentEditor();
        return prEd instanceof EnhancedPropertyEditor ? ((EnhancedPropertyEditor)prEd).supportsEditingTaggedValues() : false;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        FormPropertyEditor formPropertyEditor = this;
        synchronized (formPropertyEditor) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(l);
        }
    }

    void firePropertyChange() {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(null, null, null);
        }
    }

    public void attachEnv(PropertyEnv env) {
        this.propertyEnv = new WeakReference<PropertyEnv>(env);
        PropertyEditor prEd = this.property.getCurrentEditor();
        if (prEd instanceof ExPropertyEditor) {
            ((ExPropertyEditor)prEd).attachEnv(env);
        }
    }

    public int hashCode() {
        PropertyEditor prEd = this.property.getCurrentEditor();
        return prEd != null ? prEd.hashCode() : super.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null ? this.hashCode() == obj.hashCode() : false;
    }
}

