/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.modules.form.ComponentChooserEditor;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.openide.ErrorManager;
import org.openide.util.SharedClassObject;

public final class FormPropertyEditorManager {
    private static HashMap editorsCache = new HashMap(30);
    private static HashMap expliciteEditors = new HashMap(10);
    static /* synthetic */ Class class$org$netbeans$modules$form$FormLoaderSettings;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$org$netbeans$modules$form$ComponentChooserEditor;
    static /* synthetic */ Class class$org$netbeans$modules$form$RADConnectionPropertyEditor;
    static /* synthetic */ Class class$java$beans$PropertyEditor;

    public static synchronized PropertyEditor findEditor(Class type) {
        PropertyEditor[] editors;
        Class[] edClasses = FormPropertyEditorManager.findEditorClasses(type);
        if (edClasses.length > 0 && (editors = FormPropertyEditorManager.createEditorInstances(new Class[]{edClasses[0]}, type)).length > 0) {
            return editors[0];
        }
        return null;
    }

    public static synchronized void registerEditor(Class type, Class editorClass) {
        Class[] newEditors;
        Class[] currentEditors = (Class[])expliciteEditors.get(FormPropertyEditorManager.getTypeName(type));
        if (currentEditors == null) {
            newEditors = new Class[]{editorClass};
        } else {
            int i = 0;
            while (i < currentEditors.length) {
                if (currentEditors[i].equals(editorClass)) {
                    return;
                }
                ++i;
            }
            newEditors = new Class[currentEditors.length + 1];
            System.arraycopy(currentEditors, 0, newEditors, 0, currentEditors.length);
            newEditors[newEditors.length - 1] = editorClass;
        }
        expliciteEditors.put(FormPropertyEditorManager.getTypeName(type), newEditors);
    }

    public static synchronized PropertyEditor[] getAllEditors(Class type) {
        return FormPropertyEditorManager.createEditorInstances(FormPropertyEditorManager.findEditorClasses(type), type);
    }

    static synchronized void clearEditorsCache() {
        editorsCache.clear();
    }

    private static String getTypeName(Class type) {
        String typeName = type.getName();
        if (type.isPrimitive()) {
            if (Byte.TYPE.equals(type)) {
                typeName = "byte";
            } else if (Short.TYPE.equals(type)) {
                typeName = "short";
            } else if (Integer.TYPE.equals(type)) {
                typeName = "integer";
            } else if (Long.TYPE.equals(type)) {
                typeName = "long";
            } else if (Boolean.TYPE.equals(type)) {
                typeName = "boolean";
            } else if (Float.TYPE.equals(type)) {
                typeName = "float";
            } else if (Double.TYPE.equals(type)) {
                typeName = "double";
            } else if (Character.TYPE.equals(type)) {
                typeName = "char";
            }
        }
        return typeName;
    }

    private static Class[] findEditorClasses(Class type) {
        Class<?> edClass;
        PropertyEditor stdPropEd;
        Class[] edClasses = (Class[])editorsCache.get(type);
        if (edClasses != null) {
            return edClasses;
        }
        FormLoaderSettings formSettings = (FormLoaderSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$form$FormLoaderSettings == null ? (class$org$netbeans$modules$form$FormLoaderSettings = FormPropertyEditorManager.class$("org.netbeans.modules.form.FormLoaderSettings")) : class$org$netbeans$modules$form$FormLoaderSettings), (boolean)true);
        ArrayList<Class> editorsList = new ArrayList<Class>(5);
        PropertyEditor propertyEditor = stdPropEd = type == (class$java$lang$Object == null ? (class$java$lang$Object = FormPropertyEditorManager.class$("java.lang.Object")) : class$java$lang$Object) ? null : PropertyEditorManager.findEditor(type);
        if (stdPropEd != null) {
            editorsList.add(stdPropEd.getClass());
        } else {
            String editorName = type.getName();
            if (!editorName.startsWith("[")) {
                int dot = editorName.lastIndexOf(46);
                if (dot > 0) {
                    editorName = editorName.substring(dot + 1);
                }
                String[] searchPath = formSettings.getEditorSearchPath();
                int i = 0;
                while (i < searchPath.length) {
                    String name = searchPath[i] + "." + editorName + "Editor";
                    try {
                        edClass = Class.forName(name, true, FormUtils.getClassLoader());
                        editorsList.add(edClass);
                        break;
                    }
                    catch (Exception e) {
                        ++i;
                    }
                }
            }
        }
        String typeName = FormPropertyEditorManager.getTypeName(type);
        String[][] registered = formSettings.getRegisteredEditors();
        int i = 0;
        while (i < registered.length) {
            String[] typereg = registered[i];
            if (typereg.length > 0 && typereg[0].equals(typeName)) {
                int j = 1;
                while (j < typereg.length) {
                    try {
                        edClass = Class.forName(typereg[j], true, FormUtils.getClassLoader());
                        if (!editorsList.contains(edClass)) {
                            editorsList.add(edClass);
                        }
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Class[] explicite = (Class[])expliciteEditors.get(typeName);
        if (explicite != null) {
            int i2 = 0;
            while (i2 < explicite.length) {
                edClass = explicite[i2];
                if (!editorsList.contains(edClass)) {
                    editorsList.add(edClass);
                }
                ++i2;
            }
        }
        if ((class$java$awt$Component == null ? (class$java$awt$Component = FormPropertyEditorManager.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(type)) {
            editorsList.add(class$org$netbeans$modules$form$ComponentChooserEditor == null ? (class$org$netbeans$modules$form$ComponentChooserEditor = FormPropertyEditorManager.class$("org.netbeans.modules.form.ComponentChooserEditor")) : class$org$netbeans$modules$form$ComponentChooserEditor);
        }
        editorsList.add(class$org$netbeans$modules$form$RADConnectionPropertyEditor == null ? (class$org$netbeans$modules$form$RADConnectionPropertyEditor = FormPropertyEditorManager.class$("org.netbeans.modules.form.RADConnectionPropertyEditor")) : class$org$netbeans$modules$form$RADConnectionPropertyEditor);
        edClasses = new Class[editorsList.size()];
        editorsList.toArray(edClasses);
        editorsCache.put(type, edClasses);
        return edClasses;
    }

    private static PropertyEditor[] createEditorInstances(Class[] edClasses, Class propertyType) {
        ArrayList<FormAwareEditor> instancesList = new ArrayList<FormAwareEditor>(edClasses.length);
        int i = 0;
        while (i < edClasses.length) {
            Class edType;
            if ((class$org$netbeans$modules$form$RADConnectionPropertyEditor == null ? FormPropertyEditorManager.class$("org.netbeans.modules.form.RADConnectionPropertyEditor") : class$org$netbeans$modules$form$RADConnectionPropertyEditor).isAssignableFrom(edType = edClasses[i])) {
                instancesList.add(new RADConnectionPropertyEditor(propertyType));
            } else if ((class$org$netbeans$modules$form$ComponentChooserEditor == null ? FormPropertyEditorManager.class$("org.netbeans.modules.form.ComponentChooserEditor") : class$org$netbeans$modules$form$ComponentChooserEditor).isAssignableFrom(edType)) {
                instancesList.add(new ComponentChooserEditor(new Class[]{propertyType}));
            } else if ((class$java$beans$PropertyEditor == null ? FormPropertyEditorManager.class$("java.beans.PropertyEditor") : class$java$beans$PropertyEditor).isAssignableFrom(edType)) {
                try {
                    instancesList.add((FormAwareEditor)edType.newInstance());
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            ++i;
        }
        PropertyEditor[] editors = new PropertyEditor[instancesList.size()];
        instancesList.toArray(editors);
        return editors;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

