/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyVetoException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ComponentDragger;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.ComponentLayer;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormRootNode;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.PaletteItem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.MouseUtils;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

class HandleLayer
extends JPanel {
    static final int COMP_DEEPEST = 0;
    static final int COMP_SELECTED = 1;
    static final int COMP_ABOVE_SELECTED = 2;
    static final int COMP_UNDER_SELECTED = 3;
    private static final int DESIGNER_RESIZING = 256;
    private static final MessageFormat resizingHintFormat = new MessageFormat(FormUtils.getBundleString("FMT_HINT_DesignerResizing"));
    private FormDesigner formDesigner;
    private boolean viewOnly;
    private ComponentDragger componentDragger;
    private Point lastLeftMousePoint;
    private Point prevLeftMousePoint;
    private boolean draggingCanceled = false;
    private int resizeType;
    private SelectionDragger selectionDragger;
    private DesignerResizer designerResizer;
    private static FormLoaderSettings formSettings = FormEditor.getFormSettings();
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$javax$swing$JComponent;

    HandleLayer(FormDesigner fd) {
        this.formDesigner = fd;
        this.addMouseListener(new HandleLayerMouseListener());
        this.addMouseMotionListener(new HandleLayerMouseMotionListener());
        this.setLayout(null);
        Method setFocusTraversalKeysMethod = null;
        try {
            setFocusTraversalKeysMethod = this.getClass().getMethod("setFocusTraversalKeys", Integer.TYPE, class$java$util$Set == null ? (class$java$util$Set = HandleLayer.class$("java.util.Set")) : class$java$util$Set);
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
        if (setFocusTraversalKeysMethod != null) {
            HashSet<Object> keys = new HashSet<Object>();
            try {
                Class<?> awtKeyStrokeClass = Class.forName("java.awt.AWTKeyStroke");
                Method getAWTKeyStrokeMethod = awtKeyStrokeClass.getMethod("getAWTKeyStroke", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                keys.add(getAWTKeyStrokeMethod.invoke(null, new Integer(9), new Integer(128), Boolean.TRUE));
                setFocusTraversalKeysMethod.invoke((Object)this, new Integer(0), keys);
                keys.clear();
                keys.add(getAWTKeyStrokeMethod.invoke(null, new Integer(9), new Integer(192), Boolean.TRUE));
                setFocusTraversalKeysMethod.invoke((Object)this, new Integer(1), keys);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.getAccessibleContext().setAccessibleName(FormUtils.getBundleString("ACSN_HandleLayer"));
        this.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_HandleLayer"));
    }

    void setViewOnly(boolean viewOnly) {
        this.viewOnly = viewOnly;
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(formSettings.getSelectionBorderSize()));
        RADComponent conSource = this.formDesigner.getConnectionSource();
        RADComponent conTarget = this.formDesigner.getConnectionTarget();
        if (conSource != null || conTarget != null) {
            g2.setColor(formSettings.getConnectionBorderColor());
            if (conSource != null) {
                this.paintSelection(g2, conSource);
            }
            if (conTarget != null) {
                this.paintSelection(g2, conTarget);
            }
        } else {
            g2.setColor(formSettings.getSelectionBorderColor());
            Iterator metacomps = this.formDesigner.getSelectedComponents().iterator();
            while (metacomps.hasNext()) {
                this.paintSelection(g2, (RADComponent)metacomps.next());
            }
        }
        if (this.componentDragger != null) {
            this.componentDragger.paintDragFeedback(g2);
        }
        if (this.selectionDragger != null) {
            this.selectionDragger.paintDragFeedback(g2);
        }
    }

    private void paintSelection(Graphics2D g, RADComponent metacomp) {
        Object comp = this.formDesigner.getComponent(metacomp);
        if (!(comp instanceof Component)) {
            return;
        }
        Component component = (Component)comp;
        Container parent = component.getParent();
        if (parent != null && component.isShowing()) {
            Rectangle rect = component.getBounds();
            rect = SwingUtilities.convertRectangle(parent, rect, this);
            Rectangle parentRect = new Rectangle(new Point(0, 0), parent.getSize());
            parentRect = SwingUtilities.convertRectangle(parent, parentRect, this);
            Rectangle2D selRect = rect.createIntersection(parentRect);
            int correction = formSettings.getSelectionBorderSize() % 2;
            g.draw(new Rectangle2D.Double(selRect.getX() - (double)correction, selRect.getY() - (double)correction, selRect.getWidth() + (double)correction, selRect.getHeight() + (double)correction));
        }
    }

    public boolean isOpaque() {
        return false;
    }

    protected void processKeyEvent(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 9 || e.getKeyChar() == '\t') {
            if (e.getID() == 401) {
                if (e.isControlDown()) {
                    if (!e.isShiftDown()) {
                        FocusManager.getCurrentManager().focusNextComponent(this);
                    } else {
                        FocusManager.getCurrentManager().focusPreviousComponent(this);
                    }
                } else {
                    RADVisualComponent nextComp = this.formDesigner.getNextVisualComponent(!e.isShiftDown());
                    if (nextComp != null) {
                        this.formDesigner.setSelectedComponent(nextComp);
                    }
                }
            }
            e.consume();
        } else if (keyCode == 32) {
            Iterator it;
            if (!this.viewOnly && e.getID() == 402 && (it = this.formDesigner.getSelectedComponents().iterator()).hasNext()) {
                RADComponent comp = (RADComponent)it.next();
                if (!it.hasNext()) {
                    CPManager palette = CPManager.getDefault();
                    if (palette.getMode() == 0) {
                        this.formDesigner.startInPlaceEditing(comp);
                    } else if (palette.getMode() == 2) {
                        PaletteItem item = palette.getSelectedItem();
                        this.formDesigner.getModel().getComponentCreator().createComponent(item.getInstanceCookie(), comp, null);
                        palette.setMode(0);
                    }
                }
            }
            e.consume();
        } else if (keyCode == 27) {
            if (this.endDragging(null)) {
                e.consume();
            }
        } else if (keyCode == 121) {
            if (e.isShiftDown()) {
                Point p = null;
                Iterator it = this.formDesigner.getSelectedComponents().iterator();
                if (it.hasNext()) {
                    RADComponent metacomp = (RADComponent)it.next();
                    Component sel = (Component)this.formDesigner.getComponent(metacomp);
                    if (sel instanceof Component) {
                        Component comp = sel;
                        p = SwingUtilities.convertPoint(comp.getParent(), comp.getLocation(), this);
                    } else {
                        p = new Point(0, 0);
                    }
                    this.showContextMenu(p);
                    e.consume();
                }
            }
        } else {
            super.processKeyEvent(e);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    private RADComponent getMetaComponentAt(Point point, int mode) {
        Component[] deepComps = HandleLayer.getDeepestComponentsAt(this.formDesigner.getComponentLayer(), point);
        if (deepComps.length == 0) {
            return null;
        }
        int dIndex = mode == 0 ? deepComps.length - 1 : 0;
        Component comp = deepComps[dIndex];
        RADVisualComponent topMetaComp = this.formDesigner.getTopDesignComponent();
        RADComponent firstMetaComp = null;
        RADComponent prevMetaComp = null;
        do {
            RADComponent currMetaComp;
            if ((currMetaComp = this.formDesigner.getMetaComponent(comp)) == null) continue;
            if (firstMetaComp == null) {
                firstMetaComp = currMetaComp;
            }
            switch (mode) {
                case 0: {
                    return currMetaComp;
                }
                case 1: {
                    if (this.formDesigner.isComponentSelected(currMetaComp)) {
                        return currMetaComp;
                    }
                    if (currMetaComp != topMetaComp) break;
                    return firstMetaComp;
                }
                case 2: {
                    if (prevMetaComp != null && this.formDesigner.isComponentSelected(prevMetaComp)) {
                        return currMetaComp;
                    }
                    if (currMetaComp != topMetaComp) break;
                    return firstMetaComp;
                }
                case 3: {
                    if (this.formDesigner.isComponentSelected(currMetaComp)) {
                        return prevMetaComp != null ? prevMetaComp : topMetaComp;
                    }
                    if (currMetaComp != topMetaComp) break;
                    return topMetaComp;
                }
            }
            prevMetaComp = currMetaComp;
        } while ((comp = dIndex + 1 < deepComps.length ? deepComps[++dIndex] : comp.getParent()) != null);
        return firstMetaComp;
    }

    private static Component[] getDeepestComponentsAt(Container parent, Point point) {
        Component comp = SwingUtilities.getDeepestComponentAt(parent, point.x, point.y);
        if (comp == null) {
            return new Component[0];
        }
        Container deepestParent = comp.getParent();
        Component[] deepestComponents = deepestParent.getComponents();
        Point deepestPosition = SwingUtilities.convertPoint(parent, point, deepestParent);
        Component[] componentsAtPoint = new Component[1];
        ArrayList<Component> compList = null;
        int i = 0;
        while (i < deepestComponents.length) {
            comp = deepestComponents[i];
            Point p = comp.getLocation();
            if (comp.isVisible() && comp.contains(deepestPosition.x - p.x, deepestPosition.y - p.y)) {
                if (componentsAtPoint[0] == null) {
                    componentsAtPoint[0] = comp;
                } else {
                    if (compList == null) {
                        compList = new ArrayList<Component>();
                        compList.add(componentsAtPoint[0]);
                    }
                    compList.add(comp);
                }
            }
            ++i;
        }
        if (compList == null) {
            return componentsAtPoint[0] != null ? componentsAtPoint : new Component[]{};
        }
        componentsAtPoint = new Component[compList.size()];
        compList.toArray(componentsAtPoint);
        return componentsAtPoint;
    }

    RADVisualContainer getMetaContainerAt(Point point) {
        RADComponent metacomp = this.getMetaComponentAt(point, 0);
        if (metacomp == null) {
            return null;
        }
        if (metacomp instanceof RADVisualContainer) {
            return (RADVisualContainer)metacomp;
        }
        if (metacomp instanceof RADVisualComponent) {
            return (RADVisualContainer)metacomp.getParentComponent();
        }
        return null;
    }

    private RADComponent selectComponent(MouseEvent e) {
        int selMode = !e.isAltDown() ? 0 : (!e.isShiftDown() ? 2 : 3);
        RADComponent hitMetaComp = this.getMetaComponentAt(e.getPoint(), selMode);
        if (e.isControlDown()) {
            if (hitMetaComp != null) {
                if (this.formDesigner.isComponentSelected(hitMetaComp)) {
                    this.formDesigner.removeComponentFromSelection(hitMetaComp);
                } else {
                    this.formDesigner.addComponentToSelection(hitMetaComp);
                }
            }
        } else if (e.isShiftDown() && !e.isAltDown()) {
            if (hitMetaComp != null && !this.formDesigner.isComponentSelected(hitMetaComp)) {
                if (this.formDesigner.getSelectedComponents().size() > 0) {
                    RADComponent[] intervalToSelect = this.getComponentsIntervalToSelect(hitMetaComp, false);
                    if (intervalToSelect == null) {
                        intervalToSelect = this.getComponentsIntervalToSelect(hitMetaComp, true);
                    }
                    if (intervalToSelect != null) {
                        this.formDesigner.setSelectedComponents(intervalToSelect);
                    } else {
                        this.formDesigner.setSelectedComponent(hitMetaComp);
                    }
                } else {
                    this.formDesigner.setSelectedComponent(hitMetaComp);
                }
            }
        } else if (hitMetaComp != null) {
            if (!this.formDesigner.isComponentSelected(hitMetaComp)) {
                this.formDesigner.setSelectedComponent(hitMetaComp);
            }
        } else {
            this.formDesigner.clearSelection();
        }
        this.repaint();
        return hitMetaComp;
    }

    private RADComponent[] getComponentsIntervalToSelect(RADComponent clickedComp, boolean forward) {
        if (!(clickedComp instanceof RADVisualComponent)) {
            return null;
        }
        LinkedList<RADVisualComponent> toSelect = new LinkedList<RADVisualComponent>();
        RADVisualComponent comp = (RADVisualComponent)clickedComp;
        boolean selected = false;
        do {
            if (forward) {
                toSelect.add(comp);
                continue;
            }
            toSelect.add(0, comp);
        } while ((comp = this.formDesigner.getNextVisualComponent(comp, forward)) != null && comp != clickedComp && !(selected = this.formDesigner.isComponentSelected(comp)) && comp != this.formDesigner.getTopDesignComponent());
        if (selected) {
            if (comp == this.formDesigner.getTopDesignComponent()) {
                if (!forward) {
                    toSelect.add(0, comp);
                }
            } else {
                selected = false;
                do {
                    if (forward) {
                        toSelect.add(comp);
                        continue;
                    }
                    toSelect.add(0, comp);
                } while ((comp = this.formDesigner.getNextVisualComponent(comp, forward)) != null && (selected = this.formDesigner.isComponentSelected(comp)) && comp != this.formDesigner.getTopDesignComponent());
                if (selected && !forward) {
                    toSelect.add(0, comp);
                }
            }
            RADComponent[] compArray = new RADComponent[toSelect.size()];
            toSelect.toArray(compArray);
            return compArray;
        }
        return null;
    }

    private void selectOtherComponentsNode() {
        FormEditorSupport fes = this.formDesigner.getFormEditorSupport();
        ComponentInspector ci = ComponentInspector.getInstance();
        Node[] selectedNode = new Node[]{((FormRootNode)fes.getFormRootNode()).getOthersNode()};
        try {
            ci.setSelectedNodes(selectedNode, fes);
            this.formDesigner.clearSelectionImpl();
            this.repaint();
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
        this.formDesigner.setActivatedNodes(selectedNode);
    }

    private boolean processDoubleClick(MouseEvent e) {
        SystemAction action;
        RADComponentNode node;
        if (e.isShiftDown() || e.isControlDown()) {
            return false;
        }
        RADComponent metacomp = this.getMetaComponentAt(e.getPoint(), 1);
        if (metacomp == null) {
            return true;
        }
        if (e.isAltDown()) {
            if (metacomp == this.formDesigner.getTopDesignComponent()) {
                if ((metacomp = metacomp.getParentComponent()) == null) {
                    return true;
                }
            } else {
                return false;
            }
        }
        if ((node = metacomp.getNodeReference()) != null && (action = node.getDefaultAction()) != null) {
            action.actionPerformed(new ActionEvent(node, 1001, ""));
        }
        return true;
    }

    private void processMouseClickInLayoutSupport(RADComponent metacomp, MouseEvent e) {
        RADVisualContainer metacont;
        if (!(metacomp instanceof RADVisualComponent)) {
            return;
        }
        if (metacomp instanceof RADVisualContainer) {
            metacont = (RADVisualContainer)metacomp;
        } else {
            metacont = (RADVisualContainer)metacomp.getParentComponent();
            if (metacont == null) {
                return;
            }
        }
        Container cont = (Container)this.formDesigner.getComponent(metacont);
        Container contDelegate = metacont.getContainerDelegate(cont);
        Point p = SwingUtilities.convertPoint(this, e.getPoint(), contDelegate);
        metacont.getLayoutSupport().processMouseClick(p, cont, contDelegate);
    }

    private void showContextMenu(Point popupPos) {
        ComponentInspector inspector = ComponentInspector.getInstance();
        TopComponent activated = TopComponent.getRegistry().getActivated();
        if (activated != this.formDesigner && activated != inspector) {
            return;
        }
        this.formDesigner.componentActivated();
        Node[] selectedNodes = inspector.getSelectedNodes();
        JPopupMenu popup = NodeOp.findContextMenu((Node[])selectedNodes);
        if (popup != null) {
            popup.show(this, popupPos.x, popupPos.y);
        }
    }

    boolean anyDragger() {
        return this.componentDragger != null || this.selectionDragger != null || this.designerResizer != null;
    }

    private ComponentDragger createComponentDragger(Point hotspot, int modifiers) {
        List selectedComponents = this.formDesigner.getSelectedComponents();
        if (selectedComponents.size() == 0) {
            return null;
        }
        ArrayList<RADComponent> selComps = new ArrayList<RADComponent>(selectedComponents.size());
        Iterator iter = selectedComponents.iterator();
        while (iter.hasNext()) {
            RADComponent metacomp = (RADComponent)iter.next();
            if (!(metacomp instanceof RADVisualComponent)) continue;
            if (metacomp != this.formDesigner.getTopDesignComponent()) {
                selComps.add(metacomp);
                continue;
            }
            return null;
        }
        HashSet<RADComponent> children = new HashSet<RADComponent>();
        iter = selComps.iterator();
        while (iter.hasNext()) {
            RADComponent metacomp = (RADComponent)iter.next();
            Iterator iter2 = selComps.iterator();
            while (iter2.hasNext()) {
                RADComponent metacomp2 = (RADComponent)iter2.next();
                if (metacomp2 == metacomp || !metacomp.isParentComponent(metacomp2)) continue;
                children.add(metacomp2);
            }
        }
        selComps.removeAll(children);
        if (selComps.isEmpty()) {
            return null;
        }
        RADVisualComponent[] comps = new RADVisualComponent[selComps.size()];
        selComps.toArray(comps);
        if (this.resizeType == 0) {
            RADVisualContainer fixedTargetContainer = null;
            if ((modifiers & 8) != 0) {
                RADVisualContainer parent = comps[0].getParentContainer();
                if ((modifiers & 1) != 0 || this.formDesigner.getTopDesignComponent() == parent) {
                    int i = 1;
                    while (i < comps.length) {
                        if (comps[i].getParentContainer() != parent) {
                            parent = null;
                            break;
                        }
                        ++i;
                    }
                    fixedTargetContainer = parent;
                } else if ((parent = parent.getParentContainer()) != null) {
                    int i = 1;
                    while (i < comps.length) {
                        if (comps[i].getParentContainer().getParentContainer() != parent) {
                            parent = null;
                            break;
                        }
                        ++i;
                    }
                    fixedTargetContainer = parent;
                }
            }
            return new ComponentDragger(this.formDesigner, this, comps, hotspot, fixedTargetContainer);
        }
        return new ComponentDragger(this.formDesigner, this, comps, hotspot, this.resizeType);
    }

    private boolean endDragging(Point commitPosition) {
        if (this.anyDragger()) {
            if (this.resizeType != 0) {
                this.resizeType = 0;
                Cursor cursor = this.getCursor();
                if (cursor != null && cursor.getType() != 0) {
                    this.setCursor(Cursor.getDefaultCursor());
                }
                if (this.getToolTipText() != null) {
                    this.setToolTipText(null);
                }
            }
            if (this.designerResizer != null) {
                if (commitPosition != null) {
                    this.designerResizer.drop(commitPosition);
                } else {
                    Dimension prevSize = this.formDesigner.getStoredDesignerSize();
                    if (!this.formDesigner.getComponentLayer().getDesignerSize().equals(prevSize)) {
                        this.formDesigner.getComponentLayer().updateDesignerSize(prevSize);
                    }
                }
                this.designerResizer = null;
            }
            if (this.componentDragger != null) {
                if (commitPosition != null) {
                    this.componentDragger.dropComponents(commitPosition);
                }
                this.componentDragger = null;
                this.repaint();
            }
            if (this.selectionDragger != null) {
                if (commitPosition != null) {
                    this.selectionDragger.drop(commitPosition);
                }
                this.selectionDragger = null;
                this.repaint();
            }
            this.draggingCanceled = commitPosition == null;
            return true;
        }
        return false;
    }

    private void checkResizing(MouseEvent e) {
        int resizing = this.checkComponentsResizing(e);
        if (resizing == 0) {
            resizing = this.checkDesignerResizing(e);
            if (resizing == 0) {
                if (this.getToolTipText() != null) {
                    this.setToolTipText(null);
                }
            } else if (this.getToolTipText() == null) {
                Dimension size = this.formDesigner.getComponentLayer().getDesignerSize();
                String hint = resizingHintFormat.format(new Object[]{new Integer(size.width), new Integer(size.height)});
                this.setToolTipText(hint);
                ToolTipManager.sharedInstance().mouseEntered(e);
            }
        } else if (this.getToolTipText() != null) {
            this.setToolTipText(null);
        }
        if (resizing != 0) {
            this.setResizingCursor(resizing);
        } else {
            Cursor cursor = this.getCursor();
            if (cursor != null && cursor.getType() != 0) {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private int checkDesignerResizing(MouseEvent e) {
        if (!(e.isAltDown() || e.isControlDown() || e.isShiftDown())) {
            ComponentLayer compLayer = this.formDesigner.getComponentLayer();
            int resizing = this.getSelectionResizable(e.getPoint(), compLayer.getComponentContainer(), compLayer.getDesignerOutsets().right + 2);
            this.resizeType = this.validDesignerResizing(resizing) ? resizing | 0x100 : 0;
        } else {
            this.resizeType = 0;
        }
        return this.resizeType;
    }

    private boolean validDesignerResizing(int resizing) {
        return resizing == 10 || resizing == 2 || resizing == 8;
    }

    private int checkComponentsResizing(MouseEvent e) {
        if (e.isAltDown() || e.isControlDown() || e.isShiftDown()) {
            this.resizeType = 0;
            return this.resizeType;
        }
        RADComponent parent = null;
        Iterator selected = this.formDesigner.getSelectedComponents().iterator();
        while (selected.hasNext()) {
            RADComponent comp = (RADComponent)selected.next();
            if (!(comp instanceof RADVisualComponent) || !(parent == null ? (parent = comp.getParentComponent()) == null : comp.getParentComponent() != parent)) continue;
            return 0;
        }
        Point p = e.getPoint();
        RADComponent compAtPoint = this.getMetaComponentAt(p, 1);
        if (compAtPoint instanceof RADVisualComponent) {
            RADVisualComponent metacomp = (RADVisualComponent)compAtPoint;
            if (!this.formDesigner.isComponentSelected(metacomp)) {
                RADVisualComponent[] otherComps;
                int resizing = 0;
                if (metacomp instanceof RADVisualContainer) {
                    otherComps = ((RADVisualContainer)metacomp).getSubComponents();
                } else {
                    RADVisualContainer metacont = metacomp.getParentContainer();
                    if (metacont != null) {
                        otherComps = metacont.getSubComponents();
                    } else {
                        return 0;
                    }
                }
                int i = 0;
                while (i < otherComps.length) {
                    metacomp = otherComps[i];
                    resizing = this.getComponentResizable(p, metacomp);
                    if (resizing != 0) break;
                    ++i;
                }
                this.resizeType = resizing;
            } else {
                this.resizeType = this.getComponentResizable(p, metacomp);
            }
        } else {
            this.resizeType = 0;
        }
        return this.resizeType;
    }

    private int getComponentResizable(Point p, RADVisualComponent metacomp) {
        Component comp;
        Container contDel;
        if (!this.formDesigner.isComponentSelected(metacomp)) {
            return 0;
        }
        RADVisualContainer metacont = (RADVisualContainer)metacomp.getParentComponent();
        if (metacont == null || metacomp == this.formDesigner.getTopDesignComponent()) {
            return 0;
        }
        LayoutSupportManager laySup = metacont.getLayoutSupport();
        if (laySup == null) {
            return 0;
        }
        Container cont = (Container)this.formDesigner.getComponent(metacont);
        int resizable = laySup.getResizableDirections(cont, contDel = metacont.getContainerDelegate(cont), comp = (Component)this.formDesigner.getComponent(metacomp), metacont.getIndexOf(metacomp));
        if (resizable != 0) {
            resizable &= this.getSelectionResizable(p, comp, 2);
        }
        return resizable;
    }

    private int getSelectionResizable(Point p, Component comp, int borderWidth) {
        if (comp == null) {
            return 0;
        }
        Rectangle bounds = comp.getBounds();
        bounds.x = 0;
        bounds.y = 0;
        bounds = SwingUtilities.convertRectangle(comp, bounds, this);
        Rectangle r1 = new Rectangle(bounds);
        Rectangle r2 = new Rectangle(bounds);
        r1.grow(borderWidth, borderWidth);
        r2.grow(-3, -3);
        if (r2.width < 0) {
            r2.width = 0;
        }
        if (r2.height < 0) {
            r2.height = 0;
        }
        int resizable = 0;
        if (r1.contains(p)) {
            if (p.y >= r2.y + r2.height) {
                resizable |= 2;
            } else if (p.y < r2.y) {
                resizable |= 1;
            }
            if (p.x >= r2.x + r2.width) {
                resizable |= 8;
            } else if (p.x < r2.x) {
                resizable |= 4;
            }
        }
        return resizable;
    }

    private void setResizingCursor(int resizeType) {
        Cursor cursor = null;
        if ((resizeType & 1) != 0) {
            cursor = (resizeType & 4) != 0 ? Cursor.getPredefinedCursor(6) : ((resizeType & 8) != 0 ? Cursor.getPredefinedCursor(7) : Cursor.getPredefinedCursor(8));
        } else if ((resizeType & 2) != 0) {
            cursor = (resizeType & 4) != 0 ? Cursor.getPredefinedCursor(4) : ((resizeType & 8) != 0 ? Cursor.getPredefinedCursor(5) : Cursor.getPredefinedCursor(9));
        } else if ((resizeType & 4) != 0) {
            cursor = Cursor.getPredefinedCursor(10);
        } else if ((resizeType & 8) != 0) {
            cursor = Cursor.getPredefinedCursor(11);
        }
        if (cursor == null) {
            cursor = Cursor.getDefaultCursor();
        }
        this.setCursor(cursor);
    }

    private void setUserDesignerSize() {
        String txt;
        int i;
        NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(FormUtils.getBundleString("CTL_SetDesignerSize_Label"), FormUtils.getBundleString("CTL_SetDesignerSize_Title"));
        Dimension size = this.formDesigner.getComponentLayer().getDesignerSize();
        input.setInputText(Integer.toString(size.width) + ", " + Integer.toString(size.height));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)input) == NotifyDescriptor.OK_OPTION && (i = (txt = input.getInputText()).indexOf(44)) > 0) {
            int n = txt.length();
            try {
                int w = Integer.parseInt(txt.substring(0, i));
                while (++i < n && txt.charAt(i) == ' ') {
                }
                int h = Integer.parseInt(txt.substring(i, n));
                if (w >= 0 && h >= 0) {
                    size = new Dimension(w, h);
                    this.formDesigner.setStoredDesignerSize(size);
                    this.formDesigner.getComponentLayer().updateDesignerSize(size);
                    this.setToolTipText(null);
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
    }

    private LayoutConstraints getConstraintsAtPoint(RADComponent metacomp, Point point) {
        RADVisualContainer metacont;
        if (!(metacomp instanceof RADVisualComponent)) {
            return null;
        }
        RADVisualContainer rADVisualContainer = metacont = metacomp instanceof RADVisualContainer ? (RADVisualContainer)metacomp : (RADVisualContainer)metacomp.getParentComponent();
        if (metacont == null) {
            return null;
        }
        Container cont = (Container)this.formDesigner.getComponent(metacont);
        Container contDel = metacont.getContainerDelegate(cont);
        Point p = SwingUtilities.convertPoint(this, point, contDel);
        return metacont.getLayoutSupport().getNewConstraints(cont, contDel, null, -1, p, null);
    }

    private void showAddHint(RADComponent metacomp, Point p, PaletteItem item) {
        RADVisualContainer metacont;
        if (!(metacomp instanceof RADVisualComponent) && metacomp != null || item.getItemClass() == null) {
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        if (metacomp == null) {
            HandleLayer.setStatusText("FMT_MSG_AddToOthers", new Object[]{item.getDisplayName()});
            return;
        }
        RADVisualContainer rADVisualContainer = metacont = metacomp instanceof RADVisualContainer ? (RADVisualContainer)metacomp : (RADVisualContainer)metacomp.getParentComponent();
        if (item.isLayout()) {
            if (metacont != null) {
                if (!metacont.getLayoutSupport().isDedicated()) {
                    HandleLayer.setStatusText("FMT_MSG_SetLayout", new Object[]{item.getDisplayName(), metacont.getName()});
                } else {
                    HandleLayer.setStatusText("FMT_MSG_CannotSetLayout", new Object[]{metacont.getName()});
                }
            } else {
                HandleLayer.setStatusText("FMT_MSG_CannotSetLayout", new Object[]{metacomp.getName()});
            }
        } else if (item.isBorder()) {
            if ((class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = HandleLayer.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).isAssignableFrom(metacomp.getBeanClass())) {
                HandleLayer.setStatusText("FMT_MSG_SetBorder", new Object[]{item.getDisplayName(), metacomp.getName()});
            } else {
                HandleLayer.setStatusText("FMT_MSG_CannotSetBorder", new Object[]{metacomp.getName()});
            }
        } else if (metacont != null && (item.isMenu() && metacont.getContainerMenu() == null && metacont.canHaveMenu(item.getItemClass()) || item.isVisual() && !item.isMenu())) {
            HandleLayer.setStatusText("FMT_MSG_AddComponent", new Object[]{item.getDisplayName(), metacont.getName()});
        } else {
            HandleLayer.setStatusText("FMT_MSG_AddToOthers", new Object[]{item.getDisplayName()});
        }
    }

    private static void setStatusText(String formatId, Object[] args) {
        StatusDisplayer.getDefault().setStatusText(FormUtils.getFormattedBundleString(formatId, args));
    }

    boolean mouseOnVisual(Point p) {
        Rectangle bounds = this.formDesigner.getComponentLayer().getDesignerBounds();
        return bounds.contains(p);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SelectionDragger {
        private Point startPoint;
        private Point lastPoint;

        public SelectionDragger(Point startPoint) {
            this.startPoint = startPoint;
        }

        public void paintDragFeedback(Graphics g) {
            if (this.startPoint != null && this.lastPoint != null) {
                Rectangle r = this.getRectangle();
                g.drawRect(r.x, r.y, r.width, r.height);
            }
        }

        public void drag(Point p) {
            this.lastPoint = p;
        }

        public void drop(Point endPoint) {
            if (this.startPoint != null && endPoint != null) {
                this.lastPoint = endPoint;
                ArrayList toSelect = new ArrayList();
                this.collectSelectedComponents(this.getRectangle(), HandleLayer.this.formDesigner.getComponentLayer().getComponentContainer(), toSelect);
                RADComponent[] selected = new RADComponent[toSelect.size()];
                toSelect.toArray(selected);
                HandleLayer.this.formDesigner.setSelectedComponents(selected);
            }
        }

        private Rectangle getRectangle() {
            int h;
            int x = this.startPoint.x <= this.lastPoint.x ? this.startPoint.x : this.lastPoint.x;
            int y = this.startPoint.y <= this.lastPoint.y ? this.startPoint.y : this.lastPoint.y;
            int w = this.lastPoint.x - this.startPoint.x;
            if (w < 0) {
                w = -w;
            }
            if ((h = this.lastPoint.y - this.startPoint.y) < 0) {
                h = -h;
            }
            return new Rectangle(x, y, w, h);
        }

        private boolean collectSelectedComponents(Rectangle selRect, Container cont, List toSelect) {
            ArrayList<Component> subContainers = new ArrayList<Component>();
            Component[] comps = cont.getComponents();
            int i = 0;
            while (i < comps.length) {
                block11: {
                    boolean intersects;
                    Component comp;
                    block10: {
                        comp = comps[i];
                        Rectangle bounds = SwingUtilities.convertRectangle(cont, comps[i].getBounds(), HandleLayer.this);
                        intersects = selRect.intersects(bounds);
                        RADComponent metacomp = HandleLayer.this.formDesigner.getMetaComponent(comp);
                        if (!(metacomp instanceof RADComponent)) break block10;
                        if (intersects) {
                            toSelect.add(metacomp);
                        }
                        if (!(metacomp instanceof ComponentContainer)) break block11;
                    }
                    if (intersects && comp instanceof Container) {
                        subContainers.add(comp);
                    }
                }
                ++i;
            }
            if (toSelect.size() > 1 || toSelect.size() == 1 && subContainers.size() == 0) {
                return true;
            }
            Object theOnlyOne = toSelect.size() == 1 ? (Object)toSelect.get(0) : null;
            int i2 = 0;
            while (i2 < subContainers.size()) {
                toSelect.clear();
                if (this.collectSelectedComponents(selRect, (Container)subContainers.get(i2), toSelect)) {
                    return true;
                }
                ++i2;
            }
            if (theOnlyOne != null) {
                toSelect.add(theOnlyOne);
                return true;
            }
            return false;
        }
    }

    private class DesignerResizer {
        boolean dragged = false;

        private DesignerResizer() {
        }

        public void drag(Point p) {
            Dimension size = this.computeDesignerSize(p);
            HandleLayer.this.formDesigner.getComponentLayer().updateDesignerSize(size);
            if (!size.equals(HandleLayer.this.formDesigner.getStoredDesignerSize())) {
                this.dragged = true;
            }
        }

        public void drop(Point p) {
            if (this.dragged) {
                Dimension size = this.computeDesignerSize(p);
                HandleLayer.this.formDesigner.setStoredDesignerSize(size);
            }
        }

        private Dimension computeDesignerSize(Point p) {
            Rectangle r = HandleLayer.this.formDesigner.getComponentLayer().getDesignerBounds();
            int w = r.width;
            int h = r.height;
            if ((HandleLayer.this.resizeType & 2) != 0 && (h = p.y - r.y) < 0) {
                h = 0;
            }
            if ((HandleLayer.this.resizeType & 8) != 0 && (w = p.x - r.x) < 0) {
                w = 0;
            }
            return new Dimension(w, h);
        }
    }

    private class HandleLayerMouseMotionListener
    implements MouseMotionListener {
        private HandleLayerMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent e) {
            Point p = e.getPoint();
            if (HandleLayer.this.designerResizer != null) {
                HandleLayer.this.designerResizer.drag(e.getPoint());
            } else if (CPManager.getDefault().getMode() == 0 && !HandleLayer.this.anyDragger() && !HandleLayer.this.draggingCanceled) {
                if (!(HandleLayer.this.viewOnly || e.isControlDown() || e.isShiftDown() && !e.isAltDown() || HandleLayer.this.lastLeftMousePoint == null || HandleLayer.this.resizeType == 0 && !(HandleLayer.this.lastLeftMousePoint.distance(p) > 8.0))) {
                    HandleLayer.this.componentDragger = HandleLayer.this.createComponentDragger(HandleLayer.this.lastLeftMousePoint, e.getModifiers());
                } else if (HandleLayer.this.formDesigner.getTopDesignComponent() instanceof RADVisualContainer && !e.isAltDown() && !e.isControlDown() && e.isShiftDown() && HandleLayer.this.lastLeftMousePoint != null && HandleLayer.this.lastLeftMousePoint.distance(p) > 4.0) {
                    HandleLayer.this.selectionDragger = new SelectionDragger(HandleLayer.this.lastLeftMousePoint);
                }
            }
            if (HandleLayer.this.componentDragger != null) {
                HandleLayer.this.componentDragger.drag(p);
                HandleLayer.this.repaint();
            }
            if (HandleLayer.this.selectionDragger != null) {
                HandleLayer.this.selectionDragger.drag(p);
                HandleLayer.this.repaint();
            }
            e.consume();
        }

        public void mouseMoved(MouseEvent e) {
            CPManager palette = CPManager.getDefault();
            if (palette.getMode() == 2) {
                RADComponent hitMetaComp = HandleLayer.this.getMetaComponentAt(e.getPoint(), e.isControlDown() || e.isAltDown() ? 1 : 0);
                HandleLayer.this.showAddHint(hitMetaComp, e.getPoint(), palette.getSelectedItem());
            } else if (palette.getMode() == 0) {
                HandleLayer.this.checkResizing(e);
            }
        }
    }

    private class HandleLayerMouseListener
    implements MouseListener {
        private HandleLayerMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (MouseUtils.isRightMouseButton((MouseEvent)e) && !HandleLayer.this.anyDragger()) {
                if (!HandleLayer.this.draggingCanceled) {
                    HandleLayer.this.showContextMenu(e.getPoint());
                } else {
                    HandleLayer.this.draggingCanceled = false;
                }
            }
            e.consume();
        }

        public void mouseReleased(MouseEvent e) {
            if (!HandleLayer.this.isVisible()) {
                return;
            }
            if (MouseUtils.isLeftMouseButton((MouseEvent)e)) {
                CPManager palette = CPManager.getDefault();
                if (palette.getMode() == 0 && !HandleLayer.this.endDragging(e.getPoint())) {
                    if (HandleLayer.this.draggingCanceled) {
                        HandleLayer.this.draggingCanceled = false;
                    } else if (!((HandleLayer.this.resizeType & 0x100) == 0 || e.getClickCount() != 2 || e.isShiftDown() || e.isControlDown() || e.isAltDown())) {
                        HandleLayer.this.setUserDesignerSize();
                    } else if (HandleLayer.this.prevLeftMousePoint != null && e.getClickCount() == 1 && HandleLayer.this.prevLeftMousePoint.distance(e.getPoint()) <= 2.0 && !e.isShiftDown() && !e.isControlDown() && !e.isAltDown()) {
                        HandleLayer.this.formDesigner.startInPlaceEditing(HandleLayer.this.getMetaComponentAt(e.getPoint(), 1));
                    } else if (e.getClickCount() == 1 && !e.isAltDown() && !e.isControlDown() && e.isShiftDown()) {
                        HandleLayer.this.selectComponent(e);
                    }
                }
                HandleLayer.this.prevLeftMousePoint = HandleLayer.this.lastLeftMousePoint;
                HandleLayer.this.lastLeftMousePoint = null;
            }
            e.consume();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            StatusDisplayer.getDefault().setStatusText("");
        }

        public void mousePressed(MouseEvent e) {
            HandleLayer.this.formDesigner.componentActivated();
            if (!HandleLayer.this.isVisible()) {
                return;
            }
            if (MouseUtils.isRightMouseButton((MouseEvent)e)) {
                if (!HandleLayer.this.anyDragger()) {
                    if (!HandleLayer.this.mouseOnVisual(e.getPoint())) {
                        HandleLayer.this.selectOtherComponentsNode();
                    } else {
                        RADComponent hitMetaComp = HandleLayer.this.getMetaComponentAt(e.getPoint(), 1);
                        if (hitMetaComp != null && !HandleLayer.this.formDesigner.isComponentSelected(hitMetaComp)) {
                            HandleLayer.this.formDesigner.setSelectedComponent(hitMetaComp);
                        }
                    }
                } else {
                    HandleLayer.this.endDragging(null);
                }
                e.consume();
            } else if (MouseUtils.isLeftMouseButton((MouseEvent)e)) {
                HandleLayer.this.lastLeftMousePoint = e.getPoint();
                boolean modifier = e.isControlDown() || e.isAltDown() || e.isShiftDown();
                CPManager palette = CPManager.getDefault();
                int paletteMode = palette.getMode();
                if (paletteMode == 0) {
                    HandleLayer.this.checkResizing(e);
                    if (!e.isShiftDown() || e.isAltDown() || e.isControlDown()) {
                        RADComponent hitMetaComp;
                        if (HandleLayer.this.designerResizer == null && !modifier && (HandleLayer.this.resizeType & 0x100) != 0) {
                            if (e.getClickCount() != 2) {
                                HandleLayer.this.designerResizer = new DesignerResizer();
                            }
                        } else if (!HandleLayer.this.mouseOnVisual(HandleLayer.this.lastLeftMousePoint)) {
                            if (HandleLayer.this.resizeType == 0) {
                                HandleLayer.this.selectOtherComponentsNode();
                            }
                        } else if (!(HandleLayer.this.resizeType != 0 || e.getClickCount() == 2 && HandleLayer.this.processDoubleClick(e) || (hitMetaComp = HandleLayer.this.selectComponent(e)) == null || modifier)) {
                            HandleLayer.this.processMouseClickInLayoutSupport(hitMetaComp, e);
                        }
                    }
                    HandleLayer.this.draggingCanceled = false;
                } else if (!HandleLayer.this.viewOnly) {
                    if (paletteMode == 1) {
                        HandleLayer.this.selectComponent(e);
                    } else if (paletteMode == 2) {
                        RADComponent hitMetaComp = HandleLayer.this.getMetaComponentAt(HandleLayer.this.lastLeftMousePoint, e.isAltDown() ? 1 : 0);
                        PaletteItem item = palette.getSelectedItem();
                        LayoutConstraints constraints = !item.isMenu() && item.isVisual() ? HandleLayer.this.getConstraintsAtPoint(hitMetaComp, HandleLayer.this.lastLeftMousePoint) : null;
                        if (!HandleLayer.this.mouseOnVisual(HandleLayer.this.lastLeftMousePoint)) {
                            HandleLayer.this.formDesigner.getModel().getComponentCreator().createComponent(item.getInstanceCookie(), null, null);
                        } else {
                            HandleLayer.this.formDesigner.getModel().getComponentCreator().createComponent(item.getInstanceCookie(), hitMetaComp, (Object)constraints);
                        }
                        if (!e.isShiftDown()) {
                            palette.setMode(0);
                            HandleLayer.this.draggingCanceled = true;
                        }
                    }
                }
                e.consume();
            }
        }
    }
}

