/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.beans.MethodDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.ParametersPicker;
import org.netbeans.modules.form.RADComponent;

public class MethodPicker
extends JPanel {
    static final long serialVersionUID = 7355140527892160804L;
    private JLabel listLabel;
    private JLabel componentLabel;
    private JList methodList;
    private JComboBox componentsCombo;
    private JScrollPane propertiesScrollPane;
    private FormModel formModel;
    private boolean pickerValid = false;
    private RADComponent[] components;
    private Class requiredType;
    private MethodDescriptor[] descriptors;
    private RADComponent selectedComponent;
    private MethodDescriptor selectedMethod;

    public MethodPicker(FormModel formModel, RADComponent componentToSelect, Class requiredType) {
        this.formModel = formModel;
        this.requiredType = requiredType;
        this.initComponents();
        List componentsList = formModel.getMetaComponents();
        Collections.sort(componentsList, new ParametersPicker.ComponentComparator());
        this.components = new RADComponent[componentsList.size()];
        componentsList.toArray(this.components);
        int selIndex = -1;
        Iterator it = componentsList.iterator();
        while (it.hasNext()) {
            RADComponent radComp = (RADComponent)it.next();
            if (componentToSelect != null && componentToSelect == radComp) {
                selIndex = this.componentsCombo.getItemCount();
            }
            if (radComp == formModel.getTopRADComponent()) {
                this.componentsCombo.addItem(FormUtils.getBundleString("CTL_FormTopContainerName"));
                continue;
            }
            this.componentsCombo.addItem(radComp.getName());
        }
        if (selIndex >= 0) {
            this.componentsCombo.setSelectedIndex(selIndex);
        }
        this.updateMethodList();
        this.componentLabel.setText(FormUtils.getBundleString("CTL_CW_Component"));
        this.listLabel.setText(FormUtils.getBundleString("CTL_CW_MethodList"));
        this.componentLabel.setDisplayedMnemonic(FormUtils.getBundleString("CTL_CW_Component_Mnemonic").charAt(0));
        this.listLabel.setDisplayedMnemonic(FormUtils.getBundleString("CTL_CW_MethodList_Mnemonic").charAt(0));
        this.componentsCombo.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Component"));
        this.methodList.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_MethodList"));
        this.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_MethodPicker"));
    }

    public boolean isPickerValid() {
        return this.pickerValid;
    }

    private void setPickerValid(boolean v) {
        boolean old = this.pickerValid;
        this.pickerValid = v;
        this.firePropertyChange("pickerValid", old, this.pickerValid);
    }

    RADComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    void setSelectedComponent(RADComponent selectedComponent) {
        if (selectedComponent != null) {
            this.componentsCombo.setSelectedItem(selectedComponent.getName());
        }
    }

    MethodDescriptor getSelectedMethod() {
        if (this.selectedComponent == null || this.methodList.getSelectedIndex() == -1) {
            return null;
        }
        return this.descriptors[this.methodList.getSelectedIndex()];
    }

    void setSelectedMethod(MethodDescriptor selectedMethod) {
        if (selectedMethod == null) {
            this.methodList.setSelectedIndex(-1);
        } else {
            this.methodList.setSelectedValue(FormUtils.getMethodName(selectedMethod), true);
        }
    }

    private void addComponentsRecursively(ComponentContainer cont, Vector vect) {
        RADComponent[] children = cont.getSubBeans();
        int i = 0;
        while (i < children.length) {
            vect.addElement(children[i]);
            if (children[i] instanceof ComponentContainer) {
                this.addComponentsRecursively((ComponentContainer)((Object)children[i]), vect);
            }
            ++i;
        }
    }

    private void updateMethodList() {
        RADComponent sel = this.getSelectedComponent();
        if (sel == null) {
            this.methodList.setListData(new Object[0]);
            this.methodList.revalidate();
            this.methodList.repaint();
        } else {
            MethodDescriptor[] descs = sel.getBeanInfo().getMethodDescriptors();
            ArrayList<MethodDescriptor> filtered = new ArrayList<MethodDescriptor>();
            int i = 0;
            while (i < descs.length) {
                if (this.requiredType.isAssignableFrom(descs[i].getMethod().getReturnType()) && descs[i].getMethod().getParameterTypes().length == 0) {
                    filtered.add(descs[i]);
                }
                ++i;
            }
            Collections.sort(filtered, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((MethodDescriptor)o1).getName().compareTo(((MethodDescriptor)o2).getName());
                }
            });
            this.descriptors = new MethodDescriptor[filtered.size()];
            filtered.toArray(this.descriptors);
            String[] items = new String[this.descriptors.length];
            int i2 = 0;
            while (i2 < this.descriptors.length) {
                items[i2] = FormUtils.getMethodName(this.descriptors[i2]);
                ++i2;
            }
            this.methodList.setListData(items);
            this.methodList.revalidate();
            this.methodList.repaint();
        }
    }

    private void updateState() {
        if (this.getSelectedComponent() == null || this.getSelectedMethod() == null) {
            this.setPickerValid(false);
        } else {
            this.setPickerValid(this.getSelectedMethod().getMethod().getParameterTypes().length == 0);
        }
    }

    private void initComponents() {
        this.componentLabel = new JLabel();
        this.componentsCombo = new JComboBox();
        this.listLabel = new JLabel();
        this.propertiesScrollPane = new JScrollPane();
        this.methodList = new JList();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.componentLabel.setLabelFor(this.componentsCombo);
        this.componentLabel.setText(FormUtils.getBundleString("CTL_Component"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 6);
        this.add((Component)this.componentLabel, gridBagConstraints);
        this.componentsCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                MethodPicker.this.componentsComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.componentsCombo, gridBagConstraints);
        this.listLabel.setLabelFor(this.methodList);
        this.listLabel.setText(FormUtils.getBundleString("CTL_Component"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.listLabel, gridBagConstraints);
        this.methodList.setSelectionMode(0);
        this.methodList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                MethodPicker.this.methodListValueChanged(evt);
            }
        });
        this.propertiesScrollPane.setViewportView(this.methodList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.propertiesScrollPane, gridBagConstraints);
    }

    private void methodListValueChanged(ListSelectionEvent evt) {
        this.selectedMethod = this.methodList.getSelectedIndex() == -1 ? null : this.descriptors[this.methodList.getSelectedIndex()];
        this.updateState();
    }

    private void componentsComboItemStateChanged(ItemEvent evt) {
        this.selectedComponent = this.componentsCombo.getSelectedIndex() == -1 ? null : this.components[this.componentsCombo.getSelectedIndex()];
        this.updateMethodList();
    }

    private void closeDialog(WindowEvent evt) {
    }
}

