/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MethodPicker;
import org.netbeans.modules.form.PropertyPicker;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class ParametersPicker
extends JPanel
implements EnhancedCustomPropertyEditor {
    static final long serialVersionUID = 1116033799965380000L;
    private JTextField propertyLabel;
    private JTextField methodLabel;
    private JRadioButton codeButton;
    private JRadioButton methodButton;
    private JTextField valueField;
    private JEditorPane codeArea;
    private JRadioButton beanButton;
    private JButton propertyDetailsButton;
    private JComboBox beanCombo;
    private JScrollPane codeScrollPane;
    private JLabel paramLabel;
    private JRadioButton valueButton;
    private JButton methodDetailsButton;
    private JRadioButton propertyButton;
    private FormModel formModel;
    private Class requiredType;
    private PropertyPicker propertyPicker;
    private MethodPicker methodPicker;
    private String selectedPropertyText = null;
    private ArrayList listeners;
    private boolean currentFilledState;
    private RADComponent selectedComponent;
    private PropertyDescriptor selectedProperty;
    private MethodDescriptor selectedMethod;
    private List beansList;
    private DefaultComboBoxModel beanComboModel;
    static /* synthetic */ Class class$java$lang$String;

    public ParametersPicker(FormModel formModel, Class requiredType) {
        this.initComponents();
        this.requiredType = requiredType;
        this.formModel = formModel;
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.valueButton);
        bg.add(this.beanButton);
        bg.add(this.propertyButton);
        bg.add(this.methodButton);
        bg.add(this.codeButton);
        if (!requiredType.isPrimitive() && !requiredType.equals(class$java$lang$String == null ? (class$java$lang$String = ParametersPicker.class$("java.lang.String")) : class$java$lang$String)) {
            this.valueButton.setEnabled(false);
            this.propertyButton.setSelected(true);
        }
        this.paramLabel.setText(FormUtils.getBundleString("CTL_CW_GetParametersFrom"));
        this.paramLabel.setLabelFor(this);
        this.valueButton.setText(FormUtils.getBundleString("CTL_CW_Value"));
        this.beanButton.setText(FormUtils.getBundleString("CTL_CW_Bean"));
        this.propertyButton.setText(FormUtils.getBundleString("CTL_CW_Property"));
        this.propertyLabel.setText(FormUtils.getBundleString("CTL_CW_NoProperty"));
        this.methodButton.setText(FormUtils.getBundleString("CTL_CW_Method"));
        this.methodLabel.setText(FormUtils.getBundleString("CTL_CW_NoMethod"));
        this.codeButton.setText(FormUtils.getBundleString("CTL_CW_UserCode"));
        this.valueButton.setMnemonic(FormUtils.getBundleString("CTL_CW_Value_Mnemonic").charAt(0));
        this.beanButton.setMnemonic(FormUtils.getBundleString("CTL_CW_Bean_Mnemonic").charAt(0));
        this.propertyButton.setMnemonic(FormUtils.getBundleString("CTL_CW_Property_Mnemonic").charAt(0));
        this.methodButton.setMnemonic(FormUtils.getBundleString("CTL_CW_Method_Mnemonic").charAt(0));
        this.codeButton.setMnemonic(FormUtils.getBundleString("CTL_CW_UserCode_Mnemonic").charAt(0));
        this.beansList = new ArrayList();
        Iterator it = formModel.getMetaComponents().iterator();
        while (it.hasNext()) {
            RADComponent radComp = (RADComponent)it.next();
            if (!requiredType.isAssignableFrom(radComp.getBeanClass())) continue;
            this.beansList.add(radComp);
        }
        if (this.beansList.size() > 0) {
            Collections.sort(this.beansList, new ComponentComparator());
            this.beanCombo.addItem(FormUtils.getBundleString("CTL_CW_SelectBean"));
            Iterator it2 = this.beansList.iterator();
            while (it2.hasNext()) {
                RADComponent radComp = (RADComponent)it2.next();
                if (radComp == formModel.getTopRADComponent()) {
                    this.beanCombo.addItem(FormUtils.getBundleString("CTL_FormTopContainerName"));
                    continue;
                }
                this.beanCombo.addItem(radComp.getName());
            }
            this.beanCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    int index = ParametersPicker.this.beanCombo.getSelectedIndex();
                    if (index == 0) {
                        ParametersPicker.this.selectedComponent = null;
                    } else {
                        ParametersPicker.this.selectedComponent = (RADComponent)ParametersPicker.this.beansList.get(index - 1);
                    }
                    ParametersPicker.this.fireStateChange();
                }
            });
        } else {
            this.beanButton.setEnabled(false);
        }
        this.codeArea.setContentType("text/x-java");
        this.updateParameterTypes();
        this.currentFilledState = this.isFilled();
        HelpCtx.setHelpIDString((JComponent)this, (String)"gui.source.modifying.property");
        this.valueButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Value"));
        this.beanButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Bean"));
        this.propertyButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Property"));
        this.methodButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Method"));
        this.codeButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_UserCode"));
        this.valueField.getAccessibleContext().setAccessibleName(this.valueButton.getText());
        this.valueField.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_ValueField"));
        this.beanCombo.getAccessibleContext().setAccessibleName(this.beanButton.getText());
        this.beanCombo.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_BeanCombo"));
        this.propertyLabel.getAccessibleContext().setAccessibleName(this.propertyButton.getText());
        this.propertyLabel.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_PropertyLabel"));
        this.methodLabel.getAccessibleContext().setAccessibleName(this.methodButton.getText());
        this.methodLabel.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_MethodLabel"));
        this.codeArea.getAccessibleContext().setAccessibleName(this.codeButton.getText());
        this.codeArea.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_UserCodeArea"));
        this.propertyDetailsButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_PropertyButton"));
        this.methodDetailsButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_MethodButton"));
        this.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_ParametersPicker"));
    }

    public void setPropertyValue(RADConnectionPropertyEditor.RADConnectionDesignValue value) {
        if (value == null) {
            return;
        }
        switch (value.type) {
            case 3: {
                this.valueButton.setSelected(true);
                this.valueField.setText(value.value);
                break;
            }
            case 4: {
                this.beanButton.setSelected(true);
                this.selectedComponent = value.getRADComponent();
                int index = this.beansList.indexOf(this.selectedComponent);
                if (index <= -1) break;
                this.beanCombo.setSelectedIndex(index + 1);
                break;
            }
            case 0: {
                this.propertyButton.setSelected(true);
                this.selectedComponent = value.getRADComponent();
                this.selectedProperty = value.getProperty();
                if (this.selectedComponent.getCodeExpression() == null) {
                    this.propertyLabel.setText(FormUtils.getBundleString("CTL_CONNECTION_INVALID"));
                } else if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                    this.propertyLabel.setText(this.selectedProperty.getName());
                } else {
                    this.propertyLabel.setText(this.selectedComponent.getName() + "." + this.selectedProperty.getName());
                }
                this.propertyLabel.selectAll();
                break;
            }
            case 1: {
                this.methodButton.setSelected(true);
                this.selectedComponent = value.getRADComponent();
                this.selectedMethod = value.getMethod();
                if (this.selectedComponent.getCodeExpression() == null) {
                    this.methodLabel.setText(FormUtils.getBundleString("CTL_CONNECTION_INVALID"));
                } else if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                    this.methodLabel.setText(this.selectedMethod.getName());
                } else {
                    this.methodLabel.setText(this.selectedComponent.getName() + "." + this.selectedMethod.getName());
                }
                this.methodLabel.selectAll();
                break;
            }
            default: {
                this.codeButton.setSelected(true);
                this.codeArea.setText(value.userCode);
            }
        }
        this.updateParameterTypes();
    }

    public Object getPropertyValue() throws IllegalStateException {
        if (!this.isFilled()) {
            IllegalStateException exc = new IllegalStateException();
            ErrorManager.getDefault().annotate((Throwable)exc, 256, null, FormUtils.getBundleString("ERR_NothingEntered"), null, null);
            throw exc;
        }
        if (this.valueButton.isSelected()) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.requiredType, this.valueField.getText());
        }
        if (this.beanButton.isSelected()) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent);
        }
        if (this.codeButton.isSelected()) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.codeArea.getText());
        }
        if (this.propertyButton.isSelected()) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent, this.selectedProperty);
        }
        if (this.methodButton.isSelected()) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent, this.selectedMethod);
        }
        return null;
    }

    public String getPreviewText() {
        if (!this.isFilled()) {
            return FormUtils.getBundleString("CTL_CW_NotSet");
        }
        if (this.codeButton.isSelected()) {
            return FormUtils.getBundleString("CTL_CW_Code");
        }
        return this.getText();
    }

    public String getText() {
        if (!this.isFilled()) {
            return FormUtils.getBundleString("CTL_CW_NotSet");
        }
        if (this.valueButton.isSelected()) {
            if (this.requiredType.equals(class$java$lang$String == null ? (class$java$lang$String = ParametersPicker.class$("java.lang.String")) : class$java$lang$String)) {
                String s = this.valueField.getText();
                s = Utilities.replaceString((String)s, (String)"\\", (String)"\\\\");
                s = Utilities.replaceString((String)s, (String)"\"", (String)"\\\"");
                return "\"" + s + "\"";
            }
            return this.valueField.getText() != null ? this.valueField.getText() : "";
        }
        if (this.codeButton.isSelected()) {
            return this.codeArea.getText();
        }
        if (this.beanButton.isSelected()) {
            if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                return "this";
            }
            return this.selectedComponent.getName();
        }
        if (this.propertyButton.isSelected()) {
            StringBuffer sb = new StringBuffer();
            if (this.selectedComponent != this.formModel.getTopRADComponent()) {
                sb.append(this.selectedComponent.getName());
                sb.append(".");
            }
            if (this.selectedProperty != null) {
                sb.append(this.selectedProperty.getReadMethod().getName());
                sb.append("()");
            } else {
                sb.append("???");
            }
            return sb.toString();
        }
        if (this.methodButton.isSelected()) {
            StringBuffer sb = new StringBuffer();
            if (this.selectedComponent != this.formModel.getTopRADComponent()) {
                sb.append(this.selectedComponent.getName());
                sb.append(".");
            }
            sb.append(this.selectedMethod.getName());
            sb.append("()");
            return sb.toString();
        }
        return "";
    }

    public boolean isFilled() {
        if (this.codeButton.isSelected()) {
            if (this.requiredType.equals(class$java$lang$String == null ? (class$java$lang$String = ParametersPicker.class$("java.lang.String")) : class$java$lang$String)) {
                return true;
            }
            return !"".equals(this.codeArea.getText());
        }
        if (this.beanButton.isSelected()) {
            return this.selectedComponent != null;
        }
        if (this.propertyButton.isSelected()) {
            return this.selectedProperty != null;
        }
        if (this.valueButton.isSelected()) {
            if (this.requiredType.equals(class$java$lang$String == null ? (class$java$lang$String = ParametersPicker.class$("java.lang.String")) : class$java$lang$String)) {
                return true;
            }
            return !"".equals(this.valueField.getText());
        }
        if (this.methodButton.isSelected()) {
            return this.selectedMethod != null;
        }
        return false;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public synchronized void removeListener(ChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        ((AbstractCollection)this.listeners).remove(l);
    }

    private synchronized void fireStateChange() {
        if (this.listeners == null) {
            return;
        }
        ArrayList list = (ArrayList)this.listeners.clone();
        ChangeEvent evt = new ChangeEvent(this);
        Iterator it = ((AbstractList)list).iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(evt);
        }
    }

    private void initComponents() {
        this.valueButton = new JRadioButton();
        this.valueField = new JTextField();
        this.beanButton = new JRadioButton();
        this.beanCombo = new JComboBox();
        this.propertyButton = new JRadioButton();
        this.propertyLabel = new JTextField();
        this.propertyDetailsButton = new JButton();
        this.methodButton = new JRadioButton();
        this.methodLabel = new JTextField();
        this.methodDetailsButton = new JButton();
        this.codeButton = new JRadioButton();
        this.codeScrollPane = new JScrollPane();
        this.codeArea = new JEditorPane();
        this.paramLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.valueButton.setSelected(true);
        this.valueButton.setText(FormUtils.getBundleString("CTL_CW_Value"));
        this.valueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParametersPicker.this.typeButtonPressed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.valueButton, gridBagConstraints);
        this.valueField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                ParametersPicker.this.updateState(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.valueField, gridBagConstraints);
        this.beanButton.setText(FormUtils.getBundleString("CTL_CW_Bean"));
        this.beanButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParametersPicker.this.typeButtonPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.beanButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.beanCombo, gridBagConstraints);
        this.propertyButton.setText(FormUtils.getBundleString("CTL_CW_Property"));
        this.propertyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParametersPicker.this.typeButtonPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.propertyButton, gridBagConstraints);
        this.propertyLabel.setEditable(false);
        this.propertyLabel.setText(FormUtils.getBundleString("CTL_CW_NoProperty"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.propertyLabel, gridBagConstraints);
        this.propertyDetailsButton.setText("...");
        this.propertyDetailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParametersPicker.this.propertyDetailsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.propertyDetailsButton, gridBagConstraints);
        this.methodButton.setText(FormUtils.getBundleString("CTL_CW_MethodCall"));
        this.methodButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParametersPicker.this.typeButtonPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.methodButton, gridBagConstraints);
        this.methodLabel.setEditable(false);
        this.methodLabel.setText(FormUtils.getBundleString("CTL_CW_NoMethod"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.methodLabel, gridBagConstraints);
        this.methodDetailsButton.setText("...");
        this.methodDetailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParametersPicker.this.methodDetailsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.methodDetailsButton, gridBagConstraints);
        this.codeButton.setText(FormUtils.getBundleString("CTL_CW_UserCode"));
        this.codeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParametersPicker.this.typeButtonPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.codeButton, gridBagConstraints);
        this.codeArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                ParametersPicker.this.updateState(evt);
            }
        });
        this.codeArea.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ParametersPicker.this.codeAreaMouseClicked(evt);
            }
        });
        this.codeScrollPane.setViewportView(this.codeArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.codeScrollPane, gridBagConstraints);
        this.paramLabel.setText("label1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.paramLabel, gridBagConstraints);
    }

    private void codeAreaMouseClicked(MouseEvent evt) {
        if (!this.codeButton.isSelected()) {
            this.codeButton.doClick();
        }
    }

    private void methodDetailsButtonActionPerformed(ActionEvent evt) {
        MethodPicker picker = new MethodPicker(this.formModel, null, this.requiredType);
        picker.setSelectedComponent(this.selectedComponent);
        picker.setSelectedMethod(this.selectedMethod);
        String title = FormUtils.getFormattedBundleString("CTL_FMT_CW_SelectMethod", new Object[]{Utilities.getShortClassName((Class)this.requiredType)});
        final DialogDescriptor dd = new DialogDescriptor((Object)picker, title);
        dd.setValid(picker.isPickerValid());
        picker.addPropertyChangeListener("pickerValid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt2) {
                dd.setValid(((Boolean)evt2.getNewValue()).booleanValue());
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.show();
        if (dd.getValue() == NotifyDescriptor.OK_OPTION) {
            this.selectedComponent = picker.getSelectedComponent();
            this.selectedMethod = picker.getSelectedMethod();
            this.methodLabel.setEnabled(true);
            if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                this.methodLabel.setText(this.selectedMethod.getName());
            } else {
                this.methodLabel.setText(this.selectedComponent.getName() + "." + this.selectedMethod.getName());
            }
            this.methodLabel.repaint();
            this.fireStateChange();
        }
    }

    private void updateState(CaretEvent evt) {
        this.fireStateChange();
        this.codeArea.getCaret().setVisible(this.codeButton.isSelected() && this.codeArea.hasFocus());
    }

    private void propertyDetailsButtonActionPerformed(ActionEvent evt) {
        if (this.propertyPicker == null) {
            this.propertyPicker = new PropertyPicker(this.formModel, null, this.requiredType);
        }
        this.propertyPicker.setSelectedComponent(this.selectedComponent);
        this.propertyPicker.setSelectedProperty(this.selectedProperty);
        String title = FormUtils.getFormattedBundleString("CTL_FMT_CW_SelectProperty", new Object[]{Utilities.getShortClassName((Class)this.requiredType)});
        final DialogDescriptor dd = new DialogDescriptor((Object)this.propertyPicker, title);
        dd.setValid(this.propertyPicker.isPickerValid());
        this.propertyPicker.addPropertyChangeListener("pickerValid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt2) {
                dd.setValid(((Boolean)evt2.getNewValue()).booleanValue());
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.show();
        if (dd.getValue() == NotifyDescriptor.OK_OPTION) {
            this.selectedComponent = this.propertyPicker.getSelectedComponent();
            this.selectedProperty = this.propertyPicker.getSelectedProperty();
            this.propertyLabel.setEnabled(true);
            if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                this.propertyLabel.setText(this.selectedProperty.getName());
            } else {
                this.propertyLabel.setText(this.selectedComponent.getName() + "." + this.selectedProperty.getName());
            }
            this.propertyLabel.repaint();
            this.fireStateChange();
        }
    }

    private void typeButtonPressed(ActionEvent evt) {
        this.updateParameterTypes();
        if (this.beanButton.isSelected()) {
            this.beanCombo.requestFocus();
        } else if (this.codeButton.isSelected()) {
            this.codeArea.requestFocus();
        } else if (this.propertyButton.isSelected()) {
            this.propertyDetailsButton.requestFocus();
        } else if (this.methodButton.isSelected()) {
            this.methodDetailsButton.requestFocus();
        } else if (this.valueButton.isSelected()) {
            this.valueField.requestFocus();
        }
    }

    private void updateParameterTypes() {
        this.valueField.setEnabled(this.valueButton.isSelected());
        this.beanCombo.setEnabled(this.beanButton.isSelected());
        if (!this.propertyButton.isSelected()) {
            this.propertyLabel.setText(FormUtils.getBundleString("CTL_CW_NoProperty"));
        }
        this.propertyLabel.setEnabled(this.propertyButton.isSelected());
        this.propertyLabel.repaint();
        this.propertyDetailsButton.setEnabled(this.propertyButton.isSelected());
        if (!this.methodButton.isSelected()) {
            this.methodLabel.setText(FormUtils.getBundleString("CTL_CW_NoMethod"));
        }
        this.methodLabel.setEnabled(this.methodButton.isSelected());
        this.methodLabel.repaint();
        this.methodDetailsButton.setEnabled(this.methodButton.isSelected());
        this.codeArea.setEnabled(this.codeButton.isSelected());
        this.codeArea.getCaret().setVisible(this.codeButton.isSelected() && this.codeArea.hasFocus());
        this.fireStateChange();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ComponentComparator
    implements Comparator {
        ComponentComparator() {
        }

        public int compare(Object o1, Object o2) {
            RADComponent comp1 = (RADComponent)o1;
            RADComponent comp2 = (RADComponent)o2;
            if (comp1 == comp2) {
                return 0;
            }
            RADComponent topComp = comp1.getFormModel().getTopRADComponent();
            if (comp1 == topComp) {
                return -1;
            }
            if (comp2 == topComp) {
                return 1;
            }
            return comp1.getName().compareTo(comp2.getName());
        }
    }
}

