/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.GandalfPersistenceManager;
import org.netbeans.modules.form.PersistenceException;
import org.openide.ErrorManager;

public abstract class PersistenceManager {
    private static List managers;
    private static List managersByName;

    public abstract boolean canLoadForm(FormDataObject var1) throws PersistenceException;

    public abstract void loadForm(FormDataObject var1, FormModel var2, List var3) throws PersistenceException;

    public abstract void saveForm(FormDataObject var1, FormModel var2, List var3) throws PersistenceException;

    public static void registerManager(PersistenceManager manager) {
        PersistenceManager.getManagersList().add(manager);
    }

    public static void unregisterManager(PersistenceManager manager) {
        PersistenceManager.getManagersList().remove(manager);
    }

    static void registerManager(String managerClassName) {
        PersistenceManager.getManagersNamesList().add(managerClassName);
    }

    public static Iterator getManagers() {
        ClassLoader classLoader = null;
        Iterator iter = PersistenceManager.getManagersNamesList().iterator();
        while (iter.hasNext()) {
            if (classLoader == null) {
                classLoader = FormUtils.getClassLoader();
            }
            String pmClassName = (String)iter.next();
            try {
                PersistenceManager manager = (PersistenceManager)classLoader.loadClass(pmClassName).newInstance();
                PersistenceManager.getManagersList().add(manager);
            }
            catch (Exception ex1) {
                PersistenceManager.notifyError(ex1, pmClassName);
            }
            catch (LinkageError ex2) {
                PersistenceManager.notifyError(ex2, pmClassName);
            }
        }
        PersistenceManager.getManagersNamesList().clear();
        return PersistenceManager.getManagersList().iterator();
    }

    private static List getManagersList() {
        if (managers == null) {
            managers = new ArrayList();
            managers.add(new GandalfPersistenceManager());
        }
        return managers;
    }

    private static List getManagersNamesList() {
        if (managersByName == null) {
            managersByName = new ArrayList();
        }
        return managersByName;
    }

    private static void notifyError(Throwable th, String pmClassName) {
        String msg = FormUtils.getFormattedBundleString("FMT_ERR_PersistenceManagerInstantiation", new Object[]{pmClassName});
        ErrorManager errorManager = ErrorManager.getDefault();
        errorManager.annotate(th, msg);
        errorManager.notify(4096, th);
    }
}

