/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.TextComponent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.ComponentChooserEditor;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.nodes.Node;

public class RADVisualComponent
extends RADComponent {
    private HashMap constraints = new HashMap();
    private Node.Property[] constraintsProperties;
    private ConstraintsListener constraintsListener;
    private MetaAccessibleContext accessibilityData;
    private FormProperty[] accessibilityProperties;

    public void setParentComponent(RADComponent parentComp) {
        super.setParentComponent(parentComp);
        if (parentComp != null) {
            this.getConstraintsProperties();
        }
    }

    public Component getComponent() {
        return (Component)this.getBeanInstance();
    }

    public final RADVisualContainer getParentContainer() {
        return (RADVisualContainer)this.getParentComponent();
    }

    public final int getComponentIndex() {
        RADVisualContainer parent = (RADVisualContainer)this.getParentComponent();
        return parent != null ? parent.getIndexOf(this) : -1;
    }

    final LayoutSupportManager getParentLayoutSupport() {
        RADVisualContainer parent = (RADVisualContainer)this.getParentComponent();
        return parent != null ? parent.getLayoutSupport() : null;
    }

    public void setLayoutConstraints(Class layoutDelegateClass, LayoutConstraints constr) {
        if (constr != null) {
            this.constraints.put(layoutDelegateClass.getName(), constr);
        }
    }

    public LayoutConstraints getLayoutConstraints(Class layoutDelegateClass) {
        return (LayoutConstraints)this.constraints.get(layoutDelegateClass.getName());
    }

    HashMap getConstraintsMap() {
        return this.constraints;
    }

    void setConstraintsMap(Map map) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object layoutClassName = it.next();
            this.constraints.put(layoutClassName, map.get(layoutClassName));
        }
    }

    protected void createPropertySets(List propSets) {
        super.createPropertySets(propSets);
        if (this.constraintsProperties == null) {
            this.createConstraintsProperties();
        }
        if (this.constraintsProperties.length > 0) {
            propSets.add(propSets.size() - 1, new Node.PropertySet("layout", FormUtils.getBundleString("CTL_LayoutTab"), FormUtils.getBundleString("CTL_LayoutTabHint")){

                public Node.Property[] getProperties() {
                    return RADVisualComponent.this.getConstraintsProperties();
                }
            });
        }
        if (this.accessibilityProperties == null) {
            this.createAccessibilityProperties();
        }
        if (this.accessibilityProperties.length > 0) {
            propSets.add(new Node.PropertySet("accessibility", FormUtils.getBundleString("CTL_AccessibilityTab"), FormUtils.getBundleString("CTL_AccessibilityTabHint")){

                public Node.Property[] getProperties() {
                    return RADVisualComponent.this.getAccessibilityProperties();
                }
            });
        }
    }

    public Node.Property getPropertyByName(String name, Class propertyType, boolean fromAll) {
        if (fromAll && this.accessibilityProperties == null) {
            this.createAccessibilityProperties();
        }
        return super.getPropertyByName(name, propertyType, fromAll);
    }

    protected void changePropertiesExplicitly(List prefProps, List normalProps, List expertProps) {
        super.changePropertiesExplicitly(prefProps, normalProps, expertProps);
        if (this.getBeanInstance() instanceof TextComponent) {
            int i = 0;
            int n = normalProps.size();
            while (i < n) {
                RADProperty prop = (RADProperty)((Object)normalProps.get(i));
                if ("text".equals(((FeatureDescriptor)((Object)prop)).getName())) {
                    normalProps.remove(i);
                    normalProps.add(0, prop);
                    break;
                }
                ++i;
            }
        }
    }

    protected void clearProperties() {
        super.clearProperties();
        this.constraintsProperties = null;
        this.accessibilityData = null;
        this.accessibilityProperties = null;
    }

    public Node.Property[] getConstraintsProperties() {
        if (this.constraintsProperties == null) {
            this.createConstraintsProperties();
        }
        return this.constraintsProperties;
    }

    public void resetConstraintsProperties() {
        if (this.constraintsProperties != null) {
            int i = 0;
            while (i < this.constraintsProperties.length) {
                this.nameToProperty.remove(this.constraintsProperties[i].getName());
                ++i;
            }
            this.constraintsProperties = null;
            this.propertySets = null;
            RADComponentNode node = this.getNodeReference();
            if (node != null) {
                node.fireComponentPropertySetsChange();
            }
        }
    }

    private void createConstraintsProperties() {
        LayoutConstraints constr;
        this.constraintsProperties = null;
        LayoutSupportManager layoutSupport = this.getParentLayoutSupport();
        if (layoutSupport != null && (constr = layoutSupport.getConstraints(this)) != null) {
            this.constraintsProperties = constr.getProperties();
        }
        if (this.constraintsProperties == null) {
            this.constraintsProperties = RADComponent.NO_PROPERTIES;
            return;
        }
        int i = 0;
        while (i < this.constraintsProperties.length) {
            if (this.constraintsProperties[i] instanceof FormProperty) {
                FormProperty prop = (FormProperty)this.constraintsProperties[i];
                prop.addVetoableChangeListener(this.getConstraintsListener());
                prop.addPropertyChangeListener(this.getConstraintsListener());
                prop.setPropertyContext(new RADProperty.RADPropertyContext(this));
                if (this.isReadOnly()) {
                    int type = prop.getAccessType() | 0xA;
                    prop.setAccessType(type);
                }
                this.nameToProperty.put(((FeatureDescriptor)((Object)prop)).getName(), prop);
            }
            ++i;
        }
    }

    private ConstraintsListener getConstraintsListener() {
        if (this.constraintsListener == null) {
            this.constraintsListener = new ConstraintsListener();
        }
        return this.constraintsListener;
    }

    public FormProperty[] getAccessibilityProperties() {
        if (this.accessibilityProperties == null) {
            this.createAccessibilityProperties();
        }
        return this.accessibilityProperties;
    }

    private void createAccessibilityProperties() {
        Object comp = this.getBeanInstance();
        if (comp instanceof Accessible && ((Accessible)comp).getAccessibleContext() != null) {
            if (this.accessibilityData == null) {
                this.accessibilityData = new MetaAccessibleContext();
            }
            this.accessibilityProperties = this.accessibilityData.getProperties();
            int i = 0;
            while (i < this.accessibilityProperties.length) {
                FormProperty prop = this.accessibilityProperties[i];
                this.setPropertyListener(prop);
                prop.setPropertyContext(new RADProperty.RADPropertyContext(this));
                this.nameToProperty.put(((FeatureDescriptor)((Object)prop)).getName(), prop);
                ++i;
            }
        } else {
            this.accessibilityData = null;
            this.accessibilityProperties = RADComponent.NO_PROPERTIES;
        }
    }

    public static class AccessibleParentEditor
    extends ComponentChooserEditor {
        static /* synthetic */ Class class$javax$accessibility$Accessible;

        public AccessibleParentEditor() {
            this.setBeanTypes(new Class[]{class$javax$accessibility$Accessible == null ? (class$javax$accessibility$Accessible = AccessibleParentEditor.class$("javax.accessibility.Accessible")) : class$javax$accessibility$Accessible});
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class MetaAccessibleContext {
        private Object accName = BeanSupport.NO_VALUE;
        private Object accDescription = BeanSupport.NO_VALUE;
        private Object accParent = BeanSupport.NO_VALUE;
        private FormProperty[] properties;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$javax$accessibility$Accessible;

        private MetaAccessibleContext() {
        }

        FormProperty[] getProperties() {
            if (this.properties == null) {
                this.properties = new FormProperty[]{new FormProperty(this, "AccessibleContext.accessibleName", class$java$lang$String == null ? (class$java$lang$String = MetaAccessibleContext.class$("java.lang.String")) : class$java$lang$String, FormUtils.getBundleString("PROP_AccessibleName"), FormUtils.getBundleString("PROP_AccessibleName")){
                    private final /* synthetic */ MetaAccessibleContext this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object getTargetValue() {
                        return MetaAccessibleContext.access$200(this.this$1) != BeanSupport.NO_VALUE ? MetaAccessibleContext.access$200(this.this$1) : this.getDefaultValue();
                    }

                    public void setTargetValue(Object value) {
                        MetaAccessibleContext.access$202(this.this$1, (String)value);
                    }

                    public boolean supportsDefaultValue() {
                        return true;
                    }

                    public Object getDefaultValue() {
                        return MetaAccessibleContext.access$300(this.this$1).getAccessibleName();
                    }

                    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
                        super.restoreDefaultValue();
                        MetaAccessibleContext.access$202(this.this$1, BeanSupport.NO_VALUE);
                    }

                    String getPartialSetterCode() {
                        return "getAccessibleContext().setAccessibleName(" + this.getJavaInitializationString() + ")";
                    }
                }, new FormProperty(this, "AccessibleContext.accessibleDescription", class$java$lang$String == null ? (class$java$lang$String = MetaAccessibleContext.class$("java.lang.String")) : class$java$lang$String, FormUtils.getBundleString("PROP_AccessibleDescription"), FormUtils.getBundleString("PROP_AccessibleDescription")){
                    private final /* synthetic */ MetaAccessibleContext this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object getTargetValue() {
                        return MetaAccessibleContext.access$400(this.this$1) != BeanSupport.NO_VALUE ? MetaAccessibleContext.access$400(this.this$1) : this.getDefaultValue();
                    }

                    public void setTargetValue(Object value) {
                        MetaAccessibleContext.access$402(this.this$1, (String)value);
                    }

                    public boolean supportsDefaultValue() {
                        return true;
                    }

                    public Object getDefaultValue() {
                        return MetaAccessibleContext.access$300(this.this$1).getAccessibleDescription();
                    }

                    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
                        super.restoreDefaultValue();
                        MetaAccessibleContext.access$402(this.this$1, BeanSupport.NO_VALUE);
                    }

                    String getPartialSetterCode() {
                        return "getAccessibleContext().setAccessibleDescription(" + this.getJavaInitializationString() + ")";
                    }
                }, new FormProperty(this, "AccessibleContext.accessibleParent", class$javax$accessibility$Accessible == null ? (class$javax$accessibility$Accessible = MetaAccessibleContext.class$("javax.accessibility.Accessible")) : class$javax$accessibility$Accessible, FormUtils.getBundleString("PROP_AccessibleParent"), FormUtils.getBundleString("PROP_AccessibleParent")){
                    private final /* synthetic */ MetaAccessibleContext this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object getTargetValue() {
                        return MetaAccessibleContext.access$500(this.this$1) != BeanSupport.NO_VALUE ? MetaAccessibleContext.access$500(this.this$1) : this.getDefaultValue();
                    }

                    public void setTargetValue(Object value) {
                        MetaAccessibleContext.access$502(this.this$1, (Accessible)value);
                    }

                    public boolean supportsDefaultValue() {
                        return true;
                    }

                    public Object getDefaultValue() {
                        Container cont;
                        RADVisualContainer metacont;
                        Accessible acP = MetaAccessibleContext.access$300(this.this$1).getAccessibleParent();
                        if (acP != null && (metacont = MetaAccessibleContext.access$600(this.this$1).getParentContainer()) != null && (cont = metacont.getContainerDelegate(metacont.getBeanInstance())) == acP) {
                            return metacont;
                        }
                        return acP;
                    }

                    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
                        super.restoreDefaultValue();
                        MetaAccessibleContext.access$502(this.this$1, BeanSupport.NO_VALUE);
                    }

                    public PropertyEditor getExpliciteEditor() {
                        return new AccessibleParentEditor();
                    }

                    String getPartialSetterCode() {
                        String str = this.getJavaInitializationString();
                        return str == null ? null : "getAccessibleContext().setAccessibleParent(" + str + ")";
                    }
                }};
            }
            return this.properties;
        }

        private AccessibleContext getAccessibleContext() {
            return ((Accessible)RADVisualComponent.this.getBeanInstance()).getAccessibleContext();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ Object access$200(MetaAccessibleContext x0) {
            return x0.accName;
        }

        static /* synthetic */ Object access$202(MetaAccessibleContext x0, Object x1) {
            x0.accName = x1;
            return x0.accName;
        }

        static /* synthetic */ AccessibleContext access$300(MetaAccessibleContext x0) {
            return x0.getAccessibleContext();
        }

        static /* synthetic */ Object access$400(MetaAccessibleContext x0) {
            return x0.accDescription;
        }

        static /* synthetic */ Object access$402(MetaAccessibleContext x0, Object x1) {
            x0.accDescription = x1;
            return x0.accDescription;
        }

        static /* synthetic */ Object access$500(MetaAccessibleContext x0) {
            return x0.accParent;
        }

        static /* synthetic */ Object access$502(MetaAccessibleContext x0, Object x1) {
            x0.accParent = x1;
            return x0.accParent;
        }

        static /* synthetic */ RADVisualComponent access$600(MetaAccessibleContext x0) {
            return x0.RADVisualComponent.this;
        }
    }

    private class ConstraintsListener
    implements VetoableChangeListener,
    PropertyChangeListener {
        private ConstraintsListener() {
        }

        public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
            Object source = ev.getSource();
            String eventName = ev.getPropertyName();
            if (source instanceof FormProperty && ("propertyValue".equals(eventName) || "propertyValueAndEditor".equals(eventName))) {
                LayoutSupportManager layoutSupport = RADVisualComponent.this.getParentLayoutSupport();
                int index = RADVisualComponent.this.getComponentIndex();
                LayoutConstraints constraints = layoutSupport.getConstraints(index);
                ev = new PropertyChangeEvent(constraints, ((FeatureDescriptor)((Object)((FormProperty)((Object)source)))).getName(), ev.getOldValue(), ev.getNewValue());
                layoutSupport.componentLayoutChanged(index, ev);
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            Object source = ev.getSource();
            if (source instanceof FormProperty && "currentEditor".equals(ev.getPropertyName())) {
                LayoutSupportManager layoutSupport = RADVisualComponent.this.getParentLayoutSupport();
                int index = RADVisualComponent.this.getComponentIndex();
                LayoutConstraints constraints = layoutSupport.getConstraints(index);
                ev = new PropertyChangeEvent(constraints, null, null, null);
                try {
                    layoutSupport.componentLayoutChanged(index, ev);
                }
                catch (PropertyVetoException ex) {
                    // empty catch block
                }
            }
        }
    }
}

