/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.codestructure;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeExpressionOrigin;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructureChange;
import org.netbeans.modules.form.codestructure.CodeSupport;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.netbeans.modules.form.codestructure.DefaultCodeExpression;
import org.netbeans.modules.form.codestructure.UsedCodeObject;
import org.netbeans.modules.form.codestructure.UsingCodeObject;

public class CodeStructure {
    public static final CodeExpression[] EMPTY_PARAMS = new CodeExpression[0];
    private static final int VARIABLE_CREATE = 1;
    private static final int VARIABLE_RENAME = 2;
    private static final int VARIABLE_RELEASE = 3;
    private static final int VARIABLE_ATTACH = 4;
    private static final int VARIABLE_DETACH = 5;
    private static UsingCodeObject globalUsingObject;
    private Map namesToVariables = new HashMap(50);
    private Map expressionsToVariables = new HashMap(50);
    private static int globalDefaultVariableType;
    private int defaultVariableType = -1;
    private boolean undoRedoRecording = false;
    private int undoRedoMark = 0;
    private int oldestMark = 0;
    private int undoRedoHardLimit = 10000;
    private Map undoMap;
    private Map redoMap;
    private Set providedMarksUndo;
    private Set providedMarksRedo;
    private static int traceCount;
    private static final boolean TRACE = false;
    static /* synthetic */ Class class$org$netbeans$modules$form$codestructure$CodeStructure;
    static /* synthetic */ Class class$org$netbeans$modules$form$codestructure$CodeExpression;
    static /* synthetic */ Class class$org$netbeans$modules$form$codestructure$CodeStatement;

    public CodeStructure(boolean startUndoRedoRecording) {
        if (startUndoRedoRecording) {
            this.setUndoRedoRecording(true);
        }
    }

    public CodeExpression createExpression(Constructor ctor, CodeExpression[] params) {
        CodeSupport.ConstructorOrigin origin = new CodeSupport.ConstructorOrigin(ctor, params);
        return new DefaultCodeExpression(this, origin);
    }

    public CodeExpression createExpression(CodeExpression parent, Method method, CodeExpression[] params) {
        CodeSupport.MethodOrigin origin = new CodeSupport.MethodOrigin(parent, method, params);
        return new DefaultCodeExpression(this, origin);
    }

    public CodeExpression createExpression(CodeExpression parent, Field field) {
        CodeSupport.FieldOrigin origin = new CodeSupport.FieldOrigin(parent, field);
        return new DefaultCodeExpression(this, origin);
    }

    public CodeExpression createExpression(Class type, Object value, String javaInitStr) {
        return new DefaultCodeExpression(this, new CodeSupport.ValueOrigin(type, value, javaInitStr));
    }

    public CodeExpression createExpression(CodeExpressionOrigin origin) {
        return new DefaultCodeExpression(this, origin);
    }

    public CodeExpression createNullExpression(Class type) {
        return new DefaultCodeExpression(this, new CodeSupport.ValueOrigin(type, null, "null"));
    }

    public CodeExpression createDefaultExpression() {
        return new DefaultCodeExpression(this);
    }

    public void registerExpression(CodeExpression expression) {
        if (globalUsingObject == null) {
            globalUsingObject = new GlobalUsingObject();
        }
        expression.addUsingObject(globalUsingObject, 2, class$org$netbeans$modules$form$codestructure$CodeStructure == null ? (class$org$netbeans$modules$form$codestructure$CodeStructure = CodeStructure.class$("org.netbeans.modules.form.codestructure.CodeStructure")) : class$org$netbeans$modules$form$codestructure$CodeStructure);
    }

    public static void removeExpression(CodeExpression expression) {
        CodeStructure.unregisterUsedCodeObject(expression);
        CodeStructure.unregisterUsingCodeObject(expression);
        expression.getCodeStructure().removeExpressionFromVariable(expression);
    }

    public static CodeExpression[] filterExpressions(Iterator it, Object originMetaObject) {
        ArrayList<CodeExpression> list = new ArrayList<CodeExpression>();
        while (it.hasNext()) {
            CodeExpression exp = (CodeExpression)it.next();
            if (!originMetaObject.equals(exp.getOrigin().getMetaObject())) continue;
            list.add(exp);
        }
        return list.toArray(new CodeExpression[list.size()]);
    }

    public static CodeStatement createStatement(CodeExpression expression, Method m, CodeExpression[] params) {
        CodeSupport.MethodStatement statement = new CodeSupport.MethodStatement(expression, m, params);
        CodeStructure.registerUsingCodeObject(statement);
        return statement;
    }

    public static CodeStatement createStatement(CodeExpression expression, Field f, CodeExpression assignExp) {
        CodeSupport.FieldStatement statement = new CodeSupport.FieldStatement(expression, f, assignExp);
        CodeStructure.registerUsingCodeObject(statement);
        return statement;
    }

    public static void removeStatement(CodeStatement statement) {
        CodeStructure.unregisterUsingCodeObject(statement);
    }

    public static void removeStatements(Iterator it) {
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            list.add(it.next());
        }
        int i = 0;
        int n = list.size();
        while (i < n) {
            CodeStructure.unregisterUsingCodeObject((CodeStatement)list.get(i));
            ++i;
        }
    }

    public static CodeStatement[] filterStatements(Iterator it, Object metaObject) {
        ArrayList<CodeStatement> list = new ArrayList<CodeStatement>();
        while (it.hasNext()) {
            CodeStatement statement = (CodeStatement)it.next();
            if (!metaObject.equals(statement.getMetaObject())) continue;
            list.add(statement);
        }
        return list.toArray(new CodeStatement[list.size()]);
    }

    public CodeGroup createCodeGroup() {
        return new CodeSupport.DefaultCodeGroup();
    }

    public static CodeExpressionOrigin createOrigin(Constructor ctor, CodeExpression[] params) {
        return new CodeSupport.ConstructorOrigin(ctor, params);
    }

    public static CodeExpressionOrigin createOrigin(CodeExpression parent, Method m, CodeExpression[] params) {
        return new CodeSupport.MethodOrigin(parent, m, params);
    }

    public static CodeExpressionOrigin createOrigin(CodeExpression parent, Field f) {
        return new CodeSupport.FieldOrigin(parent, f);
    }

    public static CodeExpressionOrigin createOrigin(Class type, Object value, String javaStr) {
        return new CodeSupport.ValueOrigin(type, value, javaStr);
    }

    public static Iterator getDefinedExpressionsIterator(CodeExpression exp) {
        return exp.getUsingObjectsIterator(1, class$org$netbeans$modules$form$codestructure$CodeExpression == null ? (class$org$netbeans$modules$form$codestructure$CodeExpression = CodeStructure.class$("org.netbeans.modules.form.codestructure.CodeExpression")) : class$org$netbeans$modules$form$codestructure$CodeExpression);
    }

    public static Iterator getUsingExpressionsIterator(CodeExpression exp) {
        return exp.getUsingObjectsIterator(2, class$org$netbeans$modules$form$codestructure$CodeExpression == null ? (class$org$netbeans$modules$form$codestructure$CodeExpression = CodeStructure.class$("org.netbeans.modules.form.codestructure.CodeExpression")) : class$org$netbeans$modules$form$codestructure$CodeExpression);
    }

    public static Iterator getDefinedStatementsIterator(CodeExpression exp) {
        return exp.getUsingObjectsIterator(1, class$org$netbeans$modules$form$codestructure$CodeStatement == null ? (class$org$netbeans$modules$form$codestructure$CodeStatement = CodeStructure.class$("org.netbeans.modules.form.codestructure.CodeStatement")) : class$org$netbeans$modules$form$codestructure$CodeStatement);
    }

    public static Iterator getUsingStatementsIterator(CodeExpression exp) {
        return exp.getUsingObjectsIterator(2, class$org$netbeans$modules$form$codestructure$CodeStatement == null ? (class$org$netbeans$modules$form$codestructure$CodeStatement = CodeStructure.class$("org.netbeans.modules.form.codestructure.CodeStatement")) : class$org$netbeans$modules$form$codestructure$CodeStatement);
    }

    static void registerUsingCodeObject(CodeStatement statement) {
        CodeExpression[] params;
        CodeExpression parent = statement.getParentExpression();
        if (parent != null) {
            parent.addUsingObject(statement, 1, class$org$netbeans$modules$form$codestructure$CodeStatement == null ? (class$org$netbeans$modules$form$codestructure$CodeStatement = CodeStructure.class$("org.netbeans.modules.form.codestructure.CodeStatement")) : class$org$netbeans$modules$form$codestructure$CodeStatement);
        }
        if ((params = statement.getStatementParameters()) != null) {
            int i = 0;
            while (i < params.length) {
                params[i].addUsingObject(statement, 2, class$org$netbeans$modules$form$codestructure$CodeStatement == null ? CodeStructure.class$("org.netbeans.modules.form.codestructure.CodeStatement") : class$org$netbeans$modules$form$codestructure$CodeStatement);
                ++i;
            }
        }
    }

    static void registerUsingCodeObject(CodeExpression expression) {
        CodeExpression[] params;
        CodeExpressionOrigin origin = expression.getOrigin();
        CodeExpression parent = origin.getParentExpression();
        if (parent != null) {
            parent.addUsingObject(expression, 1, class$org$netbeans$modules$form$codestructure$CodeExpression == null ? (class$org$netbeans$modules$form$codestructure$CodeExpression = CodeStructure.class$("org.netbeans.modules.form.codestructure.CodeExpression")) : class$org$netbeans$modules$form$codestructure$CodeExpression);
        }
        if ((params = origin.getCreationParameters()) != null) {
            int i = 0;
            while (i < params.length) {
                params[i].addUsingObject(expression, 2, class$org$netbeans$modules$form$codestructure$CodeExpression == null ? CodeStructure.class$("org.netbeans.modules.form.codestructure.CodeExpression") : class$org$netbeans$modules$form$codestructure$CodeExpression);
                ++i;
            }
        }
    }

    static void unregisterUsingCodeObject(UsingCodeObject usingObject) {
        Iterator it = usingObject.getUsedObjectsIterator();
        while (it.hasNext()) {
            UsedCodeObject usedObject = (UsedCodeObject)it.next();
            if (usedObject.removeUsingObject(usingObject) || !(usedObject instanceof UsingCodeObject)) continue;
            CodeStructure.unregisterUsingCodeObject((UsingCodeObject)((Object)usedObject));
        }
    }

    static void unregisterObjectUsage(UsingCodeObject usingObject, UsedCodeObject usedObject) {
        if (!usedObject.removeUsingObject(usingObject) && usedObject instanceof UsingCodeObject) {
            CodeStructure.unregisterUsingCodeObject((UsingCodeObject)((Object)usedObject));
        }
    }

    static void unregisterUsedCodeObject(UsedCodeObject usedObject) {
        ArrayList usingObjects = new ArrayList();
        Iterator it = usedObject.getUsingObjectsIterator(0, null);
        while (it.hasNext()) {
            usingObjects.add(it.next());
        }
        it = usingObjects.iterator();
        while (it.hasNext()) {
            UsingCodeObject usingObject = (UsingCodeObject)it.next();
            if (usingObject.usedObjectRemoved(usedObject)) continue;
            if (usingObject instanceof UsedCodeObject) {
                CodeStructure.unregisterUsedCodeObject((UsedCodeObject)((Object)usingObject));
            }
            CodeStructure.unregisterUsingCodeObject(usingObject);
        }
    }

    public CodeVariable createVariable(int type, Class declaredType, String name) {
        if (this.getVariable(name) != null) {
            return null;
        }
        if (type < 0 || name == null) {
            throw new IllegalArgumentException();
        }
        Variable var = new Variable(type, declaredType, name);
        this.namesToVariables.put(name, var);
        if (this.undoRedoRecording) {
            this.logUndoableChange(new VariableChange(1, var));
        }
        return var;
    }

    public boolean renameVariable(String oldName, String newName) {
        Variable var = (Variable)this.namesToVariables.get(oldName);
        if (var == null || newName == null || newName.equals(var.getName()) || this.namesToVariables.get(newName) != null) {
            return false;
        }
        this.namesToVariables.remove(oldName);
        var.name = newName;
        this.namesToVariables.put(newName, var);
        if (this.undoRedoRecording) {
            VariableChange change = new VariableChange(2, var);
            change.oldName = oldName;
            change.newName = newName;
            this.logUndoableChange(change);
        }
        return true;
    }

    public CodeVariable releaseVariable(String name) {
        Variable var = (Variable)this.namesToVariables.remove(name);
        if (var == null) {
            return null;
        }
        Map expressionsMap = var.expressionsMap;
        if (expressionsMap == null) {
            return var;
        }
        Iterator it = expressionsMap.values().iterator();
        while (it.hasNext()) {
            this.expressionsToVariables.remove(it.next());
        }
        if (this.undoRedoRecording) {
            this.logUndoableChange(new VariableChange(3, var));
        }
        return var;
    }

    public boolean isVariableNameReserved(String name) {
        return this.namesToVariables.get(name) != null;
    }

    public CodeVariable createVariableForExpression(CodeExpression expression, int type, String name) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        if (this.getVariable(expression) != null) {
            return null;
        }
        if (type < 0) {
            throw new IllegalArgumentException();
        }
        if (this.expressionsToVariables.get(expression) != null) {
            this.removeExpressionFromVariable(expression);
        }
        if (name == null || this.namesToVariables.get(name) != null) {
            String baseName;
            int n = 0;
            if (name != null) {
                int i = name.length();
                int exp = 1;
                while (--i >= 0) {
                    char c = name.charAt(i);
                    if (c < '0' || c > '9') break;
                    n += (c - 48) * exp;
                    exp *= 10;
                }
                baseName = i >= 0 ? name.substring(0, i + 1) : name;
            } else {
                String typeName = expression.getOrigin().getType().getName();
                int i = typeName.lastIndexOf(36);
                if (i < 0) {
                    i = typeName.lastIndexOf(46);
                }
                baseName = Character.toLowerCase(typeName.charAt(i + 1)) + typeName.substring(i + 2);
            }
            while (this.namesToVariables.get(name = baseName + ++n) != null) {
            }
        }
        Variable var = new Variable(type, expression.getOrigin().getType(), name);
        CodeStatement statement = this.createVariableAssignment(var, expression);
        var.addCodeExpression(expression, statement);
        this.namesToVariables.put(name, var);
        this.expressionsToVariables.put(expression, var);
        if (this.undoRedoRecording) {
            this.logUndoableChange(new VariableChange(1, var));
            VariableChange change = new VariableChange(4, var);
            change.expression = expression;
            change.statement = statement;
            this.logUndoableChange(change);
        }
        return var;
    }

    public void attachExpressionToVariable(CodeExpression expression, CodeVariable variable) {
        if (expression == null) {
            return;
        }
        if (variable.getAssignment(expression) != null) {
            return;
        }
        int mask = 20480;
        if ((variable.getType() & mask) == 4096 && variable.getAttachedExpressions().size() > 0) {
            throw new IllegalStateException("Standalone local variable declaration required for: " + variable.getName());
        }
        Variable prevVar = (Variable)this.expressionsToVariables.get(expression);
        if (prevVar != null && prevVar != variable) {
            this.removeExpressionFromVariable(expression);
        }
        Variable var = (Variable)variable;
        CodeStatement statement = this.createVariableAssignment(var, expression);
        var.addCodeExpression(expression, statement);
        this.expressionsToVariables.put(expression, var);
        if (this.undoRedoRecording) {
            VariableChange change = new VariableChange(4, var);
            change.expression = expression;
            change.statement = statement;
            this.logUndoableChange(change);
        }
    }

    public void removeExpressionFromVariable(CodeExpression expression) {
        if (expression == null) {
            return;
        }
        Variable var = (Variable)this.expressionsToVariables.remove(expression);
        if (var == null) {
            return;
        }
        CodeStatement statement = var.removeCodeExpression(expression);
        if (this.undoRedoRecording) {
            VariableChange change = new VariableChange(5, var);
            change.expression = expression;
            change.statement = statement;
            this.logUndoableChange(change);
        }
        if (var.expressionsMap.isEmpty() && (var.getType() & 0x8000) == 0) {
            this.releaseVariable(var.getName());
        }
    }

    public CodeVariable getVariable(String name) {
        return (Variable)this.namesToVariables.get(name);
    }

    public CodeVariable getVariable(CodeExpression expression) {
        return (Variable)this.expressionsToVariables.get(expression);
    }

    public Iterator getVariablesIterator(int type, int typeMask, Class declaredType) {
        return new VariablesIterator(type, typeMask, declaredType);
    }

    public Collection getAllVariables() {
        return Collections.unmodifiableCollection(this.namesToVariables.values());
    }

    public static void setGlobalDefaultVariableType(int type) {
        if (type < 0) {
            globalDefaultVariableType = 8194;
        } else {
            int fdMask;
            if (((type &= 0xF0DF) & 0x3000) == 0) {
                type |= 0x2000;
            }
            if ((type & (fdMask = 16400)) == fdMask) {
                type &= 0xFFFFBFFF;
            }
            globalDefaultVariableType = type;
        }
    }

    public void setDefaultVariableType(int type) {
        if (type < 0) {
            this.defaultVariableType = -1;
        } else {
            int fdMask;
            if (((type &= 0xF0DF) & 0x3000) == 0) {
                type |= 0x2000;
            }
            if ((type & (fdMask = 16400)) == fdMask) {
                type &= 0xFFFFBFFF;
            }
            this.defaultVariableType = type;
        }
    }

    static int getGlobalDefaultVariableType() {
        return globalDefaultVariableType;
    }

    int getDefaultVariableType() {
        return this.defaultVariableType > -1 ? this.defaultVariableType : globalDefaultVariableType;
    }

    protected Map getNamesToVariablesMap() {
        return this.namesToVariables;
    }

    protected Map getExpressionsToVariables() {
        return this.expressionsToVariables;
    }

    private CodeStatement createVariableAssignment(CodeVariable var, CodeExpression expression) {
        CodeSupport.AssignVariableStatement statement = new CodeSupport.AssignVariableStatement(var, expression);
        return statement;
    }

    public void setUndoRedoRecording(boolean record) {
        this.undoRedoRecording = record;
        if (record && this.undoMap == null) {
            this.undoMap = new HashMap(500);
            this.redoMap = new HashMap(100);
            this.providedMarksUndo = new HashSet(100);
            this.providedMarksRedo = new HashSet(100);
        }
    }

    public boolean isUndoRedoRecording() {
        return this.undoRedoRecording;
    }

    void logUndoableChange(CodeStructureChange change) {
        this.undoRedoMark += this.redoMap.size();
        this.redoMap.clear();
        this.providedMarksRedo.clear();
        if (this.undoMap.size() == 0) {
            this.oldestMark = this.undoRedoMark;
        }
        CodeStructure.t("adding undoable change " + this.undoRedoMark);
        this.undoMap.put(new Integer(this.undoRedoMark++), change);
        if (this.undoMap.size() > this.undoRedoHardLimit) {
            CodeStructure.t("undo/redo hard limit reached: " + this.undoMap.size() + " > " + this.undoRedoHardLimit);
        }
        while (this.undoMap.size() > this.undoRedoHardLimit) {
            Integer mark = new Integer(this.oldestMark++);
            this.undoMap.remove(mark);
            this.providedMarksUndo.remove(mark);
        }
    }

    public Object markForUndo() {
        this.undoRedoMark += this.redoMap.size();
        this.redoMap.clear();
        this.providedMarksRedo.clear();
        CodeStructure.t("mark for undo: " + this.undoRedoMark);
        Integer newMark = new Integer(this.undoRedoMark);
        if (!this.providedMarksUndo.contains(newMark)) {
            this.providedMarksUndo.add(newMark);
        }
        return newMark;
    }

    public boolean releaseUndoableChanges(Object fromMark, Object toMark) {
        int m1 = (Integer)fromMark;
        int m2 = (Integer)toMark;
        CodeStructure.t("release marks from " + m1 + " to " + m2);
        if (this.undoMap.get(fromMark) != null) {
            while (m1 < m2) {
                Integer m = new Integer(m1);
                this.undoMap.remove(m);
                this.providedMarksUndo.remove(m);
                ++m1;
            }
        } else if (this.redoMap.get(fromMark) != null) {
            while (m1 < m2) {
                Integer m = new Integer(m1);
                this.redoMap.remove(m);
                this.providedMarksRedo.remove(m);
                ++m1;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean undoToMark(Object mark) {
        int lastMark = (Integer)mark;
        if (this.undoRedoMark <= lastMark) {
            return false;
        }
        CodeStructure.t("undo to mark " + mark);
        if (this.undoMap.get(mark) == null || !this.providedMarksUndo.contains(mark)) {
            CodeStructure.t("mark already dropped from the queue");
            return false;
        }
        boolean undoRedoOn = this.undoRedoRecording;
        this.undoRedoRecording = false;
        while (this.undoRedoMark > lastMark) {
            Integer key;
            CodeStructureChange change;
            if ((change = (CodeStructureChange)this.undoMap.remove(key = new Integer(--this.undoRedoMark))) != null) {
                change.undo();
                this.redoMap.put(key, change);
                CodeStructure.t("undone: " + key);
            }
            if (!this.providedMarksUndo.remove(key)) continue;
            this.providedMarksRedo.add(key);
        }
        if (undoRedoOn) {
            this.undoRedoRecording = true;
        }
        return true;
    }

    public boolean redoToMark(Object mark) {
        int toMark = (Integer)mark;
        if (this.undoRedoMark >= toMark) {
            return false;
        }
        CodeStructure.t("redo to mark " + mark);
        boolean undoRedoOn = this.undoRedoRecording;
        this.undoRedoRecording = false;
        while (this.undoRedoMark < toMark) {
            Integer key;
            CodeStructureChange change;
            if ((change = (CodeStructureChange)this.redoMap.remove(key = new Integer(this.undoRedoMark++))) != null) {
                change.redo();
                this.undoMap.put(key, change);
                CodeStructure.t("redone: " + key);
            }
            if (!this.providedMarksRedo.remove(key)) continue;
            this.providedMarksUndo.add(key);
        }
        if (undoRedoOn) {
            this.undoRedoRecording = true;
        }
        return true;
    }

    static void t(String str) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        globalDefaultVariableType = 8194;
        traceCount = 0;
    }

    private class VariableChange
    implements CodeStructureChange {
        private int changeType;
        private Variable variable;
        private CodeExpression expression;
        private CodeStatement statement;
        private String oldName;
        private String newName;

        VariableChange(int type, Variable var) {
            this.changeType = type;
            this.variable = var;
        }

        public void undo() {
            switch (this.changeType) {
                case 1: {
                    CodeStructure.this.namesToVariables.remove(this.variable.name);
                    break;
                }
                case 2: {
                    CodeStructure.this.namesToVariables.remove(this.newName);
                    this.variable.name = this.oldName;
                    CodeStructure.this.namesToVariables.put(this.oldName, this.variable);
                    break;
                }
                case 3: {
                    Iterator it = this.variable.expressionsMap.values().iterator();
                    while (it.hasNext()) {
                        CodeStructure.this.expressionsToVariables.put(it.next(), this.variable);
                    }
                    CodeStructure.this.namesToVariables.put(this.variable.name, this.variable);
                    break;
                }
                case 4: {
                    CodeStructure.this.expressionsToVariables.remove(this.expression);
                    this.variable.expressionsMap.remove(this.expression);
                    break;
                }
                case 5: {
                    this.variable.expressionsMap.put(this.expression, this.statement);
                    CodeStructure.this.expressionsToVariables.put(this.expression, this.variable);
                }
            }
        }

        public void redo() {
            switch (this.changeType) {
                case 1: {
                    CodeStructure.this.namesToVariables.put(this.variable.name, this.variable);
                    break;
                }
                case 2: {
                    CodeStructure.this.namesToVariables.remove(this.oldName);
                    this.variable.name = this.newName;
                    CodeStructure.this.namesToVariables.put(this.newName, this.variable);
                    break;
                }
                case 3: {
                    CodeStructure.this.namesToVariables.remove(this.variable.name);
                    Iterator it = this.variable.expressionsMap.values().iterator();
                    while (it.hasNext()) {
                        CodeStructure.this.expressionsToVariables.remove(it.next());
                    }
                    break;
                }
                case 4: {
                    this.variable.expressionsMap.put(this.expression, this.statement);
                    CodeStructure.this.expressionsToVariables.put(this.expression, this.variable);
                    break;
                }
                case 5: {
                    CodeStructure.this.expressionsToVariables.remove(this.expression);
                    this.variable.expressionsMap.remove(this.expression);
                }
            }
        }
    }

    private final class VariablesIterator
    implements Iterator {
        private int type;
        private int typeMask;
        private Class declaredType;
        private Iterator subIterator;
        private CodeVariable currentVar;

        public VariablesIterator(int type, int typeMask, Class declaredType) {
            this.type = type;
            this.typeMask = typeMask;
            this.declaredType = declaredType;
            this.subIterator = CodeStructure.this.namesToVariables.values().iterator();
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.currentVar == null) ** GOTO lbl7
            return true;
lbl-1000:
            // 1 sources

            {
                var = (CodeVariable)this.subIterator.next();
                if (this.type >= 0 && (this.type & this.typeMask) != (var.getType() & this.typeMask) || this.declaredType != null && !this.declaredType.equals(var.getDeclaredType())) continue;
                this.currentVar = var;
                return true;
lbl7:
                // 2 sources

                ** while (this.subIterator.hasNext())
            }
lbl8:
            // 1 sources

            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            CodeVariable var = this.currentVar;
            this.currentVar = null;
            return var;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    final class Variable
    implements CodeVariable {
        private int type;
        private Class declaredType;
        private String name;
        private Map expressionsMap;
        private CodeStatement declarationStatement;

        Variable(int type, Class declaredType, String name) {
            if ((type & 0x10) != 0) {
                type &= 0xFFFFBFFF;
            }
            this.type = type;
            this.declaredType = declaredType;
            this.name = name;
        }

        public int getType() {
            return (this.type & 0x30DF) != 12511 ? this.type : CodeStructure.this.getDefaultVariableType();
        }

        public String getName() {
            return this.name;
        }

        public Class getDeclaredType() {
            return this.declaredType;
        }

        public Collection getAttachedExpressions() {
            return this.expressionsMap != null ? Collections.unmodifiableCollection(this.expressionsMap.keySet()) : Collections.EMPTY_LIST;
        }

        public CodeStatement getDeclaration() {
            if (this.declarationStatement == null) {
                this.declarationStatement = new CodeSupport.DeclareVariableStatement(this);
            }
            return this.declarationStatement;
        }

        public CodeStatement getAssignment(CodeExpression expression) {
            return this.expressionsMap != null ? (CodeStatement)this.expressionsMap.get(expression) : null;
        }

        void addCodeExpression(CodeExpression expression, CodeStatement statement) {
            if (this.expressionsMap == null) {
                this.expressionsMap = new HashMap();
            }
            this.expressionsMap.put(expression, statement);
        }

        CodeStatement removeCodeExpression(CodeExpression expression) {
            if (this.expressionsMap != null) {
                return (CodeStatement)this.expressionsMap.remove(expression);
            }
            return null;
        }
    }

    private static class GlobalUsingObject
    implements UsingCodeObject {
        private GlobalUsingObject() {
        }

        public void usageRegistered(UsedCodeObject usedObject) {
        }

        public boolean usedObjectRemoved(UsedCodeObject usedObject) {
            return true;
        }

        public UsedCodeObject getDefiningObject() {
            return null;
        }

        public Iterator getUsedObjectsIterator() {
            return null;
        }
    }
}

