/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class KeyStrokeEditor
extends PropertyEditorSupport
implements XMLPropertyEditor {
    private String TXT_CTRL;
    private String TXT_ALT;
    private String TXT_SHIFT;
    public static final String XML_KEYSTROKE = "KeyStroke";
    public static final String ATTR_KEY = "key";
    private static String[] _virtualKeys;
    private CustomEditor _customEditor;
    static /* synthetic */ Class class$org$netbeans$modules$form$editors$KeyStrokeEditor;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public KeyStrokeEditor() {
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$form$editors$KeyStrokeEditor == null ? (class$org$netbeans$modules$form$editors$KeyStrokeEditor = KeyStrokeEditor.class$("org.netbeans.modules.form.editors.KeyStrokeEditor")) : class$org$netbeans$modules$form$editors$KeyStrokeEditor));
        this.TXT_CTRL = bundle.getString("CTL_Ctrl");
        this.TXT_SHIFT = bundle.getString("CTL_Shift");
        this.TXT_ALT = bundle.getString("CTL_Alt");
    }

    public String getJavaInitializationString() {
        KeyStroke key = (KeyStroke)this.getValue();
        int mods = key.getModifiers();
        StringBuffer modsText = new StringBuffer();
        if (0 != (mods & 0xB)) {
            if (0 != (mods & 8)) {
                modsText.append("java.awt.event.InputEvent.ALT_MASK");
            }
            if (0 != (mods & 1)) {
                if (modsText.length() > 0) {
                    modsText.append(" | ");
                }
                modsText.append("java.awt.event.InputEvent.SHIFT_MASK");
            }
            if (0 != (mods & 2)) {
                if (modsText.length() > 0) {
                    modsText.append(" | ");
                }
                modsText.append("java.awt.event.InputEvent.CTRL_MASK");
            }
        } else {
            modsText.append("0");
        }
        return "javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent." + KeyStrokeEditor.getVirtualkeyName(key.getKeyCode()) + ", " + modsText.toString() + ")";
    }

    public String getAsText() {
        KeyStroke key = (KeyStroke)this.getValue();
        return key != null ? this.keyStrokeAsString(key, true) : "null";
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null || "".equals(text) || "null".equals(text)) {
            this.setValue(null);
            return;
        }
        KeyStroke key = this.keyStrokeFromString(text, true);
        if (key == null) {
            throw new IllegalArgumentException("Unrecognized key: " + text);
        }
        this.setValue(key);
    }

    private static String getVirtualkeyName(int keycode) {
        Field[] fields = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = KeyStrokeEditor.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field f = fields[i];
            int modifiers = f.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && f.getType() == Integer.TYPE && f.getName().startsWith("VK_")) {
                try {
                    if (f.getInt(class$java$awt$event$KeyEvent == null ? KeyStrokeEditor.class$("java.awt.event.KeyEvent") : class$java$awt$event$KeyEvent) == keycode) {
                        return f.getName();
                    }
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private KeyStroke keyStrokeFromString(String s, boolean i18ned) {
        String token;
        StringTokenizer st = new StringTokenizer(s, "+");
        int mods = 0;
        int keycode = 0;
        String alt = i18ned ? this.TXT_ALT : "Alt";
        String shift = i18ned ? this.TXT_SHIFT : "Shift";
        String ctrl = i18ned ? this.TXT_CTRL : "Ctrl";
        while (st.hasMoreTokens() && (token = st.nextToken()) != null) {
            void var4_9;
            if (alt.equalsIgnoreCase((String)var4_9)) {
                mods |= 8;
                continue;
            }
            if (shift.equalsIgnoreCase((String)var4_9)) {
                mods |= 1;
                continue;
            }
            if (ctrl.equalsIgnoreCase((String)var4_9)) {
                mods |= 2;
                continue;
            }
            String keycodeName = "VK_" + var4_9.toUpperCase();
            try {
                keycode = (class$java$awt$event$KeyEvent == null ? KeyStrokeEditor.class$("java.awt.event.KeyEvent") : class$java$awt$event$KeyEvent).getField(keycodeName).getInt(class$java$awt$event$KeyEvent == null ? KeyStrokeEditor.class$("java.awt.event.KeyEvent") : class$java$awt$event$KeyEvent);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (keycode != 0) {
            return KeyStroke.getKeyStroke(keycode, mods);
        }
        return null;
    }

    private String keyStrokeAsString(KeyStroke key, boolean i18ned) {
        String alt = i18ned ? this.TXT_ALT : "Alt";
        String shift = i18ned ? this.TXT_SHIFT : "Shift";
        String ctrl = i18ned ? this.TXT_CTRL : "Ctrl";
        StringBuffer buf = new StringBuffer();
        int mods = key.getModifiers();
        int[] modMasks = new int[]{1, 2, 8};
        String[] modMaskStrings = new String[]{shift, ctrl, alt};
        int i = 0;
        while (i < modMasks.length) {
            if ((mods & modMasks[i]) != 0) {
                buf.append(modMaskStrings[i]);
                buf.append("+");
            }
            ++i;
        }
        String keyName = KeyStrokeEditor.getVirtualkeyName(key.getKeyCode());
        if (keyName != null) {
            buf.append(keyName.substring(3));
        }
        return buf.toString();
    }

    public void readFromXML(Node element) throws IOException {
        if (!XML_KEYSTROKE.equals(element.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap attributes = element.getAttributes();
        try {
            String value = attributes.getNamedItem(ATTR_KEY).getNodeValue();
            KeyStroke key = this.keyStrokeFromString(value, false);
            if (key == null) {
                throw new IllegalArgumentException();
            }
            this.setValue(key);
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    public Node storeToXML(Document doc) {
        KeyStroke key = (KeyStroke)this.getValue();
        String str = key != null ? this.keyStrokeAsString(key, false) : "null";
        Element el = doc.createElement(XML_KEYSTROKE);
        el.setAttribute(ATTR_KEY, str);
        return el;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new CustomEditor();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String[] access$602(String[] x0) {
        _virtualKeys = x0;
        return x0;
    }

    private class CustomEditor
    extends JPanel {
        private KeyGrabberField _keyGrabber;
        private JCheckBox _ctrl;
        private JCheckBox _alt;
        private JCheckBox _shift;
        private JComboBox _virtualKey;
        static /* synthetic */ Class class$org$netbeans$modules$form$editors$KeyStrokeEditor;
        static /* synthetic */ Class class$java$awt$event$KeyEvent;

        CustomEditor() {
            this.setLayout(new GridBagLayout());
            ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$form$editors$KeyStrokeEditor == null ? (class$org$netbeans$modules$form$editors$KeyStrokeEditor = CustomEditor.class$("org.netbeans.modules.form.editors.KeyStrokeEditor")) : class$org$netbeans$modules$form$editors$KeyStrokeEditor));
            JLabel virtualKeyLabel = new JLabel();
            virtualKeyLabel.setText(bundle.getString("CTL_VirtualKey"));
            virtualKeyLabel.setDisplayedMnemonic(bundle.getString("CTL_VirtualKey_Mnemonic").charAt(0));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(12, 12, 5, 12);
            this.add((Component)virtualKeyLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(12, 0, 5, 11);
            this._virtualKey = new JComboBox();
            this.add(this._virtualKey, gbc);
            this._virtualKey.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_VirtualKey"));
            JPanel panel = new JPanel(new FlowLayout(0, 6, 0));
            this._ctrl = new JCheckBox(KeyStrokeEditor.this.TXT_CTRL);
            this._ctrl.setMnemonic(bundle.getString("CTL_Ctrl_Mnemonic").charAt(0));
            this._ctrl.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CtrlKey"));
            panel.add(this._ctrl);
            this._alt = new JCheckBox(KeyStrokeEditor.this.TXT_ALT);
            this._alt.setMnemonic(bundle.getString("CTL_Alt_Mnemonic").charAt(0));
            this._alt.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_AltKey"));
            panel.add(this._alt);
            this._shift = new JCheckBox(KeyStrokeEditor.this.TXT_SHIFT);
            this._shift.setMnemonic(bundle.getString("CTL_Shift_Mnemonic").charAt(0));
            this._shift.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ShiftKey"));
            panel.add(this._shift);
            virtualKeyLabel.setLabelFor(this._virtualKey);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(12, 0, 5, 12);
            this.add((Component)panel, gbc);
            JLabel keyStrokeLabel = new JLabel();
            keyStrokeLabel.setText(bundle.getString("CTL_KeyStroke"));
            keyStrokeLabel.setDisplayedMnemonic(bundle.getString("CTL_KeyStroke_Mnemonic").charAt(0));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(0, 12, 0, 12);
            this.add((Component)keyStrokeLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(0, 0, 0, 11);
            this._keyGrabber = new KeyGrabberField();
            this.add((Component)this._keyGrabber, gbc);
            this._keyGrabber.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_KeyStroke"));
            keyStrokeLabel.setLabelFor(this._keyGrabber);
            this._keyGrabber.addActionListener(new ActionListener(this){
                private final /* synthetic */ CustomEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ev) {
                    CustomEditor.access$500(this.this$1).setAsText(CustomEditor.access$400(this.this$1).getText());
                }
            });
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_KeyStrokeCustomEditor"));
            if (_virtualKeys == null) {
                ArrayList<String> list = new ArrayList<String>();
                Field[] fields = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = CustomEditor.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getDeclaredFields();
                int i = 0;
                while (i < fields.length) {
                    Field f = fields[i];
                    int modifiers = f.getModifiers();
                    if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && f.getType() == Integer.TYPE && f.getName().startsWith("VK_")) {
                        list.add(f.getName());
                    }
                    ++i;
                }
                KeyStrokeEditor.access$602(new String[list.size()]);
                int i2 = 0;
                while (i2 < list.size()) {
                    _virtualKeys[i2] = (String)list.get(i2);
                    ++i2;
                }
            }
            this._virtualKey.addItem("");
            int i = 0;
            while (i < _virtualKeys.length) {
                this._virtualKey.addItem(_virtualKeys[i]);
                ++i;
            }
            KeyStroke key = (KeyStroke)KeyStrokeEditor.this.getValue();
            if (key != null) {
                this.setKeyStroke(key);
            }
            ItemListener il = new ItemListener(this){
                private final /* synthetic */ CustomEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void itemStateChanged(ItemEvent e) {
                    CustomEditor.access$700(this.this$1);
                }
            };
            this._virtualKey.addItemListener(il);
            this._ctrl.addItemListener(il);
            this._alt.addItemListener(il);
            this._shift.addItemListener(il);
        }

        Component getKeyGrabber() {
            return this._keyGrabber;
        }

        private void setKeyStroke(KeyStroke key) {
            this._ctrl.setSelected(0 != (2 & key.getModifiers()));
            this._alt.setSelected(0 != (8 & key.getModifiers()));
            this._shift.setSelected(0 != (1 & key.getModifiers()));
            int keycode = key.getKeyCode();
            String keyName = KeyStrokeEditor.getVirtualkeyName(keycode);
            if (keyName != null) {
                this._virtualKey.setSelectedItem(keyName);
                this._keyGrabber.setText(KeyStrokeEditor.this.getAsText());
            }
        }

        private void virtualKeyChanged() {
            String keyName = (String)this._virtualKey.getSelectedItem();
            if ("".equals(keyName)) {
                this._keyGrabber.setText("");
                KeyStrokeEditor.this.setValue(null);
                return;
            }
            try {
                Field f = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = CustomEditor.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getDeclaredField(keyName);
                int keycode = f.getInt(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = CustomEditor.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
                int mods = 0;
                if (this._ctrl.isSelected()) {
                    mods |= 2;
                }
                if (this._shift.isSelected()) {
                    mods |= 1;
                }
                if (this._alt.isSelected()) {
                    mods |= 8;
                }
                KeyStrokeEditor.this.setValue(KeyStroke.getKeyStroke(keycode, mods));
                this._keyGrabber.setText(KeyStrokeEditor.this.getAsText());
            }
            catch (NoSuchFieldException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ KeyGrabberField access$400(CustomEditor x0) {
            return x0._keyGrabber;
        }

        static /* synthetic */ KeyStrokeEditor access$500(CustomEditor x0) {
            return x0.KeyStrokeEditor.this;
        }

        static /* synthetic */ void access$700(CustomEditor x0) {
            x0.virtualKeyChanged();
        }

        private class KeyGrabberField
        extends JTextField {
            private KeyGrabberField() {
            }

            protected void processKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    super.processKeyEvent(e);
                } else if (e.getID() == 401) {
                    int keycode = e.getKeyCode();
                    if (keycode != 17 && keycode != 18 && keycode != 16) {
                        KeyStroke key = KeyStroke.getKeyStroke(keycode, e.getModifiers());
                        CustomEditor.this.setKeyStroke(key);
                    }
                    e.consume();
                }
            }
        }
    }
}

