/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.beans.PropertyEditorSupport;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;

public class MnemonicEditor
extends PropertyEditorSupport
implements EnhancedPropertyEditor {
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;

    public String getAsText() {
        Object ovalue = this.getValue();
        char value = '\u0000';
        if ((class$java$lang$Character == null ? (class$java$lang$Character = MnemonicEditor.class$("java.lang.Character")) : class$java$lang$Character).isInstance(ovalue)) {
            value = ((Character)ovalue).charValue();
        } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = MnemonicEditor.class$("java.lang.Integer")) : class$java$lang$Integer).isInstance(ovalue)) {
            value = (char)((Integer)ovalue).intValue();
        }
        if (value == '\u0000') {
            return "";
        }
        StringBuffer buf = new StringBuffer(6);
        switch (value) {
            case '\b': {
                buf.append("\\b");
                break;
            }
            case '\t': {
                buf.append("\\t");
                break;
            }
            case '\n': {
                buf.append("\\n");
                break;
            }
            case '\f': {
                buf.append("\\f");
                break;
            }
            case '\r': {
                buf.append("\\r");
                break;
            }
            case '\\': {
                buf.append("\\\\");
                break;
            }
            default: {
                if (value >= ' ' && value <= '\u007f') {
                    buf.append(value);
                    break;
                }
                buf.append("\\u");
                String hex = Integer.toHexString(value);
                int j = 0;
                while (j < 4 - hex.length()) {
                    buf.append('0');
                    ++j;
                }
                buf.append(hex);
            }
        }
        return buf.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text.length() < 1) {
            this.setValue(new Integer(0));
            return;
        }
        if (text.length() == 1 && text.charAt(0) != '\\') {
            this.setValue(new Character(text.charAt(0)));
            return;
        }
        if (text.charAt(0) == '\\') {
            char value = '\u0000';
            int ch = text.length() >= 2 ? (int)text.charAt(1) : 92;
            switch (ch) {
                case 98: {
                    value = '\b';
                    break;
                }
                case 116: {
                    value = '\t';
                    break;
                }
                case 110: {
                    value = '\n';
                    break;
                }
                case 102: {
                    value = '\f';
                    break;
                }
                case 114: {
                    value = '\r';
                    break;
                }
                case 92: {
                    value = '\\';
                    break;
                }
                case 117: {
                    String num = text.substring(2, text.length());
                    if (num.length() > 4) {
                        return;
                    }
                    try {
                        int intValue = Integer.parseInt(num, 16);
                        value = (char)intValue;
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        return;
                    }
                }
                default: {
                    return;
                }
            }
            this.setValue(new Character(value));
            return;
        }
        try {
            this.setValue(new Integer(text));
            return;
        }
        catch (NumberFormatException e) {
            this.setValue(text);
            return;
        }
    }

    public void setValue(Object newValue) throws IllegalArgumentException {
        String text;
        if (newValue instanceof Integer) {
            super.setValue(newValue);
            return;
        }
        if (newValue instanceof Character) {
            super.setValue(new Integer(((Character)newValue).charValue()));
            return;
        }
        if (newValue instanceof String && (text = (String)newValue).length() >= 1) {
            super.setValue(new Integer(text.charAt(0)));
            return;
        }
        throw new IllegalArgumentException();
    }

    public String getJavaInitializationString() {
        return "'" + this.getAsText() + "'";
    }

    public Component getInPlaceCustomEditor() {
        return null;
    }

    public boolean hasInPlaceCustomEditor() {
        return false;
    }

    public boolean supportsEditingTaggedValues() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

