/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.netbeans.modules.form.editors.StringArrayCustomEditor;
import org.netbeans.modules.form.editors.StringArrayCustomizable;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StringArrayEditor
implements XMLPropertyEditor,
StringArrayCustomizable {
    private static final String XML_STRING_ARRAY = "StringArray";
    private static final String XML_STRING_ITEM = "StringItem";
    private static final String ATTR_COUNT = "count";
    private static final String ATTR_INDEX = "index";
    private static final String ATTR_VALUE = "value";
    private String[] strings;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public Object getValue() {
        return this.strings;
    }

    public void setValue(Object value) {
        this.strings = (String[])value;
        this.support.firePropertyChange("", null, null);
    }

    public String[] getStringArray() {
        return (String[])this.getValue();
    }

    public void setStringArray(String[] value) {
        this.setValue(value);
    }

    protected final String getStrings(boolean quoted) {
        if (this.strings == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.strings.length) {
            buf.append(quoted ? "\"" + this.strings[i] + "\"" : this.strings[i]);
            if (i != this.strings.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }

    public String getAsText() {
        return this.getStrings(false);
    }

    public void setAsText(String text) {
        if (text.equals("null")) {
            this.setValue(null);
            return;
        }
        StringTokenizer tok = new StringTokenizer(text, ",");
        LinkedList<String> list = new LinkedList<String>();
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            list.add(s.trim());
        }
        String[] a = list.toArray(new String[list.size()]);
        this.setValue(a);
    }

    public String getJavaInitializationString() {
        if (this.strings == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer("new String[] {");
        buf.append(this.getStrings(true));
        buf.append("}");
        return buf.toString();
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new StringArrayCustomEditor(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Node storeToXML(Document doc) {
        Element arrayEl = doc.createElement(XML_STRING_ARRAY);
        int count = this.strings != null ? this.strings.length : 0;
        arrayEl.setAttribute(ATTR_COUNT, Integer.toString(count));
        int i = 0;
        while (i < count) {
            Element itemEl = doc.createElement(XML_STRING_ITEM);
            itemEl.setAttribute(ATTR_INDEX, Integer.toString(i));
            itemEl.setAttribute(ATTR_VALUE, this.strings[i]);
            arrayEl.appendChild(itemEl);
            ++i;
        }
        return arrayEl;
    }

    public void readFromXML(Node element) throws IOException {
        String[] stringArray;
        if (!XML_STRING_ARRAY.equals(element.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap attributes = element.getAttributes();
        Node countNode = null;
        int count = 0;
        countNode = attributes.getNamedItem(ATTR_COUNT);
        if (countNode != null && (count = Integer.parseInt(countNode.getNodeValue())) > 0) {
            stringArray = new String[count];
            NodeList items = element.getChildNodes();
            int i = 0;
            while (i < items.getLength()) {
                Element itemEl;
                if (items.item(i).getNodeType() == 1 && (itemEl = (Element)items.item(i)).getNodeName().equals(XML_STRING_ITEM)) {
                    int index;
                    String indexStr = itemEl.getAttribute(ATTR_INDEX);
                    String valueStr = itemEl.getAttribute(ATTR_VALUE);
                    if (indexStr != null && valueStr != null && (index = Integer.parseInt(indexStr)) >= 0 && index < count) {
                        stringArray[index] = valueStr;
                    }
                }
                ++i;
            }
        } else {
            stringArray = new String[]{};
        }
        this.setValue(stringArray);
    }
}

