/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.border.Border;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.ConstructorsDescriptor;
import org.netbeans.modules.form.CreationDescriptor;
import org.netbeans.modules.form.CreationFactory;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContainer;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormUtils;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class BorderDesignSupport
implements FormDesignValue,
FormPropertyContainer {
    private Border theBorder;
    private boolean borderNeedsUpdate;
    private boolean propertiesNeedInit;
    private CreationDescriptor creationDesc;
    private FormPropertyContext propertyContext = null;
    private FormProperty[] properties = null;

    public BorderDesignSupport(Class borderClass) throws Exception {
        this(new CreationFactory.InstanceSource(borderClass));
    }

    public BorderDesignSupport(CreationFactory.InstanceSource borderSource) throws Exception {
        Class borderClass = borderSource.getInstanceClass();
        this.creationDesc = CreationFactory.getDescriptor(borderClass);
        if (this.creationDesc == null) {
            this.creationDesc = new ConstructorsDescriptor(borderClass);
            CreationFactory.registerDescriptor(this.creationDesc);
        }
        Border border = (Border)CreationFactory.createInstance(borderSource);
        if (borderSource.getInstanceCookie() != null) {
            this.setBorder(border);
        } else {
            this.theBorder = border;
        }
    }

    public BorderDesignSupport(Border border) {
        this.creationDesc = CreationFactory.getDescriptor(border.getClass());
        if (this.creationDesc == null) {
            this.creationDesc = new ConstructorsDescriptor(border.getClass());
            CreationFactory.registerDescriptor(this.creationDesc);
        }
        this.setBorder(border);
    }

    public BorderDesignSupport(BorderDesignSupport borderDesignSupport) throws Exception {
        this(borderDesignSupport.getBorderClass());
        this.createProperties();
        FormUtils.copyProperties(borderDesignSupport.getProperties(), this.properties, 7);
    }

    public Border getBorder() {
        if (this.borderNeedsUpdate) {
            this.updateBorder();
        }
        return this.theBorder;
    }

    public void setBorder(Border border) {
        this.theBorder = border;
        if (this.properties != null) {
            int i = 0;
            while (i < this.properties.length) {
                try {
                    this.properties[i].reinstateProperty();
                }
                catch (IllegalAccessException e1) {
                }
                catch (InvocationTargetException e2) {
                    // empty catch block
                }
                ++i;
            }
            this.propertiesNeedInit = false;
        } else {
            this.propertiesNeedInit = true;
        }
        this.borderNeedsUpdate = false;
    }

    public Class getBorderClass() {
        return this.creationDesc.getDescribedClass();
    }

    public String getDisplayName() {
        return Utilities.getShortClassName(this.theBorder.getClass());
    }

    public void setPropertyContext(FormPropertyContext propertyContext) {
        if (this.properties != null && this.propertyContext != propertyContext) {
            int i = 0;
            while (i < this.properties.length) {
                if (!this.properties[i].getValueType().isPrimitive()) {
                    this.properties[i].setPropertyContext(propertyContext);
                }
                ++i;
            }
        }
        this.propertyContext = propertyContext;
    }

    public Node.Property[] getProperties() {
        if (this.properties == null) {
            this.createProperties();
        }
        return this.properties;
    }

    public Node.Property getPropertyOfName(String name) {
        Node.Property[] props = this.getProperties();
        int i = 0;
        while (i < props.length) {
            if (props[i].getName().equals(name)) {
                return props[i];
            }
            ++i;
        }
        return null;
    }

    private void createProperties() {
        BeanInfo bInfo = BeanSupport.createBeanInfo(this.theBorder.getClass());
        PropertyDescriptor[] props = bInfo.getPropertyDescriptors();
        ArrayList<BorderProperty> nodeProps = new ArrayList<BorderProperty>();
        int i = 0;
        while (i < props.length) {
            PropertyDescriptor pd = props[i];
            if (!pd.isHidden() && (pd.getWriteMethod() != null || CreationFactory.containsProperty(this.creationDesc, pd.getName()))) {
                BorderProperty prop = new BorderProperty(pd.getPropertyType().isPrimitive() ? null : this.propertyContext, pd);
                if (this.propertiesNeedInit) {
                    try {
                        prop.reinstateProperty();
                    }
                    catch (IllegalAccessException e1) {
                    }
                    catch (InvocationTargetException e2) {
                        // empty catch block
                    }
                }
                nodeProps.add(prop);
            }
            ++i;
        }
        this.properties = new FormProperty[nodeProps.size()];
        nodeProps.toArray(this.properties);
        this.propertiesNeedInit = false;
    }

    public String getJavaInitializationString() {
        if (this.properties == null) {
            this.createProperties();
        }
        CreationDescriptor.Creator creator = this.creationDesc.findBestCreator(this.properties, 3);
        return creator.getJavaCreationCode(this.properties);
    }

    void updateBorder() {
        if (this.properties == null) {
            this.createProperties();
        }
        CreationDescriptor.Creator creator = this.creationDesc.findBestCreator(this.properties, 3);
        try {
            this.theBorder = (Border)CreationFactory.createInstance(this.creationDesc.getDescribedClass(), this.properties, 3);
            FormProperty[] otherProps = CreationFactory.getRemainingProperties(creator, this.properties);
            int i = 0;
            while (i < otherProps.length) {
                otherProps[i].reinstateTarget();
                ++i;
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public Object getDesignValue() {
        return this.getBorder();
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public class BorderProperty
    extends FormProperty {
        private PropertyDescriptor desc;

        public BorderProperty(FormPropertyContext propertyContext, PropertyDescriptor desc) {
            super(propertyContext, desc.getName(), desc.getPropertyType(), desc.getDisplayName(), desc.getShortDescription());
            this.desc = desc;
            if (desc.getWriteMethod() == null) {
                this.setAccessType(2);
            } else if (desc.getReadMethod() == null) {
                this.setAccessType(1);
            }
        }

        public Object getTargetValue() throws IllegalAccessException, InvocationTargetException {
            Method readMethod = this.desc.getReadMethod();
            return readMethod.invoke((Object)BorderDesignSupport.this.theBorder, new Object[0]);
        }

        public void setTargetValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Method writeMethod = this.desc.getWriteMethod();
            writeMethod.invoke((Object)BorderDesignSupport.this.theBorder, value);
        }

        protected Object getRealValue(Object value) {
            Object realValue = super.getRealValue(value);
            if (realValue == FormDesignValue.IGNORED_VALUE && "title".equals(this.desc.getName())) {
                realValue = ((FormDesignValue)value).getDescription();
            }
            return realValue;
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public Object getDefaultValue() {
            Method readMethod = this.desc.getReadMethod();
            Object value = null;
            if (readMethod != null) {
                try {
                    value = readMethod.invoke(BeanSupport.getDefaultInstance(BorderDesignSupport.this.theBorder.getClass()), new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return value;
        }

        public PropertyEditor getExpliciteEditor() {
            if (this.desc.getPropertyEditorClass() != null) {
                try {
                    return (PropertyEditor)this.desc.getPropertyEditorClass().newInstance();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return null;
        }

        protected void propertyValueChanged(Object old, Object current) {
            super.propertyValueChanged(old, current);
            BorderDesignSupport.this.borderNeedsUpdate = (this.getAccessType() & 2) != 0;
        }
    }
}

