/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.form.CreationFactory;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormPropertyEditorManager;
import org.netbeans.modules.form.GandalfPersistenceManager;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.editors2.BorderDesignSupport;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.PaletteItem;
import org.openide.ErrorManager;
import org.openide.awt.SplittedPanel;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public final class BorderEditor
extends PropertyEditorSupport
implements FormAwareEditor,
XMLPropertyEditor,
NamedPropertyEditor {
    private static final String UNKNOWN_BORDER_BASE = "org/netbeans/modules/form/editors2/unknownBorder";
    private static final String NO_BORDER_BASE = "org/netbeans/modules/form/editors2/nullBorder";
    private Object current = null;
    private FormModel formModel;
    private FormPropertyContext propertyContext;
    private BorderDesignSupport borderSupport;
    private BorderPanel bPanel = null;
    private static final String XML_BORDER = "Border";
    private static final String ATTR_INFO = "info";
    private static final String PROP_NAME = "PropertyName";
    private static final String ID_BI_NULL_BORDER = "null";
    private static final String XML_TITLED_BORDER = "TitledBorder";
    private static final String ID_BI_TITLED = "org.netbeans.modules.form.compat2.border.TitledBorderInfo";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_TITLE_X = "titleX";
    private static final String ATTR_BORDER = "innerBorder";
    private static final String ATTR_JUSTIFICATION = "justification";
    private static final String ATTR_POSITION = "position";
    private static final String ATTR_FONT = "font";
    private static final String ATTR_TITLE_COLOR = "color";
    private static final String XML_ETCHED_BORDER = "EtchetBorder";
    private static final String ID_BI_ETCHED = "org.netbeans.modules.form.compat2.border.EtchedBorderInfo";
    private static final String ATTR_ETCH_TYPE = "bevelType";
    private static final String ATTR_HIGHLIGHT = "highlight";
    private static final String ATTR_SHADOW = "shadow";
    private static final String XML_LINE_BORDER = "LineBorder";
    private static final String ID_BI_LINE = "org.netbeans.modules.form.compat2.border.LineBorderInfo";
    private static final String ATTR_THICKNESS = "thickness";
    private static final String ATTR_LINE_COLOR = "color";
    private static final String ATTR_CORNERS = "roundedCorners";
    private static final String XML_EMPTY_BORDER = "EmptyBorder";
    private static final String ID_BI_EMPTY = "org.netbeans.modules.form.compat2.border.EmptyBorderInfo";
    private static final String ATTR_TOP = "top";
    private static final String ATTR_LEFT = "left";
    private static final String ATTR_RIGHT = "right";
    private static final String ATTR_BOTTOM = "bottom";
    private static final String XML_COMPOUND_BORDER = "CompundBorder";
    private static final String ID_BI_COMPOUND = "org.netbeans.modules.form.compat2.border.CompoundBorderInfo";
    private static final String ATTR_OUTSIDE = "outside";
    private static final String ATTR_INSIDE = "inside";
    private static final String XML_BEVEL_BORDER = "BevelBorder";
    private static final String ID_BI_BEVEL = "org.netbeans.modules.form.compat2.border.BevelBorderInfo";
    private static final String ID_BI_SOFTBEVEL = "org.netbeans.modules.form.compat2.border.SoftBevelBorderInfo";
    private static final String ATTR_BEVEL_TYPE = "bevelType";
    private static final String ATTR_HIGHLIGHT_OUTER = "highlightOuter";
    private static final String ATTR_HIGHLIGHT_INNER = "highlightInner";
    private static final String ATTR_SHADOW_OUTER = "shadowOuter";
    private static final String ATTR_SHADOW_INNER = "shadowInner";
    private static final String XML_MATTE_COLOR_BORDER = "MatteColorBorder";
    private static final String XML_MATTE_ICON_BORDER = "MatteIconBorder";
    private static final String ID_BI_MATTECOLOR = "org.netbeans.modules.form.compat2.border.MatteColorBorderInfo";
    private static final String ID_BI_MATTEICON = "org.netbeans.modules.form.compat2.border.MatteIconBorderInfo";
    private static final String ATTR_MATTE_COLOR = "color";
    private static final String ATTR_MATTE_ICON = "icon";
    static /* synthetic */ Class class$org$netbeans$modules$form$editors2$BorderEditor;
    static /* synthetic */ Class class$javax$swing$border$TitledBorder;
    static /* synthetic */ Class class$javax$swing$border$EtchedBorder;
    static /* synthetic */ Class class$javax$swing$border$LineBorder;
    static /* synthetic */ Class class$javax$swing$border$EmptyBorder;
    static /* synthetic */ Class class$javax$swing$border$CompoundBorder;
    static /* synthetic */ Class class$javax$swing$border$SoftBevelBorder;
    static /* synthetic */ Class class$javax$swing$border$BevelBorder;
    static /* synthetic */ Class class$javax$swing$border$MatteBorder;

    public void setFormModel(FormModel model) {
        this.formModel = model;
        this.propertyContext = new FormPropertyContext.DefaultImpl(model);
    }

    public Object getValue() {
        return this.current;
    }

    public void setValue(Object value) {
        if (this.current == value) {
            return;
        }
        this.current = value;
        this.borderSupport = null;
        if (value instanceof BorderDesignSupport) {
            this.borderSupport = (BorderDesignSupport)value;
        } else if (value instanceof Border && !(value instanceof UIResource)) {
            this.borderSupport = new BorderDesignSupport((Border)value);
        }
        if (this.borderSupport != null) {
            this.borderSupport.setPropertyContext(this.propertyContext);
            if (this.bPanel != null) {
                this.bPanel.setValue(value);
            }
        }
    }

    public String getAsText() {
        Object value = this.getValue();
        String valueText = value == null ? BorderEditor.getBundle().getString("LAB_NoBorder") : (this.borderSupport != null ? "[" + this.borderSupport.getDisplayName() + "]" : "[" + Utilities.getShortClassName(value.getClass()) + "]");
        return valueText;
    }

    public void setAsText(String string) {
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics g, Rectangle rectangle) {
        FontMetrics fm = g.getFontMetrics();
        g.drawString(this.getAsText(), rectangle.x, rectangle.y + (rectangle.height - fm.getHeight()) / 2 + fm.getAscent());
    }

    public String getJavaInitializationString() {
        Object value = this.getValue();
        if (value == null) {
            return ID_BI_NULL_BORDER;
        }
        if (this.borderSupport != null) {
            return this.borderSupport.getJavaInitializationString();
        }
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.bPanel == null) {
            this.bPanel = new BorderPanel();
        }
        this.bPanel.setValue(this.current);
        return this.bPanel;
    }

    public String getDisplayName() {
        return BorderEditor.getBundle().getString("CTL_BorderEditor_DisplayName");
    }

    void updateBorder(Node node) {
        if (node instanceof NoBorderNode) {
            this.borderSupport = null;
            this.current = null;
        } else if (node instanceof UnknownBorderNode) {
            this.current = ((UnknownBorderNode)node).getBorder();
        } else {
            this.borderSupport = ((BorderNode)node).getBorderSupport();
            this.current = this.borderSupport;
        }
    }

    private static ResourceBundle getBundle() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$form$editors2$BorderEditor == null ? (class$org$netbeans$modules$form$editors2$BorderEditor = BorderEditor.class$("org.netbeans.modules.form.editors2.BorderEditor")) : class$org$netbeans$modules$form$editors2$BorderEditor));
    }

    public org.w3c.dom.Node storeToXML(Document doc) {
        Object value = this.getValue();
        if ((value instanceof BorderDesignSupport || value instanceof Border) && this.borderSupport != null) {
            org.w3c.dom.Node storedNode = null;
            Class borderClass = this.borderSupport.getBorderClass();
            if (borderClass.isAssignableFrom(class$javax$swing$border$TitledBorder == null ? (class$javax$swing$border$TitledBorder = BorderEditor.class$("javax.swing.border.TitledBorder")) : class$javax$swing$border$TitledBorder)) {
                storedNode = this.storeTitledBorder(doc);
            } else if (borderClass.isAssignableFrom(class$javax$swing$border$EtchedBorder == null ? (class$javax$swing$border$EtchedBorder = BorderEditor.class$("javax.swing.border.EtchedBorder")) : class$javax$swing$border$EtchedBorder)) {
                storedNode = this.storeEtchedBorder(doc);
            } else if (borderClass.isAssignableFrom(class$javax$swing$border$LineBorder == null ? (class$javax$swing$border$LineBorder = BorderEditor.class$("javax.swing.border.LineBorder")) : class$javax$swing$border$LineBorder)) {
                storedNode = this.storeLineBorder(doc);
            } else if (borderClass.isAssignableFrom(class$javax$swing$border$EmptyBorder == null ? (class$javax$swing$border$EmptyBorder = BorderEditor.class$("javax.swing.border.EmptyBorder")) : class$javax$swing$border$EmptyBorder)) {
                storedNode = this.storeEmptyBorder(doc);
            } else if (borderClass.isAssignableFrom(class$javax$swing$border$CompoundBorder == null ? (class$javax$swing$border$CompoundBorder = BorderEditor.class$("javax.swing.border.CompoundBorder")) : class$javax$swing$border$CompoundBorder)) {
                storedNode = this.storeCompoundBorder(doc);
            } else if ((class$javax$swing$border$SoftBevelBorder == null ? (class$javax$swing$border$SoftBevelBorder = BorderEditor.class$("javax.swing.border.SoftBevelBorder")) : class$javax$swing$border$SoftBevelBorder).isAssignableFrom(borderClass)) {
                storedNode = this.storeBevelBorder(doc, ID_BI_SOFTBEVEL);
            } else if ((class$javax$swing$border$BevelBorder == null ? (class$javax$swing$border$BevelBorder = BorderEditor.class$("javax.swing.border.BevelBorder")) : class$javax$swing$border$BevelBorder).isAssignableFrom(borderClass)) {
                storedNode = this.storeBevelBorder(doc, ID_BI_BEVEL);
            } else if (borderClass.isAssignableFrom(class$javax$swing$border$MatteBorder == null ? (class$javax$swing$border$MatteBorder = BorderEditor.class$("javax.swing.border.MatteBorder")) : class$javax$swing$border$MatteBorder)) {
                storedNode = this.storeMatteBorder(doc);
            }
            return storedNode;
        }
        if (value == null) {
            return this.storeNullBorder(doc);
        }
        return null;
    }

    public void readFromXML(org.w3c.dom.Node element) throws IOException {
        if (!XML_BORDER.equals(element.getNodeName())) {
            IOException ex = new IOException("Missing \"Border\" XML element");
            ErrorManager.getDefault().annotate((Throwable)ex, BorderEditor.getBundle().getString("MSG_ERR_MissingMainElement"));
            throw ex;
        }
        NamedNodeMap attributes = element.getAttributes();
        String infoName = attributes.getNamedItem(ATTR_INFO).getNodeValue();
        if (ID_BI_NULL_BORDER.equals(infoName)) {
            return;
        }
        org.w3c.dom.Node readNode = null;
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeType() == 1) {
                readNode = children.item(i);
                break;
            }
            ++i;
        }
        if (readNode == null) {
            IOException ex = new IOException("Missing border data");
            ErrorManager.getDefault().annotate((Throwable)ex, BorderEditor.getBundle().getString("MSG_ERR_MissingBorderData"));
            throw ex;
        }
        if (ID_BI_TITLED.equals(infoName)) {
            this.readTitledBorder(readNode);
        } else if (ID_BI_ETCHED.equals(infoName)) {
            this.readEtchedBorder(readNode);
        } else if (ID_BI_LINE.equals(infoName)) {
            this.readLineBorder(readNode);
        } else if (ID_BI_EMPTY.equals(infoName)) {
            this.readEmptyBorder(readNode);
        } else if (ID_BI_COMPOUND.equals(infoName)) {
            this.readCompoundBorder(readNode);
        } else if (ID_BI_SOFTBEVEL.equals(infoName)) {
            this.readBevelBorder(readNode, class$javax$swing$border$SoftBevelBorder == null ? (class$javax$swing$border$SoftBevelBorder = BorderEditor.class$("javax.swing.border.SoftBevelBorder")) : class$javax$swing$border$SoftBevelBorder);
        } else if (ID_BI_BEVEL.equals(infoName)) {
            this.readBevelBorder(readNode, class$javax$swing$border$BevelBorder == null ? (class$javax$swing$border$BevelBorder = BorderEditor.class$("javax.swing.border.BevelBorder")) : class$javax$swing$border$BevelBorder);
        } else if (ID_BI_MATTECOLOR.equals(infoName) || ID_BI_MATTEICON.equals(infoName)) {
            this.readMatteBorder(readNode);
        } else if (ID_BI_NULL_BORDER.equals(infoName)) {
            this.borderSupport = null;
        }
        this.current = this.borderSupport;
    }

    private Element createBorderInfoNode(Document doc, String name) {
        Element el = doc.createElement(XML_BORDER);
        el.setAttribute(ATTR_INFO, name);
        return el;
    }

    private static void writeProperty(String propName, FormProperty prop, Element el, Document doc) {
        boolean written = false;
        org.w3c.dom.Node valueNode = null;
        PropertyEditor propEd = prop.getCurrentEditor();
        if (propEd instanceof XMLPropertyEditor) {
            Object value;
            try {
                value = prop.getValue();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            propEd.setValue(value);
            valueNode = ((XMLPropertyEditor)propEd).storeToXML(doc);
            if (valueNode != null) {
                el.appendChild(valueNode);
                if (valueNode.getNodeType() == 1) {
                    ((Element)valueNode).setAttribute(PROP_NAME, propName);
                }
                return;
            }
        }
        try {
            String encodedSerializeValue = GandalfPersistenceManager.encodeValue(prop.getValue());
            if (encodedSerializeValue != null) {
                el.setAttribute(propName, encodedSerializeValue);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static Object readProperty(String xmlPropName, String borderPropName, BorderDesignSupport bSupport, org.w3c.dom.Node element) throws IOException {
        boolean valueRead = false;
        Object value = null;
        org.w3c.dom.Node propNode = null;
        NodeList items = element.getChildNodes();
        int i = 0;
        while (i < items.getLength()) {
            if (items.item(i).getNodeType() == 1 && ((Element)items.item(i)).getAttribute(PROP_NAME).equals(xmlPropName)) {
                propNode = items.item(i);
                break;
            }
            ++i;
        }
        if (propNode != null) {
            FormProperty prop = (FormProperty)bSupport.getPropertyOfName(borderPropName);
            if (prop == null) {
                IOException ex = new IOException("Unknown property");
                ErrorManager.getDefault().annotate((Throwable)ex, MessageFormat.format(BorderEditor.getBundle().getString("FMT_ERR_UnknownProperty"), borderPropName, bSupport.getBorderClass().getName()));
                throw ex;
            }
            IOException lastEx = null;
            PropertyEditor[] editors = FormPropertyEditorManager.getAllEditors(prop.getValueType());
            int i2 = 0;
            while (i2 < editors.length && !valueRead) {
                PropertyEditor prEd = editors[i2];
                if (prEd instanceof XMLPropertyEditor) {
                    try {
                        prop.getPropertyContext().initPropertyEditor(prEd);
                        ((XMLPropertyEditor)prEd).readFromXML(propNode);
                        value = prEd.getValue();
                        prop.setValue(value);
                        prop.setCurrentEditor(prEd);
                        valueRead = true;
                    }
                    catch (IOException ex) {
                        lastEx = ex;
                    }
                    catch (Exception ex) {
                        lastEx = new IOException();
                        ErrorManager.getDefault().annotate((Throwable)lastEx, (Throwable)ex);
                    }
                }
                ++i2;
            }
            if (!valueRead && lastEx != null) {
                ErrorManager.getDefault().annotate((Throwable)lastEx, MessageFormat.format(BorderEditor.getBundle().getString("FMT_ERR_CannotReadBorderProperty"), xmlPropName));
                throw lastEx;
            }
        } else {
            String valueText;
            org.w3c.dom.Node attr;
            NamedNodeMap attributes = element.getAttributes();
            org.w3c.dom.Node node = attr = attributes == null ? null : attributes.getNamedItem(xmlPropName);
            if (attr != null && (valueText = attr.getNodeValue()) != null) {
                FormProperty prop = (FormProperty)bSupport.getPropertyOfName(borderPropName);
                try {
                    if (prop != null && (value = GandalfPersistenceManager.decodeValue(valueText)) != null) {
                        prop.setValue(value);
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().annotate((Throwable)ex, MessageFormat.format(BorderEditor.getBundle().getString("FMT_ERR_CannotReadBorderProperty"), xmlPropName));
                    throw ex;
                }
                catch (Exception ex) {
                    IOException ioex = new IOException();
                    ErrorManager.getDefault().annotate((Throwable)ioex, 4096, null, MessageFormat.format(BorderEditor.getBundle().getString("FMT_ERR_CannotReadAndSetBorderProperty"), xmlPropName), (Throwable)ex, null);
                    throw ioex;
                }
            }
        }
        return value;
    }

    private org.w3c.dom.Node storeNullBorder(Document doc) {
        try {
            return this.createBorderInfoNode(doc, ID_BI_NULL_BORDER);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private org.w3c.dom.Node storeTitledBorder(Document doc) {
        try {
            Element el = doc.createElement(XML_TITLED_BORDER);
            FormProperty prop = (FormProperty)this.borderSupport.getPropertyOfName("border");
            if (prop != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_BORDER, prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_TITLE)) != null && prop.isChanged()) {
                Object realValue = prop.getRealValue();
                el.setAttribute(ATTR_TITLE, realValue instanceof String ? (String)realValue : "");
                Object value = prop.getValue();
                if (value instanceof FormDesignValue) {
                    BorderEditor.writeProperty(ATTR_TITLE_X, prop, el, doc);
                }
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("titleJustification")) != null && prop.isChanged()) {
                el.setAttribute(ATTR_JUSTIFICATION, prop.getRealValue().toString());
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("titlePosition")) != null && prop.isChanged()) {
                el.setAttribute(ATTR_POSITION, prop.getRealValue().toString());
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("titleFont")) != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_FONT, prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("titleColor")) != null && prop.isChanged()) {
                BorderEditor.writeProperty("color", prop, el, doc);
            }
            Element nod = this.createBorderInfoNode(doc, ID_BI_TITLED);
            nod.appendChild(el);
            return nod;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void readTitledBorder(org.w3c.dom.Node element) throws IOException {
        if (!XML_TITLED_BORDER.equals(element.getNodeName())) {
            throw new IOException("Invalid format: missing \"TitledBorder\" element.");
        }
        try {
            FormProperty prop;
            org.w3c.dom.Node node;
            NamedNodeMap attributes = element.getAttributes();
            this.borderSupport = new BorderDesignSupport(class$javax$swing$border$TitledBorder == null ? (class$javax$swing$border$TitledBorder = BorderEditor.class$("javax.swing.border.TitledBorder")) : class$javax$swing$border$TitledBorder);
            this.borderSupport.setPropertyContext(this.propertyContext);
            BorderEditor.readProperty(ATTR_BORDER, "border", this.borderSupport, element);
            Object title = BorderEditor.readProperty(ATTR_TITLE_X, ATTR_TITLE, this.borderSupport, element);
            if (title == null && (node = attributes.getNamedItem(ATTR_TITLE)) != null && (prop = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_TITLE)) != null) {
                prop.setValue(node.getNodeValue());
            }
            if ((node = attributes.getNamedItem(ATTR_JUSTIFICATION)) != null && (prop = (FormProperty)this.borderSupport.getPropertyOfName("titleJustification")) != null) {
                prop.setValue(new Integer(node.getNodeValue()));
            }
            if ((node = attributes.getNamedItem(ATTR_POSITION)) != null && (prop = (FormProperty)this.borderSupport.getPropertyOfName("titlePosition")) != null) {
                prop.setValue(new Integer(node.getNodeValue()));
            }
            BorderEditor.readProperty(ATTR_FONT, "titleFont", this.borderSupport, element);
            BorderEditor.readProperty("color", "titleColor", this.borderSupport, element);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IOException ioex = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)ex);
            throw ioex;
        }
    }

    public org.w3c.dom.Node storeEtchedBorder(Document doc) {
        try {
            Element el = doc.createElement(XML_ETCHED_BORDER);
            FormProperty prop = (FormProperty)this.borderSupport.getPropertyOfName("etchType");
            if (prop != null && prop.isChanged()) {
                el.setAttribute("bevelType", prop.getRealValue().toString());
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("highlightColor")) != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_HIGHLIGHT, prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("shadowColor")) != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_SHADOW, prop, el, doc);
            }
            Element nod = this.createBorderInfoNode(doc, ID_BI_ETCHED);
            nod.appendChild(el);
            return nod;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void readEtchedBorder(org.w3c.dom.Node element) throws IOException {
        if (!XML_ETCHED_BORDER.equals(element.getNodeName())) {
            throw new IOException("Invalid format: missing \"EtchetBorder\" element.");
        }
        try {
            FormProperty prop;
            NamedNodeMap attributes = element.getAttributes();
            this.borderSupport = new BorderDesignSupport(class$javax$swing$border$EtchedBorder == null ? (class$javax$swing$border$EtchedBorder = BorderEditor.class$("javax.swing.border.EtchedBorder")) : class$javax$swing$border$EtchedBorder);
            this.borderSupport.setPropertyContext(this.propertyContext);
            org.w3c.dom.Node node = attributes.getNamedItem("bevelType");
            if (node != null && (prop = (FormProperty)this.borderSupport.getPropertyOfName("etchType")) != null) {
                prop.setValue(new Integer(node.getNodeValue()));
            }
            BorderEditor.readProperty(ATTR_HIGHLIGHT, "highlightColor", this.borderSupport, element);
            BorderEditor.readProperty(ATTR_SHADOW, "shadowColor", this.borderSupport, element);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IOException ioex = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)ex);
            throw ioex;
        }
    }

    public org.w3c.dom.Node storeLineBorder(Document doc) {
        try {
            Element el = doc.createElement(XML_LINE_BORDER);
            FormProperty prop = (FormProperty)this.borderSupport.getPropertyOfName("lineColor");
            if (prop != null && prop.isChanged()) {
                BorderEditor.writeProperty("color", prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_THICKNESS)) != null && prop.isChanged()) {
                el.setAttribute(ATTR_THICKNESS, prop.getRealValue().toString());
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_CORNERS)) != null && prop.isChanged()) {
                el.setAttribute(ATTR_CORNERS, prop.getRealValue().toString());
            }
            Element nod = this.createBorderInfoNode(doc, ID_BI_LINE);
            nod.appendChild(el);
            return nod;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void readLineBorder(org.w3c.dom.Node element) throws IOException {
        if (!XML_LINE_BORDER.equals(element.getNodeName())) {
            throw new IOException("Invalid format: missing \"LineBorder\" element.");
        }
        try {
            FormProperty prop;
            NamedNodeMap attributes = element.getAttributes();
            this.borderSupport = new BorderDesignSupport(class$javax$swing$border$LineBorder == null ? (class$javax$swing$border$LineBorder = BorderEditor.class$("javax.swing.border.LineBorder")) : class$javax$swing$border$LineBorder);
            this.borderSupport.setPropertyContext(this.propertyContext);
            BorderEditor.readProperty("color", "lineColor", this.borderSupport, element);
            org.w3c.dom.Node node = attributes.getNamedItem(ATTR_THICKNESS);
            if (node != null && (prop = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_THICKNESS)) != null) {
                prop.setValue(new Integer(node.getNodeValue()));
            }
            if ((node = attributes.getNamedItem(ATTR_CORNERS)) != null && (prop = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_CORNERS)) != null) {
                prop.setValue(Boolean.valueOf(node.getNodeValue()));
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IOException ioex = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)ex);
            throw ioex;
        }
    }

    public org.w3c.dom.Node storeEmptyBorder(Document doc) {
        try {
            Object value;
            Element el = doc.createElement(XML_EMPTY_BORDER);
            FormProperty prop = (FormProperty)this.borderSupport.getPropertyOfName("borderInsets");
            if (prop != null && prop.isChanged() && (value = prop.getRealValue()) instanceof Insets) {
                Insets insets = (Insets)value;
                el.setAttribute(ATTR_TOP, Integer.toString(insets.top));
                el.setAttribute(ATTR_LEFT, Integer.toString(insets.left));
                el.setAttribute(ATTR_BOTTOM, Integer.toString(insets.bottom));
                el.setAttribute(ATTR_RIGHT, Integer.toString(insets.right));
            }
            Element nod = this.createBorderInfoNode(doc, ID_BI_EMPTY);
            nod.appendChild(el);
            return nod;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void readEmptyBorder(org.w3c.dom.Node element) throws IOException {
        if (!XML_EMPTY_BORDER.equals(element.getNodeName())) {
            throw new IOException("Invalid format: missing \"EmptyBorder\" element.");
        }
        try {
            FormProperty prop;
            NamedNodeMap attributes = element.getAttributes();
            int top = 1;
            int left = 1;
            int bottom = 1;
            int right = 1;
            org.w3c.dom.Node node = attributes.getNamedItem(ATTR_TOP);
            if (node != null) {
                top = Integer.parseInt(node.getNodeValue());
            }
            if ((node = attributes.getNamedItem(ATTR_LEFT)) != null) {
                left = Integer.parseInt(node.getNodeValue());
            }
            if ((node = attributes.getNamedItem(ATTR_BOTTOM)) != null) {
                bottom = Integer.parseInt(node.getNodeValue());
            }
            if ((node = attributes.getNamedItem(ATTR_RIGHT)) != null) {
                right = Integer.parseInt(node.getNodeValue());
            }
            this.borderSupport = new BorderDesignSupport(class$javax$swing$border$EmptyBorder == null ? (class$javax$swing$border$EmptyBorder = BorderEditor.class$("javax.swing.border.EmptyBorder")) : class$javax$swing$border$EmptyBorder);
            this.borderSupport.setPropertyContext(this.propertyContext);
            if ((top != 1 || left != 1 || bottom != 1 || right != 1) && (prop = (FormProperty)this.borderSupport.getPropertyOfName("borderInsets")) != null) {
                prop.setValue(new Insets(top, left, bottom, right));
            }
        }
        catch (Exception ex) {
            IOException ioex = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)ex);
            throw ioex;
        }
    }

    private org.w3c.dom.Node storeCompoundBorder(Document doc) {
        try {
            Element el = doc.createElement(XML_COMPOUND_BORDER);
            FormProperty prop = (FormProperty)this.borderSupport.getPropertyOfName("outsideBorder");
            if (prop != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_OUTSIDE, prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("insideBorder")) != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_INSIDE, prop, el, doc);
            }
            Element nod = this.createBorderInfoNode(doc, ID_BI_COMPOUND);
            nod.appendChild(el);
            return nod;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void readCompoundBorder(org.w3c.dom.Node element) throws IOException {
        if (!XML_COMPOUND_BORDER.equals(element.getNodeName())) {
            throw new IOException("Invalid format: missing \"CompundBorder\" element.");
        }
        try {
            NamedNodeMap attributes = element.getAttributes();
            this.borderSupport = new BorderDesignSupport(class$javax$swing$border$CompoundBorder == null ? (class$javax$swing$border$CompoundBorder = BorderEditor.class$("javax.swing.border.CompoundBorder")) : class$javax$swing$border$CompoundBorder);
            this.borderSupport.setPropertyContext(this.propertyContext);
            BorderEditor.readProperty(ATTR_OUTSIDE, "outsideBorder", this.borderSupport, element);
            BorderEditor.readProperty(ATTR_INSIDE, "insideBorder", this.borderSupport, element);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IOException ioex = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)ex);
            throw ioex;
        }
    }

    public org.w3c.dom.Node storeBevelBorder(Document doc, String infoId) {
        try {
            Element el = doc.createElement(XML_BEVEL_BORDER);
            FormProperty prop = (FormProperty)this.borderSupport.getPropertyOfName("bevelType");
            if (prop != null && prop.isChanged()) {
                el.setAttribute("bevelType", prop.getRealValue().toString());
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("highlightOuterColor")) != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_HIGHLIGHT_OUTER, prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("highlightInnerColor")) != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_HIGHLIGHT_INNER, prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("shadowOuterColor")) != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_SHADOW_OUTER, prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("shadowInnerColor")) != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_SHADOW_INNER, prop, el, doc);
            }
            Element nod = this.createBorderInfoNode(doc, infoId);
            nod.appendChild(el);
            return nod;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void readBevelBorder(org.w3c.dom.Node element, Class borderClass) throws IOException {
        if (!XML_BEVEL_BORDER.equals(element.getNodeName())) {
            throw new IOException("Invalid format: missing \"BevelBorder\" element.");
        }
        try {
            FormProperty prop;
            NamedNodeMap attributes = element.getAttributes();
            this.borderSupport = new BorderDesignSupport(borderClass);
            org.w3c.dom.Node node = attributes.getNamedItem("bevelType");
            if (node != null && (prop = (FormProperty)this.borderSupport.getPropertyOfName("bevelType")) != null) {
                prop.setValue(new Integer(node.getNodeValue()));
            }
            BorderEditor.readProperty(ATTR_HIGHLIGHT_OUTER, "highlightOuterColor", this.borderSupport, element);
            BorderEditor.readProperty(ATTR_HIGHLIGHT_INNER, "highlightInnerColor", this.borderSupport, element);
            BorderEditor.readProperty(ATTR_SHADOW_OUTER, "shadowOuterColor", this.borderSupport, element);
            BorderEditor.readProperty(ATTR_SHADOW_INNER, "shadowInnerColor", this.borderSupport, element);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IOException ioex = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)ex);
            throw ioex;
        }
    }

    public org.w3c.dom.Node storeMatteBorder(Document doc) {
        try {
            Object value;
            String infoId;
            Element el;
            FormProperty prop = (FormProperty)this.borderSupport.getPropertyOfName("tileIcon");
            if (prop.isChanged()) {
                el = doc.createElement(XML_MATTE_ICON_BORDER);
                infoId = ID_BI_MATTEICON;
                BorderEditor.writeProperty(ATTR_MATTE_ICON, prop, el, doc);
            } else {
                el = doc.createElement(XML_MATTE_COLOR_BORDER);
                infoId = ID_BI_MATTECOLOR;
            }
            prop = (FormProperty)this.borderSupport.getPropertyOfName("matteColor");
            if (prop != null && prop.isChanged()) {
                BorderEditor.writeProperty("color", prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("borderInsets")) != null && prop.isChanged() && (value = prop.getRealValue()) instanceof Insets) {
                Insets insets = (Insets)value;
                el.setAttribute(ATTR_TOP, Integer.toString(insets.top));
                el.setAttribute(ATTR_LEFT, Integer.toString(insets.left));
                el.setAttribute(ATTR_BOTTOM, Integer.toString(insets.bottom));
                el.setAttribute(ATTR_RIGHT, Integer.toString(insets.right));
            }
            Element nod = this.createBorderInfoNode(doc, infoId);
            nod.appendChild(el);
            return nod;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void readMatteBorder(org.w3c.dom.Node element) throws IOException {
        if (!XML_MATTE_COLOR_BORDER.equals(element.getNodeName()) && !XML_MATTE_ICON_BORDER.equals(element.getNodeName())) {
            throw new IOException("Invalid format: missing \"MatteColorBorder\" or \"MatteIconBorder\" element.");
        }
        try {
            FormProperty prop;
            this.borderSupport = new BorderDesignSupport(class$javax$swing$border$MatteBorder == null ? (class$javax$swing$border$MatteBorder = BorderEditor.class$("javax.swing.border.MatteBorder")) : class$javax$swing$border$MatteBorder);
            this.borderSupport.setPropertyContext(this.propertyContext);
            BorderEditor.readProperty(ATTR_MATTE_ICON, "tileIcon", this.borderSupport, element);
            BorderEditor.readProperty("color", "matteColor", this.borderSupport, element);
            NamedNodeMap attributes = element.getAttributes();
            int top = 1;
            int left = 1;
            int bottom = 1;
            int right = 1;
            org.w3c.dom.Node node = attributes.getNamedItem(ATTR_TOP);
            if (node != null) {
                top = Integer.parseInt(node.getNodeValue());
            }
            if ((node = attributes.getNamedItem(ATTR_LEFT)) != null) {
                left = Integer.parseInt(node.getNodeValue());
            }
            if ((node = attributes.getNamedItem(ATTR_BOTTOM)) != null) {
                bottom = Integer.parseInt(node.getNodeValue());
            }
            if ((node = attributes.getNamedItem(ATTR_RIGHT)) != null) {
                right = Integer.parseInt(node.getNodeValue());
            }
            if ((top != 1 || left != 1 || bottom != 1 || right != 1) && (prop = (FormProperty)this.borderSupport.getPropertyOfName("borderInsets")) != null) {
                prop.setValue(new Insets(top, left, bottom, right));
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IOException ioex = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)ex);
            throw ioex;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class UnknownBorderNode
    extends AbstractNode {
        private Object border;

        UnknownBorderNode(Object border) {
            super(Children.LEAF);
            this.setBorder(border);
            this.setIconBase(BorderEditor.UNKNOWN_BORDER_BASE);
        }

        void setBorder(Object border) {
            this.border = border;
            String longName = border.getClass().getName();
            int dot = longName.lastIndexOf(46);
            String shortName = dot < 0 ? longName : longName.substring(dot + 1);
            this.setDisplayName(new MessageFormat(BorderEditor.getBundle().getString("LAB_FMT_UnknownBorder")).format(new Object[]{longName, shortName}));
        }

        Object getBorder() {
            return this.border;
        }
    }

    static final class NoBorderNode
    extends AbstractNode {
        NoBorderNode() {
            super(Children.LEAF);
            this.setDisplayName(BorderEditor.getBundle().getString("LAB_NoBorder"));
            this.setIconBase(BorderEditor.NO_BORDER_BASE);
        }
    }

    final class BorderNode
    extends AbstractNode
    implements PropertyChangeListener {
        private BorderDesignSupport nodeBorder;
        private Node palItemNode;

        BorderNode(BorderDesignSupport bds, Node itemNode) {
            super(Children.LEAF);
            this.nodeBorder = bds;
            this.palItemNode = itemNode;
            this.setName(this.nodeBorder.getDisplayName());
        }

        public Image getIcon(int type) {
            return this.palItemNode.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        protected Sheet createSheet() {
            Node.Property[] props = this.nodeBorder.getProperties();
            Sheet.Set propsSet = Sheet.createPropertiesSet();
            propsSet.put(props);
            Sheet sheet = new Sheet();
            sheet.put(propsSet);
            int i = 0;
            while (i < props.length) {
                if (props[i] instanceof FormProperty) {
                    ((FormProperty)props[i]).addPropertyChangeListener(this);
                }
                ++i;
            }
            return sheet;
        }

        public BorderDesignSupport getBorderSupport() {
            return this.nodeBorder;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            BorderEditor.this.updateBorder((Node)this);
        }
    }

    final class BorderPanel
    extends ExplorerPanel
    implements PropertyChangeListener,
    VetoableChangeListener {
        static /* synthetic */ Class class$org$netbeans$modules$form$editors2$BorderEditor$BorderPanel;

        private BorderPanel() {
            this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
            this.getExplorerManager().addVetoableChangeListener((VetoableChangeListener)this);
            ((Container)((Object)this)).setLayout(new BorderLayout());
            ((JComponent)((Object)this)).setBorder(new EmptyBorder(5, 5, 5, 5));
            SplittedPanel split = new SplittedPanel();
            split.setSplitType(1);
            split.setSplitAbsolute(false);
            split.setSplitPosition(45);
            ResourceBundle bundle = BorderEditor.getBundle();
            ListView listView = new ListView();
            listView.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_AvailableBorders"));
            JLabel label = new JLabel(bundle.getString("LAB_AvailableBorders"));
            label.setDisplayedMnemonic(bundle.getString("LAB_AvailableBorders_Mnemonic").charAt(0));
            label.setLabelFor((Component)listView);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout(0, 2));
            panel.add((Component)label, "North");
            panel.add("Center", (Component)listView);
            split.add((Component)panel, SplittedPanel.ADD_TOP);
            PropertySheetView sheetView = new PropertySheetView();
            split.add((Component)sheetView, SplittedPanel.ADD_BOTTOM);
            ((Container)((Object)this)).add("Center", (Component)split);
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_BorderCustomEditor"));
        }

        void setValue(Object border) {
            ArrayList<BorderNode> bordersList = new ArrayList<BorderNode>(10);
            AbstractNode selectNode = null;
            PaletteItem[] items = CPManager.getDefault().getAllItems();
            int i = 0;
            while (i < items.length) {
                block13: {
                    PaletteItem palItem = items[i];
                    if (palItem.isBorder()) {
                        BorderDesignSupport nodeBDS = null;
                        try {
                            CreationFactory.InstanceSource instSource = new CreationFactory.InstanceSource(palItem.getInstanceCookie());
                            nodeBDS = new BorderDesignSupport(instSource);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (nodeBDS != null) {
                            BorderNode borderNode;
                            if (BorderEditor.this.borderSupport != null && BorderEditor.this.borderSupport.getBorderClass() == nodeBDS.getBorderClass()) {
                                try {
                                    nodeBDS = new BorderDesignSupport(BorderEditor.this.borderSupport);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    break block13;
                                }
                                nodeBDS.setPropertyContext(BorderEditor.this.propertyContext);
                                borderNode = new BorderNode(nodeBDS, palItem.getItemNode());
                                selectNode = borderNode;
                            } else {
                                nodeBDS.setPropertyContext(BorderEditor.this.propertyContext);
                                borderNode = new BorderNode(nodeBDS, palItem.getItemNode());
                            }
                            bordersList.add(borderNode);
                        }
                    }
                }
                ++i;
            }
            AbstractNode root = new AbstractNode((Children)new Children.Array());
            NoBorderNode noBorder = new NoBorderNode();
            if (border == null) {
                selectNode = noBorder;
            }
            root.getChildren().add(new Node[]{noBorder});
            Node[] bordersArray = new Node[bordersList.size()];
            bordersList.toArray(bordersArray);
            Arrays.sort(bordersArray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Node)o1).getDisplayName().compareTo(((Node)o2).getDisplayName());
                }
            });
            root.getChildren().add(bordersArray);
            if (selectNode == null) {
                UnknownBorderNode unknownBorder = new UnknownBorderNode(border);
                root.getChildren().add(new Node[]{unknownBorder});
                selectNode = unknownBorder;
            }
            this.getExplorerManager().setRootContext((Node)root);
            try {
                this.getExplorerManager().setSelectedNodes(new Node[]{selectNode});
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Node[] nodes;
            if ("selectedNodes".equals(evt.getPropertyName()) && (nodes = (Node[])evt.getNewValue()).length == 1) {
                BorderEditor.this.updateBorder(nodes[0]);
            }
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            Node[] nodes;
            if ("selectedNodes".equals(evt.getPropertyName()) && (nodes = (Node[])evt.getNewValue()).length != 1) {
                throw new PropertyVetoException("", evt);
            }
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$form$editors2$BorderEditor$BorderPanel == null ? (class$org$netbeans$modules$form$editors2$BorderEditor$BorderPanel = BorderPanel.class$("org.netbeans.modules.form.editors2.BorderEditor$BorderPanel")) : class$org$netbeans$modules$form$editors2$BorderEditor$BorderPanel);
        }

        public Dimension getPreferredSize() {
            return new Dimension(360, 440);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

