/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.form.editors2.CustomTableModelEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableModelEditor
implements PropertyEditor,
XMLPropertyEditor {
    private static final String XML_TABLE = "Table";
    private static final String XML_COLUMN = "Column";
    private static final String XML_DATA = "Data";
    private static final String ATTR_COLUMN_COUNT = "columnCount";
    private static final String ATTR_ROW_COUNT = "rowCount";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_EDITABLE = "editable";
    private static final String ATTR_VALUE = "value";
    private NbTableModel table;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$netbeans$modules$form$editors2$TableModelEditor;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;

    public Object getValue() {
        return this.table;
    }

    public void setValue(Object value) {
        this.table = new NbTableModel((TableModel)value);
        this.support.firePropertyChange("", null, null);
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String string) {
    }

    public String getJavaInitializationString() {
        TableModel m = (TableModel)this.getValue();
        StringBuffer titlesSB = new StringBuffer();
        int i = m.getColumnCount();
        int j = m.getRowCount();
        titlesSB.append("{\n\t\t");
        if (i > 0) {
            String s = m.getColumnName(0);
            titlesSB.append("\"").append(s != null ? s : "").append('\"');
            int k = 1;
            while (k < i) {
                String s1 = m.getColumnName(k);
                titlesSB.append(", \"").append(s1 != null ? s1 : "").append('\"');
                ++k;
            }
        }
        titlesSB.append("\n\t}");
        boolean generateTypes = false;
        StringBuffer typesSB = new StringBuffer();
        typesSB.append("{\n\t\t");
        if (i > 0) {
            typesSB.append(m.getColumnClass(0).getName()).append(".class");
            if (m.getColumnClass(0) != (class$java$lang$Object == null ? (class$java$lang$Object = TableModelEditor.class$("java.lang.Object")) : class$java$lang$Object)) {
                generateTypes = true;
            }
            int k = 1;
            while (k < i) {
                if (m.getColumnClass(k) != (class$java$lang$Object == null ? TableModelEditor.class$("java.lang.Object") : class$java$lang$Object)) {
                    generateTypes = true;
                }
                typesSB.append(", ").append(m.getColumnClass(k).getName()).append(".class");
                ++k;
            }
        }
        typesSB.append("\n\t}");
        boolean generateEditable = false;
        StringBuffer editableSB = new StringBuffer();
        editableSB.append("{\n\t\t");
        if (i > 0) {
            editableSB.append(m.isCellEditable(0, 0));
            if (!m.isCellEditable(0, 0)) {
                generateEditable = true;
            }
            int k = 1;
            while (k < i) {
                if (!m.isCellEditable(0, k)) {
                    generateEditable = true;
                }
                editableSB.append(", ").append(m.isCellEditable(0, k));
                ++k;
            }
        }
        editableSB.append("\n\t}");
        StringBuffer dataSB = new StringBuffer();
        dataSB.append("{\n\t\t");
        if (j > 0) {
            int l = 0;
            while (l < j) {
                if (l != 0) {
                    dataSB.append(",\n\t\t");
                }
                if (i == 0) {
                    dataSB.append("{}");
                } else {
                    Object obj = m.getValueAt(l, 0);
                    dataSB.append('{').append(TableModelEditor.getAsString(obj));
                    int i1 = 1;
                    while (i1 < i) {
                        obj = m.getValueAt(l, i1);
                        dataSB.append(", ").append(TableModelEditor.getAsString(obj));
                        ++i1;
                    }
                    dataSB.append('}');
                }
                ++l;
            }
        }
        dataSB.append("\n\t}");
        if (generateEditable || generateTypes) {
            return "new javax.swing.table.DefaultTableModel(\n\tnew Object [][] " + new String(dataSB) + ",\n" + "\tnew String [] " + new String(titlesSB) + "\n" + ") {\n" + (generateTypes ? "\tClass[] types = new Class [] " + new String(typesSB) + ";\n" : "") + (generateEditable ? "\tboolean[] canEdit = new boolean [] " + new String(editableSB) + ";\n" : "") + (generateTypes ? "\n\tpublic Class getColumnClass(int columnIndex) {\n\t\treturn types [columnIndex];\n\t}\n" : "") + (generateEditable ? "\n\tpublic boolean isCellEditable(int rowIndex, int columnIndex) {\n\t\treturn canEdit [columnIndex];\n\t}\n" : "") + "}";
        }
        return "new javax.swing.table.DefaultTableModel(\n\tnew Object [][] " + new String(dataSB) + ",\n" + "\tnew String [] " + new String(titlesSB) + "\n" + ")";
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new CustomTableModelEditor(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Node storeToXML(Document doc) {
        Element tableEl = doc.createElement(XML_TABLE);
        int colCount = this.table.getColumnCount();
        int rowCount = this.table.getRowCount();
        tableEl.setAttribute(ATTR_COLUMN_COUNT, Integer.toString(colCount));
        tableEl.setAttribute(ATTR_ROW_COUNT, Integer.toString(rowCount));
        int i = 0;
        while (i < colCount) {
            NbTableModel.ColumnItem column = this.table.getColumnItem(i);
            Element columnEl = doc.createElement(XML_COLUMN);
            columnEl.setAttribute(ATTR_TITLE, column.title);
            columnEl.setAttribute(ATTR_TYPE, column.type.getName());
            columnEl.setAttribute(ATTR_EDITABLE, column.editable ? "true" : "false");
            boolean anyData = false;
            int j = 0;
            while (j < rowCount) {
                if (column.rows.get(j) != null) {
                    anyData = true;
                    break;
                }
                ++j;
            }
            if (anyData) {
                int j2 = 0;
                while (j2 < rowCount) {
                    Element dataEl = doc.createElement(XML_DATA);
                    dataEl.setAttribute(ATTR_VALUE, TableModelEditor.valueToString(column.rows.get(j2)));
                    columnEl.appendChild(dataEl);
                    ++j2;
                }
            }
            tableEl.appendChild(columnEl);
            ++i;
        }
        return tableEl;
    }

    public void readFromXML(Node element) throws IOException {
        if (!XML_TABLE.equals(element.getNodeName())) {
            throw new IOException(TableModelEditor.getReadingErrorMessage());
        }
        NamedNodeMap tableAttr = element.getAttributes();
        if (tableAttr == null) {
            return;
        }
        IOException ioex = null;
        int columnCount = -1;
        int rowCount = -1;
        Node node = tableAttr.getNamedItem(ATTR_COLUMN_COUNT);
        if (node != null) {
            try {
                columnCount = Integer.parseInt(node.getNodeValue());
            }
            catch (NumberFormatException e) {
                ioex = new IOException(TableModelEditor.getReadingErrorMessage());
                ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)e);
            }
        }
        if ((node = tableAttr.getNamedItem(ATTR_ROW_COUNT)) != null) {
            try {
                rowCount = Integer.parseInt(node.getNodeValue());
            }
            catch (NumberFormatException e) {
                if (ioex == null) {
                    ioex = new IOException(TableModelEditor.getReadingErrorMessage());
                }
                ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)e);
            }
        }
        if (columnCount < 0 || rowCount < 0) {
            if (ioex == null) {
                ioex = new IOException(TableModelEditor.getReadingErrorMessage());
            }
            throw ioex;
        }
        ArrayList<NbTableModel.ColumnItem> columns = new ArrayList<NbTableModel.ColumnItem>(columnCount);
        NodeList columnNodes = element.getChildNodes();
        int i = 0;
        int cCount = columnNodes.getLength();
        while (i < cCount) {
            NamedNodeMap columnAttr;
            Node cNode = columnNodes.item(i);
            if (XML_COLUMN.equals(cNode.getNodeName()) && (columnAttr = cNode.getAttributes()) != null) {
                String title = null;
                Class<?> type = null;
                Boolean editable = null;
                node = columnAttr.getNamedItem(ATTR_TITLE);
                if (node != null) {
                    title = node.getNodeValue();
                }
                if ((node = columnAttr.getNamedItem(ATTR_TYPE)) != null) {
                    try {
                        type = Class.forName(node.getNodeValue());
                    }
                    catch (Exception e) {
                        ioex = new IOException(TableModelEditor.getReadingErrorMessage());
                        ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)e);
                    }
                }
                if ((node = columnAttr.getNamedItem(ATTR_EDITABLE)) != null) {
                    editable = Boolean.valueOf(node.getNodeValue());
                }
                if (title == null || type == null || editable == null) {
                    if (ioex == null) {
                        ioex = new IOException(TableModelEditor.getReadingErrorMessage());
                    }
                    throw ioex;
                }
                ArrayList<Object> columnData = new ArrayList<Object>(rowCount);
                NodeList dataNodes = cNode.getChildNodes();
                int j = 0;
                int dCount = dataNodes.getLength();
                while (j < dCount) {
                    NamedNodeMap dataAttr;
                    Node dNode = dataNodes.item(j);
                    if (XML_DATA.equals(dNode.getNodeName()) && (dataAttr = dNode.getAttributes()) != null) {
                        Object value = null;
                        node = dataAttr.getNamedItem(ATTR_VALUE);
                        if (node != null) {
                            try {
                                value = TableModelEditor.stringToValue(node.getNodeValue(), type);
                            }
                            catch (IllegalArgumentException e) {
                                ioex = new IOException(TableModelEditor.getReadingErrorMessage());
                                ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)e);
                                throw ioex;
                            }
                        }
                        columnData.add(value);
                    }
                    ++j;
                }
                if (columnData.size() != rowCount) {
                    if (columnData.size() == 0) {
                        int ii = 0;
                        while (ii < rowCount) {
                            columnData.add(null);
                            ++ii;
                        }
                    } else {
                        throw new IOException(TableModelEditor.getReadingErrorMessage());
                    }
                }
                columns.add(new NbTableModel.ColumnItem(title, type, (boolean)editable, columnData));
            }
            ++i;
        }
        if (columns.size() != columnCount) {
            throw new IOException(TableModelEditor.getReadingErrorMessage());
        }
        this.table = new NbTableModel(columns, rowCount);
    }

    private static ResourceBundle getBundle() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$form$editors2$TableModelEditor == null ? (class$org$netbeans$modules$form$editors2$TableModelEditor = TableModelEditor.class$("org.netbeans.modules.form.editors2.TableModelEditor")) : class$org$netbeans$modules$form$editors2$TableModelEditor));
    }

    private static String getReadingErrorMessage() {
        return TableModelEditor.getBundle().getString("ERR_InvalidXMLFormat");
    }

    private static String valueToString(Object value) {
        if (value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Boolean || value instanceof Character) {
            return value.toString();
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return "null";
        }
        return null;
    }

    private static Object stringToValue(String encoded, Class type) {
        if ("null".equals(encoded)) {
            return null;
        }
        if (type == (class$java$lang$Object == null ? (class$java$lang$Object = TableModelEditor.class$("java.lang.Object")) : class$java$lang$Object)) {
            return encoded;
        }
        if ((class$java$lang$Integer == null ? (class$java$lang$Integer = TableModelEditor.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(type) || Integer.TYPE.equals(type)) {
            return Integer.valueOf(encoded);
        }
        if ((class$java$lang$Short == null ? (class$java$lang$Short = TableModelEditor.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(type) || Short.TYPE.equals(type)) {
            return Short.valueOf(encoded);
        }
        if ((class$java$lang$Byte == null ? (class$java$lang$Byte = TableModelEditor.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(type) || Byte.TYPE.equals(type)) {
            return Byte.valueOf(encoded);
        }
        if ((class$java$lang$Long == null ? (class$java$lang$Long = TableModelEditor.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(type) || Long.TYPE.equals(type)) {
            return Long.valueOf(encoded);
        }
        if ((class$java$lang$Float == null ? (class$java$lang$Float = TableModelEditor.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(type) || Float.TYPE.equals(type)) {
            return Float.valueOf(encoded);
        }
        if ((class$java$lang$Double == null ? (class$java$lang$Double = TableModelEditor.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(type) || Double.TYPE.equals(type)) {
            return Double.valueOf(encoded);
        }
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = TableModelEditor.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(type) || Boolean.TYPE.equals(type)) {
            return Boolean.valueOf(encoded);
        }
        if ((class$java$lang$Character == null ? (class$java$lang$Character = TableModelEditor.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(type) || Character.TYPE.equals(type)) {
            return new Character(encoded.charAt(0));
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = TableModelEditor.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(type)) {
            return encoded;
        }
        throw new IllegalArgumentException();
    }

    static String getAsString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            if (o == null) {
                return "\"\"";
            }
            return "\"" + o + "\"";
        }
        String s = o.getClass().getName();
        int g = s.lastIndexOf(46);
        if (g >= 0) {
            s = s.substring(g + 1, s.length());
        }
        String cast = "";
        if (o instanceof Byte) {
            cast = "(byte) ";
        } else if (o instanceof Short) {
            cast = "(short) ";
        }
        return "new " + s + "(" + cast + o + ")";
    }

    static Object getDefaultValue(Class c) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class NbTableModel
    extends AbstractTableModel
    implements Externalizable {
        static final long serialVersionUID = -6843008677521167210L;
        List columns;
        int rowCount;
        transient boolean alwaysEditable = false;
        static /* synthetic */ Class class$java$lang$Object;

        public NbTableModel() {
        }

        public NbTableModel(String[] titles, Class[] types, boolean[] editable) {
            this(titles, types, editable, 4);
        }

        public NbTableModel(String[] titles, Class[] types, boolean[] editable, int rowCount) {
            this.rowCount = rowCount;
            this.columns = new ArrayList(titles.length);
            int i = 0;
            while (i < titles.length) {
                this.columns.add(new ColumnItem(titles[i], types[i], editable[i], rowCount));
                ++i;
            }
        }

        public NbTableModel(TableModel createFrom) {
            ResourceBundle bundle = TableModelEditor.getBundle();
            if (createFrom == null) {
                this.rowCount = 4;
                this.columns = new ArrayList(20);
                int i = 0;
                while (i < 4) {
                    this.columns.add(new ColumnItem(bundle.getString("CTL_Title") + " " + Integer.toString(i + 1), class$java$lang$Object == null ? NbTableModel.class$("java.lang.Object") : class$java$lang$Object, true, this.rowCount));
                    ++i;
                }
            } else {
                this.rowCount = createFrom.getRowCount();
                int colCount = createFrom.getColumnCount();
                this.columns = new ArrayList(colCount);
                if (createFrom instanceof NbTableModel) {
                    NbTableModel model = (NbTableModel)createFrom;
                    int i = 0;
                    while (i < colCount) {
                        ColumnItem ci = (ColumnItem)model.columns.get(i);
                        this.columns.add(new ColumnItem(ci));
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < colCount) {
                        ColumnItem ci = new ColumnItem(createFrom.getColumnName(i), createFrom.getColumnClass(i), true, this.rowCount);
                        int j = 0;
                        while (j < this.rowCount) {
                            ci.rows.set(j, createFrom.getValueAt(j, i));
                            ++j;
                        }
                        this.columns.add(ci);
                        ++i;
                    }
                }
            }
        }

        NbTableModel(List columns, int rowCount) {
            this.columns = columns;
            this.rowCount = rowCount;
        }

        public Class getColumnClass(int i) {
            ColumnItem ci = (ColumnItem)this.columns.get(i);
            return ci.type;
        }

        public void setColumnClass(int i, Class type) {
            ColumnItem ci = (ColumnItem)this.columns.get(i);
            ci.type = type;
        }

        public String getColumnName(int i) {
            ColumnItem ci = (ColumnItem)this.columns.get(i);
            return ci.title;
        }

        public void setColumnName(int i, String title) {
            ColumnItem ci = (ColumnItem)this.columns.get(i);
            ci.title = title;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public int getColumnCount() {
            return this.columns.size();
        }

        public boolean isColumnEditable(int i) {
            ColumnItem ci = (ColumnItem)this.columns.get(i);
            return ci.editable;
        }

        public boolean isCellEditable(int i, int j) {
            if (this.alwaysEditable) {
                return true;
            }
            ColumnItem ci = (ColumnItem)this.columns.get(j);
            return ci.editable;
        }

        public void setColumnEditable(int i, boolean editable) {
            ColumnItem ci = (ColumnItem)this.columns.get(i);
            ci.editable = editable;
        }

        public Object getValueAt(int row, int column) {
            ColumnItem ci = (ColumnItem)this.columns.get(column);
            return ci.rows.get(row);
        }

        public void setValueAt(Object obj, int row, int column) {
            ColumnItem ci = (ColumnItem)this.columns.get(column);
            ci.rows.set(row, obj);
            this.fireTableCellUpdated(row, column);
        }

        private ColumnItem getColumnItem(int i) {
            return (ColumnItem)this.columns.get(i);
        }

        void setRowCount(int newRowCount) {
            if (newRowCount == this.rowCount) {
                return;
            }
            int i = 0;
            int n = this.columns.size();
            while (i < n) {
                List rows = ((ColumnItem)this.columns.get((int)i)).rows;
                if (newRowCount > this.rowCount) {
                    int nr = newRowCount - this.rowCount;
                    while (nr > 0) {
                        rows.add(null);
                        --nr;
                    }
                } else {
                    int rn = this.rowCount - newRowCount;
                    while (rn > 0) {
                        rows.remove(newRowCount + rn - 1);
                        --rn;
                    }
                }
                ++i;
            }
            int rc = this.rowCount;
            this.rowCount = newRowCount;
            if (newRowCount > rc) {
                this.fireTableRowsInserted(rc, newRowCount - 1);
            } else {
                this.fireTableRowsDeleted(newRowCount, rc - 1);
            }
        }

        void addRow(int index) {
            if (index >= 0 && index <= this.rowCount) {
                int i = 0;
                int n = this.columns.size();
                while (i < n) {
                    ((ColumnItem)this.columns.get((int)i)).rows.add(index, null);
                    ++i;
                }
                ++this.rowCount;
                this.fireTableRowsInserted(index, index);
            }
        }

        void removeRow(int index) {
            if (index >= 0 && index < this.rowCount) {
                int i = 0;
                int n = this.columns.size();
                while (i < n) {
                    ((ColumnItem)this.columns.get((int)i)).rows.remove(index);
                    ++i;
                }
                --this.rowCount;
                this.fireTableRowsDeleted(index, index);
            }
        }

        void moveRow(int fromIndex, int toIndex) {
            if (this.columns.size() > 0 && fromIndex >= 0 && fromIndex < this.rowCount && toIndex >= 0 && toIndex < this.rowCount && fromIndex != toIndex) {
                int i = 0;
                int n = this.columns.size();
                while (i < n) {
                    List rows = ((ColumnItem)this.columns.get((int)i)).rows;
                    Object obj = rows.get(toIndex);
                    rows.set(toIndex, rows.get(fromIndex));
                    rows.set(fromIndex, obj);
                    ++i;
                }
                this.fireTableStructureChanged();
            }
        }

        void setColumnCount(int newColumnCount) {
            ResourceBundle bundle = TableModelEditor.getBundle();
            int colCount = this.columns.size();
            if (newColumnCount == colCount) {
                return;
            }
            if (newColumnCount > colCount) {
                int nc = newColumnCount - colCount;
                while (nc > 0) {
                    this.columns.add(new ColumnItem(bundle.getString("CTL_Title") + " " + Integer.toString(newColumnCount - nc + 1), class$java$lang$Object == null ? NbTableModel.class$("java.lang.Object") : class$java$lang$Object, true, this.rowCount));
                    --nc;
                }
            } else {
                int cn = colCount - newColumnCount;
                while (cn > 0) {
                    this.columns.remove(newColumnCount + cn - 1);
                    --cn;
                }
            }
            this.fireTableStructureChanged();
        }

        void addColumn(int index) {
            if (index >= 0 && index <= this.columns.size()) {
                this.columns.add(index, new ColumnItem(TableModelEditor.getBundle().getString("CTL_Title") + " " + Integer.toString(index + 1), class$java$lang$Object == null ? (class$java$lang$Object = NbTableModel.class$("java.lang.Object")) : class$java$lang$Object, true, this.rowCount));
                int i = index + 1;
                int n = this.columns.size();
                while (i < n) {
                    ColumnItem ci = (ColumnItem)this.columns.get(i);
                    NbTableModel.renameDefaultColumnTitle(ci, i, i + 1);
                    ++i;
                }
                this.fireTableStructureChanged();
            }
        }

        void removeColumn(int index) {
            if (index >= 0 && index < this.columns.size()) {
                this.columns.remove(index);
                int i = index;
                int n = this.columns.size();
                while (i < n) {
                    ColumnItem ci = (ColumnItem)this.columns.get(i);
                    NbTableModel.renameDefaultColumnTitle(ci, i + 2, i + 1);
                    ++i;
                }
                this.fireTableStructureChanged();
            }
        }

        void moveColumn(int fromIndex, int toIndex) {
            if (fromIndex >= 0 && fromIndex < this.columns.size() && toIndex >= 0 && toIndex < this.columns.size() && fromIndex != toIndex) {
                ColumnItem ciFrom = (ColumnItem)this.columns.get(fromIndex);
                ColumnItem ciTo = (ColumnItem)this.columns.get(toIndex);
                NbTableModel.renameDefaultColumnTitle(ciFrom, fromIndex + 1, toIndex + 1);
                NbTableModel.renameDefaultColumnTitle(ciTo, toIndex + 1, fromIndex + 1);
                this.columns.set(toIndex, ciFrom);
                this.columns.set(fromIndex, ciTo);
                this.fireTableStructureChanged();
            }
        }

        private static void renameDefaultColumnTitle(ColumnItem ci, int fromIndex, int toIndex) {
            String fromStr = TableModelEditor.getBundle().getString("CTL_Title") + " " + Integer.toString(fromIndex);
            if (fromStr.equals(ci.title)) {
                ci.title = TableModelEditor.getBundle().getString("CTL_Title") + " " + Integer.toString(toIndex);
            }
        }

        public void writeExternal(ObjectOutput oo) throws IOException {
            oo.writeInt(this.rowCount);
            int colCount = this.columns.size();
            oo.writeInt(colCount);
            String[] titles = new String[colCount];
            boolean[] editable = new boolean[colCount];
            int i = 0;
            while (i < colCount) {
                ColumnItem ci = (ColumnItem)this.columns.get(i);
                titles[i] = ci.title;
                editable[i] = ci.editable;
                ++i;
            }
            oo.writeObject(titles);
            oo.writeObject(editable);
            int i2 = 0;
            while (i2 < colCount) {
                ColumnItem ci = (ColumnItem)this.columns.get(i2);
                oo.writeObject(ci.type.getName());
                ++i2;
            }
            int i3 = 0;
            while (i3 < this.rowCount) {
                int j = 0;
                while (j < colCount) {
                    ColumnItem ci = (ColumnItem)this.columns.get(j);
                    if (ci.rows.get(i3) instanceof Serializable) {
                        oo.writeObject(ci.rows.get(i3));
                    } else {
                        oo.writeObject(null);
                    }
                    ++j;
                }
                ++i3;
            }
        }

        public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
            this.rowCount = oi.readInt();
            int colCount = oi.readInt();
            this.columns = new ArrayList(colCount);
            String[] titles = (String[])oi.readObject();
            boolean[] editable = (boolean[])oi.readObject();
            int i = 0;
            while (i < colCount) {
                this.columns.add(new ColumnItem(titles[i], Class.forName((String)oi.readObject()), editable[i], this.rowCount));
                ++i;
            }
            int i2 = 0;
            while (i2 < this.rowCount) {
                int j = 0;
                while (j < colCount) {
                    ColumnItem ci = (ColumnItem)this.columns.get(j);
                    ci.rows.set(i2, oi.readObject());
                    ++j;
                }
                ++i2;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private static class ColumnItem {
            String title;
            Class type;
            boolean editable;
            List rows;

            ColumnItem(String title, Class type, boolean editable, int rowCount) {
                this.title = title;
                this.type = type;
                this.editable = editable;
                this.rows = new ArrayList(rowCount);
                int i = 0;
                while (i < rowCount) {
                    this.rows.add(null);
                    ++i;
                }
            }

            ColumnItem(String title, Class type, boolean editable, List data) {
                this.title = title;
                this.type = type;
                this.editable = editable;
                this.rows = data;
            }

            ColumnItem(ColumnItem ci) {
                this.title = ci.title;
                this.type = ci.type;
                this.editable = ci.editable;
                int rowCount = ci.rows.size();
                this.rows = new ArrayList(rowCount);
                int i = 0;
                while (i < rowCount) {
                    this.rows.add(ci.rows.get(i));
                    ++i;
                }
            }
        }
    }
}

