/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.fakepeer;

import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.peer.ChoicePeer;
import org.netbeans.modules.form.fakepeer.FakeComponentPeer;
import org.netbeans.modules.form.fakepeer.FakePeerUtils;

class FakeChoicePeer
extends FakeComponentPeer
implements ChoicePeer {
    private static final int BUT_W = 16;
    private static final int BUT_H = 16;

    FakeChoicePeer(Choice target) {
        super(target);
    }

    Component createDelegate() {
        return new Delegate();
    }

    public void add(String item, int index) {
    }

    public void remove(int index) {
    }

    public void removeAll() {
    }

    public void select(int index) {
    }

    public void addItem(String item, int index) {
        this.add(item, index);
    }

    private class Delegate
    extends Component {
        Delegate() {
            this.setBackground(SystemColor.window);
            this.setForeground(SystemColor.controlText);
        }

        public void paint(Graphics g) {
            Choice target = (Choice)FakeChoicePeer.this._target;
            Dimension sz = target.getSize();
            FontMetrics fm = g.getFontMetrics();
            int w = sz.width;
            int h = sz.height;
            int fh = fm.getHeight();
            int comph = h > fh + 4 ? fh + 4 : h;
            int y = (h - comph) / 2;
            g.setColor(target.getBackground());
            FakePeerUtils.drawLoweredBox(g, 0, y, w, comph);
            String item = target.getSelectedItem();
            if (item != null) {
                if (target.isEnabled()) {
                    g.setColor(target.getForeground());
                } else {
                    g.setColor(SystemColor.controlShadow);
                }
                g.setFont(target.getFont());
                g.setClip(2, y + 2, w - 4, comph - 4);
                int ih = fh - fm.getDescent();
                int iy = y + 1 + ih;
                g.drawString(item, 4, iy);
            }
            FakePeerUtils.drawArrowButton(g, w - 16 - 2, y + 2, 16, comph - 4, 4, target.isEnabled());
        }

        public Dimension getMinimumSize() {
            String label = ((Choice)FakeChoicePeer.this._target).getSelectedItem();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int w = label != null ? fm.stringWidth(label) + 5 : 8;
            int h = fm.getHeight();
            return new Dimension(w + 4 + 16, h + 4);
        }
    }
}

