/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.fakepeer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.peer.LabelPeer;
import org.netbeans.modules.form.fakepeer.FakeComponentPeer;

class FakeLabelPeer
extends FakeComponentPeer
implements LabelPeer {
    FakeLabelPeer(Label target) {
        super(target);
    }

    Component createDelegate() {
        return new Delegate();
    }

    public void setText(String label) {
    }

    public void setAlignment(int alignment) {
    }

    private class Delegate
    extends Component {
        Delegate() {
            this.setForeground(SystemColor.controlText);
        }

        public void paint(Graphics g) {
            Label target = (Label)FakeLabelPeer.this._target;
            Dimension sz = target.getSize();
            g.setColor(target.getBackground());
            g.fillRect(0, 0, sz.width, sz.height);
            String label = target.getText();
            if (label == null) {
                return;
            }
            g.setFont(target.getFont());
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(label);
            int h = fm.getHeight() - fm.getDescent();
            int x = 0;
            int y = (sz.height - h) / 2 + h - 2;
            int alignment = target.getAlignment();
            if (alignment == 2) {
                x = sz.width - w;
            } else if (alignment == 1) {
                x = (sz.width - w) / 2;
            }
            if (target.isEnabled()) {
                g.setColor(target.getForeground());
            } else {
                g.setColor(SystemColor.controlLtHighlight);
                g.drawString(label, x + 1, y + 1);
                g.setColor(SystemColor.controlShadow);
            }
            g.drawString(label, x, y);
        }

        public Dimension getMinimumSize() {
            String label = ((Label)FakeLabelPeer.this._target).getText();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int w = fm.stringWidth(label);
            int h = fm.getHeight();
            return new Dimension(w + 4, h + 4);
        }
    }
}

