/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.fakepeer;

import java.awt.Graphics;
import java.awt.SystemColor;

class FakePeerUtils {
    private static int ABUT_SIZE = 16;
    static final int SCROLL_W = 16;
    static final int SCROLL_H = 16;

    FakePeerUtils() {
    }

    static void drawButton(Graphics g, int x, int y, int w, int h) {
        g.fillRect(x, y, w, h);
        g.setColor(SystemColor.controlHighlight);
        g.drawLine(x, y + h - 2, x, y);
        g.drawLine(x, y, x + w - 2, y);
        g.setColor(SystemColor.controlDkShadow);
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        g.drawLine(x + w - 1, y + h - 1, x + w - 1, y);
        if (w >= 4 && h >= 4) {
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(x + 1, y + h - 3, x + 1, y + 1);
            g.drawLine(x + 1, y + 1, x + w - 3, y + 1);
            g.setColor(SystemColor.controlShadow);
            g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
            g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + 1);
        }
    }

    static void drawArrowButton(Graphics g, int x, int y, int w, int h, int type, boolean enabled) {
        int minWH;
        g.setColor(SystemColor.control);
        FakePeerUtils.drawButton(g, x, y, w, h);
        int n = minWH = w < h ? w : h;
        int size = minWH >= ABUT_SIZE ? 4 : (minWH >= 12 ? 3 : (minWH >= 8 ? 2 : (minWH >= 6 ? 1 : 0)));
        if (enabled) {
            g.setColor(SystemColor.controlText);
        } else {
            g.setColor(SystemColor.controlLtHighlight);
            ++x;
            ++y;
        }
        while (true) {
            int i;
            int ay;
            int ax;
            if (type == 1) {
                ax = x + w / 2 - size / 2;
                ay = y + h / 2 - 1;
                i = 0;
                while (i < size) {
                    g.drawLine(ax + i, ay - i, ax + i, ay + i);
                    ++i;
                }
            } else if (type == 2) {
                ax = x + w / 2 + size / 2;
                ay = y + h / 2 - 1;
                i = 0;
                while (i < size) {
                    g.drawLine(ax - i, ay - i, ax - i, ay + i);
                    ++i;
                }
            } else if (type == 3) {
                ax = x + w / 2 - 1;
                ay = y + h / 2 - size / 2;
                i = 0;
                while (i < size) {
                    g.drawLine(ax - i, ay + i, ax + i, ay + i);
                    ++i;
                }
            } else if (type == 4) {
                ax = x + w / 2 - 1;
                ay = y + h / 2 + size / 2;
                i = 0;
                while (i < size) {
                    g.drawLine(ax - i, ay - i, ax + i, ay - i);
                    ++i;
                }
            }
            if (enabled) break;
            enabled = true;
            g.setColor(SystemColor.controlShadow);
            --x;
            --y;
        }
    }

    static void drawChoiceButton(Graphics g, int x, int y, int w, int h, boolean enabled) {
        FakePeerUtils.drawArrowButton(g, x, y, w, h, 4, enabled);
    }

    static void drawScrollThumb(Graphics g, int x, int y, int w, int h) {
        FakePeerUtils.drawButton(g, x, y, w, h);
    }

    static void drawLoweredBox(Graphics g, int x, int y, int w, int h) {
        g.fillRect(x, y, w, h);
        g.setColor(SystemColor.controlShadow);
        g.drawLine(x, y + h - 2, x, y);
        g.drawLine(x, y, x + w - 2, y);
        g.setColor(SystemColor.controlLtHighlight);
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        g.drawLine(x + w - 1, y + h - 1, x + w - 1, y);
        if (w >= 4 && h >= 4) {
            g.setColor(SystemColor.controlDkShadow);
            g.drawLine(x + 1, y + h - 3, x + 1, y + 1);
            g.drawLine(x + 1, y + 1, x + w - 3, y + 1);
            g.setColor(SystemColor.controlHighlight);
            g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
            g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + 1);
        }
    }

    static void drawScrollbar(Graphics g, int x, int y, int w, int h, int orientation, boolean enabled, boolean border, int relValue, int amount, int range) {
        g.fillRect(x, y, w, h);
        if (border) {
            g.setColor(SystemColor.controlShadow);
            g.drawRect(x, y, w - 1, h - 1);
            g.setColor(SystemColor.control);
            g.drawRect(x + 1, y + 1, w - 3, h - 3);
        } else {
            g.setColor(SystemColor.control);
        }
        if (orientation == 0) {
            int butW;
            if (w >= 32) {
                butW = 16;
                int wFT = w - 2 * butW;
                if (wFT >= 4 && enabled) {
                    int thumbW;
                    int n = thumbW = range > 0 ? wFT * amount / range : wFT;
                    if (thumbW < 6) {
                        thumbW = 6;
                    }
                    if (thumbW > wFT) {
                        thumbW = wFT;
                    }
                    int thumbX = ((range -= relValue) > 0 ? relValue * (wFT - thumbW) / range : 0) + x + butW;
                    FakePeerUtils.drawScrollThumb(g, thumbX, y, thumbW, h);
                }
            } else {
                butW = w / 2;
            }
            if (butW >= 4) {
                FakePeerUtils.drawArrowButton(g, x, y, butW, h, 1, enabled);
                FakePeerUtils.drawArrowButton(g, x + w - butW, y, butW, h, 2, enabled);
            }
        } else {
            int butH;
            if (h >= 32) {
                butH = 16;
                int hFT = h - 2 * butH;
                if (hFT >= 4 && enabled) {
                    int thumbH;
                    int n = thumbH = range > 0 ? hFT * amount / range : hFT;
                    if (thumbH < 6) {
                        thumbH = 6;
                    }
                    if (thumbH > hFT) {
                        thumbH = hFT;
                    }
                    int thumbY = ((range -= relValue) > 0 ? relValue * (hFT - thumbH) / range : 0) + y + butH;
                    FakePeerUtils.drawScrollThumb(g, x, thumbY, w, thumbH);
                }
            } else {
                butH = h / 2;
            }
            if (butH >= 4) {
                FakePeerUtils.drawArrowButton(g, x, y, w, butH, 3, enabled);
                FakePeerUtils.drawArrowButton(g, x, y + h - butH, w, butH, 4, enabled);
            }
        }
    }
}

