/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeExpressionOrigin;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutNode;
import org.netbeans.modules.form.layoutsupport.LayoutSupportContext;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.netbeans.modules.form.layoutsupport.LayoutSupportRegistry;
import org.netbeans.modules.form.layoutsupport.UnknownLayoutSupport;
import org.netbeans.modules.form.layoutsupport.delegates.NullLayoutSupport;
import org.openide.ErrorManager;
import org.openide.nodes.Node;

public final class LayoutSupportManager
implements LayoutSupportContext {
    public static final int RESIZE_UP = 1;
    public static final int RESIZE_DOWN = 2;
    public static final int RESIZE_LEFT = 4;
    public static final int RESIZE_RIGHT = 8;
    private LayoutSupportDelegate layoutDelegate;
    private Node.PropertySet[] propertySets;
    private LayoutListener layoutListener;
    private RADVisualContainer metaContainer;
    private Container primaryContainer;
    private Container primaryContainerDelegate;
    private CodeStructure codeStructure;
    private CodeExpression containerCodeExpression;
    private CodeExpression containerDelegateCodeExpression;
    static /* synthetic */ Class class$java$awt$LayoutManager;

    public void initialize(RADVisualContainer container, CodeStructure codeStructure) {
        if (this.layoutDelegate != null) {
            this.removeLayoutDelegate(false);
        }
        this.metaContainer = container;
        this.codeStructure = codeStructure;
        this.containerCodeExpression = this.metaContainer.getCodeExpression();
        this.containerDelegateCodeExpression = null;
    }

    public boolean initializeLayoutDelegate(boolean fromCode) throws Exception {
        LayoutSupportDelegate delegate = null;
        LayoutManager lmInstance = null;
        Class layoutDelegateClass = LayoutSupportRegistry.getSupportClassForContainer(this.metaContainer.getBeanClass());
        if (layoutDelegateClass != null) {
            delegate = LayoutSupportRegistry.createSupportInstance(layoutDelegateClass);
        } else {
            CodeExpressionOrigin layoutOrigin;
            Iterator it;
            CodeStatement[] statements;
            if (fromCode && (statements = CodeStructure.filterStatements(it = CodeStructure.getDefinedStatementsIterator(this.getContainerDelegateCodeExpression()), AbstractLayoutSupport.getSetLayoutMethod())).length > 0 && (delegate = LayoutSupportRegistry.createSupportForLayout((layoutOrigin = statements[0].getStatementParameters()[0].getOrigin()).getType())) == null) {
                if (layoutOrigin.getType() == (class$java$awt$LayoutManager == null ? (class$java$awt$LayoutManager = LayoutSupportManager.class$("java.awt.LayoutManager")) : class$java$awt$LayoutManager) && layoutOrigin.getCreationParameters().length == 0 && layoutOrigin.getParentExpression() == null && "null".equals(layoutOrigin.getJavaCodeString(null, null))) {
                    delegate = new NullLayoutSupport();
                } else {
                    return false;
                }
            }
            if (delegate == null) {
                Container contDel = this.getPrimaryContainerDelegate();
                if (contDel.getComponentCount() == 0) {
                    lmInstance = contDel.getLayout();
                    delegate = lmInstance != null ? LayoutSupportRegistry.createSupportForLayout(lmInstance.getClass()) : new NullLayoutSupport();
                } else {
                    IllegalArgumentException ex = new IllegalArgumentException();
                    ErrorManager.getDefault().annotate((Throwable)ex, AbstractLayoutSupport.getBundle().getString("MSG_ERR_NonEmptyContainer"));
                    throw ex;
                }
            }
        }
        if (delegate == null) {
            return false;
        }
        this.setLayoutDelegate(delegate, lmInstance, fromCode);
        return true;
    }

    public void setLayoutDelegate(LayoutSupportDelegate newDelegate, LayoutManager lmInstance, boolean fromCode) throws Exception {
        LayoutSupportDelegate oldDelegate = this.layoutDelegate;
        LayoutConstraints[] oldConstraints = this.layoutDelegate != null && (this.layoutDelegate != newDelegate || !fromCode) ? this.removeLayoutDelegate(true) : null;
        this.layoutDelegate = newDelegate;
        this.propertySets = null;
        if (this.layoutDelegate != null) {
            try {
                this.layoutDelegate.initialize(this, lmInstance, fromCode);
                if (!fromCode) {
                    this.fillLayout(oldConstraints);
                }
                this.getPropertySets();
            }
            catch (Exception ex) {
                this.removeLayoutDelegate(false);
                this.layoutDelegate = oldDelegate;
                if (this.layoutDelegate != null) {
                    this.fillLayout(null);
                }
                throw ex;
            }
        }
    }

    public LayoutSupportDelegate getLayoutDelegate() {
        return this.layoutDelegate;
    }

    public void setUnknownLayoutDelegate(boolean fromCode) {
        try {
            this.setLayoutDelegate(new UnknownLayoutSupport(), null, fromCode);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isUnknownLayout() {
        return this.layoutDelegate == null || this.layoutDelegate instanceof UnknownLayoutSupport;
    }

    public void copyLayoutDelegateFrom(LayoutSupportManager sourceLayoutSupport, RADVisualComponent[] newMetaComps) {
        LayoutSupportDelegate sourceDelegate = sourceLayoutSupport.getLayoutDelegate();
        int componentCount = sourceDelegate.getComponentCount();
        Container cont = this.getPrimaryContainer();
        Container contDel = this.getPrimaryContainerDelegate();
        if (this.layoutDelegate != null) {
            this.removeLayoutDelegate(false);
        }
        CodeExpression[] compExps = new CodeExpression[componentCount];
        Component[] primaryComps = new Component[componentCount];
        int i = 0;
        while (i < componentCount) {
            RADVisualComponent metacomp = newMetaComps[i];
            compExps[i] = metacomp.getCodeExpression();
            primaryComps[i] = metacomp.getComponent();
            LayoutSupportManager.ensureFakePeerAttached(primaryComps[i]);
            ++i;
        }
        LayoutSupportDelegate newDelegate = sourceDelegate.cloneLayoutSupport(this, compExps);
        newDelegate.setLayoutToContainer(cont, contDel);
        newDelegate.addComponentsToContainer(cont, contDel, primaryComps, 0);
        this.layoutDelegate = newDelegate;
    }

    public void clearPrimaryContainer() {
        this.layoutDelegate.clearContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate());
    }

    public RADVisualContainer getMetaContainer() {
        return this.metaContainer;
    }

    private LayoutConstraints[] removeLayoutDelegate(boolean extractConstraints) {
        CodeGroup code = this.layoutDelegate.getLayoutCode();
        if (code != null) {
            CodeStructure.removeStatements(code.getStatementsIterator());
        }
        int componentCount = this.layoutDelegate.getComponentCount();
        LayoutConstraints[] constraints = null;
        if (componentCount > 0) {
            RADVisualComponent[] metacomps = this.metaContainer.getSubComponents();
            if (extractConstraints) {
                constraints = new LayoutConstraints[componentCount];
            }
            int i = 0;
            while (i < componentCount) {
                LayoutConstraints constr = this.layoutDelegate.getConstraints(i);
                if (extractConstraints) {
                    constraints[i] = constr;
                }
                if (constr != null) {
                    metacomps[i].setLayoutConstraints(this.layoutDelegate.getClass(), constr);
                }
                if ((code = this.layoutDelegate.getComponentCode(i)) != null) {
                    CodeStructure.removeStatements(code.getStatementsIterator());
                }
                ++i;
            }
        }
        this.layoutDelegate.removeAll();
        this.layoutDelegate.clearContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate());
        this.layoutDelegate = null;
        return constraints;
    }

    private void fillLayout(LayoutConstraints[] oldConstraints) {
        RADVisualComponent[] metacomps = this.metaContainer.getSubComponents();
        int componentCount = metacomps.length;
        CodeExpression[] compExps = new CodeExpression[componentCount];
        Component[] designComps = new Component[componentCount];
        Component[] primaryComps = new Component[componentCount];
        LayoutConstraints[] newConstraints = new LayoutConstraints[componentCount];
        FormDesigner designer = this.metaContainer.getFormModel().getFormDesigner();
        int i = 0;
        while (i < componentCount) {
            RADVisualComponent metacomp = metacomps[i];
            compExps[i] = metacomp.getCodeExpression();
            primaryComps[i] = metacomp.getComponent();
            LayoutSupportManager.ensureFakePeerAttached(primaryComps[i]);
            newConstraints[i] = metacomp.getLayoutConstraints(this.layoutDelegate.getClass());
            Component comp = (Component)designer.getComponent(metacomp);
            designComps[i] = comp != null ? comp : metacomp.getComponent();
            ++i;
        }
        if (oldConstraints != null) {
            this.layoutDelegate.convertConstraints(oldConstraints, newConstraints, designComps);
        }
        if (componentCount > 0) {
            this.layoutDelegate.acceptNewComponents(compExps, newConstraints, 0);
            this.layoutDelegate.addComponents(compExps, newConstraints, 0);
            int i2 = 0;
            while (i2 < componentCount) {
                metacomps[i2].resetConstraintsProperties();
                ++i2;
            }
        }
        Container cont = this.getPrimaryContainer();
        Container contDel = this.getPrimaryContainerDelegate();
        this.layoutDelegate.setLayoutToContainer(cont, contDel);
        if (componentCount > 0) {
            this.layoutDelegate.addComponentsToContainer(cont, contDel, primaryComps, 0);
        }
    }

    public boolean isDedicated() {
        return this.layoutDelegate.isDedicated();
    }

    public boolean shouldHaveNode() {
        return this.layoutDelegate.shouldHaveNode();
    }

    public String getDisplayName() {
        return this.layoutDelegate.getDisplayName();
    }

    public Image getIcon(int type) {
        return this.layoutDelegate.getIcon(type);
    }

    public Node.PropertySet[] getPropertySets() {
        if (this.propertySets == null) {
            this.propertySets = this.layoutDelegate.getPropertySets();
            int i = 0;
            while (i < this.propertySets.length) {
                Node.Property[] props = this.propertySets[i].getProperties();
                int j = 0;
                while (j < props.length) {
                    if (props[j] instanceof FormProperty) {
                        FormProperty prop = (FormProperty)props[j];
                        prop.addVetoableChangeListener(this.getLayoutListener());
                        prop.addPropertyChangeListener(this.getLayoutListener());
                    }
                    ++j;
                }
                ++i;
            }
        }
        return this.propertySets;
    }

    public Node.Property[] getAllProperties() {
        if (this.layoutDelegate instanceof AbstractLayoutSupport) {
            return ((AbstractLayoutSupport)this.layoutDelegate).getAllProperties();
        }
        ArrayList<Node.Property> allPropsList = new ArrayList<Node.Property>();
        int i = 0;
        while (i < this.propertySets.length) {
            Node.Property[] props = this.propertySets[i].getProperties();
            int j = 0;
            while (j < props.length) {
                allPropsList.add(props[j]);
                ++j;
            }
            ++i;
        }
        Node.Property[] allProperties = new Node.Property[allPropsList.size()];
        allPropsList.toArray(allProperties);
        return allProperties;
    }

    public Node.Property getLayoutProperty(String name) {
        if (this.layoutDelegate instanceof AbstractLayoutSupport) {
            return ((AbstractLayoutSupport)this.layoutDelegate).getProperty(name);
        }
        Node.Property[] properties = this.getAllProperties();
        int i = 0;
        while (i < properties.length) {
            if (name.equals(properties[i].getName())) {
                return properties[i];
            }
            ++i;
        }
        return null;
    }

    public Class getCustomizerClass() {
        return this.layoutDelegate.getCustomizerClass();
    }

    public Component getSupportCustomizer() {
        return this.layoutDelegate.getSupportCustomizer();
    }

    public CodeGroup getLayoutCode() {
        return this.layoutDelegate.getLayoutCode();
    }

    public CodeGroup getComponentCode(int index) {
        return this.layoutDelegate.getComponentCode(index);
    }

    public CodeGroup getComponentCode(RADVisualComponent metacomp) {
        int index = this.metaContainer.getIndexOf(metacomp);
        return index >= 0 && index < this.layoutDelegate.getComponentCount() ? this.layoutDelegate.getComponentCode(index) : null;
    }

    public int getComponentCount() {
        return this.layoutDelegate.getComponentCount();
    }

    public void acceptNewComponents(RADVisualComponent[] components, LayoutConstraints[] constraints, int index) {
        CodeExpression[] compExps = new CodeExpression[components.length];
        int i = 0;
        while (i < components.length) {
            compExps[i] = components[i].getCodeExpression();
            ++i;
        }
        this.layoutDelegate.acceptNewComponents(compExps, constraints, index);
    }

    public void addComponents(RADVisualComponent[] components, LayoutConstraints[] constraints, int index) {
        CodeExpression[] compExps = new CodeExpression[components.length];
        Component[] comps = new Component[components.length];
        int i = 0;
        while (i < components.length) {
            compExps[i] = components[i].getCodeExpression();
            comps[i] = components[i].getComponent();
            LayoutSupportManager.ensureFakePeerAttached(comps[i]);
            ++i;
        }
        if (index < 0) {
            index = this.layoutDelegate.getComponentCount();
        }
        this.layoutDelegate.addComponents(compExps, constraints, index);
        int i2 = 0;
        while (i2 < components.length) {
            components[i2].resetConstraintsProperties();
            ++i2;
        }
        this.layoutDelegate.addComponentsToContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate(), comps, index);
    }

    public void removeComponent(RADVisualComponent metacomp, int index) {
        LayoutConstraints constr = this.layoutDelegate.getConstraints(index);
        if (constr != null) {
            metacomp.setLayoutConstraints(this.layoutDelegate.getClass(), constr);
        }
        CodeStructure.removeStatements(this.layoutDelegate.getComponentCode(index).getStatementsIterator());
        this.layoutDelegate.removeComponent(index);
        if (!this.layoutDelegate.removeComponentFromContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate(), metacomp.getComponent())) {
            this.layoutDelegate.clearContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate());
            RADVisualComponent[] metacomps = this.metaContainer.getSubComponents();
            if (metacomps.length > 1) {
                Component[] comps = new Component[metacomps.length - 1];
                int i = 0;
                while (i < metacomps.length) {
                    if (i != index) {
                        Component comp = metacomps[i].getComponent();
                        LayoutSupportManager.ensureFakePeerAttached(comp);
                        comps[i < index ? i : i - 1] = comp;
                    }
                    ++i;
                }
                this.layoutDelegate.addComponentsToContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate(), comps, 0);
            }
        }
    }

    public void removeAll() {
        RADVisualComponent[] components = this.metaContainer.getSubComponents();
        int i = 0;
        while (i < components.length) {
            LayoutConstraints constr = this.layoutDelegate.getConstraints(i);
            if (constr != null) {
                components[i].setLayoutConstraints(this.layoutDelegate.getClass(), constr);
            }
            ++i;
        }
        int i2 = 0;
        int n = this.layoutDelegate.getComponentCount();
        while (i2 < n) {
            CodeStructure.removeStatements(this.layoutDelegate.getComponentCode(i2).getStatementsIterator());
            ++i2;
        }
        this.layoutDelegate.removeAll();
        this.layoutDelegate.clearContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate());
    }

    public boolean isLayoutChanged() {
        Container defaultContainer = (Container)BeanSupport.getDefaultInstance(this.metaContainer.getBeanClass());
        Container defaultContDelegate = this.metaContainer.getContainerDelegate(defaultContainer);
        return this.layoutDelegate.isLayoutChanged(defaultContainer, defaultContDelegate);
    }

    public LayoutConstraints getConstraints(int index) {
        return this.layoutDelegate.getConstraints(index);
    }

    public LayoutConstraints getConstraints(RADVisualComponent metacomp) {
        if (this.layoutDelegate == null) {
            return null;
        }
        int index = this.metaContainer.getIndexOf(metacomp);
        return index >= 0 && index < this.layoutDelegate.getComponentCount() ? this.layoutDelegate.getConstraints(index) : null;
    }

    public static LayoutConstraints storeConstraints(RADVisualComponent metacomp) {
        RADVisualContainer parent = metacomp.getParentContainer();
        if (parent == null) {
            return null;
        }
        LayoutSupportManager layoutSupport = parent.getLayoutSupport();
        LayoutConstraints constr = layoutSupport.getConstraints(metacomp);
        if (constr != null) {
            metacomp.setLayoutConstraints(layoutSupport.getLayoutDelegate().getClass(), constr);
        }
        return constr;
    }

    public LayoutConstraints getStoredConstraints(RADVisualComponent metacomp) {
        return metacomp.getLayoutConstraints(this.layoutDelegate.getClass());
    }

    public void setLayoutToContainer(Container container, Container containerDelegate) {
        this.layoutDelegate.setLayoutToContainer(container, containerDelegate);
    }

    public void addComponentsToContainer(Container container, Container containerDelegate, Component[] components, int index) {
        this.layoutDelegate.addComponentsToContainer(container, containerDelegate, components, index);
    }

    public boolean removeComponentFromContainer(Container container, Container containerDelegate, Component component) {
        return this.layoutDelegate.removeComponentFromContainer(container, containerDelegate, component);
    }

    public boolean clearContainer(Container container, Container containerDelegate) {
        return this.layoutDelegate.clearContainer(container, containerDelegate);
    }

    public LayoutConstraints getNewConstraints(Container container, Container containerDelegate, Component component, int index, Point posInCont, Point posInComp) {
        return this.layoutDelegate.getNewConstraints(container, containerDelegate, component, index, posInCont, posInComp);
    }

    public int getNewIndex(Container container, Container containerDelegate, Component component, int index, Point posInCont, Point posInComp) {
        return this.layoutDelegate.getNewIndex(container, containerDelegate, component, index, posInCont, posInComp);
    }

    public boolean paintDragFeedback(Container container, Container containerDelegate, Component component, LayoutConstraints newConstraints, int newIndex, Graphics g) {
        return this.layoutDelegate.paintDragFeedback(container, containerDelegate, component, newConstraints, newIndex, g);
    }

    public int getResizableDirections(Container container, Container containerDelegate, Component component, int index) {
        return this.layoutDelegate.getResizableDirections(container, containerDelegate, component, index);
    }

    public LayoutConstraints getResizedConstraints(Container container, Container containerDelegate, Component component, int index, Insets sizeChanges, Point posInCont) {
        return this.layoutDelegate.getResizedConstraints(container, containerDelegate, component, index, sizeChanges, posInCont);
    }

    public void processMouseClick(Point p, Container cont, Container contDelegate) {
        this.layoutDelegate.processMouseClick(p, cont, contDelegate);
    }

    public void selectComponent(int index) {
        this.layoutDelegate.selectComponent(index);
    }

    public void arrangeContainer(Container container, Container containerDelegate) {
        this.layoutDelegate.arrangeContainer(container, containerDelegate);
    }

    public CodeStructure getCodeStructure() {
        return this.codeStructure;
    }

    public CodeExpression getContainerCodeExpression() {
        return this.containerCodeExpression;
    }

    public CodeExpression getContainerDelegateCodeExpression() {
        if (this.containerDelegateCodeExpression == null) {
            Method delegateGetter = this.metaContainer.getContainerDelegateMethod();
            if (delegateGetter != null) {
                Iterator it = CodeStructure.getDefinedExpressionsIterator(this.containerCodeExpression);
                CodeExpression[] expressions = CodeStructure.filterExpressions(it, delegateGetter);
                if (expressions.length > 0) {
                    this.containerDelegateCodeExpression = expressions[0];
                } else {
                    CodeExpressionOrigin origin = CodeStructure.createOrigin(this.containerCodeExpression, delegateGetter, null);
                    this.containerDelegateCodeExpression = this.codeStructure.createExpression(origin);
                }
            } else {
                this.containerDelegateCodeExpression = this.containerCodeExpression;
            }
        }
        return this.containerDelegateCodeExpression;
    }

    public Container getPrimaryContainer() {
        return (Container)this.metaContainer.getBeanInstance();
    }

    public Container getPrimaryContainerDelegate() {
        Container defCont = (Container)this.metaContainer.getBeanInstance();
        if (this.primaryContainerDelegate == null || this.primaryContainer != defCont) {
            this.primaryContainer = defCont;
            this.primaryContainerDelegate = this.metaContainer.getContainerDelegate(defCont);
        }
        return this.primaryContainerDelegate;
    }

    public Component getPrimaryComponent(int index) {
        return this.metaContainer.getSubComponent(index).getComponent();
    }

    public void updatePrimaryContainer() {
        Container cont = this.getPrimaryContainer();
        Container contDel = this.getPrimaryContainerDelegate();
        this.layoutDelegate.clearContainer(cont, contDel);
        this.layoutDelegate.setLayoutToContainer(cont, contDel);
        RADVisualComponent[] components = this.metaContainer.getSubComponents();
        if (components.length > 0) {
            Component[] comps = new Component[components.length];
            int i = 0;
            while (i < components.length) {
                comps[i] = components[i].getComponent();
                LayoutSupportManager.ensureFakePeerAttached(comps[i]);
                ++i;
            }
            this.layoutDelegate.addComponentsToContainer(cont, contDel, comps, 0);
        }
    }

    public void containerLayoutChanged(PropertyChangeEvent ev) throws PropertyVetoException {
        if (ev != null && ev.getPropertyName() != null) {
            this.layoutDelegate.acceptContainerLayoutChange(LayoutSupportManager.getEventWithValues(ev));
            FormModel formModel = this.metaContainer.getFormModel();
            formModel.fireContainerLayoutChanged(this.metaContainer, ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
        } else {
            this.propertySets = null;
        }
        LayoutNode node = this.metaContainer.getLayoutNodeReference();
        if (node != null) {
            if (ev != null && ev.getPropertyName() != null) {
                node.fireLayoutPropertiesChange();
            } else {
                node.fireLayoutPropertySetsChange();
            }
        }
    }

    public void componentLayoutChanged(int index, PropertyChangeEvent ev) throws PropertyVetoException {
        RADVisualComponent metacomp = this.metaContainer.getSubComponent(index);
        if (ev != null && ev.getPropertyName() != null) {
            this.layoutDelegate.acceptComponentLayoutChange(index, LayoutSupportManager.getEventWithValues(ev));
            FormModel formModel = this.metaContainer.getFormModel();
            formModel.fireComponentLayoutChanged(metacomp, ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
            if (metacomp.getNodeReference() != null) {
                metacomp.getNodeReference().firePropertyChangeHelper(null, null, null);
            }
        } else {
            if (metacomp.getNodeReference() != null) {
                metacomp.getNodeReference().fireComponentPropertySetsChange();
            }
            metacomp.resetConstraintsProperties();
        }
    }

    private static PropertyChangeEvent getEventWithValues(PropertyChangeEvent ev) {
        Object oldVal = ev.getOldValue();
        Object newVal = ev.getNewValue();
        if (oldVal instanceof FormProperty.ValueWithEditor) {
            ev = new PropertyChangeEvent(ev.getSource(), ev.getPropertyName(), ((FormProperty.ValueWithEditor)oldVal).getValue(), ((FormProperty.ValueWithEditor)newVal).getValue());
        }
        return ev;
    }

    private LayoutListener getLayoutListener() {
        if (this.layoutListener == null) {
            this.layoutListener = new LayoutListener();
        }
        return this.layoutListener;
    }

    private static void ensureFakePeerAttached(Component comp) {
        FakePeerSupport.attachFakePeer(comp);
        if (comp instanceof Container) {
            FakePeerSupport.attachFakePeerRecursively((Container)comp);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LayoutListener
    implements VetoableChangeListener,
    PropertyChangeListener {
        private LayoutListener() {
        }

        public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
            Object source = ev.getSource();
            String eventName = ev.getPropertyName();
            if (source instanceof FormProperty && ("propertyValue".equals(eventName) || "propertyValueAndEditor".equals(eventName))) {
                ev = new PropertyChangeEvent(LayoutSupportManager.this.layoutDelegate, ((FeatureDescriptor)((Object)((FormProperty)((Object)source)))).getName(), ev.getOldValue(), ev.getNewValue());
                LayoutSupportManager.this.containerLayoutChanged(ev);
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            Object source = ev.getSource();
            if (source instanceof FormProperty && "currentEditor".equals(ev.getPropertyName())) {
                ev = new PropertyChangeEvent(LayoutSupportManager.this.layoutDelegate, null, null, null);
                try {
                    LayoutSupportManager.this.containerLayoutChanged(ev);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }
}

